(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   2089152,      49019]
NotebookOptionsPosition[   2078410,      48875]
NotebookOutlinePosition[   2078848,      48892]
CellTagsIndexPosition[   2078805,      48889]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Plot data and fits", "Title",
 CellChangeTimes->{{3.8601397412505856`*^9, 3.860139755017807*^9}, {
  3.9022202669447126`*^9, 
  3.9022202738303194`*^9}},ExpressionUUID->"d0e8ddea-97d3-4359-93ee-\
9734776dce2c"],

Cell["\<\
This notebook is used for plotting multiple samples in one figure.\
\>", "Text",
 CellChangeTimes->{{3.8601397453382463`*^9, 3.8601397964528313`*^9}, {
  3.8617669288125243`*^9, 3.861766945139561*^9}, {3.8617673062268524`*^9, 
  3.8617673066939745`*^9}, {3.861942912912383*^9, 3.861942913146066*^9}, {
  3.9022202811863976`*^9, 
  3.902220291076703*^9}},ExpressionUUID->"7c1a7862-4493-4bbd-ad86-\
2d905071e2e2"],

Cell[CellGroupData[{

Cell["Import data (previously processed in a different notebook)", \
"Subsection",
 CellChangeTimes->{{3.902215546140896*^9, 3.902215554970817*^9}, {
  3.9022172423037977`*^9, 
  3.9022172450257316`*^9}},ExpressionUUID->"05ff968c-c2cd-4505-bd49-\
519a456dd620"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "C14", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"merged", " ", "and", " ", "binned", " ", "data"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"importlist", " ", "=", " ", 
     RowBox[{"Import", "[", "\[IndentingNewLine]", 
      RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
         "\"\<Sample playground LH-ESRF-C14 NEW SAXS data merged and \
binned.csv\>\""}], "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}],
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "convert", " ", "the", " ", "imported", " ", "list", " ", "to", " ", 
      "the", " ", "right", " ", "data", " ", "format", " ", "with", " ", 
      "x"}], ",", " ", 
     RowBox[{"y", "+", 
      RowBox[{"-", "error"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamergedbinnedC14", " ", "=", " ", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", " ", 
     RowBox[{"i", "<=", 
      RowBox[{"Length", "[", "importlist", "]"}]}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"errorvalue", " ", "=", 
        RowBox[{
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[PlusMinus]", 
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "3"}], "]"}], "]"}]}]}], ",", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"datamergedbinnedC14", " ", ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"importlist", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "errorvalue"}], 
          "}"}]}], "]"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"datamergedbinned", "\[IndentingNewLine]", 
     RowBox[{"ListLogPlot", "[", "datamergedbinned", "]"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "convert", " ", "the", " ", "imported", " ", "list", " ", "to", " ", 
      "the", " ", "right", " ", "data", " ", "format", " ", "with", " ", 
      "x"}], ",", " ", 
     RowBox[{"y", "+", 
      RowBox[{"-", "error"}]}]}], "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "slopes", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"importlist", " ", "=", " ", 
     RowBox[{"Import", "[", "\[IndentingNewLine]", 
      RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
         "\"\<Sample playground LH-ESRF-C14 NEW SAXS slopes.csv\>\""}], 
        "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "convert", " ", "the", " ", "imported", " ", "list", " ", "to", " ", 
      "the", " ", "right", " ", "data", " ", "format", " ", "with", " ", 
      "x"}], ",", " ", 
     RowBox[{"y", "+", 
      RowBox[{"-", "error"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopesC14", " ", "=", " ", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", " ", 
     RowBox[{"i", "<=", 
      RowBox[{"Length", "[", "importlist", "]"}]}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"errorvalue", " ", "=", " ", 
        RowBox[{
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[PlusMinus]", 
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "3"}], "]"}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"slopesC14", " ", ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"importlist", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "errorvalue"}], 
          "}"}]}], "]"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopesC14NE", " ", "=", " ", 
     RowBox[{"importlist", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"without", " ", "error", " ", "data"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "C15", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"merged", " ", "and", " ", "binned", " ", "data"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"importlist", " ", "=", " ", 
     RowBox[{"Import", "[", "\[IndentingNewLine]", 
      RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
         "\"\<Sample playground LH-ESRF-C15 NEW SAXS data merged and \
binned.csv\>\""}], "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}],
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "convert", " ", "the", " ", "imported", " ", "list", " ", "to", " ", 
      "the", " ", "right", " ", "data", " ", "format", " ", "with", " ", 
      "x"}], ",", " ", 
     RowBox[{"y", "+", 
      RowBox[{"-", "error"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamergedbinnedC15", " ", "=", " ", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", " ", 
     RowBox[{"i", "<=", 
      RowBox[{"Length", "[", "importlist", "]"}]}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"errorvalue", " ", "=", " ", 
        RowBox[{
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[PlusMinus]", 
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "3"}], "]"}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"datamergedbinnedC15", " ", ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"importlist", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "errorvalue"}], 
          "}"}]}], "]"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"datamergedbinned", "\[IndentingNewLine]", 
     RowBox[{"ListLogPlot", "[", "datamergedbinned", "]"}]}], "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "slopes", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"importlist", " ", "=", " ", 
     RowBox[{"Import", "[", "\[IndentingNewLine]", 
      RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
         "\"\<Sample playground LH-ESRF-C15 NEW SAXS slopes.csv\>\""}], 
        "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "convert", " ", "the", " ", "imported", " ", "list", " ", "to", " ", 
      "the", " ", "right", " ", "data", " ", "format", " ", "with", " ", 
      "x"}], ",", " ", 
     RowBox[{"y", "+", 
      RowBox[{"-", "error"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopesC15", " ", "=", " ", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", " ", 
     RowBox[{"i", "<=", 
      RowBox[{"Length", "[", "importlist", "]"}]}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"errorvalue", " ", "=", " ", 
        RowBox[{
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[PlusMinus]", 
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "3"}], "]"}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"slopesC15", " ", ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"importlist", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "errorvalue"}], 
          "}"}]}], "]"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopesC15NE", " ", "=", " ", 
     RowBox[{"importlist", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"without", " ", "error", " ", "data"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "C16", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"merged", " ", "and", " ", "binned", " ", "data"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"importlist", " ", "=", " ", 
     RowBox[{"Import", "[", "\[IndentingNewLine]", 
      RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
         "\"\<Sample playground LH-ESRF-C16 NEW SAXS data merged and \
binned.csv\>\""}], "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}],
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "convert", " ", "the", " ", "imported", " ", "list", " ", "to", " ", 
      "the", " ", "right", " ", "data", " ", "format", " ", "with", " ", 
      "x"}], ",", " ", 
     RowBox[{"y", "+", 
      RowBox[{"-", "error"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamergedbinnedC16", " ", "=", " ", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", " ", 
     RowBox[{"i", "<=", 
      RowBox[{"Length", "[", "importlist", "]"}]}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"errorvalue", " ", "=", " ", 
        RowBox[{
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[PlusMinus]", 
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "3"}], "]"}], "]"}]}]}], ",", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"datamergedbinnedC16", " ", ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"importlist", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "errorvalue"}], 
          "}"}]}], "]"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"datamergedbinned", "\[IndentingNewLine]", 
     RowBox[{"ListLogPlot", "[", "datamergedbinned", "]"}]}], "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "slopes", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"importlist", " ", "=", " ", 
     RowBox[{"Import", "[", "\[IndentingNewLine]", 
      RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
         "\"\<Sample playground LH-ESRF-C16 NEW SAXS slopes.csv\>\""}], 
        "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "convert", " ", "the", " ", "imported", " ", "list", " ", "to", " ", 
      "the", " ", "right", " ", "data", " ", "format", " ", "with", " ", 
      "x"}], ",", " ", 
     RowBox[{"y", "+", 
      RowBox[{"-", "error"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopesC16", " ", "=", " ", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", " ", 
     RowBox[{"i", "<=", 
      RowBox[{"Length", "[", "importlist", "]"}]}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"errorvalue", " ", "=", " ", 
        RowBox[{
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[PlusMinus]", 
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "3"}], "]"}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"slopesC16", " ", ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"importlist", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "errorvalue"}], 
          "}"}]}], "]"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopesC16NE", " ", "=", " ", 
     RowBox[{"importlist", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"without", " ", "error", " ", "data"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "C20", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"merged", " ", "and", " ", "binned", " ", "data"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"importlist", " ", "=", " ", 
     RowBox[{"Import", "[", "\[IndentingNewLine]", 
      RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
         "\"\<Sample playground LH-ESRF-C20 NEW SAXS data merged and \
binned.csv\>\""}], "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}],
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "convert", " ", "the", " ", "imported", " ", "list", " ", "to", " ", 
      "the", " ", "right", " ", "data", " ", "format", " ", "with", " ", 
      "x"}], ",", " ", 
     RowBox[{"y", "+", 
      RowBox[{"-", "error"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamergedbinnedC20", " ", "=", " ", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", " ", 
     RowBox[{"i", "<=", 
      RowBox[{"Length", "[", "importlist", "]"}]}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"errorvalue", " ", "=", " ", 
        RowBox[{
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[PlusMinus]", 
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "3"}], "]"}], "]"}]}]}], ",", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"datamergedbinnedC20", " ", ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"importlist", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "errorvalue"}], 
          "}"}]}], "]"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"datamergedbinned", "\[IndentingNewLine]", 
     RowBox[{"ListLogPlot", "[", "datamergedbinned", "]"}]}], "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "slopes", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"importlist", " ", "=", " ", 
     RowBox[{"Import", "[", "\[IndentingNewLine]", 
      RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
         "\"\<Sample playground LH-ESRF-C20 NEW SAXS slopes.csv\>\""}], 
        "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "convert", " ", "the", " ", "imported", " ", "list", " ", "to", " ", 
      "the", " ", "right", " ", "data", " ", "format", " ", "with", " ", 
      "x"}], ",", " ", 
     RowBox[{"y", "+", 
      RowBox[{"-", "error"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopesC20", " ", "=", " ", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", " ", 
     RowBox[{"i", "<=", 
      RowBox[{"Length", "[", "importlist", "]"}]}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"errorvalue", " ", "=", " ", 
        RowBox[{
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[PlusMinus]", 
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "3"}], "]"}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"slopesC20", " ", ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"importlist", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "errorvalue"}], 
          "}"}]}], "]"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopesC20NE", " ", "=", " ", 
     RowBox[{"importlist", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"without", " ", "error", " ", "data"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "C21", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"merged", " ", "and", " ", "binned", " ", "data"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"importlist", " ", "=", " ", 
     RowBox[{"Import", "[", "\[IndentingNewLine]", 
      RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
         "\"\<Sample playground LH-ESRF-C21 NEW SAXS data merged and \
binned.csv\>\""}], "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}],
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "convert", " ", "the", " ", "imported", " ", "list", " ", "to", " ", 
      "the", " ", "right", " ", "data", " ", "format", " ", "with", " ", 
      "x"}], ",", " ", 
     RowBox[{"y", "+", 
      RowBox[{"-", "error"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamergedbinnedC21", " ", "=", " ", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", " ", 
     RowBox[{"i", "<=", 
      RowBox[{"Length", "[", "importlist", "]"}]}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"errorvalue", " ", "=", " ", 
        RowBox[{
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[PlusMinus]", 
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "3"}], "]"}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"datamergedbinnedC21", " ", ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"importlist", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "errorvalue"}], 
          "}"}]}], "]"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"datamergedbinned", "\[IndentingNewLine]", 
     RowBox[{"ListLogPlot", "[", "datamergedbinned", "]"}]}], "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "slopes", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"importlist", " ", "=", " ", 
     RowBox[{"Import", "[", "\[IndentingNewLine]", 
      RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
         "\"\<Sample playground LH-ESRF-C21 NEW SAXS slopes.csv\>\""}], 
        "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "convert", " ", "the", " ", "imported", " ", "list", " ", "to", " ", 
      "the", " ", "right", " ", "data", " ", "format", " ", "with", " ", 
      "x"}], ",", " ", 
     RowBox[{"y", "+", 
      RowBox[{"-", "error"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopesC21", " ", "=", " ", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", " ", 
     RowBox[{"i", "<=", 
      RowBox[{"Length", "[", "importlist", "]"}]}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"errorvalue", " ", "=", " ", 
        RowBox[{
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[PlusMinus]", 
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "3"}], "]"}], "]"}]}]}], ",", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"slopesC21", " ", ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"importlist", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "errorvalue"}], 
          "}"}]}], "]"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopesC21NE", " ", "=", " ", 
     RowBox[{"importlist", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"without", " ", "error", " ", "data"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "C22", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"merged", " ", "and", " ", "binned", " ", "data"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"importlist", " ", "=", " ", 
     RowBox[{"Import", "[", "\[IndentingNewLine]", 
      RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
         "\"\<Sample playground LH-ESRF-C22 NEW SAXS data merged and \
binned.csv\>\""}], "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}],
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "convert", " ", "the", " ", "imported", " ", "list", " ", "to", " ", 
      "the", " ", "right", " ", "data", " ", "format", " ", "with", " ", 
      "x"}], ",", " ", 
     RowBox[{"y", "+", 
      RowBox[{"-", "error"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamergedbinnedC22", " ", "=", " ", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", " ", 
     RowBox[{"i", "<=", 
      RowBox[{"Length", "[", "importlist", "]"}]}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"errorvalue", " ", "=", " ", 
        RowBox[{
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[PlusMinus]", 
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "3"}], "]"}], "]"}]}]}], ",", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"datamergedbinnedC22", " ", ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"importlist", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "errorvalue"}], 
          "}"}]}], "]"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"datamergedbinned", "\[IndentingNewLine]", 
     RowBox[{"ListLogPlot", "[", "datamergedbinned", "]"}]}], "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "slopes", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"importlist", " ", "=", " ", 
     RowBox[{"Import", "[", "\[IndentingNewLine]", 
      RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
         "\"\<Sample playground LH-ESRF-C22 NEW SAXS slopes.csv\>\""}], 
        "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "convert", " ", "the", " ", "imported", " ", "list", " ", "to", " ", 
      "the", " ", "right", " ", "data", " ", "format", " ", "with", " ", 
      "x"}], ",", " ", 
     RowBox[{"y", "+", 
      RowBox[{"-", "error"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopesC22", " ", "=", " ", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", " ", 
     RowBox[{"i", "<=", 
      RowBox[{"Length", "[", "importlist", "]"}]}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"errorvalue", " ", "=", " ", 
        RowBox[{
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], "\[PlusMinus]", 
         RowBox[{"importlist", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "3"}], "]"}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"slopesC22", ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"importlist", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "errorvalue"}], 
          "}"}]}], "]"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopesC22NE", " ", "=", " ", 
     RowBox[{"importlist", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"without", " ", "error", " ", "data"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Import", " ", "DLS", " ", "data"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataDLSC14", "=", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Import", "[", 
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
          "\"\<LH-GNP2425-500g(2x)_2022-08-23 ethyl acetate (1).xlsx\>\""}], 
         "}"}], "]"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", 
        RowBox[{"9", ";;", "150"}], ",", 
        RowBox[{"{", 
         RowBox[{"6", ",", "7"}], "}"}]}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataDLSC14", "=", 
     RowBox[{"dataDLSC14", ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"4", "/", "3"}], ")"}], "/", "2"}]}], ",", "0"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"1", "/", 
           RowBox[{"Max", "[", 
            RowBox[{"dataDLSC14", "[", 
             RowBox[{"[", 
              RowBox[{";;", ",", "2"}], "]"}], "]"}], "]"}]}]}], "}"}]}], 
       "}"}]}]}], ";"}], 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "here", " ", "we", " ", "used", " ", "R", " ", "instead", " ", "of", " ",
       "Dh"}], ";", " ", 
     RowBox[{"D", " ", "=", " ", 
      RowBox[{
       RowBox[{"4", "/", "3"}], " ", "Dh"}]}], ";", " ", 
     RowBox[{"R", " ", "=", " ", 
      RowBox[{
       RowBox[{"4", "/", "3"}], " ", 
       RowBox[{"Dh", "/", "2"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataDLSC15", "=", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Import", "[", 
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
          "\"\<LH-GNP2425-1000g(2x)_2022-08-23 ethyl acetate (1).xlsx\>\""}], 
         "}"}], "]"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", 
        RowBox[{"9", ";;", "150"}], ",", 
        RowBox[{"{", 
         RowBox[{"6", ",", "7"}], "}"}]}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataDLSC15", "=", 
     RowBox[{"dataDLSC15", ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"4", "/", "3"}], ")"}], "/", "2"}]}], ",", "0"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"1", "/", 
           RowBox[{"Max", "[", 
            RowBox[{"dataDLSC15", "[", 
             RowBox[{"[", 
              RowBox[{";;", ",", "2"}], "]"}], "]"}], "]"}]}]}], "}"}]}], 
       "}"}]}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataDLSC16", "=", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Import", "[", 
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
          "\"\<LH-GNP2425-2000g(2x)_2022-08-23 ethyl acetate (1).xlsx\>\""}], 
         "}"}], "]"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", 
        RowBox[{"9", ";;", "150"}], ",", 
        RowBox[{"{", 
         RowBox[{"6", ",", "7"}], "}"}]}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataDLSC16", "=", 
     RowBox[{"dataDLSC16", ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"4", "/", "3"}], ")"}], "/", "2"}]}], ",", "0"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"1", "/", 
           RowBox[{"Max", "[", 
            RowBox[{"dataDLSC16", "[", 
             RowBox[{"[", 
              RowBox[{";;", ",", "2"}], "]"}], "]"}], "]"}]}]}], "}"}]}], 
       "}"}]}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataDLSC20", "=", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Import", "[", 
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
          "\"\<LH-GNP2627-500g(2x)_2022-08-23 ethyl acetate (1).xlsx\>\""}], 
         "}"}], "]"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", 
        RowBox[{"9", ";;", "150"}], ",", 
        RowBox[{"{", 
         RowBox[{"6", ",", "7"}], "}"}]}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataDLSC20", "=", 
     RowBox[{"dataDLSC20", ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"4", "/", "3"}], ")"}], "/", "2"}]}], ",", "0"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"1", "/", 
           RowBox[{"Max", "[", 
            RowBox[{"dataDLSC20", "[", 
             RowBox[{"[", 
              RowBox[{";;", ",", "2"}], "]"}], "]"}], "]"}]}]}], "}"}]}], 
       "}"}]}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataDLSC21", "=", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Import", "[", 
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
          "\"\<LH-GNP2627-1000g(2x)_2022-08-23 ethyl acetate (1).xlsx\>\""}], 
         "}"}], "]"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", 
        RowBox[{"9", ";;", "150"}], ",", 
        RowBox[{"{", 
         RowBox[{"6", ",", "7"}], "}"}]}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataDLSC21", "=", 
     RowBox[{"dataDLSC21", ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"4", "/", "3"}], ")"}], "/", "2"}]}], ",", "0"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"1", "/", 
           RowBox[{"Max", "[", 
            RowBox[{"dataDLSC21", "[", 
             RowBox[{"[", 
              RowBox[{";;", ",", "2"}], "]"}], "]"}], "]"}]}]}], "}"}]}], 
       "}"}]}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataDLSC22", "=", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Import", "[", 
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
          "\"\<LH-GNP2627-2000g(2x)_2022-08-23 ethyl acetate (1).xlsx\>\""}], 
         "}"}], "]"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", 
        RowBox[{"9", ";;", "150"}], ",", 
        RowBox[{"{", 
         RowBox[{"6", ",", "7"}], "}"}]}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataDLSC22", "=", 
     RowBox[{"dataDLSC22", ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"4", "/", "3"}], ")"}], "/", "2"}]}], ",", "0"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"1", "/", 
           RowBox[{"Max", "[", 
            RowBox[{"dataDLSC22", "[", 
             RowBox[{"[", 
              RowBox[{";;", ",", "2"}], "]"}], "]"}], "]"}]}]}], "}"}]}], 
       "}"}]}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.9022149115519915`*^9, 3.902214928032826*^9}, {
   3.9022150167319202`*^9, 3.9022150644423866`*^9}, {3.902215095852667*^9, 
   3.9022152713751416`*^9}, {3.902215382750983*^9, 3.9022154164512854`*^9}, 
   3.902215533177294*^9, {3.902216229033347*^9, 3.902216235713913*^9}, {
   3.9022162659820976`*^9, 3.902216278847211*^9}, {3.9022164330284615`*^9, 
   3.9022164731633058`*^9}, {3.9022165155945787`*^9, 
   3.9022165618679824`*^9}, {3.9022166101726637`*^9, 3.902216666465963*^9}, {
   3.902216755747498*^9, 3.902216849924554*^9}, {3.9022175917249975`*^9, 
   3.9022176842847805`*^9}, {3.9022177317856274`*^9, 
   3.9022178257695775`*^9}, {3.902221859450025*^9, 3.9022219362276278`*^9}, {
   3.9023779753574314`*^9, 3.902378171173195*^9}, {3.9023856262031407`*^9, 
   3.9023856412986794`*^9}, {3.902386739539275*^9, 3.902386755955065*^9}, {
   3.904796370674417*^9, 3.904796383259288*^9}, {3.904796452679225*^9, 
   3.9047964757987194`*^9}, {3.904798242079618*^9, 3.904798284099079*^9}, {
   3.9187196406878586`*^9, 3.918719716771818*^9}, {3.9187201458760824`*^9, 
   3.9187201973385954`*^9}, {3.918720247658125*^9, 3.918720459976304*^9}, {
   3.918721672248149*^9, 3.918721688867731*^9}, {3.9187269590402308`*^9, 
   3.9187270037403774`*^9}},
 CellLabel->
  "In[1218]:=",ExpressionUUID->"b66525ca-dbd1-499c-86f2-a52ff36ff035"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"datamergedbinned", "\[IndentingNewLine]", "slopes"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", "datamergedbinnedC14", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"dataDLSC20", "=", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Import", "[", 
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
          "\"\<LH-GNP2627-2000g(2x)_2022-08-23 ethyl acetate (1).xlsx\>\""}], 
         "}"}], "]"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", 
        RowBox[{"9", ";;", "150"}], ",", 
        RowBox[{"{", 
         RowBox[{"6", ",", "7"}], "}"}]}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"dataDLSC20", "=", 
     RowBox[{"dataDLSC20", ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"4", "/", "3"}], ")"}], "/", "2"}]}], ",", "0"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"1", "/", 
           RowBox[{"Max", "[", 
            RowBox[{"dataDLSC20", "[", 
             RowBox[{"[", 
              RowBox[{";;", ",", "2"}], "]"}], "]"}], "]"}]}]}], "}"}]}], 
       "}"}]}]}], ";", "\[IndentingNewLine]", "dataDLSC20"}], 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.9022176983981686`*^9, 3.9022177028977084`*^9}, 
   3.9022177413174353`*^9, {3.902378336480983*^9, 3.902378356433791*^9}, {
   3.902385510376478*^9, 3.9023855133622427`*^9}, {3.9023855833053727`*^9, 
   3.9023856207906637`*^9}, {3.902386677154141*^9, 3.902386684288723*^9}, {
   3.9023867296946726`*^9, 3.902386736491104*^9}},
 CellLabel->
  "In[210]:=",ExpressionUUID->"9ae5eaff-e228-4d54-9852-b1ab8f5ef318"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plot merged data and slopes", "Subsection",
 CellChangeTimes->{{3.9022171611679006`*^9, 
  3.9022171697188206`*^9}},ExpressionUUID->"31402af8-8d6f-4a29-9ffd-\
3acaa818d538"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Plot", " ", "merged", " ", "data", " ", "C14"}], "-", "C16"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"plotDataBinned", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "datamergedbinnedC14", ",", "\[IndentingNewLine]", 
        "datamergedbinnedC15", ",", "\[IndentingNewLine]", 
        "datamergedbinnedC16"}], "\[IndentingNewLine]", "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", 
           RowBox[{"1", " ", 
            RowBox[{"10", "^", "3"}]}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"PlotStyle", "->", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
             RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Automatic"}],
             "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
             RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Dashed"}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "9", "]"}], "[", "4", "]"}], ",", " ", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Dotted"}], 
            "}"}]}], "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"PlotStyle", "->", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "8", "]"}], "[", "1", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
             RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Automatic"}],
             "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "8", "]"}], "[", "4", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
             RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Dashed"}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "8", "]"}], "[", "3", "]"}], ",", " ", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Dotted"}], 
            "}"}]}], "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Dashed"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "9", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Dotted"}], 
          "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<C14\>\"", ",", " ", "\"\<C15\>\"", ",", " ", "\"\<C16\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<DataMergedBinnedC14-16.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotDataBinned", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Plot", " ", "slopes", " ", "C14"}], "-", "C16"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"plotSlopes", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"datamerged", ",", "0.15"}], "]"}], ","}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{"default", ":", " ", "0.15"}], " ", "*)"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "slopesC14", ",", "\[IndentingNewLine]", "slopesC15", ",", 
        "\[IndentingNewLine]", "slopesC16"}], "\[IndentingNewLine]", "}"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "6"}], ",", "0"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "9", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"PowerTicks", "[", "True", "]"}], "[", 
            RowBox[{
             RowBox[{"10", "^", 
              RowBox[{"-", "2"}]}], ",", " ", 
             RowBox[{"10", "^", "0"}]}], "]"}], ",", 
           RowBox[{
            RowBox[{"PowerTicks", "[", "False", "]"}], "[", 
            RowBox[{
             RowBox[{"10", "^", 
              RowBox[{"-", "2"}]}], ",", " ", 
             RowBox[{"10", "^", "0"}]}], "]"}]}], "}"}]}], "}"}]}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<C14\>\"", ",", " ", "\"\<C15\>\"", ",", " ", "\"\<C16\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"n\",FontSlant->\"Italic\"]\)\>\"", ",", " ", 
           "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<SlopesC14-16.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotSlopes", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Plot", " ", "merged", " ", "data", " ", "C20"}], "-", "C22"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"plotDataBinned", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "datamergedbinnedC20", ",", "\[IndentingNewLine]", 
        "datamergedbinnedC21", ",", "\[IndentingNewLine]", 
        "datamergedbinnedC22"}], "\[IndentingNewLine]", "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", 
           RowBox[{"1", " ", 
            RowBox[{"10", "^", "3"}]}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"PlotStyle", "->", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
             RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Automatic"}],
             "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
             RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Dashed"}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "9", "]"}], "[", "4", "]"}], ",", " ", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Dotted"}], 
            "}"}]}], "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"PlotStyle", "->", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "8", "]"}], "[", "1", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
             RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Automatic"}],
             "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "8", "]"}], "[", "4", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
             RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Dashed"}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "8", "]"}], "[", "3", "]"}], ",", " ", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Dotted"}], 
            "}"}]}], "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Dashed"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "9", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Dotted"}], 
          "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<C20\>\"", ",", " ", "\"\<C21\>\"", ",", " ", "\"\<C22\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<DataMergedBinnedC20-22.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotDataBinned", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Plot", " ", "slopes", " ", "C20"}], "-", "C22"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"plotSlopes", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"datamerged", ",", "0.15"}], "]"}], ","}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{"default", ":", " ", "0.15"}], " ", "*)"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "slopesC20", ",", "\[IndentingNewLine]", "slopesC21", ",", 
        "\[IndentingNewLine]", "slopesC22"}], "\[IndentingNewLine]", "}"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "6"}], ",", "0"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "9", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"PowerTicks", "[", "True", "]"}], "[", 
            RowBox[{
             RowBox[{"10", "^", 
              RowBox[{"-", "2"}]}], ",", " ", 
             RowBox[{"10", "^", "0"}]}], "]"}], ",", 
           RowBox[{
            RowBox[{"PowerTicks", "[", "False", "]"}], "[", 
            RowBox[{
             RowBox[{"10", "^", 
              RowBox[{"-", "2"}]}], ",", " ", 
             RowBox[{"10", "^", "0"}]}], "]"}]}], "}"}]}], "}"}]}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<C20\>\"", ",", " ", "\"\<C21\>\"", ",", " ", "\"\<C22\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"n\",FontSlant->\"Italic\"]\)\>\"", ",", " ", 
           "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<SlopesC20-22.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotSlopes", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.902217140297951*^9, 3.902217142443056*^9}, {
   3.9022172099071436`*^9, 3.902217219370745*^9}, {3.90221747755323*^9, 
   3.9022174854501867`*^9}, {3.90221783596463*^9, 3.902217844747697*^9}, {
   3.9022179432654448`*^9, 3.902218032003544*^9}, {3.9022180686460114`*^9, 
   3.9022180788450203`*^9}, {3.902218146414893*^9, 3.9022181956068068`*^9}, {
   3.902218258187581*^9, 3.902218298334155*^9}, {3.902220330818726*^9, 
   3.90222033766553*^9}, {3.9022219542091923`*^9, 3.902222037404671*^9}, {
   3.903580733279014*^9, 3.9035807377356052`*^9}, {3.9047950807536182`*^9, 
   3.9047951594294024`*^9}, {3.904795195194067*^9, 3.9047952008467627`*^9}, {
   3.9047955140511813`*^9, 3.904795523708535*^9}, {3.9047955691227865`*^9, 
   3.9047955975647383`*^9}, {3.9059260892610974`*^9, 3.905926110043765*^9}, {
   3.917944174496408*^9, 3.9179441850999165`*^9}, {3.91872065861443*^9, 
   3.9187206719185257`*^9}, 3.918720716237586*^9},
 CellLabel->
  "In[1272]:=",ExpressionUUID->"a0e9289a-ab87-4bb3-a319-78f5d7640948"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.777881903329149, 
           6.185579638708113}, {-5.777881903329149, 6.225310593615811}}], 
          
          LineBox[{{-5.777881903329149, 
           6.225310593615811}, {-5.777881903329149, 6.263523135646599}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.483842181677217, 
           5.860349586025714}, {-5.483842181677217, 5.89299758492467}}], 
          
          LineBox[{{-5.483842181677217, 
           5.89299758492467}, {-5.483842181677217, 5.924613305040363}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.380228407219979, 
           5.697412499331066}, {-5.380228407219979, 5.724535326011281}}], 
          
          LineBox[{{-5.380228407219979, 
           5.724535326011281}, {-5.380228407219979, 5.750941889303415}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.286352047426554, 
           5.560585817217301}, {-5.286352047426554, 5.58792658332851}}], 
          
          LineBox[{{-5.286352047426554, 
           5.58792658332851}, {-5.286352047426554, 5.614539682791201}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.228332740694611, 
           5.470644416511208}, {-5.228332740694611, 5.495252350499616}}], 
          
          LineBox[{{-5.228332740694611, 
           5.495252350499616}, {-5.228332740694611, 5.519269249124126}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.1734965151745005`, 
           5.3757764657859335`}, {-5.1734965151745005`, 
           5.3975645983572385`}}], 
          
          LineBox[{{-5.1734965151745005`, 
           5.3975645983572385`}, {-5.1734965151745005`, 
           5.418888113368581}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.121512103387059, 
           5.301580317079159}, {-5.121512103387059, 5.322895334449794}}], 
          
          LineBox[{{-5.121512103387059, 
           5.322895334449794}, {-5.121512103387059, 5.343765487651377}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.0720974097604925`, 
           5.213554461677427}, {-5.0720974097604925`, 5.23550234194944}}], 
          
          LineBox[{{-5.0720974097604925`, 
           5.23550234194944}, {-5.0720974097604925`, 
           5.2569788400958775`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.025010372042255, 
           5.154606689525226}, {-5.025010372042255, 5.170691395659697}}], 
          
          LineBox[{{-5.025010372042255, 
           5.170691395659697}, {-5.025010372042255, 
           5.1865214742295365`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.980041374477484, 
           5.069908159886643}, {-4.980041374477484, 5.086838644548193}}], 
          
          LineBox[{{-4.980041374477484, 
           5.086838644548193}, {-4.980041374477484, 5.103487253569169}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.92662358321994, 4.963445770425649}, {-4.92662358321994,
            4.986508076366771}}], 
          
          LineBox[{{-4.92662358321994, 4.986508076366771}, {-4.92662358321994,
            5.009050479975904}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.87574337247038, 4.882016463543931}, {-4.87574337247038,
            4.899052525044205}}], 
          
          LineBox[{{-4.87574337247038, 4.899052525044205}, {-4.87574337247038,
            4.915803213991206}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.827483513108963, 
           4.794668613443834}, {-4.827483513108963, 4.815277906924735}}], 
          
          LineBox[{{-4.827483513108963, 
           4.815277906924735}, {-4.827483513108963, 4.835471020175331}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.77239942676781, 4.701609301421392}, {-4.77239942676781,
            4.720682461524624}}], 
          
          LineBox[{{-4.77239942676781, 4.720682461524624}, {-4.77239942676781,
            4.739398634445729}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.720192452293243, 
           4.6091745324914974`}, {-4.720192452293243, 4.628274823529931}}], 
          
          LineBox[{{-4.720192452293243, 
           4.628274823529931}, {-4.720192452293243, 4.647017120560879}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.670576785004793, 
           4.513219711454581}, {-4.670576785004793, 4.534922545064283}}], 
          
          LineBox[{{-4.670576785004793, 
           4.534922545064283}, {-4.670576785004793, 4.556164353528393}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.623307322213241, 
           4.439005704898653}, {-4.623307322213241, 4.451661981797308}}], 
          
          LineBox[{{-4.623307322213241, 
           4.451661981797308}, {-4.623307322213241, 
           4.4641600772540855`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.578172095309458, 
           4.341809477098288}, {-4.578172095309458, 4.357598539370904}}], 
          
          LineBox[{{-4.578172095309458, 
           4.357598539370904}, {-4.578172095309458, 4.373142177159269}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.528024063416046, 
           4.247169446190361}, {-4.528024063416046, 4.26733293154385}}], 
          
          LineBox[{{-4.528024063416046, 
           4.26733293154385}, {-4.528024063416046, 4.287097873543126}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.473567500947851, 
           4.142864896733381}, {-4.473567500947851, 4.163069007670943}}], 
          
          LineBox[{{-4.473567500947851, 
           4.163069007670943}, {-4.473567500947851, 4.182872983541387}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.4219245540939545`, 
           4.042759737078628}, {-4.4219245540939545`, 4.059435667088285}}], 
          
          LineBox[{{-4.4219245540939545`, 
           4.059435667088285}, {-4.4219245540939545`, 
           4.075838065613418}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.372818566555532, 
           3.9559622089177284`}, {-4.372818566555532, 3.9679306808577666`}}], 
          
          LineBox[{{-4.372818566555532, 
           3.9679306808577666`}, {-4.372818566555532, 
           3.9797576009666327`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.326011954933506, 
           3.8750762882734486`}, {-4.326011954933506, 3.886123846556424}}], 
          
          LineBox[{{-4.326011954933506, 
           3.886123846556424}, {-4.326011954933506, 
           3.8970506886996277`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.275892138786888, 
           3.766025585677875}, {-4.275892138786888, 3.780606366265063}}], 
          
          LineBox[{{-4.275892138786888, 
           3.780606366265063}, {-4.275892138786888, 
           3.7949775993961237`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.222951251037713, 
           3.6633260098323355`}, {-4.222951251037713, 3.6774566923193435`}}], 
          
          LineBox[{{-4.222951251037713, 
           3.6774566923193435`}, {-4.222951251037713, 
           3.6913904776789708`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.172673294218139, 
           3.5596679307174433`}, {-4.172673294218139, 3.576634720630255}}], 
          
          LineBox[{{-4.172673294218139, 
           3.576634720630255}, {-4.172673294218139, 
           3.5933184347925056`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.124803134014643, 
           3.472247846174197}, {-4.124803134014643, 3.4812124301796485`}}], 
          
          LineBox[{{-4.124803134014643, 
           3.4812124301796485`}, {-4.124803134014643, 
           3.4900973639215134`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.074701219535939, 
           3.364332113093484}, {-4.074701219535939, 3.379122099541725}}], 
          
          LineBox[{{-4.074701219535939, 
           3.379122099541725}, {-4.074701219535939, 
           3.3936965265401233`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.026921534839552, 
           3.2723101322494057`}, {-4.026921534839552, 3.2836693555849914`}}], 
          
          LineBox[{{-4.026921534839552, 
           3.2836693555849914`}, {-4.026921534839552, 
           3.2949009948651184`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.9773780413268547`, 
           3.174054059287333}, {-3.9773780413268547`, 3.1864660752822047`}}], 
          
          LineBox[{{-3.9773780413268547`, 
           3.1864660752822047`}, {-3.9773780413268547`, 
           3.1987259199592137`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.9262371908045295`, 
           3.0769409046345766`}, {-3.9262371908045295`, 3.09399724550642}}], 
          
          LineBox[{{-3.9262371908045295`, 
           3.09399724550642}, {-3.9262371908045295`, 3.110767539705583}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.8776461425773476`, 
           2.9726379502540774`}, {-3.8776461425773476`, 2.983281474740106}}], 
          
          LineBox[{{-3.8776461425773476`, 
           2.983281474740106}, {-3.8776461425773476`, 
           2.9938129066259385`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.827799486652153, 
           2.8516367993881273`}, {-3.827799486652153, 2.8670332227653788`}}], 
          
          LineBox[{{-3.827799486652153, 
           2.8670332227653788`}, {-3.827799486652153, 
           2.8821961861961753`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.7770410262852683`, 
           2.7533372954809328`}, {-3.7770410262852683`, 
           2.7632201478256446`}}], 
          
          LineBox[{{-3.7770410262852683`, 
           2.7632201478256446`}, {-3.7770410262852683`, 
           2.773006284447612}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.7255676492705025`, 
           2.6406209974863466`}, {-3.7255676492705025`, 2.651374195948865}}], 
          
          LineBox[{{-3.7255676492705025`, 
           2.651374195948865}, {-3.7255676492705025`, 2.6620129922329}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.6766150586043187`, 
           2.551365370187399}, {-3.6766150586043187`, 2.563562334772086}}], 
          
          LineBox[{{-3.6766150586043187`, 
           2.563562334772086}, {-3.6766150586043187`, 
           2.575612324261619}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.6271250750319357`, 
           2.4434452717025175`}, {-3.6271250750319357`, 2.454515677997838}}], 
          
          LineBox[{{-3.6271250750319357`, 
           2.454515677997838}, {-3.6271250750319357`, 
           2.4654648710530638`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.577239779380398, 
           2.339374076867526}, {-3.577239779380398, 2.3492633993244976`}}], 
          
          LineBox[{{-3.577239779380398, 
           2.3492633993244976`}, {-3.577239779380398, 
           2.359055880000889}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.5271719803333474`, 
           2.2305224068820206`}, {-3.5271719803333474`, 
           2.2407756764125795`}}], 
          
          LineBox[{{-3.5271719803333474`, 
           2.2407756764125795`}, {-3.5271719803333474`, 
           2.2509248824952306`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.4770227859145613`, 
           2.1263134937789534`}, {-3.4770227859145613`, 
           2.1358223222840604`}}], 
          
          LineBox[{{-3.4770227859145613`, 
           2.1358223222840604`}, {-3.4770227859145613`, 
           2.145241583976579}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.4269594457071775`, 
           2.0232697854946724`}, {-3.4269594457071775`, 
           2.0349547769344554`}}], 
          
          LineBox[{{-3.4269594457071775`, 
           2.0349547769344554`}, {-3.4269594457071775`, 
           2.0465048048786794`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.377049578478242, 
           1.9139762830156788`}, {-3.377049578478242, 1.9249233754627164`}}], 
          
          LineBox[{{-3.377049578478242, 
           1.9249233754627164`}, {-3.377049578478242, 
           1.9357519255993363`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.327422124402821, 
           1.8083466762130214`}, {-3.327422124402821, 1.8169673703350642`}}], 
          
          LineBox[{{-3.327422124402821, 
           1.8169673703350642`}, {-3.327422124402821, 
           1.8255143828243687`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.2761327623308096`, 
           1.7076587303609376`}, {-3.2761327623308096`, 
           1.7184210346944193`}}], 
          
          LineBox[{{-3.2761327623308096`, 
           1.7184210346944193`}, {-3.2761327623308096`, 
           1.7290687440450971`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.2254264836890396`, 
           1.594477253401151}, {-3.2254264836890396`, 1.6041591287990704`}}], 
          
          LineBox[{{-3.2254264836890396`, 
           1.6041591287990704`}, {-3.2254264836890396`, 
           1.6137481636382192`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.17716826024446, 1.497800646342015}, {-3.17716826024446,
            1.5061576566784902`}}], 
          
          LineBox[{{-3.17716826024446, 
           1.5061576566784902`}, {-3.17716826024446, 
           1.5144454058100512`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.127705210497175, 
           1.3849457791552466`}, {-3.127705210497175, 1.3960273849292266`}}], 
          
          LineBox[{{-3.127705210497175, 
           1.3960273849292266`}, {-3.127705210497175, 
           1.4069875334290052`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.077261733718196, 
           1.2777257519296135`}, {-3.077261733718196, 1.2860838467166507`}}], 
          
          LineBox[{{-3.077261733718196, 
           1.2860838467166507`}, {-3.077261733718196, 1.2943726623966}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.0276924518494375`, 
           1.1640893023998142`}, {-3.0276924518494375`, 1.172003271031062}}], 
          
          LineBox[{{-3.0276924518494375`, 
           1.172003271031062}, {-3.0276924518494375`, 
           1.1798551002107107`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.977298040136891, 
           1.057455810821756}, {-2.977298040136891, 1.0666279270797743`}}], 
          
          LineBox[{{-2.977298040136891, 
           1.0666279270797743`}, {-2.977298040136891, 
           1.075716679663337}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.932588839908245, 
           0.9633419111528586}, {-2.932588839908245, 0.9719041815365776}}], 
          
          LineBox[{{-2.932588839908245, 
           0.9719041815365776}, {-2.932588839908245, 
           0.9803937614017253}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.522480231534296, 
           0.02745778702206065}, {-2.522480231534296, 0.0725523965352548}}], 
          
          LineBox[{{-2.522480231534296, 
           0.0725523965352548}, {-2.522480231534296, 
           0.11570092450757392`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.380038563220422, -0.2943539415601956}, \
{-2.380038563220422, -0.2540582315229037}}], 
          
          LineBox[{{-2.380038563220422, -0.2540582315229037}, \
{-2.380038563220422, -0.2153235653897459}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.2851211182798545`, -0.5204174839180119}, \
{-2.2851211182798545`, -0.48349383498829546`}}], 
          
          LineBox[{{-2.2851211182798545`, -0.48349383498829546`}, \
{-2.2851211182798545`, -0.4478851333229762}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.226506167649257, -0.6570699433774596}, \
{-2.226506167649257, -0.6226186257015528}}], 
          
          LineBox[{{-2.226506167649257, -0.6226186257015528}, \
{-2.226506167649257, -0.5893147791310508}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.1711381157832257`, -0.7914974767239965}, \
{-2.1711381157832257`, -0.7574996899745435}}], 
          
          LineBox[{{-2.1711381157832257`, -0.7574996899745435}, \
{-2.1711381157832257`, -0.7246198491756652}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.1186760185140363`, -0.9196802472233837}, \
{-2.1186760185140363`, -0.8868122185627191}}], 
          
          LineBox[{{-2.1186760185140363`, -0.8868122185627191}, \
{-2.1186760185140363`, -0.8549902078296127}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.0688299492905053`, -1.0443693951020259`}, \
{-2.0688299492905053`, -1.0133484345063426`}}], 
          
          LineBox[{{-2.0688299492905053`, -1.0133484345063426`}, \
{-2.0688299492905053`, -0.9832608910085139}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.021351319690928, -1.1614588179411809`}, \
{-2.021351319690928, -1.1321537609085568`}}], 
          
          LineBox[{{-2.021351319690928, -1.1321537609085568`}, \
{-2.021351319690928, -1.1036830963360957`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.976025406568619, -1.2752865764674561`}, \
{-1.976025406568619, -1.2471795719103893`}}], 
          
          LineBox[{{-1.976025406568619, -1.2471795719103893`}, \
{-1.976025406568619, -1.2198410213243125`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.9326653384575119`, -1.3832036196935122`}, \
{-1.9326653384575119`, -1.3559211852686959`}}], 
          
          LineBox[{{-1.9326653384575119`, -1.3559211852686959`}, \
{-1.9326653384575119`, -1.3293633568075913`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.8810672419769725`, -1.5190633412136754`}, \
{-1.8810672419769725`, -1.4885651075787771`}}], 
          
          LineBox[{{-1.8810672419769725`, -1.4885651075787771`}, \
{-1.8810672419769725`, -1.4589695539475065`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.8223707416388202`, -1.6720365519370128`}, \
{-1.8223707416388202`, -1.6423101727791038`}}], 
          
          LineBox[{{-1.8223707416388202`, -1.6423101727791038`}, \
{-1.8223707416388202`, -1.613442001204677}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.7758907745205157`, -1.7914998178076416`}, \
{-1.7758907745205157`, -1.7671801883900236`}}], 
          
          LineBox[{{-1.7758907745205157`, -1.7671801883900236`}, \
{-1.7758907745205157`, -1.7434379882642659`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.7316070609965282`, -1.9140224961551888`}, \
{-1.7316070609965282`, -1.8860210342570252`}}], 
          
          LineBox[{{-1.7316070609965282`, -1.8860210342570252`}, \
{-1.7316070609965282`, -1.8587823439867361`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.680857774871063, -2.050558714883264}, \
{-1.680857774871063, -2.0245982496429376`}}], 
          
          LineBox[{{-1.680857774871063, -2.0245982496429376`}, \
{-1.680857774871063, -1.9992947119724331`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.632560487956873, -2.184110541886247}, \
{-1.632560487956873, -2.158498034820748}}], 
          
          LineBox[{{-1.632560487956873, -2.158498034820748}, \
{-1.632560487956873, -2.13352517928731}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.5790774413137347`, -2.336709945413305}, \
{-1.5790774413137347`, -2.309297545959301}}], 
          
          LineBox[{{-1.5790774413137347`, -2.309297545959301}, \
{-1.5790774413137347`, -2.2826165803704477`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.5281875999704038`, -2.4783661901067435`}, \
{-1.5281875999704038`, -2.4539070972046724`}}], 
          
          LineBox[{{-1.5281875999704038`, -2.4539070972046724`}, \
{-1.5281875999704038`, -2.4300319960383896`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.4798745637368198`, -2.620096613687998}, \
{-1.4798745637368198`, -2.5946590550859727`}}], 
          
          LineBox[{{-1.4798745637368198`, -2.5946590550859727`}, \
{-1.4798745637368198`, -2.569852546677861}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.4273150021222818`, -2.7753588844487713`}, \
{-1.4273150021222818`, -2.7501385346736305`}}], 
          
          LineBox[{{-1.4273150021222818`, -2.7501385346736305`}, \
{-1.4273150021222818`, -2.725538635048676}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.377381030775886, -2.9229826108926}, \
{-1.377381030775886, -2.8995121026845423`}}], 
          
          LineBox[{{-1.377381030775886, -2.8995121026845423`}, \
{-1.377381030775886, -2.8765798502373157`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.329822772449285, -3.066520131184286}, \
{-1.329822772449285, -3.043719852520491}}], 
          
          LineBox[{{-1.329822772449285, -3.043719852520491}, \
{-1.329822772449285, -3.0214278590478707`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.2789374525299622`, -3.224025983534785}, \
{-1.2789374525299622`, -3.1993743388776505`}}], 
          
          LineBox[{{-1.2789374525299622`, -3.1993743388776505`}, \
{-1.2789374525299622`, -3.1753158059383164`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.2252283792125176`, -3.3927366639556795`}, \
{-1.2252283792125176`, -3.36904769546062}}], 
          
          LineBox[{{-1.2252283792125176`, -3.36904769546062}, \
{-1.2252283792125176`, -3.345906932805359}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.1742581157840541`, -3.552982557965538}, \
{-1.1742581157840541`, -3.5306656880880185`}}], 
          
          LineBox[{{-1.1742581157840541`, -3.5306656880880185`}, \
{-1.1742581157840541`, -3.5088360081161154`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.125760810882863, -3.709098828699062}, \
{-1.125760810882863, -3.6870177862772393`}}], 
          
          LineBox[{{-1.125760810882863, -3.6870177862772393`}, \
{-1.125760810882863, -3.6654138013276816`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.0750347908756233`, -3.878058147161652}, \
{-1.0750347908756233`, -3.854916629396177}}], 
          
          LineBox[{{-1.0750347908756233`, -3.854916629396177}, \
{-1.0750347908756233`, -3.8322985511217267`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.026687762897248, -4.033717919724653}, \
{-1.026687762897248, -4.013181879917808}}], 
          
          LineBox[{{-1.026687762897248, -4.013181879917808}, \
{-1.026687762897248, -3.9930590966207373`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-0.9806356434778151, -4.190253280459673}, \
{-0.9806356434778151, -4.168688260425477}}], 
          
          LineBox[{{-0.9806356434778151, -4.168688260425477}, \
{-0.9806356434778151, -4.147578490277431}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-0.9288080748978164, -4.366441817876594}, \
{-0.9288080748978164, -4.3444314394609576`}}], 
          
          LineBox[{{-0.9288080748978164, -4.3444314394609576`}, \
{-0.9288080748978164, -4.32289510269239}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-0.8758086169295246, -4.545513687607098}, \
{-0.8758086169295246, -4.524528475851065}}], 
          
          LineBox[{{-0.8758086169295246, -4.524528475851065}, \
{-0.8758086169295246, -4.503974606891383}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-0.8254778772492771, -4.714570644480026}, \
{-0.8254778772492771, -4.694697112542122}}], 
          
          LineBox[{{-0.8254778772492771, -4.694697112542122}, \
{-0.8254778772492771, -4.675210853885714}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-0.7775597923865766, -4.877361890537961}, \
{-0.7775597923865766, -4.85865032938524}}], 
          
          LineBox[{{-0.7775597923865766, -4.85865032938524}, \
{-0.7775597923865766, -4.84028246941142}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-0.7286714703974044, -5.046748473230386}, \
{-0.7286714703974044, -5.027630866116531}}], 
          
          LineBox[{{-0.7286714703974044, -5.027630866116531}, \
{-0.7286714703974044, -5.008871896334708}}]}}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-5.483842181677217, 
           4.675900169545167}, {-5.483842181677217, 4.722487759710027}}], 
          
          LineBox[{{-5.483842181677217, 
           4.722487759710027}, {-5.483842181677217, 4.767001216777024}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-5.380228407219979, 
           4.580655707081528}, {-5.380228407219979, 4.591693535995225}}], 
          
          LineBox[{{-5.380228407219979, 
           4.591693535995225}, {-5.380228407219979, 4.602610860142691}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-5.286352047426554, 
           4.464462838819469}, {-5.286352047426554, 4.477944949531135}}], 
          
          LineBox[{{-5.286352047426554, 
           4.477944949531135}, {-5.286352047426554, 4.491247708295837}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-5.228332740694611, 
           4.434381809600946}, {-5.228332740694611, 4.442654771155675}}], 
          
          LineBox[{{-5.228332740694611, 
           4.442654771155675}, {-5.228332740694611, 4.450859852007981}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-5.1734965151745005`, 
           4.36819534389658}, {-5.1734965151745005`, 4.395116224906497}}], 
          
          LineBox[{{-5.1734965151745005`, 
           4.395116224906497}, {-5.1734965151745005`, 
           4.421331330667573}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-5.121512103387059, 4.3045232614309}, {-5.121512103387059,
            4.32167994683415}}], 
          
          LineBox[{{-5.121512103387059, 
           4.32167994683415}, {-5.121512103387059, 4.338547238442871}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-5.0720974097604925`, 
           4.2172438412122935`}, {-5.0720974097604925`, 4.234949461390515}}], 
          
          LineBox[{{-5.0720974097604925`, 
           4.234949461390515}, {-5.0720974097604925`, 
           4.252347038764525}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-5.025010372042255, 
           4.135681955041758}, {-5.025010372042255, 4.150038384681967}}], 
          
          LineBox[{{-5.025010372042255, 
           4.150038384681967}, {-5.025010372042255, 
           4.1641916209411045`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.980041374477484, 
           4.04476333851624}, {-4.980041374477484, 4.072566500423234}}], 
          
          LineBox[{{-4.980041374477484, 
           4.072566500423234}, {-4.980041374477484, 4.099617511548654}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.92662358321994, 
           3.9735250386888508`}, {-4.92662358321994, 3.9958820215200213`}}], 
          
          LineBox[{{-4.92662358321994, 
           3.9958820215200213`}, {-4.92662358321994, 
           4.0177500806103215`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.87574337247038, 3.88897642963578}, {-4.87574337247038, 
           3.91203914237788}}], 
          
          LineBox[{{-4.87574337247038, 3.91203914237788}, {-4.87574337247038, 
           3.9345819346524675`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.827483513108963, 
           3.7581394711940503`}, {-4.827483513108963, 3.795755309950172}}], 
          
          LineBox[{{-4.827483513108963, 
           3.795755309950172}, {-4.827483513108963, 
           3.8320073431036508`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.77239942676781, 3.707398226474566}, {-4.77239942676781,
            3.7276301384501145`}}], 
          
          LineBox[{{-4.77239942676781, 
           3.7276301384501145`}, {-4.77239942676781, 
           3.7474608243202425`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.720192452293243, 
           3.6107586154312252`}, {-4.720192452293243, 3.626349371202599}}], 
          
          LineBox[{{-4.720192452293243, 
           3.626349371202599}, {-4.720192452293243, 3.641700782102213}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.670576785004793, 
           3.495286125709503}, {-4.670576785004793, 3.5150526466269087`}}], 
          
          LineBox[{{-4.670576785004793, 
           3.5150526466269087`}, {-4.670576785004793, 
           3.534436013582646}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.623307322213241, 
           3.428557093367157}, {-4.623307322213241, 3.448619010582719}}], 
          
          LineBox[{{-4.623307322213241, 
           3.448619010582719}, {-4.623307322213241, 
           3.4682863502837464`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.578172095309458, 
           3.352007440412228}, {-4.578172095309458, 3.3716483652783027`}}], 
          
          LineBox[{{-4.578172095309458, 
           3.3716483652783027`}, {-4.578172095309458, 
           3.3909109433671523`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.528024063416046, 
           3.2500238805129245`}, {-4.528024063416046, 3.2740499603840263`}}], 
          
          LineBox[{{-4.528024063416046, 
           3.2740499603840263`}, {-4.528024063416046, 
           3.2975123055940747`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.473567500947851, 
           3.154123844037605}, {-4.473567500947851, 3.176243375573975}}], 
          
          LineBox[{{-4.473567500947851, 
           3.176243375573975}, {-4.473567500947851, 
           3.1978842030492856`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.4219245540939545`, 
           3.08091971269431}, {-4.4219245540939545`, 3.0971456948544214`}}], 
          
          LineBox[{{-4.4219245540939545`, 
           3.0971456948544214`}, {-4.4219245540939545`, 
           3.1131125928194745`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.372818566555532, 
           2.982522600129852}, {-4.372818566555532, 2.9982834426283276`}}], 
          
          LineBox[{{-4.372818566555532, 
           2.9982834426283276`}, {-4.372818566555532, 
           3.013799730375699}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.326011954933506, 
           2.9004166024112616`}, {-4.326011954933506, 2.911216207184414}}], 
          
          LineBox[{{-4.326011954933506, 
           2.911216207184414}, {-4.326011954933506, 2.921900425512824}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.275892138786888, 
           2.7995855725978562`}, {-4.275892138786888, 2.8127975145660082`}}], 
          
          LineBox[{{-4.275892138786888, 
           2.8127975145660082`}, {-4.275892138786888, 2.82583717482616}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.222951251037713, 
           2.7210828756265157`}, {-4.222951251037713, 2.7326949387608126`}}], 
          
          LineBox[{{-4.222951251037713, 
           2.7326949387608126`}, {-4.222951251037713, 
           2.7441737082188844`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.172673294218139, 
           2.620628529150354}, {-4.172673294218139, 2.6302194646139734`}}], 
          LineBox[{{-4.172673294218139, 
           2.6302194646139734`}, {-4.172673294218139, 
           2.6397192872004616`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.124803134014643, 
           2.501607487296671}, {-4.124803134014643, 2.522376458985155}}], 
          
          LineBox[{{-4.124803134014643, 
           2.522376458985155}, {-4.124803134014643, 
           2.5427228423330206`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.074701219535939, 
           2.416279595973625}, {-4.074701219535939, 2.4250442182526317`}}], 
          
          LineBox[{{-4.074701219535939, 
           2.4250442182526317`}, {-4.074701219535939, 
           2.433732688885111}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.026921534839552, 
           2.306727609287834}, {-4.026921534839552, 2.3230301595626983`}}], 
          
          LineBox[{{-4.026921534839552, 
           2.3230301595626983`}, {-4.026921534839552, 
           2.339071194362285}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.9773780413268547`, 
           2.2291586947642044`}, {-3.9773780413268547`, 
           2.2455736482920776`}}], 
          
          LineBox[{{-3.9773780413268547`, 
           2.2455736482920776`}, {-3.9773780413268547`, 
           2.261723496948268}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.9262371908045295`, 
           2.112757793346774}, {-3.9262371908045295`, 2.1272201641977317`}}], 
          
          LineBox[{{-3.9262371908045295`, 
           2.1272201641977317`}, {-3.9262371908045295`, 
           2.1414763532137373`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.8776461425773476`, 
           2.0266566701081334`}, {-3.8776461425773476`, 2.041993791005915}}], 
          
          LineBox[{{-3.8776461425773476`, 
           2.041993791005915}, {-3.8776461425773476`, 
           2.057099233434189}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.827799486652153, 
           1.9206648813388483`}, {-3.827799486652153, 1.9353570342644473`}}], 
          
          LineBox[{{-3.827799486652153, 
           1.9353570342644473`}, {-3.827799486652153, 
           1.9498364496338338`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.7770410262852683`, 
           1.7922954729847043`}, {-3.7770410262852683`, 1.799598716148061}}], 
          
          LineBox[{{-3.7770410262852683`, 
           1.799598716148061}, {-3.7770410262852683`, 
           1.806849008430228}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.7255676492705025`, 
           1.673599878805249}, {-3.7255676492705025`, 1.689826336257677}}], 
          
          LineBox[{{-3.7255676492705025`, 
           1.689826336257677}, {-3.7255676492705025`, 
           1.7057936944574732`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.6766150586043187`, 
           1.572230977626313}, {-3.6766150586043187`, 1.584961479341827}}], 
          
          LineBox[{{-3.6766150586043187`, 
           1.584961479341827}, {-3.6766150586043187`, 
           1.5975319505183612`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.6271250750319357`, 
           1.4607451696770724`}, {-3.6271250750319357`, 
           1.4695452773030806`}}], 
          
          LineBox[{{-3.6271250750319357`, 
           1.4695452773030806`}, {-3.6271250750319357`, 
           1.478268618100126}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.577239779380398, 
           1.3964142671080735`}, {-3.577239779380398, 1.407776803634236}}], 
          
          LineBox[{{-3.577239779380398, 
           1.407776803634236}, {-3.577239779380398, 1.419011682085602}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.5271719803333474`, 
           1.2804499657627177`}, {-3.5271719803333474`, 
           1.2899692122934803`}}], 
          
          LineBox[{{-3.5271719803333474`, 
           1.2899692122934803`}, {-3.5271719803333474`, 
           1.2993986965673514`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.4770227859145613`, 
           1.1652540781110206`}, {-3.4770227859145613`, 1.178039179655991}}], 
          
          LineBox[{{-3.4770227859145613`, 
           1.178039179655991}, {-3.4770227859145613`, 
           1.1906628836922677`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.4269594457071775`, 
           1.063871698425543}, {-3.4269594457071775`, 1.0741896382486367`}}], 
          
          LineBox[{{-3.4269594457071775`, 
           1.0741896382486367`}, {-3.4269594457071775`, 
           1.0844022045023987`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.377049578478242, 
           0.956309477000897}, {-3.377049578478242, 0.9698918423305931}}], 
          
          LineBox[{{-3.377049578478242, 
           0.9698918423305931}, {-3.377049578478242, 0.983292196395228}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.327422124402821, 
           0.8468705840733722}, {-3.327422124402821, 0.8600252786589343}}], 
          
          LineBox[{{-3.327422124402821, 
           0.8600252786589343}, {-3.327422124402821, 
           0.8730091716664086}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.2761327623308096`, 
           0.7668825321796741}, {-3.2761327623308096`, 0.773740608360407}}], 
          
          LineBox[{{-3.2761327623308096`, 
           0.773740608360407}, {-3.2761327623308096`, 
           0.7805519715119112}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.2254264836890396`, 
           0.6323221206067006}, {-3.2254264836890396`, 0.6460382595089121}}], 
          
          LineBox[{{-3.2254264836890396`, 
           0.6460382595089121}, {-3.2254264836890396`, 
           0.659568808649463}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.17716826024446, 
           0.5420589480904371}, {-3.17716826024446, 0.5514411034048418}}], 
          
          LineBox[{{-3.17716826024446, 
           0.5514411034048418}, {-3.17716826024446, 0.5607360514393951}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.127705210497175, 
           0.4433440239053005}, {-3.127705210497175, 0.4558989864602742}}], 
          
          LineBox[{{-3.127705210497175, 
           0.4558989864602742}, {-3.127705210497175, 
           0.4682982743999501}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.077261733718196, 
           0.3348411766934679}, {-3.077261733718196, 0.3448001390495084}}], 
          
          LineBox[{{-3.077261733718196, 
           0.3448001390495084}, {-3.077261733718196, 
           0.35466089767791276`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.0276924518494375`, 
           0.2309946210793196}, {-3.0276924518494375`, 
           0.24311640778114302`}}], 
          
          LineBox[{{-3.0276924518494375`, 
           0.24311640778114302`}, {-3.0276924518494375`, 
           0.25509301485026975`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.977298040136891, 
           0.11431777608292373`}, {-2.977298040136891, 
           0.12640916259054974`}}], 
          
          LineBox[{{-2.977298040136891, 
           0.12640916259054974`}, {-2.977298040136891, 
           0.1383560924131667}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.932588839908245, 
           0.01918865292186883}, {-2.932588839908245, 0.02746518822426405}}], 
          
          LineBox[{{-2.932588839908245, 
           0.02746518822426405}, {-2.932588839908245, 
           0.035673784405938345`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.522480231534296, -0.8760746896286001}, \
{-2.522480231534296, -0.8327006647670928}}], 
          
          LineBox[{{-2.522480231534296, -0.8327006647670928}, \
{-2.522480231534296, -0.7911299979833759}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.380038563220422, -1.188679489471253}, \
{-2.380038563220422, -1.149769111811792}}], 
          
          LineBox[{{-2.380038563220422, -1.149769111811792}, \
{-2.380038563220422, -1.1123162174051857`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.2851211182798545`, -1.4040532366707095`}, \
{-2.2851211182798545`, -1.3694020314692246`}}], 
          
          LineBox[{{-2.2851211182798545`, -1.3694020314692246`}, \
{-2.2851211182798545`, -1.3359114282641018`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.226506167649257, -1.536992277861183}, \
{-2.226506167649257, -1.5036289689645517`}}], 
          
          LineBox[{{-2.226506167649257, -1.5036289689645517`}, \
{-2.226506167649257, -1.4713429259874147`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.1711381157832257`, -1.6643492238645232`}, \
{-2.1711381157832257`, -1.6320606457246563`}}], 
          
          LineBox[{{-2.1711381157832257`, -1.6320606457246563`}, \
{-2.1711381157832257`, -1.6007820925927845`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.1186760185140363`, -1.7882096921869584`}, \
{-2.1186760185140363`, -1.7562026084573796`}}], 
          
          LineBox[{{-2.1186760185140363`, -1.7562026084573796`}, \
{-2.1186760185140363`, -1.7251882848989442`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.0688299492905053`, -1.9055862747248606`}, \
{-2.0688299492905053`, -1.8762558088502688`}}], 
          
          LineBox[{{-2.0688299492905053`, -1.8762558088502688`}, \
{-2.0688299492905053`, -1.8477611624395294`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.021351319690928, -2.0169460097513228`}, \
{-2.021351319690928, -1.9887319195712214`}}], 
          
          LineBox[{{-2.021351319690928, -1.9887319195712214`}, \
{-2.021351319690928, -1.9612920697377043`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.976025406568619, -2.123870062357529}, \
{-1.976025406568619, -2.0973974509689617`}}], 
          
          LineBox[{{-1.976025406568619, -2.0973974509689617`}, \
{-1.976025406568619, -2.071607603045859}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.9326653384575119`, -2.2260664073148075`}, \
{-1.9326653384575119`, -2.1997515220253065`}}], 
          
          LineBox[{{-1.9326653384575119`, -2.1997515220253065`}, \
{-1.9326653384575119`, -2.1741113917603183`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.8810672419769725`, -2.3542738844936646`}, \
{-1.8810672419769725`, -2.3254991793012008`}}], 
          
          LineBox[{{-1.8810672419769725`, -2.3254991793012008`}, \
{-1.8810672419769725`, -2.2975293516340036`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.8223707416388202`, -2.497909230983027}, \
{-1.8223707416388202`, -2.470219931944728}}], 
          
          LineBox[{{-1.8223707416388202`, -2.470219931944728}, \
{-1.8223707416388202`, -2.443276717996786}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.7758907745205157`, -2.610289844671692}, \
{-1.7758907745205157`, -2.5871583116671633`}}], 
          
          LineBox[{{-1.7758907745205157`, -2.5871583116671633`}, \
{-1.7758907745205157`, -2.564549771644241}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.7316070609965282`, -2.7232489920745655`}, \
{-1.7316070609965282`, -2.6974982439253865`}}], 
          
          LineBox[{{-1.7316070609965282`, -2.6974982439253865`}, \
{-1.7316070609965282`, -2.6723939840750104`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.680857774871063, -2.8516523232979885`}, \
{-1.680857774871063, -2.8267910358424957`}}], 
          
          LineBox[{{-1.680857774871063, -2.8267910358424957`}, \
{-1.680857774871063, -2.8025328679816677`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.632560487956873, -2.9732951942549906`}, \
{-1.632560487956873, -2.9495813138545848`}}], 
          
          LineBox[{{-1.632560487956873, -2.9495813138545848`}, \
{-1.632560487956873, -2.9264167795957152`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.5790774413137347`, -3.1161575684046046`}, \
{-1.5790774413137347`, -3.090723046868166}}], 
          
          LineBox[{{-1.5790774413137347`, -3.090723046868166}, \
{-1.5790774413137347`, -3.0659194267097503`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.5281875999704038`, -3.2460769227898476`}, \
{-1.5281875999704038`, -3.224968198293915}}], 
          
          LineBox[{{-1.5281875999704038`, -3.224968198293915}, \
{-1.5281875999704038`, -3.2042958564351913`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.4798745637368198`, -3.3783467133882854`}, \
{-1.4798745637368198`, -3.3547495285734725`}}], 
          
          LineBox[{{-1.4798745637368198`, -3.3547495285734725`}, \
{-1.4798745637368198`, -3.3316963583381365`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.4273150021222818`, -3.5189825744148915`}, \
{-1.4273150021222818`, -3.4959242007758196`}}], 
          
          LineBox[{{-1.4273150021222818`, -3.4959242007758196`}, \
{-1.4273150021222818`, -3.47338555417941}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.377381030775886, -3.6534171177365002`}, \
{-1.377381030775886, -3.6314528966915143`}}], 
          
          LineBox[{{-1.377381030775886, -3.6314528966915143`}, \
{-1.377381030775886, -3.6099607524241524`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.329822772449285, -3.785488625627486}, \
{-1.329822772449285, -3.764181262227396}}], 
          
          LineBox[{{-1.329822772449285, -3.764181262227396}, \
{-1.329822772449285, -3.7433184468830034`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.2789374525299622`, -3.930535813078375}, \
{-1.2789374525299622`, -3.907687355172488}}], 
          
          LineBox[{{-1.2789374525299622`, -3.907687355172488}, \
{-1.2789374525299622`, -3.8853493088854147`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.2252283792125176`, -4.082594008818626}, \
{-1.2252283792125176`, -4.06116943781234}}], 
          
          LineBox[{{-1.2252283792125176`, -4.06116943781234}, \
{-1.2252283792125176`, -4.0401942676574905`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.1742581157840541`, -4.229261663014666}, \
{-1.1742581157840541`, -4.209148099230967}}], 
          
          LineBox[{{-1.1742581157840541`, -4.209148099230967}, \
{-1.1742581157840541`, -4.1894311271296365`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.125760810882863, -4.367588909483971}, \
{-1.125760810882863, -4.348285910520277}}], 
          
          LineBox[{{-1.125760810882863, -4.348285910520277}, \
{-1.125760810882863, -4.329348472047461}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.0750347908756233`, -4.52076224841439}, \
{-1.0750347908756233`, -4.4997251888140815`}}], 
          
          LineBox[{{-1.0750347908756233`, -4.4997251888140815`}, \
{-1.0750347908756233`, -4.479121584129528}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.026687762897248, -4.665686978504849}, \
{-1.026687762897248, -4.646493103086148}}], 
          
          LineBox[{{-1.026687762897248, -4.646493103086148}, \
{-1.026687762897248, -4.627660705253593}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-0.9765855081311018, -4.814610234623728}, \
{-0.9765855081311018, -4.795323900706378}}], 
          
          LineBox[{{-0.9765855081311018, -4.795323900706378}, \
{-0.9765855081311018, -4.776402502294601}}]}}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-5.084348085637381, 
           3.279452909016259}, {-5.084348085637381, 3.314542386460722}}], 
          LineBox[{{-5.084348085637381, 
           3.314542386460722}, {-5.084348085637381, 
           3.3484422185909875`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-5.025010372042255, 
           3.140434407492224}, {-5.025010372042255, 3.1904604070222797`}}], 
          
          LineBox[{{-5.025010372042255, 
           3.1904604070222797`}, {-5.025010372042255, 
           3.2381025855518906`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.980041374477484, 
           3.1323237699105575`}, {-4.980041374477484, 3.1435417916075243`}}], 
          
          LineBox[{{-4.980041374477484, 
           3.1435417916075243`}, {-4.980041374477484, 
           3.1546353640772167`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.937008119887209, 
           3.066195063650514}, {-4.937008119887209, 3.0971495065080012`}}], 
          
          LineBox[{{-4.937008119887209, 
           3.0971495065080012`}, {-4.937008119887209, 
           3.1271744713226384`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.885780418275388, 
           2.980880103532562}, {-4.885780418275388, 3.0018829905983417`}}], 
          
          LineBox[{{-4.885780418275388, 
           3.0018829905983417`}, {-4.885780418275388, 
           3.0224538153984084`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.836890997791754, 
           2.8853086808053727`}, {-4.836890997791754, 2.917386374898896}}], 
          
          LineBox[{{-4.836890997791754, 
           2.917386374898896}, {-4.836890997791754, 2.948466991640423}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.7904256789098545`, 
           2.867518294899543}, {-4.7904256789098545`, 2.8704834190774}}], 
          
          LineBox[{{-4.7904256789098545`, 
           2.8704834190774}, {-4.7904256789098545`, 2.87343977727967}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.737293643353486, 
           2.7675594381395063`}, {-4.737293643353486, 2.779143118662392}}], 
          
          LineBox[{{-4.737293643353486, 
           2.779143118662392}, {-4.737293643353486, 
           2.7905941526002507`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.686843305597875, 
           2.6839107663004125`}, {-4.686843305597875, 2.7048203417960495`}}], 
          
          LineBox[{{-4.686843305597875, 
           2.7048203417960495`}, {-4.686843305597875, 
           2.725301646618478}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          LineBox[{{-4.638816810695785, 
           2.629128336773666}, {-4.638816810695785, 2.638824047974745}}], 
          
          LineBox[{{-4.638816810695785, 
           2.638824047974745}, {-4.638816810695785, 2.648426654355215}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.585618618209504, 
           2.5486602406331813`}, {-4.585618618209504, 2.5808989903535555`}}], 
          
          LineBox[{{-4.585618618209504, 
           2.5808989903535555`}, {-4.585618618209504, 
           2.612130781684148}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.5349866218238715`, 
           2.432122173533449}, {-4.5349866218238715`, 2.451369566215743}}], 
          
          LineBox[{{-4.5349866218238715`, 
           2.451369566215743}, {-4.5349866218238715`, 
           2.4702534817512425`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.486906098502099, 
           2.3587307662098245`}, {-4.486906098502099, 2.3682333031194784`}}], 
          
          LineBox[{{-4.486906098502099, 
           2.3682333031194784`}, {-4.486906098502099, 
           2.3776463911459764`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.434587362995433, 
           2.252412966869751}, {-4.434587362995433, 2.27081507675031}}], 
          
          LineBox[{{-4.434587362995433, 
           2.27081507675031}, {-4.434587362995433, 2.288884658979055}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.384870809286841, 
           2.1472727615170455`}, {-4.384870809286841, 2.166335247286328}}], 
          
          LineBox[{{-4.384870809286841, 
           2.166335247286328}, {-4.384870809286841, 
           2.1850411416152133`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.331793922235689, 
           2.087616762960733}, {-4.331793922235689, 2.098801133098538}}], 
          
          LineBox[{{-4.331793922235689, 
           2.098801133098538}, {-4.331793922235689, 
           2.1098617954196928`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.281298916050743, 
           2.031836786797353}, {-4.281298916050743, 2.047598741387879}}], 
          
          LineBox[{{-4.281298916050743, 
           2.047598741387879}, {-4.281298916050743, 2.063116106981403}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.233317532819553, 
           1.9443344626136934`}, {-4.233317532819553, 1.953624495023331}}], 
          
          LineBox[{{-4.233317532819553, 
           1.953624495023331}, {-4.233317532819553, 
           1.9628290165206077`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.182528650278334, 
           1.8311199246586698`}, {-4.182528650278334, 1.8497226371786375`}}], 
          
          LineBox[{{-4.182528650278334, 
           1.8497226371786375`}, {-4.182528650278334, 
           1.8679855994430858`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.134195560414886, 
           1.7614067111146317`}, {-4.134195560414886, 1.7702461119108914`}}], 
          
          LineBox[{{-4.134195560414886, 
           1.7702461119108914`}, {-4.134195560414886, 
           1.7790080618202642`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.083632876366685, 
           1.643792427856789}, {-4.083632876366685, 1.661769974238217}}], 
          
          LineBox[{{-4.083632876366685, 
           1.661769974238217}, {-4.083632876366685, 
           1.6794300277880683`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.031202073622229, 
           1.5702878893397565`}, {-4.031202073622229, 1.5871056630155926`}}], 
          
          LineBox[{{-4.031202073622229, 
           1.5871056630155926`}, {-4.031202073622229, 
           1.6036452708621975`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.9813843596872887`, 
           1.4711436619786875`}, {-3.9813843596872887`, 
           1.4878395831415843`}}], 
          
          LineBox[{{-3.9813843596872887`, 
           1.4878395831415843`}, {-3.9813843596872887`, 
           1.5042613219829941`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.9339315540729225`, 
           1.3543496971527986`}, {-3.9339315540729225`, 1.37490561030113}}], 
          
          LineBox[{{-3.9339315540729225`, 
           1.37490561030113}, {-3.9339315540729225`, 
           1.3950474747476804`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.8849743942398893`, 
           1.2646481673035028`}, {-3.8849743942398893`, 
           1.2884072320514817`}}], 
          
          LineBox[{{-3.8849743942398893`, 
           1.2884072320514817`}, {-3.8849743942398893`, 
           1.3116148794653462`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.8347700755229908`, 
           1.157998137133887}, {-3.8347700755229908`, 1.170749298190538}}], 
          
          LineBox[{{-3.8347700755229908`, 
           1.170749298190538}, {-3.8347700755229908`, 
           1.183339912152852}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.7836656131917032`, 
           1.0738231437592032`}, {-3.7836656131917032`, 
           1.0823662293157374`}}], 
          
          LineBox[{{-3.7836656131917032`, 
           1.0823662293157374`}, {-3.7836656131917032`, 
           1.0908369483583602`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.7318587542877983`, 
           0.9277920873382811}, {-3.7318587542877983`, 0.9427635551351089}}], 
          
          LineBox[{{-3.7318587542877983`, 
           0.9427635551351089}, {-3.7318587542877983`, 
           0.9575141803572729}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.6826046446528315`, 
           0.8363669553045435}, {-3.6826046446528315`, 0.8474525887197378}}], 
          
          LineBox[{{-3.6826046446528315`, 
           0.8474525887197378}, {-3.6826046446528315`, 
           0.8584166770400009}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.6328247148137414`, 
           0.7423729993329857}, {-3.6328247148137414`, 0.7570295290775163}}], 
          
          LineBox[{{-3.6328247148137414`, 
           0.7570295290775163}, {-3.6328247148137414`, 
           0.7714743442240471}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.582661256928897, 
           0.647354795317877}, {-3.582661256928897, 0.6649766883645467}}], 
          
          LineBox[{{-3.582661256928897, 
           0.6649766883645467}, {-3.582661256928897, 
           0.6822934200574347}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.5323280693679435`, 
           0.5607889003823958}, {-3.5323280693679435`, 0.572611237303806}}], 
          
          LineBox[{{-3.5323280693679435`, 
           0.572611237303806}, {-3.5323280693679435`, 
           0.5842954380769154}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.4819260190211643`, 
           0.4399705250801725}, {-3.4819260190211643`, 0.4529276018765503}}], 
          
          LineBox[{{-3.4819260190211643`, 
           0.4529276018765503}, {-3.4819260190211643`, 
           0.4657189380585773}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.4339433400456847`, 
           0.34391641136880535`}, {-3.4339433400456847`, 
           0.35825376454778385`}}], 
          
          LineBox[{{-3.4339433400456847`, 
           0.35825376454778385`}, {-3.4339433400456847`, 
           0.3723884601809776}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.383729549397733, 
           0.22678367169179003`}, {-3.383729549397733, 0.2374843489957654}}], 
          
          LineBox[{{-3.383729549397733, 
           0.2374843489957654}, {-3.383729549397733, 
           0.24807173304988714`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.3337423956288244`, 
           0.12689742213572724`}, {-3.3337423956288244`, 
           0.13940466381280547`}}], 
          
          LineBox[{{-3.3337423956288244`, 
           0.13940466381280547`}, {-3.3337423956288244`, 
           0.15175740478401775`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.284167120918414, 
           0.008622408276849635}, {-3.284167120918414, 0.01826662396035124}}], 
          
          LineBox[{{-3.284167120918414, 
           0.01826662396035124}, {-3.284167120918414, 
           0.02781871649599614}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.233062016517094, -0.08266597770769586}, \
{-3.233062016517094, -0.06741801729973676}}], 
          
          LineBox[{{-3.233062016517094, -0.06741801729973676}, \
{-3.233062016517094, -0.05239906958237543}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.1826340373457827`, -0.17288739959377117`}, \
{-3.1826340373457827`, -0.16266550527492635`}}], 
          
          LineBox[{{-3.1826340373457827`, -0.16266550527492635`}, \
{-3.1826340373457827`, -0.15254704171276418`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.1328778939592064`, -0.28508337067898626`}, \
{-3.1328778939592064`, -0.2740472578382911}}], 
          
          LineBox[{{-3.1328778939592064`, -0.2740472578382911}, \
{-3.1328778939592064`, -0.2631316125006203}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.083842293493626, -0.39069333866822975`}, \
{-3.083842293493626, -0.3791990847934415}}], 
          
          LineBox[{{-3.083842293493626, -0.3791990847934415}, \
{-3.083842293493626, -0.367835448856779}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.033953781539961, -0.497182163024974}, \
{-3.033953781539961, -0.4893920941987288}}], 
          
          LineBox[{{-3.033953781539961, -0.4893920941987288}, \
{-3.033953781539961, -0.48166224175718525`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.9829211452899216`, -0.5920564642337651}, \
{-2.9829211452899216`, -0.5774712841091912}}], 
          
          LineBox[{{-2.9829211452899216`, -0.5774712841091912}, \
{-2.9829211452899216`, -0.563095777008525}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.935437193039225, -0.7172713398317058}, \
{-2.935437193039225, -0.7030151323678153}}], 
          
          LineBox[{{-2.935437193039225, -0.7030151323678153}, \
{-2.935437193039225, -0.6889593109561694}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.734894278728679, -1.144668033949282}, \
{-2.734894278728679, -1.091975147121931}}], 
          
          LineBox[{{-2.734894278728679, -1.091975147121931}, \
{-2.734894278728679, -1.041920370727219}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.4849223397830356`, -1.6834380641246345`}, \
{-2.4849223397830356`, -1.6408209719824067`}}], 
          
          LineBox[{{-2.4849223397830356`, -1.6408209719824067`}, \
{-2.4849223397830356`, -1.5999461008742535`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.380038563220422, -1.9108237759488234`}, \
{-2.380038563220422, -1.8722069926232128`}}], 
          
          LineBox[{{-2.380038563220422, -1.8722069926232128`}, \
{-2.380038563220422, -1.835026184318243}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.2851211182798545`, -2.1262706071873487`}, \
{-2.2851211182798545`, -2.091117028684412}}], 
          
          LineBox[{{-2.2851211182798545`, -2.091117028684412}, \
{-2.2851211182798545`, -2.0571573723934438`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.226506167649257, -2.2553812603071863`}, \
{-2.226506167649257, -2.222472940569326}}], 
          
          LineBox[{{-2.226506167649257, -2.222472940569326}, \
{-2.226506167649257, -2.190613164148159}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.144562997373256, -2.438418191817762}, \
{-2.144562997373256, -2.4091549285013123`}}], 
          
          LineBox[{{-2.144562997373256, -2.4091549285013123`}, \
{-2.144562997373256, -2.3807237130155934`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.0934424039470523`, -2.5607471529117753`}, \
{-2.0934424039470523`, -2.529812830682827}}], 
          
          LineBox[{{-2.0934424039470523`, -2.529812830682827}, \
{-2.0934424039470523`, -2.4998067965825657`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.0331259247878006`, -2.704281580414075}, \
{-2.0331259247878006`, -2.6729899129722887`}}], 
          
          LineBox[{{-2.0331259247878006`, -2.6729899129722887`}, \
{-2.0331259247878006`, -2.6426477766930336`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.976025406568619, -2.8315515958360735`}, \
{-1.976025406568619, -2.8055305258836105`}}], 
          
          LineBox[{{-1.976025406568619, -2.8055305258836105`}, \
{-1.976025406568619, -2.7801694154521113`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.9326653384575119`, -2.931288221234967}, \
{-1.9326653384575119`, -2.906535198136373}}], 
          
          LineBox[{{-1.9326653384575119`, -2.906535198136373}, \
{-1.9326653384575119`, -2.8823801161326528`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.8810672419769725`, -3.056141828470672}, \
{-1.8810672419769725`, -3.028012340909488}}], 
          
          LineBox[{{-1.8810672419769725`, -3.028012340909488}, \
{-1.8810672419769725`, -3.0006525204384733`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.8318406272528898`, -3.1681457802986426`}, \
{-1.8318406272528898`, -3.1455492295298764`}}], 
          
          LineBox[{{-1.8318406272528898`, -3.1455492295298764`}, \
{-1.8318406272528898`, -3.123452020249571}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.7850708398172375`, -3.285972716562865}, \
{-1.7850708398172375`, -3.260367304990234}}], 
          
          LineBox[{{-1.7850708398172375`, -3.260367304990234}, \
{-1.7850708398172375`, -3.2354011949953616`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.7316070609965282`, -3.4147984202301536`}, \
{-1.7316070609965282`, -3.39033279633426}}], 
          
          LineBox[{{-1.7316070609965282`, -3.39033279633426}, \
{-1.7316070609965282`, -3.3664514723767653`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.680857774871063, -3.5370400459367612`}, \
{-1.680857774871063, -3.514038749407419}}], 
          
          LineBox[{{-1.680857774871063, -3.514038749407419}, \
{-1.680857774871063, -3.491554638860539}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.632560487956873, -3.654479607134656}, \
{-1.632560487956873, -3.6321706866510852`}}], 
          
          LineBox[{{-1.632560487956873, -3.6321706866510852`}, \
{-1.632560487956873, -3.6103486128275866`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.5864890309770467`, -3.77344025514442}, \
{-1.5864890309770467`, -3.750732576033931}}], 
          
          LineBox[{{-1.5864890309770467`, -3.750732576033931}, \
{-1.5864890309770467`, -3.728529107349718}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.5353513680587525`, -3.899029592261912}, \
{-1.5353513680587525`, -3.8763240904633025`}}], 
          
          LineBox[{{-1.5353513680587525`, -3.8763240904633025`}, \
{-1.5353513680587525`, -3.854122703473151}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.4798745637368198`, -4.040444420522331}, \
{-1.4798745637368198`, -4.018557380056135}}], 
          
          LineBox[{{-1.4798745637368198`, -4.018557380056135}, \
{-1.4798745637368198`, -3.9971391397945837`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.4336874114561198`, -4.15822147123487}, \
{-1.4336874114561198`, -4.138258691704482}}], 
          
          LineBox[{{-1.4336874114561198`, -4.138258691704482}, \
{-1.4336874114561198`, -4.118686637498688}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.3835443794448625`, -4.289578277604251}, \
{-1.3835443794448625`, -4.266676446494015}}], 
          
          LineBox[{{-1.3835443794448625`, -4.266676446494015}, \
{-1.3835443794448625`, -4.244287387735965}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.329822772449285, -4.42936818116037}, \
{-1.329822772449285, -4.409850085065111}}], 
          
          LineBox[{{-1.329822772449285, -4.409850085065111}, \
{-1.329822772449285, -4.390705663269606}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.2844243515113174`, -4.552443946762301}, \
{-1.2844243515113174`, -4.532730826147561}}], 
          
          LineBox[{{-1.2844243515113174`, -4.532730826147561}, \
{-1.2844243515113174`, -4.513398811963061}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.2357418538566787`, -4.68125974420196}, \
{-1.2357418538566787`, -4.660724623619137}}], 
          
          LineBox[{{-1.2357418538566787`, -4.660724623619137}, \
{-1.2357418538566787`, -4.640602722921925}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.1842463978924687`, -4.82101872994302}, \
{-1.1842463978924687`, -4.80005262803286}}], 
          
          LineBox[{{-1.1842463978924687`, -4.80005262803286}, \
{-1.1842463978924687`, -4.779517091717867}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.1352739017580313`, -4.951046696965949}, \
{-1.1352739017580313`, -4.9331638876616015`}}], 
          
          LineBox[{{-1.1352739017580313`, -4.9331638876616015`}, \
{-1.1352739017580313`, -4.915595262948392}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.0840754969609638`, -5.094638723085209}, \
{-1.0840754969609638`, -5.075435924294481}}], 
          
          LineBox[{{-1.0840754969609638`, -5.075435924294481}, \
{-1.0840754969609638`, -5.056594936117124}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.0310183660733363`, -5.242740703015136}, \
{-1.0310183660733363`, -5.224416387236958}}], 
          
          LineBox[{{-1.0310183660733363`, -5.224416387236958}, \
{-1.0310183660733363`, -5.206421818676085}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-0.9806356434778151, -5.384898727982056}, \
{-0.9806356434778151, -5.36711129798286}}], 
          
          LineBox[{{-0.9806356434778151, -5.36711129798286}, \
{-0.9806356434778151, -5.349634739104412}}]}}}}}, {{{
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.02], 
         Thickness[0.01]], 
        PointBox[CompressedData["
1:eJwVk/k/FHgfwIcZw5gx5nbEppVWViqKDjvz3UxSKUaOsstDWx6Uq6zrFUJ4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         "]]}, {
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
         PointSize[0.02], 
         Thickness[0.01], 
         Dashing[{Small, Small}]], 
        PointBox[CompressedData["
1:eJwV1Pk/1HkcwPGZMWNOc3yHylVq0+1Khy7fj5oOtRXKSEVqEVOpqKhMtKKS
SIsiph66XHk4isquz5uYVo5Gii5FJBKGMMq17Q+vx/M/eE3dc9DJi0ahUHb8
6n8Pfp2z5UiPHrDe17ysayHQoV2MB00P9WCmePZDeQGBjukGXd0ergdXZOyO
VjcCFVw+hthb9SDIi04stCTQ6x3XgpaY6oGlvsJb1iFCEN3AV3XoQqlJ/fq1
5SL09S8OkZ6rC0nuFNfEOBFyO2aTeSBYF/iPqwO97UWo3FLypc5eF5wiA64k
qIXobdddx2R9XVggu5h+M1GIJH4OmphOMfj5+nzctF6ITM9qq97fF0Pai3Vj
lzQCVFPZ/KE0VAy3Tpw3e7dBgAZMLtS7bBZD1qvigftufPQ5Q6+pZ4IYNtRS
weKFDirKd556opmAiyfPH31C00GZCyXZmdkEFL5mfqubzEPhOo5rJKcICDsn
vVSewEUBdmHbeA4EyN9ZP532g4Pa5AKXPCMCHKI5hnZWHKQW05u7W0VwQ3XY
vs+HjZhvz4zyckQQofR36ley0PZnJ2aUyUWgUsUyg0eYKNSsT1y/UQQZ57mP
5q5nolzECAozEAFx5/HwtVBtlLPcwnljqxAMdo/PjnnPQN+WKyS1OUJIjc4O
zeEwUN+UKM+qECHwnIMf1JnREQobPn7qdyG8HF0dL/fWQmlKhWOsoRAsoybW
X4qnoSCFQVxmrQAMPac69gxS0aoSKbfHRwB1Gk9qFJ2KPG7ZuuxjCMCKa9NA
kVKQ+zmp1Pk6H1xHtdQ2mjHSys3IfvdiPnwMGmHMqhwhp9p4+Q5W60CXdJrL
WfYwuenU55kPfHVg6YSAWMrOH6SuUfGM7XQdyDO50W4XpiFrjPJbLBQ8KH+x
dAhFDJJFVoG9txfzIGPH45KCm/3khsSzTr0qLngHeiSTb/rIfFso8JVxQX1v
1/Fmi16yZ01Z7Hw6F9z7ulO2s3vIeR6p8hgFB3a55hVtCe8k+eEjE8MXcqCq
QZBxsrSd5CmDvLOq2fBDGXtgW1YryTR2s2qQsYHto6/ae7uZrOlYsDmSwQaX
iet6/c0aSUfZTu9lCha86lqctEBUT2Y6DNUW2LDgGbna9tDk52R6ekTq6Vom
rPyg6JhnDuTQbPRb71EmMCNr4l5NSSZNEyPcV3/ShrqoVKck10J8a8jKeHmg
NgQrTkvKv1Rg52BL4oxIGxT7j9QpR+twCDPVLzmHAbdmHP5MjX6Ld3ssKtfb
yoAa88vnngc2YYuuiukxw3QINDz0T3d4C553ZX1K/h06ZGn/+7bArw0fHko0
5pjTYSbTsfHk7a+4rebNsj1FWjApN9Lu081uvJpQR17x14KKQ4vK/OPV2Ij6
Z5ojRwtGO19sOOLVhysTJVUxd2jwJq1rXLmiH1+2z4/rWksD1dMnBkTHAL4/
xzrw03Mq1DiryUb+EE4zEKfL3anQmHL3eqfRT1ycd9mX950CrQnM9r36I9j0
tG/hYBQFZhLXn09njOFNnooVj+dSINg4N+Z17TjuOKhbW5Uyjrsp8Q5BTylQ
lrRfPv/bGF7qHbBlYiIVPFsaB99MGsOPKjY7XE+igVzGWuI3axSbcroyaE+0
QC1tPMyTjWDNiVh+aB4dtnJZ19LvD+MDsviB43EMeK2UTKls/Yk3Ru9USFK0
oWkVC2sm/8T7LEImFF9lQnI+/UHbqh84QrqUWv2IBZ0+qOFIwBBWhfib/F3F
Bv0O6fdL9zQ4v7+oM6KeA9b2AXbr6gexhC43vKvhwgeaXi6wB/FK9jSzxTo6
0L7VybZ/zQAOfV8p5Brz4WL3qslnj/XjWZkXEnpXCqAl7h5xPuk7Lsk6aX3T
VgiB2eVNpRV9+NmHbZ1z6oXQ+ySlzFirD+9xrxbc9vz1Bc3GbBfrXhyjLBoo
HBfBnYvVpg4H1PiVR5E9LYGAkqNeyBL14M1c+R++5mL4D6p7zME=
         "]]}, {
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
         PointSize[0.02], 
         Thickness[0.01], 
         Dashing[{0, Small}]], 
        PointBox[CompressedData["
1:eJwV0/k/1HkcwPGZMTOGMWMubePOsgkPkg4d+n7DbI4KQ44emzNJOcqKWWfU
Qzkyskli6lGiUFk7OpA+b9Gloa3YSD2SkNyNQWTY9ofX4/kXvFYERwtDSQQC
Qfij/31mvs43wJsHL6JFMssT6vjbsWseJXwe5CNtHVaGGu4Y5T4rHuGCZbqx
3ZyJGq5JSmKmIi58t1YXzjym4e73LlHUs7kwveveph4VGu7vtVIx58uFD/0T
le3eqniqb4hf6CouJFo+IsEMFZ8mvtFWyjlQFm8RUr2Zin/gLnR7Ig4k5452
iUopuJWraNEklwOeRW5P3XQpeM/ptQdu+HCg4Okt/1tlZPy5Qcyp1z9zwO/3
yrKwEhX8kKnJ8UI5G7rPeOw0lpNwxXY7EbmRDYa42/LLZiS8xVmWr5PFhuNG
8/nXvIi4FXPtsyZPNrjWF2O+rQTcbY/0lYYhG9obRmMSgwh4lMXZ1uFxFkiv
WDyk2y9hv+j5tw7VsyCkvKA57rwS8yZIxAczWSCKdTo3JlzAforz7CndzQI+
1qZbcm4ei+XfjZ4yYMFxi4Chp/vmsMidDHpvtybwixS9q9tnsdt5rjo1Ik1o
czpKlSxNY1vjTsVG8jShLrZ70F2iwF6HTY4X32RCeM09SUiDHBtw0EuQOzIh
ydUTD/D4ij24vqG56y0DmtzK/tA3H8eyGScj5o4ywPyJZb+X/gg20nYkjMpi
QNE/1cqCjUPYBoy/y6VCA1L4xtbJ2wew1xEU23X2GlDoY93WIezDsnd4qy68
pcNLZSCjZeEdlphm6XxXRAdubdGay2P/YocCnWW9bDpYdRjofgptx6r1eEZp
VepgaL3IVelqwvZn+4TPCdShVsQJTqrNx+7TfS66vVcDUmVc6S77GjTsktNJ
i1ODlJEq042vWpDAS9XZiKUGtN0p6crMl8hGYpx+u4oGRO3ZLTLHLrTJ46A4
U0CDQufeDTbCDygwc/Qh5b0qhPEVzLKEPmSWcT/lcaIq/F3iUMhPHUQmRRn+
gj4qhHQqlVfch9HVb9Z6W+KpIE/7XPnq4xga3haOsz5SIHsid7xe9BUFBa5/
pOVFgaPa4zVneqeQ1dgzY/F3MkTFNFaFhU4ji0IXibScDO4dkT3i/hmk61Ce
abubDJkO0l7W1m/I+4F0Rv+jCixqdSS34fNIwJnMKoxRgQ6TvblOJgtIl5h+
3UNdBYxyWj3ECiV6XuQoE5eT4KR2mKipdQnlO0vPjm0ngVN8fl5xPQFqzWzi
+14QQT5yqf/SEyIcudDZwEogwhaB0rc1iwQBhzXLWKZEOOD0mTwlUAES37TB
HxEgSbA/nWlHhlVDv2W8cSDAiOqyTKdgCnyJ5r2USZaQv4ysrDtChZYLEclr
RhfRDr+yjAJcFfZ9ej/TvXwRVdTBKf+NNMjKW65v66ZEqW6Dd7TM1KBpvPdw
uXgBSekGsZu11MGLTiuuqP2O6lKWte03oEPXY0eD5/3zyPCahh/oakCvAw3N
6s8jBi5Iq2YyIN5EJLQPnkM73v3FO0Zkgs3ghfOyvG9IdSB87R3Sjw++eE/l
3ZxF+s01tQQuC/BtzPXBkzNISmus/vM0C3SS9kUtGc0giW3QZS6bDUNewq2K
X6eRi+hiY3UpG0SdKTmE0wrUmSpefWIFB2zb1fCiR1OoPGJo8exVDrRXdPrd
kMtR+ghxCbfhgk/3sVmemRztsY90FzdwgZSwNyfA9yvCVlpxsZ08mGi202Ok
TiJ2wosDbQM8KBvHCf5BEyjI3Zw6Gq8F/wFXgIBx
         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-6.907755278982122, -6.907755278982122}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
         TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameTicks -> {{{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           
           TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           
           TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.907755278982137, 0.}, {-6.907755278982137, 
      6.907755278982137}}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{0, 0}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], 
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0]}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"C14\"", "\"C15\"", "\"C16\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.18]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.18]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608], 
                    PointSize[0.5], 
                    Thickness[0.18], 
                    Dashing[{Small, Small}]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608], 
                    PointSize[0.5], 
                    Thickness[0.18], 
                    Dashing[{Small, Small}]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6470588235294118, 0.5686274509803921, 
                    0.611764705882353], 
                    PointSize[0.5], 
                    Thickness[0.18], 
                    Dashing[{0, Small}]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6470588235294118, 0.5686274509803921, 
                    0.611764705882353], 
                    PointSize[0.5], 
                    Thickness[0.18], 
                    Dashing[{0, Small}]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.01`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6470588235294118, 0.5686274509803921, 
                    0.611764705882353]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "Small"}], "}"}], "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "False", ",", "False"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.902217220996213*^9, {3.902217492107437*^9, 3.9022175133591595`*^9}, 
   3.9022177145073056`*^9, 3.9022178456890564`*^9, {3.902218004462067*^9, 
   3.902218039095897*^9}, 3.9022180801172466`*^9, 3.902218183630154*^9, 
   3.9022182179687195`*^9, 3.902218267061261*^9, 3.902218299722651*^9, 
   3.90222033900448*^9, 3.9022220423314676`*^9, 3.902378538939608*^9, 
   3.9023824867786922`*^9, {3.9035807464138355`*^9, 3.9035807631379757`*^9}, 
   3.904795167218701*^9, 3.9047952017819695`*^9, 3.904795546459771*^9, 
   3.904795599048907*^9, 3.905926114100419*^9, 3.9156985270599546`*^9, 
   3.91794429993673*^9, 3.917945240423125*^9, 3.918720616496622*^9, 
   3.9187206741702046`*^9, 3.918720718493164*^9, 3.91872169588393*^9, 
   3.918727018066352*^9},
 CellLabel->
  "Out[1272]=",ExpressionUUID->"b5cc83a2-077f-4903-aed9-86dcab4dbbff"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\LH-ESRF-C14-16 & C20-22 \
plot\\\\DataMergedBinnedC14-16.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.902217220996213*^9, {3.902217492107437*^9, 3.9022175133591595`*^9}, 
   3.9022177145073056`*^9, 3.9022178456890564`*^9, {3.902218004462067*^9, 
   3.902218039095897*^9}, 3.9022180801172466`*^9, 3.902218183630154*^9, 
   3.9022182179687195`*^9, 3.902218267061261*^9, 3.902218299722651*^9, 
   3.90222033900448*^9, 3.9022220423314676`*^9, 3.902378538939608*^9, 
   3.9023824867786922`*^9, {3.9035807464138355`*^9, 3.9035807631379757`*^9}, 
   3.904795167218701*^9, 3.9047952017819695`*^9, 3.904795546459771*^9, 
   3.904795599048907*^9, 3.905926114100419*^9, 3.9156985270599546`*^9, 
   3.91794429993673*^9, 3.917945240423125*^9, 3.918720616496622*^9, 
   3.9187206741702046`*^9, 3.918720718493164*^9, 3.91872169588393*^9, 
   3.918727019671856*^9},
 CellLabel->
  "Out[1273]=",ExpressionUUID->"48e1ae8e-22fb-4213-bb7b-0ccebdf3fcc3"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.6554248936175195`, -1.3754752798292404`}, \
{-5.6554248936175195`, -1.0598095276965294`}}], 
          
          LineBox[{{-5.6554248936175195`, -1.0598095276965294`}, \
{-5.6554248936175195`, -0.7441437755638183}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.505650557368423, -1.6058265850271665`}, \
{-5.505650557368423, -1.299153679788789}}], 
          
          LineBox[{{-5.505650557368423, -1.299153679788789}, \
{-5.505650557368423, -0.9924807745504116}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.352012198649872, -1.8664192256781258`}, \
{-5.352012198649872, -1.5487656000261758`}}], 
          
          LineBox[{{-5.352012198649872, -1.5487656000261758`}, \
{-5.352012198649872, -1.2311119743742258`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.197327949963066, -1.9160413309640592`}, \
{-5.197327949963066, -1.6221727152612109`}}], 
          
          LineBox[{{-5.197327949963066, -1.6221727152612109`}, \
{-5.197327949963066, -1.3283040995583626`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.046182498246482, -1.9443899812655037`}, \
{-5.046182498246482, -1.646337564940634}}], 
          
          LineBox[{{-5.046182498246482, -1.646337564940634}, \
{-5.046182498246482, -1.3482851486157643`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.894444132978499, -2.054729383000484}, \
{-4.894444132978499, -1.7673180501957881`}}], 
          
          LineBox[{{-4.894444132978499, -1.7673180501957881`}, \
{-4.894444132978499, -1.4799067173910923`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.745125399370905, -2.0436838539320887`}, \
{-4.745125399370905, -1.7790030360493436`}}], 
          
          LineBox[{{-4.745125399370905, -1.7790030360493436`}, \
{-4.745125399370905, -1.5143222181665987`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.596628633102665, -2.155055401276338}, \
{-4.596628633102665, -1.9018395732059943`}}], 
          
          LineBox[{{-4.596628633102665, -1.9018395732059943`}, \
{-4.596628633102665, -1.6486237451356507`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.447741719114617, -2.141283295074858}, \
{-4.447741719114617, -1.9072672831704347`}}], 
          
          LineBox[{{-4.447741719114617, -1.9072672831704347`}, \
{-4.447741719114617, -1.6732512712660113`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.298711959937622, -2.1741403061228324`}, \
{-4.298711959937622, -1.956182801462741}}], 
          
          LineBox[{{-4.298711959937622, -1.956182801462741}, \
{-4.298711959937622, -1.7382252968026495`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.149632905511913, -2.2157632698654677`}, \
{-4.149632905511913, -2.0014304169941814`}}], 
          
          LineBox[{{-4.149632905511913, -2.0014304169941814`}, \
{-4.149632905511913, -1.787097564122895}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.001278268975371, -2.180179830632701}, \
{-4.001278268975371, -1.9797092707882549`}}], 
          
          LineBox[{{-4.001278268975371, -1.9797092707882549`}, \
{-4.001278268975371, -1.7792387109438086`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.8508575458258987`, -2.3621772224343935`}, \
{-3.8508575458258987`, -2.1744414390160456`}}], 
          
          LineBox[{{-3.8508575458258987`, -2.1744414390160456`}, \
{-3.8508575458258987`, -1.9867056555976979`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.6998351226863213`, -2.21519821644171}, \
{-3.6998351226863213`, -2.03529139387336}}], 
          
          LineBox[{{-3.6998351226863213`, -2.03529139387336}, \
{-3.6998351226863213`, -1.8553845713050103`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.550260154845919, -2.2882721832855677`}, \
{-3.550260154845919, -2.1232882907193176`}}], 
          
          LineBox[{{-3.550260154845919, -2.1232882907193176`}, \
{-3.550260154845919, -1.9583043981530677`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.3997502222704012`, -2.2596424372692936`}, \
{-3.3997502222704012`, -2.1108374517938837`}}], 
          
          LineBox[{{-3.3997502222704012`, -2.1108374517938837`}, \
{-3.3997502222704012`, -1.9620324663184738`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.2492191603155653`, -2.262247354252459}, \
{-3.2492191603155653`, -2.120548060098231}}], 
          
          LineBox[{{-3.2492191603155653`, -2.120548060098231}, \
{-3.2492191603155653`, -1.9788487659440033`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.099363949694378, -2.325682989323952}, \
{-3.099363949694378, -2.1912112272257005`}}], 
          
          LineBox[{{-3.099363949694378, -2.1912112272257005`}, \
{-3.099363949694378, -2.056739465127449}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.9723318619592627`, -2.3447234080641337`}, \
{-2.9723318619592627`, -2.1198491065643985`}}], 
          
          LineBox[{{-2.9723318619592627`, -2.1198491065643985`}, \
{-2.9723318619592627`, -1.8949748050646635`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.8161289018458944`, -2.4254477492472883`}, \
{-2.8161289018458944`, -2.1235798621853275`}}], 
          
          LineBox[{{-2.8161289018458944`, -2.1235798621853275`}, \
{-2.8161289018458944`, -1.8217119751233666`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.637122953927779, -2.8413253632452493`}, \
{-2.637122953927779, -2.278547275957496}}], 
          
          LineBox[{{-2.637122953927779, -2.278547275957496}, \
{-2.637122953927779, -1.7157691886697428`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.4883394437723703`, -2.8224766777422747`}, \
{-2.4883394437723703`, -2.2945785421813194`}}], 
          
          LineBox[{{-2.4883394437723703`, -2.2945785421813194`}, \
{-2.4883394437723703`, -1.766680406620364}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.3426491274116255`, -2.8819377562355633`}, \
{-2.3426491274116255`, -2.3841664101003133`}}], 
          
          LineBox[{{-2.3426491274116255`, -2.3841664101003133`}, \
{-2.3426491274116255`, -1.8863950639650633`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.1952323671440643`, -2.8970664017320726`}, \
{-2.1952323671440643`, -2.4353568974949273`}}], 
          
          LineBox[{{-2.1952323671440643`, -2.4353568974949273`}, \
{-2.1952323671440643`, -1.973647393257782}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.048114358050804, -2.968529373545217}, \
{-2.048114358050804, -2.514206950968894}}], 
          
          LineBox[{{-2.048114358050804, -2.514206950968894}, \
{-2.048114358050804, -2.059884528392571}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.9047213128625353`, -3.0022765477363382`}, \
{-1.9047213128625353`, -2.576373376847949}}], 
          
          LineBox[{{-1.9047213128625353`, -2.576373376847949}, \
{-1.9047213128625353`, -2.15047020595956}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.7572185227137695`, -3.094837271329944}, \
{-1.7572185227137695`, -2.694912787804791}}], 
          
          LineBox[{{-1.7572185227137695`, -2.694912787804791}, \
{-1.7572185227137695`, -2.2949883042796384`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.6053998639759, -3.1963113633507874`}, \
{-1.6053998639759, -2.815233406102849}}], 
          
          LineBox[{{-1.6053998639759, -2.815233406102849}, {-1.6053998639759, \
-2.43415544885491}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.4536487775630647`, -3.319806547313522}, \
{-1.4536487775630647`, -2.9498566221552425`}}], 
          
          LineBox[{{-1.4536487775630647`, -2.9498566221552425`}, \
{-1.4536487775630647`, -2.579906696996963}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.3021571254789979`, -3.4374715265753477`}, \
{-1.3021571254789979`, -3.0820720918970834`}}], 
          
          LineBox[{{-1.3021571254789979`, -3.0820720918970834`}, \
{-1.3021571254789979`, -2.726672657218819}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.1509597708634107`, -3.575354502019425}, \
{-1.1509597708634107`, -3.229140593642689}}], 
          
          LineBox[{{-1.1509597708634107`, -3.229140593642689}, \
{-1.1509597708634107`, -2.8829266852659527`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.0007923805337786`, -3.6838381654034302`}, \
{-1.0007923805337786`, -3.352874895418735}}], 
          
          LineBox[{{-1.0007923805337786`, -3.352874895418735}, \
{-1.0007923805337786`, -3.02191162543404}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-0.8504177096512346, -3.7163191294527014`}, \
{-0.8504177096512346, -3.4036106316122847`}}], 
          
          LineBox[{{-0.8504177096512346, -3.4036106316122847`}, \
{-0.8504177096512346, -3.090902133771868}}]}}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.352012198649872, -1.3931597078962221`}, \
{-5.352012198649872, -1.151834366725471}}], 
          
          LineBox[{{-5.352012198649872, -1.151834366725471}, \
{-5.352012198649872, -0.9105090255547197}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.197327949963066, -1.3134154073527315`}, \
{-5.197327949963066, -1.069959893773818}}], 
          
          LineBox[{{-5.197327949963066, -1.069959893773818}, \
{-5.197327949963066, -0.8265043801949042}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.046182498246482, -1.9504581230708071`}, \
{-5.046182498246482, -1.6762357931850604`}}], 
          
          LineBox[{{-5.046182498246482, -1.6762357931850604`}, \
{-5.046182498246482, -1.4020134632993138`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.894444132978499, -2.0135895487593514`}, \
{-4.894444132978499, -1.7375884675911477`}}], 
          
          LineBox[{{-4.894444132978499, -1.7375884675911477`}, \
{-4.894444132978499, -1.461587386422944}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.745125399370905, -2.1041540613861183`}, \
{-4.745125399370905, -1.8251655604291082`}}], 
          
          LineBox[{{-4.745125399370905, -1.8251655604291082`}, \
{-4.745125399370905, -1.546177059472098}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.596628633102665, -2.0307430586360637`}, \
{-4.596628633102665, -1.7724110332954253`}}], 
          
          LineBox[{{-4.596628633102665, -1.7724110332954253`}, \
{-4.596628633102665, -1.5140790079547868`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.447741719114617, -2.0169830121124313`}, \
{-4.447741719114617, -1.7725072919707168`}}], 
          
          LineBox[{{-4.447741719114617, -1.7725072919707168`}, \
{-4.447741719114617, -1.5280315718290023`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.298711959937622, -2.0626503772314857`}, \
{-4.298711959937622, -1.8496491893256315`}}], 
          
          LineBox[{{-4.298711959937622, -1.8496491893256315`}, \
{-4.298711959937622, -1.6366480014197775`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.149632905511913, -2.236616860168895}, \
{-4.149632905511913, -2.0325593608914523`}}], 
          
          LineBox[{{-4.149632905511913, -2.0325593608914523`}, \
{-4.149632905511913, -1.8285018616140096`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.001278268975371, -2.126596922805546}, \
{-4.001278268975371, -1.9202406735472024`}}], 
          
          LineBox[{{-4.001278268975371, -1.9202406735472024`}, \
{-4.001278268975371, -1.7138844242888587`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.8508575458258987`, -2.405553425795285}, \
{-3.8508575458258987`, -2.2031646692537383`}}], 
          
          LineBox[{{-3.8508575458258987`, -2.2031646692537383`}, \
{-3.8508575458258987`, -2.0007759127121916`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.6998351226863213`, -2.3164167395806587`}, \
{-3.6998351226863213`, -2.134158695867596}}], 
          
          LineBox[{{-3.6998351226863213`, -2.134158695867596}, \
{-3.6998351226863213`, -1.9519006521545337`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.550260154845919, -2.203216947445259}, \
{-3.550260154845919, -2.0473258241851515`}}], 
          
          LineBox[{{-3.550260154845919, -2.0473258241851515`}, \
{-3.550260154845919, -1.891434700925044}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.3997502222704012`, -2.2307861716923925`}, \
{-3.3997502222704012`, -2.0800504841837304`}}], 
          
          LineBox[{{-3.3997502222704012`, -2.0800504841837304`}, \
{-3.3997502222704012`, -1.9293147966750681`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.2492191603155653`, -2.2478328027805525`}, \
{-3.2492191603155653`, -2.1107168701832237`}}], 
          
          LineBox[{{-3.2492191603155653`, -2.1107168701832237`}, \
{-3.2492191603155653`, -1.973600937585895}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.099363949694378, -2.2353296307097104`}, \
{-3.099363949694378, -2.1004607688868693`}}], 
          
          LineBox[{{-3.099363949694378, -2.1004607688868693`}, \
{-3.099363949694378, -1.9655919070640282`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.9723318619592627`, -2.3858567159594695`}, \
{-2.9723318619592627`, -2.169150133472718}}], 
          
          LineBox[{{-2.9723318619592627`, -2.169150133472718}, \
{-2.9723318619592627`, -1.9524435509859663`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.8161289018458944`, -2.306313665840845}, \
{-2.8161289018458944`, -2.014061893425849}}], 
          
          LineBox[{{-2.8161289018458944`, -2.014061893425849}, \
{-2.8161289018458944`, -1.7218101210108534`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.637122953927779, -2.7518917128356595`}, \
{-2.637122953927779, -2.2061952959799984`}}], 
          
          LineBox[{{-2.637122953927779, -2.2061952959799984`}, \
{-2.637122953927779, -1.6604988791243374`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.4883394437723703`, -2.7366945816937207`}, \
{-2.4883394437723703`, -2.225953227624485}}], 
          
          LineBox[{{-2.4883394437723703`, -2.225953227624485}, \
{-2.4883394437723703`, -1.7152118735552495`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.3426491274116255`, -2.772455987224709}, \
{-2.3426491274116255`, -2.2921739832968755`}}], 
          
          LineBox[{{-2.3426491274116255`, -2.2921739832968755`}, \
{-2.3426491274116255`, -1.811891979369042}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.1952323671440643`, -2.7715253067085035`}, \
{-2.1952323671440643`, -2.329483345181388}}], 
          
          LineBox[{{-2.1952323671440643`, -2.329483345181388}, \
{-2.1952323671440643`, -1.8874413836542725`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.048114358050804, -2.8147049786780887`}, \
{-2.048114358050804, -2.3830075094473293`}}], 
          
          LineBox[{{-2.048114358050804, -2.3830075094473293`}, \
{-2.048114358050804, -1.95131004021657}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.9047213128625353`, -2.832278194104769}, \
{-1.9047213128625353`, -2.4311676688983095`}}], 
          
          LineBox[{{-1.9047213128625353`, -2.4311676688983095`}, \
{-1.9047213128625353`, -2.0300571436918498`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.7572185227137695`, -2.8846177931737373`}, \
{-1.7572185227137695`, -2.511398827530227}}], 
          
          LineBox[{{-1.7572185227137695`, -2.511398827530227}, \
{-1.7572185227137695`, -2.1381798618867163`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.6053998639759, -2.9663156495983545`}, \
{-1.6053998639759, -2.61370163284424}}], 
          
          LineBox[{{-1.6053998639759, -2.61370163284424}, {-1.6053998639759, \
-2.2610876160901254`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.4536487775630647`, -3.0377885868632313`}, \
{-1.4536487775630647`, -2.6973826950774096`}}], 
          
          LineBox[{{-1.4536487775630647`, -2.6973826950774096`}, \
{-1.4536487775630647`, -2.356976803291588}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.3021571254789979`, -3.144948413067255}, \
{-1.3021571254789979`, -2.8205679377033843`}}], 
          
          LineBox[{{-1.3021571254789979`, -2.8205679377033843`}, \
{-1.3021571254789979`, -2.4961874623395137`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.1509597708634107`, -3.234763455290838}, \
{-1.1509597708634107`, -2.9191367616169543`}}], 
          
          LineBox[{{-1.1509597708634107`, -2.9191367616169543`}, \
{-1.1509597708634107`, -2.6035100679430707`}}]}}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.962020517152551, -1.7975229365155172`}, \
{-4.962020517152551, -1.4904522790582342`}}], 
          
          LineBox[{{-4.962020517152551, -1.4904522790582342`}, \
{-4.962020517152551, -1.1833816216009512`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.812318020609066, -1.7499804854261338`}, \
{-4.812318020609066, -1.484844590276649}}], 
          
          LineBox[{{-4.812318020609066, -1.484844590276649}, \
{-4.812318020609066, -1.219708695127164}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.662288009830052, -1.731832308155819}, \
{-4.662288009830052, -1.484844094732198}}], 
          
          LineBox[{{-4.662288009830052, -1.484844094732198}, \
{-4.662288009830052, -1.237855881308577}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.510921616983912, -2.1820005297355953`}, \
{-4.510921616983912, -1.9277101971080235`}}], 
          
          LineBox[{{-4.510921616983912, -1.9277101971080235`}, \
{-4.510921616983912, -1.6734198644804519`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.358825697731176, -1.7496301838784403`}, \
{-4.358825697731176, -1.5407870885745718`}}], 
          
          LineBox[{{-4.358825697731176, -1.5407870885745718`}, \
{-4.358825697731176, -1.3319439932707033`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.206267641506683, -2.0186112646490657`}, \
{-4.206267641506683, -1.8301249552977674`}}], 
          
          LineBox[{{-4.206267641506683, -1.8301249552977674`}, \
{-4.206267641506683, -1.6416386459464691`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.056255653469975, -2.045423498599775}, \
{-4.056255653469975, -1.8298421264932705`}}], 
          
          LineBox[{{-4.056255653469975, -1.8298421264932705`}, \
{-4.056255653469975, -1.6142607543867664`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.9071666992729934`, -2.2539753896725387`}, \
{-3.9071666992729934`, -2.048083845765819}}], 
          
          LineBox[{{-3.9071666992729934`, -2.048083845765819}, \
{-3.9071666992729934`, -1.8421923018590989`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.7563029605395606`, -2.356016322351946}, \
{-3.7563029605395606`, -2.1793864693343323`}}], 
          
          LineBox[{{-3.7563029605395606`, -2.1793864693343323`}, \
{-3.7563029605395606`, -2.0027566163167188`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.6055069407082008`, -2.0712591417540867`}, \
{-3.6055069407082008`, -1.9041921854873916`}}], 
          
          LineBox[{{-3.6055069407082008`, -1.9041921854873916`}, \
{-3.6055069407082008`, -1.7371252292206965`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.4564260807134493`, -2.3154337014558}, \
{-3.4564260807134493`, -2.1486849495091764`}}], 
          
          LineBox[{{-3.4564260807134493`, -2.1486849495091764`}, \
{-3.4564260807134493`, -1.9819361975625527`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.3071524238710044`, -2.236134018237064}, \
{-3.3071524238710044`, -2.0916457307990073`}}], 
          
          LineBox[{{-3.3071524238710044`, -2.0916457307990073`}, \
{-3.3071524238710044`, -1.9471574433609504`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.156690529396256, -2.207572101104361}, \
{-3.156690529396256, -2.0758943792454656`}}], 
          
          LineBox[{{-3.156690529396256, -2.0758943792454656`}, \
{-3.156690529396256, -1.9442166573865698`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.0195378319942416`, -2.242122341649085}, \
{-3.0195378319942416`, -2.0720360768688115`}}], 
          
          LineBox[{{-3.0195378319942416`, -2.0720360768688115`}, \
{-3.0195378319942416`, -1.9019498120885379`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.8585261080745212`, -2.317698131453854}, \
{-2.8585261080745212`, -2.0032105152590582`}}], 
          
          LineBox[{{-2.8585261080745212`, -2.0032105152590582`}, \
{-2.8585261080745212`, -1.6887228990642622`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.691382454472379, -2.78784802624227}, \
{-2.691382454472379, -2.1892779813885275`}}], 
          
          LineBox[{{-2.691382454472379, -2.1892779813885275`}, \
{-2.691382454472379, -1.5907079365347847`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.5545155316419494`, -2.7417402803813147`}, \
{-2.5545155316419494`, -2.1924652191783975`}}], 
          
          LineBox[{{-2.5545155316419494`, -2.1924652191783975`}, \
{-2.5545155316419494`, -1.6431901579754804`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.408966023604327, -2.7235790038725742`}, \
{-2.408966023604327, -2.242770317295063}}], 
          
          LineBox[{{-2.408966023604327, -2.242770317295063}, \
{-2.408966023604327, -1.7619616307175516`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.2588388882868426`, -2.729795390355834}, \
{-2.2588388882868426`, -2.268822869979683}}], 
          
          LineBox[{{-2.2588388882868426`, -2.268822869979683}, \
{-2.2588388882868426`, -1.807850349603532}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.1096964413451786`, -2.7535327288177047`}, \
{-2.1096964413451786`, -2.3379921382936306`}}], 
          
          LineBox[{{-2.1096964413451786`, -2.3379921382936306`}, \
{-2.1096964413451786`, -1.9224515477695563`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.9578947894818906`, -2.7345648695754594`}, \
{-1.9578947894818906`, -2.3436357189221946`}}], 
          
          LineBox[{{-1.9578947894818906`, -2.3436357189221946`}, \
{-1.9578947894818906`, -1.9527065682689297`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.8071283500440232`, -2.7889862251377617`}, \
{-1.8071283500440232`, -2.4214478851744476`}}], 
          
          LineBox[{{-1.8071283500440232`, -2.4214478851744476`}, \
{-1.8071283500440232`, -2.0539095452111336`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.65618364739931, -2.81505323267394}, \
{-1.65618364739931, -2.4706079244040438`}}], 
          
          LineBox[{{-1.65618364739931, -2.4706079244040438`}, \
{-1.65618364739931, -2.1261626161341476`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.5040228008910033`, -2.875105173039695}, \
{-1.5040228008910033`, -2.5481456990090083`}}], 
          
          LineBox[{{-1.5040228008910033`, -2.5481456990090083`}, \
{-1.5040228008910033`, -2.2211862249783216`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.3539296288670801`, -2.956534168031409}, \
{-1.3539296288670801`, -2.6412677590483873`}}], 
          
          LineBox[{{-1.3539296288670801`, -2.6412677590483873`}, \
{-1.3539296288670801`, -2.326001350065366}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.2055237319284868`, -3.0030836819866935`}, \
{-1.2055237319284868`, -2.702590293800939}}], 
          
          LineBox[{{-1.2055237319284868`, -2.702590293800939}, \
{-1.2055237319284868`, -2.4020969056151844`}}]}}}}, {{{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-5.6554248936175195`, -0.7441437755638183}, 
             
             Offset[{3, 
              0}, {-5.6554248936175195`, -0.7441437755638183}]}, \
{{-5.6554248936175195`, -0.7441437755638183}, 
             
             Offset[{-3, 
              0}, {-5.6554248936175195`, -0.7441437755638183}]}, \
{{-5.6554248936175195`, -1.3754752798292404`}, 
             
             Offset[{3, 
              0}, {-5.6554248936175195`, -1.3754752798292404`}]}, \
{{-5.6554248936175195`, -1.3754752798292404`}, 
             
             Offset[{-3, 
              0}, {-5.6554248936175195`, -1.3754752798292404`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-5.505650557368423, -0.9924807745504116}, 
             
             Offset[{3, 
              0}, {-5.505650557368423, -0.9924807745504116}]}, \
{{-5.505650557368423, -0.9924807745504116}, 
             
             Offset[{-3, 
              0}, {-5.505650557368423, -0.9924807745504116}]}, \
{{-5.505650557368423, -1.6058265850271665`}, 
             
             Offset[{3, 
              0}, {-5.505650557368423, -1.6058265850271665`}]}, \
{{-5.505650557368423, -1.6058265850271665`}, 
             
             Offset[{-3, 
              0}, {-5.505650557368423, -1.6058265850271665`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-5.352012198649872, -1.2311119743742258`}, 
             
             Offset[{3, 
              0}, {-5.352012198649872, -1.2311119743742258`}]}, \
{{-5.352012198649872, -1.2311119743742258`}, 
             
             Offset[{-3, 
              0}, {-5.352012198649872, -1.2311119743742258`}]}, \
{{-5.352012198649872, -1.8664192256781258`}, 
             
             Offset[{3, 
              0}, {-5.352012198649872, -1.8664192256781258`}]}, \
{{-5.352012198649872, -1.8664192256781258`}, 
             
             Offset[{-3, 
              0}, {-5.352012198649872, -1.8664192256781258`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-5.197327949963066, -1.3283040995583626`}, 
             
             Offset[{3, 
              0}, {-5.197327949963066, -1.3283040995583626`}]}, \
{{-5.197327949963066, -1.3283040995583626`}, 
             
             Offset[{-3, 
              0}, {-5.197327949963066, -1.3283040995583626`}]}, \
{{-5.197327949963066, -1.9160413309640592`}, 
             
             Offset[{3, 
              0}, {-5.197327949963066, -1.9160413309640592`}]}, \
{{-5.197327949963066, -1.9160413309640592`}, 
             
             Offset[{-3, 
              0}, {-5.197327949963066, -1.9160413309640592`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-5.046182498246482, -1.3482851486157643`}, 
             
             Offset[{3, 
              0}, {-5.046182498246482, -1.3482851486157643`}]}, \
{{-5.046182498246482, -1.3482851486157643`}, 
             
             Offset[{-3, 
              0}, {-5.046182498246482, -1.3482851486157643`}]}, \
{{-5.046182498246482, -1.9443899812655037`}, 
             
             Offset[{3, 
              0}, {-5.046182498246482, -1.9443899812655037`}]}, \
{{-5.046182498246482, -1.9443899812655037`}, 
             
             Offset[{-3, 
              0}, {-5.046182498246482, -1.9443899812655037`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.894444132978499, -1.4799067173910923`}, 
             
             Offset[{3, 
              0}, {-4.894444132978499, -1.4799067173910923`}]}, \
{{-4.894444132978499, -1.4799067173910923`}, 
             
             Offset[{-3, 
              0}, {-4.894444132978499, -1.4799067173910923`}]}, \
{{-4.894444132978499, -2.054729383000484}, 
             
             Offset[{3, 
              0}, {-4.894444132978499, -2.054729383000484}]}, \
{{-4.894444132978499, -2.054729383000484}, 
             Offset[{-3, 0}, {-4.894444132978499, -2.054729383000484}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.745125399370905, -1.5143222181665987`}, 
             
             Offset[{3, 
              0}, {-4.745125399370905, -1.5143222181665987`}]}, \
{{-4.745125399370905, -1.5143222181665987`}, 
             
             Offset[{-3, 
              0}, {-4.745125399370905, -1.5143222181665987`}]}, \
{{-4.745125399370905, -2.0436838539320887`}, 
             
             Offset[{3, 
              0}, {-4.745125399370905, -2.0436838539320887`}]}, \
{{-4.745125399370905, -2.0436838539320887`}, 
             
             Offset[{-3, 
              0}, {-4.745125399370905, -2.0436838539320887`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.596628633102665, -1.6486237451356507`}, 
             
             Offset[{3, 
              0}, {-4.596628633102665, -1.6486237451356507`}]}, \
{{-4.596628633102665, -1.6486237451356507`}, 
             
             Offset[{-3, 
              0}, {-4.596628633102665, -1.6486237451356507`}]}, \
{{-4.596628633102665, -2.155055401276338}, 
             
             Offset[{3, 
              0}, {-4.596628633102665, -2.155055401276338}]}, \
{{-4.596628633102665, -2.155055401276338}, 
             Offset[{-3, 0}, {-4.596628633102665, -2.155055401276338}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.447741719114617, -1.6732512712660113`}, 
             
             Offset[{3, 
              0}, {-4.447741719114617, -1.6732512712660113`}]}, \
{{-4.447741719114617, -1.6732512712660113`}, 
             
             Offset[{-3, 
              0}, {-4.447741719114617, -1.6732512712660113`}]}, \
{{-4.447741719114617, -2.141283295074858}, 
             
             Offset[{3, 
              0}, {-4.447741719114617, -2.141283295074858}]}, \
{{-4.447741719114617, -2.141283295074858}, 
             Offset[{-3, 0}, {-4.447741719114617, -2.141283295074858}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.298711959937622, -1.7382252968026495`}, 
             
             Offset[{3, 
              0}, {-4.298711959937622, -1.7382252968026495`}]}, \
{{-4.298711959937622, -1.7382252968026495`}, 
             
             Offset[{-3, 
              0}, {-4.298711959937622, -1.7382252968026495`}]}, \
{{-4.298711959937622, -2.1741403061228324`}, 
             
             Offset[{3, 
              0}, {-4.298711959937622, -2.1741403061228324`}]}, \
{{-4.298711959937622, -2.1741403061228324`}, 
             
             Offset[{-3, 
              0}, {-4.298711959937622, -2.1741403061228324`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.149632905511913, -1.787097564122895}, 
             
             Offset[{3, 
              0}, {-4.149632905511913, -1.787097564122895}]}, \
{{-4.149632905511913, -1.787097564122895}, 
             
             Offset[{-3, 
              0}, {-4.149632905511913, -1.787097564122895}]}, \
{{-4.149632905511913, -2.2157632698654677`}, 
             
             Offset[{3, 
              0}, {-4.149632905511913, -2.2157632698654677`}]}, \
{{-4.149632905511913, -2.2157632698654677`}, 
             
             Offset[{-3, 
              0}, {-4.149632905511913, -2.2157632698654677`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.001278268975371, -1.7792387109438086`}, 
             
             Offset[{3, 
              0}, {-4.001278268975371, -1.7792387109438086`}]}, \
{{-4.001278268975371, -1.7792387109438086`}, 
             
             Offset[{-3, 
              0}, {-4.001278268975371, -1.7792387109438086`}]}, \
{{-4.001278268975371, -2.180179830632701}, 
             
             Offset[{3, 
              0}, {-4.001278268975371, -2.180179830632701}]}, \
{{-4.001278268975371, -2.180179830632701}, 
             Offset[{-3, 0}, {-4.001278268975371, -2.180179830632701}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.8508575458258987`, -1.9867056555976979`}, 
             
             Offset[{3, 
              0}, {-3.8508575458258987`, -1.9867056555976979`}]}, \
{{-3.8508575458258987`, -1.9867056555976979`}, 
             
             Offset[{-3, 
              0}, {-3.8508575458258987`, -1.9867056555976979`}]}, \
{{-3.8508575458258987`, -2.3621772224343935`}, 
             
             Offset[{3, 
              0}, {-3.8508575458258987`, -2.3621772224343935`}]}, \
{{-3.8508575458258987`, -2.3621772224343935`}, 
             
             Offset[{-3, 
              0}, {-3.8508575458258987`, -2.3621772224343935`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.6998351226863213`, -1.8553845713050103`}, 
             
             Offset[{3, 
              0}, {-3.6998351226863213`, -1.8553845713050103`}]}, \
{{-3.6998351226863213`, -1.8553845713050103`}, 
             
             Offset[{-3, 
              0}, {-3.6998351226863213`, -1.8553845713050103`}]}, \
{{-3.6998351226863213`, -2.21519821644171}, 
             
             Offset[{3, 
              0}, {-3.6998351226863213`, -2.21519821644171}]}, \
{{-3.6998351226863213`, -2.21519821644171}, 
             
             Offset[{-3, 
              0}, {-3.6998351226863213`, -2.21519821644171}]}}], {{{1., 0.}, {
           0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.550260154845919, -1.9583043981530677`}, 
             
             Offset[{3, 
              0}, {-3.550260154845919, -1.9583043981530677`}]}, \
{{-3.550260154845919, -1.9583043981530677`}, 
             
             Offset[{-3, 
              0}, {-3.550260154845919, -1.9583043981530677`}]}, \
{{-3.550260154845919, -2.2882721832855677`}, 
             
             Offset[{3, 
              0}, {-3.550260154845919, -2.2882721832855677`}]}, \
{{-3.550260154845919, -2.2882721832855677`}, 
             
             Offset[{-3, 
              0}, {-3.550260154845919, -2.2882721832855677`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.3997502222704012`, -1.9620324663184738`}, 
             
             Offset[{3, 
              0}, {-3.3997502222704012`, -1.9620324663184738`}]}, \
{{-3.3997502222704012`, -1.9620324663184738`}, 
             
             Offset[{-3, 
              0}, {-3.3997502222704012`, -1.9620324663184738`}]}, \
{{-3.3997502222704012`, -2.2596424372692936`}, 
             
             Offset[{3, 
              0}, {-3.3997502222704012`, -2.2596424372692936`}]}, \
{{-3.3997502222704012`, -2.2596424372692936`}, 
             
             Offset[{-3, 
              0}, {-3.3997502222704012`, -2.2596424372692936`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.2492191603155653`, -1.9788487659440033`}, 
             
             Offset[{3, 
              0}, {-3.2492191603155653`, -1.9788487659440033`}]}, \
{{-3.2492191603155653`, -1.9788487659440033`}, 
             
             Offset[{-3, 
              0}, {-3.2492191603155653`, -1.9788487659440033`}]}, \
{{-3.2492191603155653`, -2.262247354252459}, 
             
             Offset[{3, 
              0}, {-3.2492191603155653`, -2.262247354252459}]}, \
{{-3.2492191603155653`, -2.262247354252459}, 
             
             Offset[{-3, 
              0}, {-3.2492191603155653`, -2.262247354252459}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.099363949694378, -2.056739465127449}, 
             
             Offset[{3, 
              0}, {-3.099363949694378, -2.056739465127449}]}, \
{{-3.099363949694378, -2.056739465127449}, 
             
             Offset[{-3, 
              0}, {-3.099363949694378, -2.056739465127449}]}, \
{{-3.099363949694378, -2.325682989323952}, 
             
             Offset[{3, 
              0}, {-3.099363949694378, -2.325682989323952}]}, \
{{-3.099363949694378, -2.325682989323952}, 
             Offset[{-3, 0}, {-3.099363949694378, -2.325682989323952}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.9723318619592627`, -1.8949748050646635`}, 
             
             Offset[{3, 
              0}, {-2.9723318619592627`, -1.8949748050646635`}]}, \
{{-2.9723318619592627`, -1.8949748050646635`}, 
             
             Offset[{-3, 
              0}, {-2.9723318619592627`, -1.8949748050646635`}]}, \
{{-2.9723318619592627`, -2.3447234080641337`}, 
             
             Offset[{3, 
              0}, {-2.9723318619592627`, -2.3447234080641337`}]}, \
{{-2.9723318619592627`, -2.3447234080641337`}, 
             
             Offset[{-3, 
              0}, {-2.9723318619592627`, -2.3447234080641337`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.8161289018458944`, -1.8217119751233666`}, 
             
             Offset[{3, 
              0}, {-2.8161289018458944`, -1.8217119751233666`}]}, \
{{-2.8161289018458944`, -1.8217119751233666`}, 
             Offset[{-3, 
              0}, {-2.8161289018458944`, -1.8217119751233666`}]}, \
{{-2.8161289018458944`, -2.4254477492472883`}, 
             
             Offset[{3, 
              0}, {-2.8161289018458944`, -2.4254477492472883`}]}, \
{{-2.8161289018458944`, -2.4254477492472883`}, 
             
             Offset[{-3, 
              0}, {-2.8161289018458944`, -2.4254477492472883`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.637122953927779, -1.7157691886697428`}, 
             
             Offset[{3, 
              0}, {-2.637122953927779, -1.7157691886697428`}]}, \
{{-2.637122953927779, -1.7157691886697428`}, 
             
             Offset[{-3, 
              0}, {-2.637122953927779, -1.7157691886697428`}]}, \
{{-2.637122953927779, -2.8413253632452493`}, 
             
             Offset[{3, 
              0}, {-2.637122953927779, -2.8413253632452493`}]}, \
{{-2.637122953927779, -2.8413253632452493`}, 
             
             Offset[{-3, 
              0}, {-2.637122953927779, -2.8413253632452493`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.4883394437723703`, -1.766680406620364}, 
             
             Offset[{3, 
              0}, {-2.4883394437723703`, -1.766680406620364}]}, \
{{-2.4883394437723703`, -1.766680406620364}, 
             
             Offset[{-3, 
              0}, {-2.4883394437723703`, -1.766680406620364}]}, \
{{-2.4883394437723703`, -2.8224766777422747`}, 
             
             Offset[{3, 
              0}, {-2.4883394437723703`, -2.8224766777422747`}]}, \
{{-2.4883394437723703`, -2.8224766777422747`}, 
             
             Offset[{-3, 
              0}, {-2.4883394437723703`, -2.8224766777422747`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.3426491274116255`, -1.8863950639650633`}, 
             
             Offset[{3, 
              0}, {-2.3426491274116255`, -1.8863950639650633`}]}, \
{{-2.3426491274116255`, -1.8863950639650633`}, 
             
             Offset[{-3, 
              0}, {-2.3426491274116255`, -1.8863950639650633`}]}, \
{{-2.3426491274116255`, -2.8819377562355633`}, 
             
             Offset[{3, 
              0}, {-2.3426491274116255`, -2.8819377562355633`}]}, \
{{-2.3426491274116255`, -2.8819377562355633`}, 
             
             Offset[{-3, 
              0}, {-2.3426491274116255`, -2.8819377562355633`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.1952323671440643`, -1.973647393257782}, 
             
             Offset[{3, 
              0}, {-2.1952323671440643`, -1.973647393257782}]}, \
{{-2.1952323671440643`, -1.973647393257782}, 
             
             Offset[{-3, 
              0}, {-2.1952323671440643`, -1.973647393257782}]}, \
{{-2.1952323671440643`, -2.8970664017320726`}, 
             
             Offset[{3, 
              0}, {-2.1952323671440643`, -2.8970664017320726`}]}, \
{{-2.1952323671440643`, -2.8970664017320726`}, 
             
             Offset[{-3, 
              0}, {-2.1952323671440643`, -2.8970664017320726`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.048114358050804, -2.059884528392571}, 
             
             Offset[{3, 
              0}, {-2.048114358050804, -2.059884528392571}]}, \
{{-2.048114358050804, -2.059884528392571}, 
             
             Offset[{-3, 
              0}, {-2.048114358050804, -2.059884528392571}]}, \
{{-2.048114358050804, -2.968529373545217}, 
             
             Offset[{3, 
              0}, {-2.048114358050804, -2.968529373545217}]}, \
{{-2.048114358050804, -2.968529373545217}, 
             Offset[{-3, 0}, {-2.048114358050804, -2.968529373545217}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.9047213128625353`, -2.15047020595956}, 
             
             Offset[{3, 
              0}, {-1.9047213128625353`, -2.15047020595956}]}, \
{{-1.9047213128625353`, -2.15047020595956}, 
             
             Offset[{-3, 
              0}, {-1.9047213128625353`, -2.15047020595956}]}, \
{{-1.9047213128625353`, -3.0022765477363382`}, 
             
             Offset[{3, 
              0}, {-1.9047213128625353`, -3.0022765477363382`}]}, \
{{-1.9047213128625353`, -3.0022765477363382`}, 
             
             Offset[{-3, 
              0}, {-1.9047213128625353`, -3.0022765477363382`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.7572185227137695`, -2.2949883042796384`}, 
             
             Offset[{3, 
              0}, {-1.7572185227137695`, -2.2949883042796384`}]}, \
{{-1.7572185227137695`, -2.2949883042796384`}, 
             
             Offset[{-3, 
              0}, {-1.7572185227137695`, -2.2949883042796384`}]}, \
{{-1.7572185227137695`, -3.094837271329944}, 
             
             Offset[{3, 
              0}, {-1.7572185227137695`, -3.094837271329944}]}, \
{{-1.7572185227137695`, -3.094837271329944}, 
             
             Offset[{-3, 
              0}, {-1.7572185227137695`, -3.094837271329944}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.6053998639759, -2.43415544885491}, 
             
             Offset[{3, 
              0}, {-1.6053998639759, -2.43415544885491}]}, \
{{-1.6053998639759, -2.43415544885491}, 
             
             Offset[{-3, 
              0}, {-1.6053998639759, -2.43415544885491}]}, \
{{-1.6053998639759, -3.1963113633507874`}, 
             
             Offset[{3, 
              0}, {-1.6053998639759, -3.1963113633507874`}]}, \
{{-1.6053998639759, -3.1963113633507874`}, 
             Offset[{-3, 0}, {-1.6053998639759, -3.1963113633507874`}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.4536487775630647`, -2.579906696996963}, 
             Offset[{3, 
              0}, {-1.4536487775630647`, -2.579906696996963}]}, \
{{-1.4536487775630647`, -2.579906696996963}, 
             
             Offset[{-3, 
              0}, {-1.4536487775630647`, -2.579906696996963}]}, \
{{-1.4536487775630647`, -3.319806547313522}, 
             
             Offset[{3, 
              0}, {-1.4536487775630647`, -3.319806547313522}]}, \
{{-1.4536487775630647`, -3.319806547313522}, 
             
             Offset[{-3, 
              0}, {-1.4536487775630647`, -3.319806547313522}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.3021571254789979`, -2.726672657218819}, 
             
             Offset[{3, 
              0}, {-1.3021571254789979`, -2.726672657218819}]}, \
{{-1.3021571254789979`, -2.726672657218819}, 
             
             Offset[{-3, 
              0}, {-1.3021571254789979`, -2.726672657218819}]}, \
{{-1.3021571254789979`, -3.4374715265753477`}, 
             
             Offset[{3, 
              0}, {-1.3021571254789979`, -3.4374715265753477`}]}, \
{{-1.3021571254789979`, -3.4374715265753477`}, 
             
             Offset[{-3, 
              0}, {-1.3021571254789979`, -3.4374715265753477`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.1509597708634107`, -2.8829266852659527`}, 
             
             Offset[{3, 
              0}, {-1.1509597708634107`, -2.8829266852659527`}]}, \
{{-1.1509597708634107`, -2.8829266852659527`}, 
             
             Offset[{-3, 
              0}, {-1.1509597708634107`, -2.8829266852659527`}]}, \
{{-1.1509597708634107`, -3.575354502019425}, 
             
             Offset[{3, 
              0}, {-1.1509597708634107`, -3.575354502019425}]}, \
{{-1.1509597708634107`, -3.575354502019425}, 
             
             Offset[{-3, 
              0}, {-1.1509597708634107`, -3.575354502019425}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.0007923805337786`, -3.02191162543404}, 
             
             Offset[{3, 
              0}, {-1.0007923805337786`, -3.02191162543404}]}, \
{{-1.0007923805337786`, -3.02191162543404}, 
             
             Offset[{-3, 
              0}, {-1.0007923805337786`, -3.02191162543404}]}, \
{{-1.0007923805337786`, -3.6838381654034302`}, 
             
             Offset[{3, 
              0}, {-1.0007923805337786`, -3.6838381654034302`}]}, \
{{-1.0007923805337786`, -3.6838381654034302`}, 
             
             Offset[{-3, 
              0}, {-1.0007923805337786`, -3.6838381654034302`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-0.8504177096512346, -3.090902133771868}, 
             
             Offset[{3, 
              0}, {-0.8504177096512346, -3.090902133771868}]}, \
{{-0.8504177096512346, -3.090902133771868}, 
             
             Offset[{-3, 
              0}, {-0.8504177096512346, -3.090902133771868}]}, \
{{-0.8504177096512346, -3.7163191294527014`}, 
             
             Offset[{3, 
              0}, {-0.8504177096512346, -3.7163191294527014`}]}, \
{{-0.8504177096512346, -3.7163191294527014`}, 
             Offset[{-3, 
              0}, {-0.8504177096512346, -3.7163191294527014`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-5.352012198649872, -0.9105090255547197}, 
             
             Offset[{3, 
              0}, {-5.352012198649872, -0.9105090255547197}]}, \
{{-5.352012198649872, -0.9105090255547197}, 
             
             Offset[{-3, 
              0}, {-5.352012198649872, -0.9105090255547197}]}, \
{{-5.352012198649872, -1.3931597078962221`}, 
             
             Offset[{3, 
              0}, {-5.352012198649872, -1.3931597078962221`}]}, \
{{-5.352012198649872, -1.3931597078962221`}, 
             
             Offset[{-3, 
              0}, {-5.352012198649872, -1.3931597078962221`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-5.197327949963066, -0.8265043801949042}, 
             
             Offset[{3, 
              0}, {-5.197327949963066, -0.8265043801949042}]}, \
{{-5.197327949963066, -0.8265043801949042}, 
             
             Offset[{-3, 
              0}, {-5.197327949963066, -0.8265043801949042}]}, \
{{-5.197327949963066, -1.3134154073527315`}, 
             
             Offset[{3, 
              0}, {-5.197327949963066, -1.3134154073527315`}]}, \
{{-5.197327949963066, -1.3134154073527315`}, 
             
             Offset[{-3, 
              0}, {-5.197327949963066, -1.3134154073527315`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-5.046182498246482, -1.4020134632993138`}, 
             
             Offset[{3, 
              0}, {-5.046182498246482, -1.4020134632993138`}]}, \
{{-5.046182498246482, -1.4020134632993138`}, 
             
             Offset[{-3, 
              0}, {-5.046182498246482, -1.4020134632993138`}]}, \
{{-5.046182498246482, -1.9504581230708071`}, 
             
             Offset[{3, 
              0}, {-5.046182498246482, -1.9504581230708071`}]}, \
{{-5.046182498246482, -1.9504581230708071`}, 
             
             Offset[{-3, 
              0}, {-5.046182498246482, -1.9504581230708071`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.894444132978499, -1.461587386422944}, 
             
             Offset[{3, 
              0}, {-4.894444132978499, -1.461587386422944}]}, \
{{-4.894444132978499, -1.461587386422944}, 
             
             Offset[{-3, 
              0}, {-4.894444132978499, -1.461587386422944}]}, \
{{-4.894444132978499, -2.0135895487593514`}, 
             
             Offset[{3, 
              0}, {-4.894444132978499, -2.0135895487593514`}]}, \
{{-4.894444132978499, -2.0135895487593514`}, 
             
             Offset[{-3, 
              0}, {-4.894444132978499, -2.0135895487593514`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.745125399370905, -1.546177059472098}, 
             
             Offset[{3, 
              0}, {-4.745125399370905, -1.546177059472098}]}, \
{{-4.745125399370905, -1.546177059472098}, 
             
             Offset[{-3, 
              0}, {-4.745125399370905, -1.546177059472098}]}, \
{{-4.745125399370905, -2.1041540613861183`}, 
             
             Offset[{3, 
              0}, {-4.745125399370905, -2.1041540613861183`}]}, \
{{-4.745125399370905, -2.1041540613861183`}, 
             
             Offset[{-3, 
              0}, {-4.745125399370905, -2.1041540613861183`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.596628633102665, -1.5140790079547868`}, 
             
             Offset[{3, 
              0}, {-4.596628633102665, -1.5140790079547868`}]}, \
{{-4.596628633102665, -1.5140790079547868`}, 
             
             Offset[{-3, 
              0}, {-4.596628633102665, -1.5140790079547868`}]}, \
{{-4.596628633102665, -2.0307430586360637`}, 
             
             Offset[{3, 
              0}, {-4.596628633102665, -2.0307430586360637`}]}, \
{{-4.596628633102665, -2.0307430586360637`}, 
             
             Offset[{-3, 
              0}, {-4.596628633102665, -2.0307430586360637`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.447741719114617, -1.5280315718290023`}, 
             
             Offset[{3, 
              0}, {-4.447741719114617, -1.5280315718290023`}]}, \
{{-4.447741719114617, -1.5280315718290023`}, 
             
             Offset[{-3, 
              0}, {-4.447741719114617, -1.5280315718290023`}]}, \
{{-4.447741719114617, -2.0169830121124313`}, 
             
             Offset[{3, 
              0}, {-4.447741719114617, -2.0169830121124313`}]}, \
{{-4.447741719114617, -2.0169830121124313`}, 
             
             Offset[{-3, 
              0}, {-4.447741719114617, -2.0169830121124313`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.298711959937622, -1.6366480014197775`}, 
             
             Offset[{3, 
              0}, {-4.298711959937622, -1.6366480014197775`}]}, \
{{-4.298711959937622, -1.6366480014197775`}, 
             
             Offset[{-3, 
              0}, {-4.298711959937622, -1.6366480014197775`}]}, \
{{-4.298711959937622, -2.0626503772314857`}, 
             
             Offset[{3, 
              0}, {-4.298711959937622, -2.0626503772314857`}]}, \
{{-4.298711959937622, -2.0626503772314857`}, 
             
             Offset[{-3, 
              0}, {-4.298711959937622, -2.0626503772314857`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.149632905511913, -1.8285018616140096`}, 
             
             Offset[{3, 
              0}, {-4.149632905511913, -1.8285018616140096`}]}, \
{{-4.149632905511913, -1.8285018616140096`}, 
             
             Offset[{-3, 
              0}, {-4.149632905511913, -1.8285018616140096`}]}, \
{{-4.149632905511913, -2.236616860168895}, 
             
             Offset[{3, 
              0}, {-4.149632905511913, -2.236616860168895}]}, \
{{-4.149632905511913, -2.236616860168895}, 
             Offset[{-3, 0}, {-4.149632905511913, -2.236616860168895}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.001278268975371, -1.7138844242888587`}, 
             
             Offset[{3, 
              0}, {-4.001278268975371, -1.7138844242888587`}]}, \
{{-4.001278268975371, -1.7138844242888587`}, 
             
             Offset[{-3, 
              0}, {-4.001278268975371, -1.7138844242888587`}]}, \
{{-4.001278268975371, -2.126596922805546}, 
             
             Offset[{3, 
              0}, {-4.001278268975371, -2.126596922805546}]}, \
{{-4.001278268975371, -2.126596922805546}, 
             Offset[{-3, 0}, {-4.001278268975371, -2.126596922805546}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.8508575458258987`, -2.0007759127121916`}, 
             
             Offset[{3, 
              0}, {-3.8508575458258987`, -2.0007759127121916`}]}, \
{{-3.8508575458258987`, -2.0007759127121916`}, 
             
             Offset[{-3, 
              0}, {-3.8508575458258987`, -2.0007759127121916`}]}, \
{{-3.8508575458258987`, -2.405553425795285}, 
             
             Offset[{3, 
              0}, {-3.8508575458258987`, -2.405553425795285}]}, \
{{-3.8508575458258987`, -2.405553425795285}, 
             
             Offset[{-3, 
              0}, {-3.8508575458258987`, -2.405553425795285}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.6998351226863213`, -1.9519006521545337`}, 
             
             Offset[{3, 
              0}, {-3.6998351226863213`, -1.9519006521545337`}]}, \
{{-3.6998351226863213`, -1.9519006521545337`}, 
             
             Offset[{-3, 
              0}, {-3.6998351226863213`, -1.9519006521545337`}]}, \
{{-3.6998351226863213`, -2.3164167395806587`}, 
             
             Offset[{3, 
              0}, {-3.6998351226863213`, -2.3164167395806587`}]}, \
{{-3.6998351226863213`, -2.3164167395806587`}, 
             
             Offset[{-3, 
              0}, {-3.6998351226863213`, -2.3164167395806587`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.550260154845919, -1.891434700925044}, 
             
             Offset[{3, 
              0}, {-3.550260154845919, -1.891434700925044}]}, \
{{-3.550260154845919, -1.891434700925044}, 
             
             Offset[{-3, 
              0}, {-3.550260154845919, -1.891434700925044}]}, \
{{-3.550260154845919, -2.203216947445259}, 
             
             Offset[{3, 
              0}, {-3.550260154845919, -2.203216947445259}]}, \
{{-3.550260154845919, -2.203216947445259}, 
             Offset[{-3, 0}, {-3.550260154845919, -2.203216947445259}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.3997502222704012`, -1.9293147966750681`}, 
             
             Offset[{3, 
              0}, {-3.3997502222704012`, -1.9293147966750681`}]}, \
{{-3.3997502222704012`, -1.9293147966750681`}, 
             
             Offset[{-3, 
              0}, {-3.3997502222704012`, -1.9293147966750681`}]}, \
{{-3.3997502222704012`, -2.2307861716923925`}, 
             
             Offset[{3, 
              0}, {-3.3997502222704012`, -2.2307861716923925`}]}, \
{{-3.3997502222704012`, -2.2307861716923925`}, 
             
             Offset[{-3, 
              0}, {-3.3997502222704012`, -2.2307861716923925`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.2492191603155653`, -1.973600937585895}, 
             
             Offset[{3, 
              0}, {-3.2492191603155653`, -1.973600937585895}]}, \
{{-3.2492191603155653`, -1.973600937585895}, 
             
             Offset[{-3, 
              0}, {-3.2492191603155653`, -1.973600937585895}]}, \
{{-3.2492191603155653`, -2.2478328027805525`}, 
             
             Offset[{3, 
              0}, {-3.2492191603155653`, -2.2478328027805525`}]}, \
{{-3.2492191603155653`, -2.2478328027805525`}, 
             
             Offset[{-3, 
              0}, {-3.2492191603155653`, -2.2478328027805525`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.099363949694378, -1.9655919070640282`}, 
             
             Offset[{3, 
              0}, {-3.099363949694378, -1.9655919070640282`}]}, \
{{-3.099363949694378, -1.9655919070640282`}, 
             
             Offset[{-3, 
              0}, {-3.099363949694378, -1.9655919070640282`}]}, \
{{-3.099363949694378, -2.2353296307097104`}, 
             
             Offset[{3, 
              0}, {-3.099363949694378, -2.2353296307097104`}]}, \
{{-3.099363949694378, -2.2353296307097104`}, 
             
             Offset[{-3, 
              0}, {-3.099363949694378, -2.2353296307097104`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.9723318619592627`, -1.9524435509859663`}, 
             
             Offset[{3, 
              0}, {-2.9723318619592627`, -1.9524435509859663`}]}, \
{{-2.9723318619592627`, -1.9524435509859663`}, 
             
             Offset[{-3, 
              0}, {-2.9723318619592627`, -1.9524435509859663`}]}, \
{{-2.9723318619592627`, -2.3858567159594695`}, 
             
             Offset[{3, 
              0}, {-2.9723318619592627`, -2.3858567159594695`}]}, \
{{-2.9723318619592627`, -2.3858567159594695`}, 
             
             Offset[{-3, 
              0}, {-2.9723318619592627`, -2.3858567159594695`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.8161289018458944`, -1.7218101210108534`}, 
             
             Offset[{3, 
              0}, {-2.8161289018458944`, -1.7218101210108534`}]}, \
{{-2.8161289018458944`, -1.7218101210108534`}, 
             
             Offset[{-3, 
              0}, {-2.8161289018458944`, -1.7218101210108534`}]}, \
{{-2.8161289018458944`, -2.306313665840845}, 
             
             Offset[{3, 
              0}, {-2.8161289018458944`, -2.306313665840845}]}, \
{{-2.8161289018458944`, -2.306313665840845}, 
             
             Offset[{-3, 
              0}, {-2.8161289018458944`, -2.306313665840845}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.637122953927779, -1.6604988791243374`}, 
             
             Offset[{3, 
              0}, {-2.637122953927779, -1.6604988791243374`}]}, \
{{-2.637122953927779, -1.6604988791243374`}, 
             
             Offset[{-3, 
              0}, {-2.637122953927779, -1.6604988791243374`}]}, \
{{-2.637122953927779, -2.7518917128356595`}, 
             
             Offset[{3, 
              0}, {-2.637122953927779, -2.7518917128356595`}]}, \
{{-2.637122953927779, -2.7518917128356595`}, 
             
             Offset[{-3, 
              0}, {-2.637122953927779, -2.7518917128356595`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.4883394437723703`, -1.7152118735552495`}, 
             
             Offset[{3, 
              0}, {-2.4883394437723703`, -1.7152118735552495`}]}, \
{{-2.4883394437723703`, -1.7152118735552495`}, 
             
             Offset[{-3, 
              0}, {-2.4883394437723703`, -1.7152118735552495`}]}, \
{{-2.4883394437723703`, -2.7366945816937207`}, 
             
             Offset[{3, 
              0}, {-2.4883394437723703`, -2.7366945816937207`}]}, \
{{-2.4883394437723703`, -2.7366945816937207`}, 
             
             Offset[{-3, 
              0}, {-2.4883394437723703`, -2.7366945816937207`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.3426491274116255`, -1.811891979369042}, 
             
             Offset[{3, 
              0}, {-2.3426491274116255`, -1.811891979369042}]}, \
{{-2.3426491274116255`, -1.811891979369042}, 
             
             Offset[{-3, 
              0}, {-2.3426491274116255`, -1.811891979369042}]}, \
{{-2.3426491274116255`, -2.772455987224709}, 
             
             Offset[{3, 
              0}, {-2.3426491274116255`, -2.772455987224709}]}, \
{{-2.3426491274116255`, -2.772455987224709}, 
             
             Offset[{-3, 
              0}, {-2.3426491274116255`, -2.772455987224709}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.1952323671440643`, -1.8874413836542725`}, 
             
             Offset[{3, 
              0}, {-2.1952323671440643`, -1.8874413836542725`}]}, \
{{-2.1952323671440643`, -1.8874413836542725`}, 
             
             Offset[{-3, 
              0}, {-2.1952323671440643`, -1.8874413836542725`}]}, \
{{-2.1952323671440643`, -2.7715253067085035`}, 
             
             Offset[{3, 
              0}, {-2.1952323671440643`, -2.7715253067085035`}]}, \
{{-2.1952323671440643`, -2.7715253067085035`}, 
             
             Offset[{-3, 
              0}, {-2.1952323671440643`, -2.7715253067085035`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.048114358050804, -1.95131004021657}, 
             
             Offset[{3, 
              0}, {-2.048114358050804, -1.95131004021657}]}, \
{{-2.048114358050804, -1.95131004021657}, 
             
             Offset[{-3, 
              0}, {-2.048114358050804, -1.95131004021657}]}, \
{{-2.048114358050804, -2.8147049786780887`}, 
             
             Offset[{3, 
              0}, {-2.048114358050804, -2.8147049786780887`}]}, \
{{-2.048114358050804, -2.8147049786780887`}, 
             
             Offset[{-3, 
              0}, {-2.048114358050804, -2.8147049786780887`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.9047213128625353`, -2.0300571436918498`}, 
             
             Offset[{3, 
              0}, {-1.9047213128625353`, -2.0300571436918498`}]}, \
{{-1.9047213128625353`, -2.0300571436918498`}, 
             
             Offset[{-3, 
              0}, {-1.9047213128625353`, -2.0300571436918498`}]}, \
{{-1.9047213128625353`, -2.832278194104769}, 
             
             Offset[{3, 
              0}, {-1.9047213128625353`, -2.832278194104769}]}, \
{{-1.9047213128625353`, -2.832278194104769}, 
             
             Offset[{-3, 
              0}, {-1.9047213128625353`, -2.832278194104769}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.7572185227137695`, -2.1381798618867163`}, 
             
             Offset[{3, 
              0}, {-1.7572185227137695`, -2.1381798618867163`}]}, \
{{-1.7572185227137695`, -2.1381798618867163`}, 
             
             Offset[{-3, 
              0}, {-1.7572185227137695`, -2.1381798618867163`}]}, \
{{-1.7572185227137695`, -2.8846177931737373`}, 
             
             Offset[{3, 
              0}, {-1.7572185227137695`, -2.8846177931737373`}]}, \
{{-1.7572185227137695`, -2.8846177931737373`}, 
             
             Offset[{-3, 
              0}, {-1.7572185227137695`, -2.8846177931737373`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.6053998639759, -2.2610876160901254`}, 
             
             Offset[{3, 
              0}, {-1.6053998639759, -2.2610876160901254`}]}, \
{{-1.6053998639759, -2.2610876160901254`}, 
             
             Offset[{-3, 
              0}, {-1.6053998639759, -2.2610876160901254`}]}, \
{{-1.6053998639759, -2.9663156495983545`}, 
             
             Offset[{3, 
              0}, {-1.6053998639759, -2.9663156495983545`}]}, \
{{-1.6053998639759, -2.9663156495983545`}, 
             Offset[{-3, 0}, {-1.6053998639759, -2.9663156495983545`}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.4536487775630647`, -2.356976803291588}, 
             
             Offset[{3, 
              0}, {-1.4536487775630647`, -2.356976803291588}]}, \
{{-1.4536487775630647`, -2.356976803291588}, 
             
             Offset[{-3, 
              0}, {-1.4536487775630647`, -2.356976803291588}]}, \
{{-1.4536487775630647`, -3.0377885868632313`}, 
             
             Offset[{3, 
              0}, {-1.4536487775630647`, -3.0377885868632313`}]}, \
{{-1.4536487775630647`, -3.0377885868632313`}, 
             
             Offset[{-3, 
              0}, {-1.4536487775630647`, -3.0377885868632313`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.3021571254789979`, -2.4961874623395137`}, 
             
             Offset[{3, 
              0}, {-1.3021571254789979`, -2.4961874623395137`}]}, \
{{-1.3021571254789979`, -2.4961874623395137`}, 
             
             Offset[{-3, 
              0}, {-1.3021571254789979`, -2.4961874623395137`}]}, \
{{-1.3021571254789979`, -3.144948413067255}, 
             
             Offset[{3, 
              0}, {-1.3021571254789979`, -3.144948413067255}]}, \
{{-1.3021571254789979`, -3.144948413067255}, 
             
             Offset[{-3, 
              0}, {-1.3021571254789979`, -3.144948413067255}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.1509597708634107`, -2.6035100679430707`}, 
             
             Offset[{3, 
              0}, {-1.1509597708634107`, -2.6035100679430707`}]}, \
{{-1.1509597708634107`, -2.6035100679430707`}, 
             
             Offset[{-3, 
              0}, {-1.1509597708634107`, -2.6035100679430707`}]}, \
{{-1.1509597708634107`, -3.234763455290838}, 
             
             Offset[{3, 
              0}, {-1.1509597708634107`, -3.234763455290838}]}, \
{{-1.1509597708634107`, -3.234763455290838}, 
             
             Offset[{-3, 
              0}, {-1.1509597708634107`, -3.234763455290838}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.962020517152551, -1.1833816216009512`}, 
             
             Offset[{3, 
              0}, {-4.962020517152551, -1.1833816216009512`}]}, \
{{-4.962020517152551, -1.1833816216009512`}, 
             
             Offset[{-3, 
              0}, {-4.962020517152551, -1.1833816216009512`}]}, \
{{-4.962020517152551, -1.7975229365155172`}, 
             
             Offset[{3, 
              0}, {-4.962020517152551, -1.7975229365155172`}]}, \
{{-4.962020517152551, -1.7975229365155172`}, 
             
             Offset[{-3, 
              0}, {-4.962020517152551, -1.7975229365155172`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.812318020609066, -1.219708695127164}, 
             
             Offset[{3, 
              0}, {-4.812318020609066, -1.219708695127164}]}, \
{{-4.812318020609066, -1.219708695127164}, 
             
             Offset[{-3, 
              0}, {-4.812318020609066, -1.219708695127164}]}, \
{{-4.812318020609066, -1.7499804854261338`}, 
             
             Offset[{3, 
              0}, {-4.812318020609066, -1.7499804854261338`}]}, \
{{-4.812318020609066, -1.7499804854261338`}, 
             
             Offset[{-3, 
              0}, {-4.812318020609066, -1.7499804854261338`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.662288009830052, -1.237855881308577}, 
             
             Offset[{3, 
              0}, {-4.662288009830052, -1.237855881308577}]}, \
{{-4.662288009830052, -1.237855881308577}, 
             
             Offset[{-3, 
              0}, {-4.662288009830052, -1.237855881308577}]}, \
{{-4.662288009830052, -1.731832308155819}, 
             
             Offset[{3, 
              0}, {-4.662288009830052, -1.731832308155819}]}, \
{{-4.662288009830052, -1.731832308155819}, 
             Offset[{-3, 0}, {-4.662288009830052, -1.731832308155819}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.510921616983912, -1.6734198644804519`}, 
             
             Offset[{3, 
              0}, {-4.510921616983912, -1.6734198644804519`}]}, \
{{-4.510921616983912, -1.6734198644804519`}, 
             
             Offset[{-3, 
              0}, {-4.510921616983912, -1.6734198644804519`}]}, \
{{-4.510921616983912, -2.1820005297355953`}, 
             
             Offset[{3, 
              0}, {-4.510921616983912, -2.1820005297355953`}]}, \
{{-4.510921616983912, -2.1820005297355953`}, 
             
             Offset[{-3, 
              0}, {-4.510921616983912, -2.1820005297355953`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.358825697731176, -1.3319439932707033`}, 
             
             Offset[{3, 
              0}, {-4.358825697731176, -1.3319439932707033`}]}, \
{{-4.358825697731176, -1.3319439932707033`}, 
             
             Offset[{-3, 
              0}, {-4.358825697731176, -1.3319439932707033`}]}, \
{{-4.358825697731176, -1.7496301838784403`}, 
             
             Offset[{3, 
              0}, {-4.358825697731176, -1.7496301838784403`}]}, \
{{-4.358825697731176, -1.7496301838784403`}, 
             
             Offset[{-3, 
              0}, {-4.358825697731176, -1.7496301838784403`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.206267641506683, -1.6416386459464691`}, 
             
             Offset[{3, 
              0}, {-4.206267641506683, -1.6416386459464691`}]}, \
{{-4.206267641506683, -1.6416386459464691`}, 
             
             Offset[{-3, 
              0}, {-4.206267641506683, -1.6416386459464691`}]}, \
{{-4.206267641506683, -2.0186112646490657`}, 
             
             Offset[{3, 
              0}, {-4.206267641506683, -2.0186112646490657`}]}, \
{{-4.206267641506683, -2.0186112646490657`}, 
             
             Offset[{-3, 
              0}, {-4.206267641506683, -2.0186112646490657`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.056255653469975, -1.6142607543867664`}, 
             Offset[{3, 
              0}, {-4.056255653469975, -1.6142607543867664`}]}, \
{{-4.056255653469975, -1.6142607543867664`}, 
             
             Offset[{-3, 
              0}, {-4.056255653469975, -1.6142607543867664`}]}, \
{{-4.056255653469975, -2.045423498599775}, 
             
             Offset[{3, 
              0}, {-4.056255653469975, -2.045423498599775}]}, \
{{-4.056255653469975, -2.045423498599775}, 
             Offset[{-3, 0}, {-4.056255653469975, -2.045423498599775}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.9071666992729934`, -1.8421923018590989`}, 
             
             Offset[{3, 
              0}, {-3.9071666992729934`, -1.8421923018590989`}]}, \
{{-3.9071666992729934`, -1.8421923018590989`}, 
             
             Offset[{-3, 
              0}, {-3.9071666992729934`, -1.8421923018590989`}]}, \
{{-3.9071666992729934`, -2.2539753896725387`}, 
             
             Offset[{3, 
              0}, {-3.9071666992729934`, -2.2539753896725387`}]}, \
{{-3.9071666992729934`, -2.2539753896725387`}, 
             
             Offset[{-3, 
              0}, {-3.9071666992729934`, -2.2539753896725387`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.7563029605395606`, -2.0027566163167188`}, 
             
             Offset[{3, 
              0}, {-3.7563029605395606`, -2.0027566163167188`}]}, \
{{-3.7563029605395606`, -2.0027566163167188`}, 
             
             Offset[{-3, 
              0}, {-3.7563029605395606`, -2.0027566163167188`}]}, \
{{-3.7563029605395606`, -2.356016322351946}, 
             
             Offset[{3, 
              0}, {-3.7563029605395606`, -2.356016322351946}]}, \
{{-3.7563029605395606`, -2.356016322351946}, 
             
             Offset[{-3, 
              0}, {-3.7563029605395606`, -2.356016322351946}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.6055069407082008`, -1.7371252292206965`}, 
             
             Offset[{3, 
              0}, {-3.6055069407082008`, -1.7371252292206965`}]}, \
{{-3.6055069407082008`, -1.7371252292206965`}, 
             
             Offset[{-3, 
              0}, {-3.6055069407082008`, -1.7371252292206965`}]}, \
{{-3.6055069407082008`, -2.0712591417540867`}, 
             
             Offset[{3, 
              0}, {-3.6055069407082008`, -2.0712591417540867`}]}, \
{{-3.6055069407082008`, -2.0712591417540867`}, 
             
             Offset[{-3, 
              0}, {-3.6055069407082008`, -2.0712591417540867`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.4564260807134493`, -1.9819361975625527`}, 
             
             Offset[{3, 
              0}, {-3.4564260807134493`, -1.9819361975625527`}]}, \
{{-3.4564260807134493`, -1.9819361975625527`}, 
             
             Offset[{-3, 
              0}, {-3.4564260807134493`, -1.9819361975625527`}]}, \
{{-3.4564260807134493`, -2.3154337014558}, 
             
             Offset[{3, 
              0}, {-3.4564260807134493`, -2.3154337014558}]}, \
{{-3.4564260807134493`, -2.3154337014558}, 
             Offset[{-3, 0}, {-3.4564260807134493`, -2.3154337014558}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.3071524238710044`, -1.9471574433609504`}, 
             
             Offset[{3, 
              0}, {-3.3071524238710044`, -1.9471574433609504`}]}, \
{{-3.3071524238710044`, -1.9471574433609504`}, 
             
             Offset[{-3, 
              0}, {-3.3071524238710044`, -1.9471574433609504`}]}, \
{{-3.3071524238710044`, -2.236134018237064}, 
             
             Offset[{3, 
              0}, {-3.3071524238710044`, -2.236134018237064}]}, \
{{-3.3071524238710044`, -2.236134018237064}, 
             
             Offset[{-3, 
              0}, {-3.3071524238710044`, -2.236134018237064}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.156690529396256, -1.9442166573865698`}, 
             
             Offset[{3, 
              0}, {-3.156690529396256, -1.9442166573865698`}]}, \
{{-3.156690529396256, -1.9442166573865698`}, 
             
             Offset[{-3, 
              0}, {-3.156690529396256, -1.9442166573865698`}]}, \
{{-3.156690529396256, -2.207572101104361}, 
             
             Offset[{3, 
              0}, {-3.156690529396256, -2.207572101104361}]}, \
{{-3.156690529396256, -2.207572101104361}, 
             Offset[{-3, 0}, {-3.156690529396256, -2.207572101104361}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.0195378319942416`, -1.9019498120885379`}, 
             
             Offset[{3, 
              0}, {-3.0195378319942416`, -1.9019498120885379`}]}, \
{{-3.0195378319942416`, -1.9019498120885379`}, 
             
             Offset[{-3, 
              0}, {-3.0195378319942416`, -1.9019498120885379`}]}, \
{{-3.0195378319942416`, -2.242122341649085}, 
             
             Offset[{3, 
              0}, {-3.0195378319942416`, -2.242122341649085}]}, \
{{-3.0195378319942416`, -2.242122341649085}, 
             
             Offset[{-3, 
              0}, {-3.0195378319942416`, -2.242122341649085}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.8585261080745212`, -1.6887228990642622`}, 
             
             Offset[{3, 
              0}, {-2.8585261080745212`, -1.6887228990642622`}]}, \
{{-2.8585261080745212`, -1.6887228990642622`}, 
             
             Offset[{-3, 
              0}, {-2.8585261080745212`, -1.6887228990642622`}]}, \
{{-2.8585261080745212`, -2.317698131453854}, 
             
             Offset[{3, 
              0}, {-2.8585261080745212`, -2.317698131453854}]}, \
{{-2.8585261080745212`, -2.317698131453854}, 
             
             Offset[{-3, 
              0}, {-2.8585261080745212`, -2.317698131453854}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.691382454472379, -1.5907079365347847`}, 
             
             Offset[{3, 
              0}, {-2.691382454472379, -1.5907079365347847`}]}, \
{{-2.691382454472379, -1.5907079365347847`}, 
             
             Offset[{-3, 
              0}, {-2.691382454472379, -1.5907079365347847`}]}, \
{{-2.691382454472379, -2.78784802624227}, 
             
             Offset[{3, 
              0}, {-2.691382454472379, -2.78784802624227}]}, \
{{-2.691382454472379, -2.78784802624227}, 
             Offset[{-3, 0}, {-2.691382454472379, -2.78784802624227}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.5545155316419494`, -1.6431901579754804`}, 
             
             Offset[{3, 
              0}, {-2.5545155316419494`, -1.6431901579754804`}]}, \
{{-2.5545155316419494`, -1.6431901579754804`}, 
             
             Offset[{-3, 
              0}, {-2.5545155316419494`, -1.6431901579754804`}]}, \
{{-2.5545155316419494`, -2.7417402803813147`}, 
             
             Offset[{3, 
              0}, {-2.5545155316419494`, -2.7417402803813147`}]}, \
{{-2.5545155316419494`, -2.7417402803813147`}, 
             
             Offset[{-3, 
              0}, {-2.5545155316419494`, -2.7417402803813147`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.408966023604327, -1.7619616307175516`}, 
             
             Offset[{3, 
              0}, {-2.408966023604327, -1.7619616307175516`}]}, \
{{-2.408966023604327, -1.7619616307175516`}, 
             
             Offset[{-3, 
              0}, {-2.408966023604327, -1.7619616307175516`}]}, \
{{-2.408966023604327, -2.7235790038725742`}, 
             
             Offset[{3, 
              0}, {-2.408966023604327, -2.7235790038725742`}]}, \
{{-2.408966023604327, -2.7235790038725742`}, 
             
             Offset[{-3, 
              0}, {-2.408966023604327, -2.7235790038725742`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.2588388882868426`, -1.807850349603532}, 
             
             Offset[{3, 
              0}, {-2.2588388882868426`, -1.807850349603532}]}, \
{{-2.2588388882868426`, -1.807850349603532}, 
             
             Offset[{-3, 
              0}, {-2.2588388882868426`, -1.807850349603532}]}, \
{{-2.2588388882868426`, -2.729795390355834}, 
             
             Offset[{3, 
              0}, {-2.2588388882868426`, -2.729795390355834}]}, \
{{-2.2588388882868426`, -2.729795390355834}, 
             
             Offset[{-3, 
              0}, {-2.2588388882868426`, -2.729795390355834}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.1096964413451786`, -1.9224515477695563`}, 
             
             Offset[{3, 
              0}, {-2.1096964413451786`, -1.9224515477695563`}]}, \
{{-2.1096964413451786`, -1.9224515477695563`}, 
             
             Offset[{-3, 
              0}, {-2.1096964413451786`, -1.9224515477695563`}]}, \
{{-2.1096964413451786`, -2.7535327288177047`}, 
             
             Offset[{3, 
              
              0}, {-2.1096964413451786`, -2.7535327288177047`}]}, \
{{-2.1096964413451786`, -2.7535327288177047`}, 
             
             Offset[{-3, 
              0}, {-2.1096964413451786`, -2.7535327288177047`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.9578947894818906`, -1.9527065682689297`}, 
             
             Offset[{3, 
              0}, {-1.9578947894818906`, -1.9527065682689297`}]}, \
{{-1.9578947894818906`, -1.9527065682689297`}, 
             
             Offset[{-3, 
              0}, {-1.9578947894818906`, -1.9527065682689297`}]}, \
{{-1.9578947894818906`, -2.7345648695754594`}, 
             
             Offset[{3, 
              0}, {-1.9578947894818906`, -2.7345648695754594`}]}, \
{{-1.9578947894818906`, -2.7345648695754594`}, 
             
             Offset[{-3, 
              0}, {-1.9578947894818906`, -2.7345648695754594`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.8071283500440232`, -2.0539095452111336`}, 
             
             Offset[{3, 
              0}, {-1.8071283500440232`, -2.0539095452111336`}]}, \
{{-1.8071283500440232`, -2.0539095452111336`}, 
             
             Offset[{-3, 
              0}, {-1.8071283500440232`, -2.0539095452111336`}]}, \
{{-1.8071283500440232`, -2.7889862251377617`}, 
             
             Offset[{3, 
              0}, {-1.8071283500440232`, -2.7889862251377617`}]}, \
{{-1.8071283500440232`, -2.7889862251377617`}, 
             
             Offset[{-3, 
              0}, {-1.8071283500440232`, -2.7889862251377617`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.65618364739931, -2.1261626161341476`}, 
             
             Offset[{3, 
              0}, {-1.65618364739931, -2.1261626161341476`}]}, \
{{-1.65618364739931, -2.1261626161341476`}, 
             
             Offset[{-3, 
              0}, {-1.65618364739931, -2.1261626161341476`}]}, \
{{-1.65618364739931, -2.81505323267394}, 
             
             Offset[{3, 
              0}, {-1.65618364739931, -2.81505323267394}]}, \
{{-1.65618364739931, -2.81505323267394}, 
             Offset[{-3, 0}, {-1.65618364739931, -2.81505323267394}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.5040228008910033`, -2.2211862249783216`}, 
             
             Offset[{3, 
              0}, {-1.5040228008910033`, -2.2211862249783216`}]}, \
{{-1.5040228008910033`, -2.2211862249783216`}, 
             
             Offset[{-3, 
              0}, {-1.5040228008910033`, -2.2211862249783216`}]}, \
{{-1.5040228008910033`, -2.875105173039695}, 
             
             Offset[{3, 
              0}, {-1.5040228008910033`, -2.875105173039695}]}, \
{{-1.5040228008910033`, -2.875105173039695}, 
             
             Offset[{-3, 
              0}, {-1.5040228008910033`, -2.875105173039695}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.3539296288670801`, -2.326001350065366}, 
             
             Offset[{3, 
              0}, {-1.3539296288670801`, -2.326001350065366}]}, \
{{-1.3539296288670801`, -2.326001350065366}, 
             
             Offset[{-3, 
              0}, {-1.3539296288670801`, -2.326001350065366}]}, \
{{-1.3539296288670801`, -2.956534168031409}, 
             
             Offset[{3, 
              0}, {-1.3539296288670801`, -2.956534168031409}]}, \
{{-1.3539296288670801`, -2.956534168031409}, 
             
             Offset[{-3, 
              0}, {-1.3539296288670801`, -2.956534168031409}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.2055237319284868`, -2.4020969056151844`}, 
             
             Offset[{3, 
              0}, {-1.2055237319284868`, -2.4020969056151844`}]}, \
{{-1.2055237319284868`, -2.4020969056151844`}, 
             
             Offset[{-3, 
              0}, {-1.2055237319284868`, -2.4020969056151844`}]}, \
{{-1.2055237319284868`, -3.0030836819866935`}, 
             
             Offset[{3, 
              0}, {-1.2055237319284868`, -3.0030836819866935`}]}, \
{{-1.2055237319284868`, -3.0030836819866935`}, 
             
             Offset[{-3, 
              0}, {-1.2055237319284868`, -3.0030836819866935`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}}}}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.02], 
         Thickness[0.005]], 
        LineBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAPkkMtCefFsD/IdfV+vTwv/xnfELJ
BRbAB7xyXlXJ9L8e+sPidWgVwBCEFHC+x/i/XraOVhDKFMCvKohga/T5vwJ3
/nZKLxTAcYr5DmZX+r+I96wp6ZMTwNeKs0rvRvy/L94WJwL7EsD1EDXjy3b8
v+0hzJ3yYhLAk4gSVe9t/r/AmyLOfMoRwCQq37IqhP6/smxLjOExEcBte1RW
hkz/vwZRTl45mRDAXq1R8+0CAMBixy0XTwEQwB362aDjrP+/NgSnZo7ODsD2
IJ2NQWUBwDs9JChDmQ3AdSG02kZIAMBI18rL7mYMwCT0RJJ+/ADAxsKZPrAy
C8B/A/W+/uIAwEi8eJ1m/gnAw7695uH2AMC/tZJTf8sIwNB/fMCZhwHAYspf
7VXHB8D4MMlyc/UAwPP89ZZuhwbAyT1UcBf9AMCwNFXr0xgFwMcEhf52OgLA
Fcuigh7oA8BPLab+S1sCwA/jYdO+vQLAENK81sUSA8AOCcD81Y8BwEGhpmWc
ewPAsl7Sx4liAMBXTK6IGB0EwATSKw69ef6/tcYepWmcBMB6sm8rkR38v9WM
iW8ujwXALHiMxLev+b8hjI4XmYUGwFMPeDglQve/yl3AbU6ZB8B7+MK1otX0
v/PltGkVqAjAiOvtylRq8r8ODd+pR9UJwDWoB98+A/C/HTm7ErDSCsBWhVwz
nzbrv8i9+DWYOgvAnNwTjQ==
         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
         PointSize[0.02], 
         Thickness[0.005]], 
        LineBox[CompressedData["
1:eJwB4QEe/iFib1JlAgAAAB0AAAACAAAAHvrD4nVoFcCS6nff6W3yv162jlYQ
yhTAlqT8Q44e8b8Cd/52Si8UwM7UgZ/c0fq/iPesKemTE8AsX6OQKc37vy/e
FicC+xLAqkF9zeAz/b/tIcyd8mISwLks8avLW/y/wJsiznzKEcDX+C6bMFz8
v7JsS4zhMRHAvp+TvymY/b8GUU5eOZkQwNuocXuuQgDAYsctF08BEMATWdVI
Trn+vzYEp2aOzg7AAS5RzBSgAcA7PSQoQ5kNwH3NWcvBEgHASNfKy+5mDMBB
DZlc7GAAwMbCmT6wMgvA4sgcgvGjAMBIvHidZv4JwF1rxIa/4gDAv7WSU3/L
CMBxMydgvs0AwGLKX+1VxwfA7QibYmtaAcDz/PWWbocGwCUSY3vMHADAsDRV
69MYBcDHlSa4SaYBwBXLooIe6APAHJXYkMDOAcAP42HTvr0CwF0EOFBfVgLA
DgnA/NWPAcDCCwEqyKICwLJe0seJYgDA65a5PWYQA8AE0isOvXn+vxwW6AgI
cwPAerJvK5Ed/L/7o7tEWBcEwCx4jMS3r/m/4IrUZtzoBMBTD3g4JUL3vwM7
4WA9lAXAe/jCtaLV9L9ZqETshZAGwIjr7cpUavK/wJHdX2RaB8BQju9P
         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
         PointSize[0.02], 
         Thickness[0.005]], 
        LineBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAPgEN6BvZE8BK3Cx95Nj3v5zekUvQ
PxPAdReuZuzB978SA/vTLqYSwEiJqOHrwfe/tQ9PCS8LEsAw6sul5tf+vw/h
8gBwbxHA8W24XBCn+L8e+hnTN9MQwNeO6RoxSP2/gHn/FJs5EMBpG6KJCEf9
v6QuS53gQQ/ApT2IyHliAMBIFQuR6AwOwEAWWSxibwHA673eBRTYDMBLeZ85
knf+v1GljbfCpgvABGUcvIEwAcAETntUDHUKwE3MxMGwuwDAfMza9uZACcDZ
eSaDbpsAwJ+Za3MDKAjA/kSSpoeTAMCwiafvQt4GwOVTEDyTBgDAiOU3hvOH
BcA+VZ8spIMBwLY1zNalbwTA1uhvNCuKAcAscoT6j0UDwFPGaZAx8QHA+f+A
HxoSAsA41teajCYCwGCFIIeo4ADAxDXiODW0AsAeVp18iVP/v/IQdBXEvwLA
+tCxav/p/L9HV54RIF8DwCEAnGy6f/q/M25kFs7DA8AsPmQ2ehD4v3d+VTaa
YgTAyBxRHbKp9b97vKj9UCEFwJ/0skDTSfO/guXyqOeeBcDOr9El
         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {-6.907755278982122, 0}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"n\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
          HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameTicks -> {{Automatic, Automatic}, {{{
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.907755278982137, 0.}, {-6., 0.}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{0, 0}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"C14\"", "\"C15\"", "\"C16\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608], 
                    PointSize[0.5], 
                    Thickness[0.09]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6470588235294118, 0.5686274509803921, 
                    0.611764705882353], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6470588235294118, 0.5686274509803921, 
                    0.611764705882353], 
                    PointSize[0.5], 
                    Thickness[0.09]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6470588235294118, 0.5686274509803921, 
                    0.611764705882353]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.902217220996213*^9, {3.902217492107437*^9, 3.9022175133591595`*^9}, 
   3.9022177145073056`*^9, 3.9022178456890564`*^9, {3.902218004462067*^9, 
   3.902218039095897*^9}, 3.9022180801172466`*^9, 3.902218183630154*^9, 
   3.9022182179687195`*^9, 3.902218267061261*^9, 3.902218299722651*^9, 
   3.90222033900448*^9, 3.9022220423314676`*^9, 3.902378538939608*^9, 
   3.9023824867786922`*^9, {3.9035807464138355`*^9, 3.9035807631379757`*^9}, 
   3.904795167218701*^9, 3.9047952017819695`*^9, 3.904795546459771*^9, 
   3.904795599048907*^9, 3.905926114100419*^9, 3.9156985270599546`*^9, 
   3.91794429993673*^9, 3.917945240423125*^9, 3.918720616496622*^9, 
   3.9187206741702046`*^9, 3.918720718493164*^9, 3.91872169588393*^9, 
   3.918727020186144*^9},
 CellLabel->
  "Out[1274]=",ExpressionUUID->"de615199-0ba9-433b-9142-10a29d409eb2"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\LH-ESRF-C14-16 & C20-22 \
plot\\\\SlopesC14-16.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.902217220996213*^9, {3.902217492107437*^9, 3.9022175133591595`*^9}, 
   3.9022177145073056`*^9, 3.9022178456890564`*^9, {3.902218004462067*^9, 
   3.902218039095897*^9}, 3.9022180801172466`*^9, 3.902218183630154*^9, 
   3.9022182179687195`*^9, 3.902218267061261*^9, 3.902218299722651*^9, 
   3.90222033900448*^9, 3.9022220423314676`*^9, 3.902378538939608*^9, 
   3.9023824867786922`*^9, {3.9035807464138355`*^9, 3.9035807631379757`*^9}, 
   3.904795167218701*^9, 3.9047952017819695`*^9, 3.904795546459771*^9, 
   3.904795599048907*^9, 3.905926114100419*^9, 3.9156985270599546`*^9, 
   3.91794429993673*^9, 3.917945240423125*^9, 3.918720616496622*^9, 
   3.9187206741702046`*^9, 3.918720718493164*^9, 3.91872169588393*^9, 
   3.918727022189314*^9},
 CellLabel->
  "Out[1275]=",ExpressionUUID->"f9443db5-23e2-4d7c-9ba6-b0347b6a9fe8"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.483842181677217, 
           5.639120607832296}, {-5.483842181677217, 5.658308020563744}}], 
          
          LineBox[{{-5.483842181677217, 
           5.658308020563744}, {-5.483842181677217, 5.677134196807653}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.380228407219979, 
           5.463228385283321}, {-5.380228407219979, 5.4880787640393365`}}], 
          
          LineBox[{{-5.380228407219979, 
           5.4880787640393365`}, {-5.380228407219979, 
           5.512326545972506}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.286352047426554, 
           5.304190017934105}, {-5.286352047426554, 5.329918865918128}}], 
          
          LineBox[{{-5.286352047426554, 
           5.329918865918128}, {-5.286352047426554, 5.355002311046444}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.228332740694611, 
           5.210029250209856}, {-5.228332740694611, 5.233733243142149}}], 
          
          LineBox[{{-5.228332740694611, 
           5.233733243142149}, {-5.228332740694611, 5.256888342654102}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.1734965151745005`, 
           5.092445752201097}, {-5.1734965151745005`, 5.109660616985704}}], 
          
          LineBox[{{-5.1734965151745005`, 
           5.109660616985704}, {-5.1734965151745005`, 
           5.126584138561573}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.121512103387059, 
           5.010339786663916}, {-5.121512103387059, 5.0292078065201835`}}], 
          
          LineBox[{{-5.121512103387059, 
           5.0292078065201835`}, {-5.121512103387059, 
           5.047726406883069}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.0720974097604925`, 
           4.927998737737164}, {-5.0720974097604925`, 4.946531796199192}}], 
          
          LineBox[{{-5.0720974097604925`, 
           4.946531796199192}, {-5.0720974097604925`, 
           4.964727620901456}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.025010372042255, 
           4.8330581887174535`}, {-5.025010372042255, 4.857376517651019}}], 
          
          LineBox[{{-5.025010372042255, 
           4.857376517651019}, {-5.025010372042255, 
           4.8811174783165505`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.980041374477484, 
           4.7534914327996125`}, {-4.980041374477484, 4.779244648856057}}], 
          
          LineBox[{{-4.980041374477484, 
           4.779244648856057}, {-4.980041374477484, 4.804351254240483}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.92662358321994, 4.66307171295235}, {-4.92662358321994, 
           4.682550486707133}}], 
          
          LineBox[{{-4.92662358321994, 4.682550486707133}, {-4.92662358321994,
            4.701657075989198}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.87574337247038, 4.581783934926421}, {-4.87574337247038,
            4.597906232542973}}], 
          
          LineBox[{{-4.87574337247038, 4.597906232542973}, {-4.87574337247038,
            4.613772720466069}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.827483513108963, 
           4.482929735370725}, {-4.827483513108963, 4.50782143628559}}], 
          
          LineBox[{{-4.827483513108963, 
           4.50782143628559}, {-4.827483513108963, 4.532108558949896}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.77239942676781, 4.378496568072931}, {-4.77239942676781,
            4.400532424337347}}], 
          
          LineBox[{{-4.77239942676781, 4.400532424337347}, {-4.77239942676781,
            4.422093152680026}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.720192452293243, 
           4.284726127335531}, {-4.720192452293243, 4.300491445141724}}], 
          
          LineBox[{{-4.720192452293243, 
           4.300491445141724}, {-4.720192452293243, 4.316012070369279}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.670576785004793, 
           4.1878596806737045`}, {-4.670576785004793, 4.205749893509886}}], 
          
          LineBox[{{-4.670576785004793, 
           4.205749893509886}, {-4.670576785004793, 4.223325663835028}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.623307322213241, 
           4.106344057721594}, {-4.623307322213241, 4.123009599391003}}], 
          
          LineBox[{{-4.623307322213241, 
           4.123009599391003}, {-4.623307322213241, 4.139401947480926}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.578172095309458, 
           4.010072943256998}, {-4.578172095309458, 4.0258029508699495`}}], 
          
          LineBox[{{-4.578172095309458, 
           4.0258029508699495`}, {-4.578172095309458, 
           4.041289352324948}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.528024063416046, 
           3.9116670570141894`}, {-4.528024063416046, 3.932728950643705}}], 
          
          LineBox[{{-4.528024063416046, 
           3.932728950643705}, {-4.528024063416046, 
           3.9533563759071524`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.473567500947851, 
           3.804202893049107}, {-4.473567500947851, 3.819154999086636}}], 
          
          LineBox[{{-4.473567500947851, 
           3.819154999086636}, {-4.473567500947851, 3.83388682919492}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.4219245540939545`, 
           3.6970740876771404`}, {-4.4219245540939545`, 
           3.7163761425828605`}}], 
          
          LineBox[{{-4.4219245540939545`, 
           3.7163761425828605`}, {-4.4219245540939545`, 
           3.7353126724165024`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.372818566555532, 
           3.60081473142476}, {-4.372818566555532, 3.6183621839896247`}}], 
          
          LineBox[{{-4.372818566555532, 
           3.6183621839896247`}, {-4.372818566555532, 
           3.635607025878659}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.326011954933506, 
           3.523564395458878}, {-4.326011954933506, 3.53440558010795}}], 
          
          LineBox[{{-4.326011954933506, 
           3.53440558010795}, {-4.326011954933506, 3.545130492870836}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.275892138786888, 
           3.419314335098255}, {-4.275892138786888, 3.4375706018508603`}}], 
          
          LineBox[{{-4.275892138786888, 
           3.4375706018508603`}, {-4.275892138786888, 
           3.4554995441227057`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.222951251037713, 
           3.3148361389699357`}, {-4.222951251037713, 3.329973823116622}}], 
          
          LineBox[{{-4.222951251037713, 
           3.329973823116622}, {-4.222951251037713, 
           3.3448857706650186`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.172673294218139, 
           3.203368555012267}, {-4.172673294218139, 3.2241897915561744`}}], 
          
          LineBox[{{-4.172673294218139, 
           3.2241897915561744`}, {-4.172673294218139, 
           3.244586331879608}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.124803134014643, 
           3.112602683399516}, {-4.124803134014643, 3.1306426695224343`}}], 
          
          LineBox[{{-4.124803134014643, 
           3.1306426695224343`}, {-4.124803134014643, 
           3.148362973098695}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.074701219535939, 
           3.01505420518475}, {-4.074701219535939, 3.026791358357144}}], 
          
          LineBox[{{-4.074701219535939, 
           3.026791358357144}, {-4.074701219535939, 3.038392347399173}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.026921534839552, 
           2.936475885221001}, {-4.026921534839552, 2.9443203692997746`}}], 
          
          LineBox[{{-4.026921534839552, 
           2.9443203692997746`}, {-4.026921534839552, 
           2.9521037961002703`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.9773780413268547`, 
           2.8248902620216794`}, {-3.9773780413268547`, 
           2.8375779146957236`}}], 
          
          LineBox[{{-3.9773780413268547`, 
           2.8375779146957236`}, {-3.9773780413268547`, 
           2.8501066055856037`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.9262371908045295`, 
           2.71743982316707}, {-3.9262371908045295`, 2.7307389524110044`}}], 
          
          LineBox[{{-3.9262371908045295`, 
           2.7307389524110044`}, {-3.9262371908045295`, 
           2.743863533614384}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.8776461425773476`, 
           2.613478162799047}, {-3.8776461425773476`, 2.629357209582338}}], 
          
          LineBox[{{-3.8776461425773476`, 
           2.629357209582338}, {-3.8776461425773476`, 
           2.644988048410846}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.827799486652153, 
           2.484686212906948}, {-3.827799486652153, 2.5005151978466125`}}], 
          
          LineBox[{{-3.827799486652153, 
           2.5005151978466125`}, {-3.827799486652153, 
           2.5160975252900233`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.7770410262852683`, 
           2.394391269397238}, {-3.7770410262852683`, 2.4067663660488092`}}], 
          
          LineBox[{{-3.7770410262852683`, 
           2.4067663660488092`}, {-3.7770410262852683`, 
           2.418990189793173}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.7255676492705025`, 
           2.273546526274074}, {-3.7255676492705025`, 2.2855397994521325`}}], 
          
          LineBox[{{-3.7255676492705025`, 
           2.2855397994521325`}, {-3.7255676492705025`, 
           2.2973909370163996`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.6766150586043187`, 
           2.1792851033584544`}, {-3.6766150586043187`, 2.190162841453973}}], 
          
          LineBox[{{-3.6766150586043187`, 
           2.190162841453973}, {-3.6766150586043187`, 
           2.2009235264941296`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.6271250750319357`, 
           2.0631283793834054`}, {-3.6271250750319357`, 
           2.0804296882029125`}}], 
          
          LineBox[{{-3.6271250750319357`, 
           2.0804296882029125`}, {-3.6271250750319357`, 
           2.0974367454576948`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.577239779380398, 
           1.9737838422188985`}, {-3.577239779380398, 1.9827519429181553`}}], 
          
          LineBox[{{-3.577239779380398, 
           1.9827519429181553`}, {-3.577239779380398, 
           1.9916403311273965`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.5271719803333474`, 
           1.8749399094801518`}, {-3.5271719803333474`, 
           1.8863652031400537`}}], 
          
          LineBox[{{-3.5271719803333474`, 
           1.8863652031400537`}, {-3.5271719803333474`, 
           1.8976614326721961`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.4770227859145613`, 
           1.7540117436742344`}, {-3.4770227859145613`, 
           1.7648907381320562`}}], 
          
          LineBox[{{-3.4770227859145613`, 
           1.7648907381320562`}, {-3.4770227859145613`, 
           1.7756526526393064`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.4269594457071775`, 
           1.6504906298583384`}, {-3.4269594457071775`, 
           1.6613241553828935`}}], 
          
          LineBox[{{-3.4269594457071775`, 
           1.6613241553828935`}, {-3.4269594457071775`, 
           1.6720415723735083`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.377049578478242, 
           1.5369877450336973`}, {-3.377049578478242, 1.5463691125810604`}}], 
          
          LineBox[{{-3.377049578478242, 
           1.5463691125810604`}, {-3.377049578478242, 
           1.5556632874246268`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.327422124402821, 
           1.4374781742198985`}, {-3.327422124402821, 1.4486686722158109`}}], 
          
          LineBox[{{-3.327422124402821, 
           1.4486686722158109`}, {-3.327422124402821, 
           1.4597353275493294`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.2761327623308096`, 
           1.3278756942804386`}, {-3.2761327623308096`, 
           1.3405904475012727`}}], 
          
          LineBox[{{-3.2761327623308096`, 
           1.3405904475012727`}, {-3.2761327623308096`, 
           1.3531455633981908`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.2254264836890396`, 
           1.2185953180895022`}, {-3.2254264836890396`, 
           1.2256870133041329`}}], 
          
          LineBox[{{-3.2254264836890396`, 
           1.2256870133041329`}, {-3.2254264836890396`, 
           1.2327287703164393`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.17716826024446, 
           1.1118746651789475`}, {-3.17716826024446, 1.1209724566719186`}}], 
          
          LineBox[{{-3.17716826024446, 
           1.1209724566719186`}, {-3.17716826024446, 
           1.1299882240326355`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.127705210497175, 
           1.0032905776075902`}, {-3.127705210497175, 1.012379915658238}}], 
          LineBox[{{-3.127705210497175, 
           1.012379915658238}, {-3.127705210497175, 
           1.0213873812505523`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.077261733718196, 
           0.8922646648189078}, {-3.077261733718196, 0.9020847537665542}}], 
          
          LineBox[{{-3.077261733718196, 
           0.9020847537665542}, {-3.077261733718196, 
           0.9118093455974762}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-3.0276924518494375`, 
           0.7872449867029813}, {-3.0276924518494375`, 0.7944332758911548}}], 
          
          LineBox[{{-3.0276924518494375`, 
           0.7944332758911548}, {-3.0276924518494375`, 
           0.8015702621389162}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.977298040136891, 
           0.6839412807763662}, {-2.977298040136891, 0.6927942752812658}}], 
          
          LineBox[{{-2.977298040136891, 
           0.6927942752812658}, {-2.977298040136891, 
           0.7015695815450832}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.932588839908245, 
           0.5766795374745063}, {-2.932588839908245, 0.5858141529972112}}], 
          
          LineBox[{{-2.932588839908245, 
           0.5858141529972112}, {-2.932588839908245, 
           0.5948660820584548}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.522480231534296, -0.3357020884277062}, \
{-2.522480231534296, -0.290966007179707}}], 
          
          LineBox[{{-2.522480231534296, -0.290966007179707}, \
{-2.522480231534296, -0.24814583830093545`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.380038563220422, -0.6542555096471044}, \
{-2.380038563220422, -0.6145797456204279}}], 
          
          LineBox[{{-2.380038563220422, -0.6145797456204279}, \
{-2.380038563220422, -0.5764182587879307}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.2851211182798545`, -0.8793338725834295}, \
{-2.2851211182798545`, -0.8433035141237146}}], 
          
          LineBox[{{-2.2851211182798545`, -0.8433035141237146}, \
{-2.2851211182798545`, -0.8085263212367373}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.226506167649257, -1.0139641167040716`}, \
{-2.226506167649257, -0.9799884119486759}}], 
          
          LineBox[{{-2.226506167649257, -0.9799884119486759}, \
{-2.226506167649257, -0.947129225093269}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.1711381157832257`, -1.1454886939271145`}, \
{-2.1711381157832257`, -1.112606783402379}}], 
          
          LineBox[{{-2.1711381157832257`, -1.112606783402379}, \
{-2.1711381157832257`, -1.0807717605684273`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.1186760185140363`, -1.2737338081629337`}, \
{-2.1186760185140363`, -1.2407551056801267`}}], 
          
          LineBox[{{-2.1186760185140363`, -1.2407551056801267`}, \
{-2.1186760185140363`, -1.2088293650792294`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.0688299492905053`, -1.3975204547927167`}, \
{-2.0688299492905053`, -1.366579955878219}}], 
          
          LineBox[{{-2.0688299492905053`, -1.366579955878219}, \
{-2.0688299492905053`, -1.336568110296873}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-2.021351319690928, -1.51291200877387}, \
{-2.021351319690928, -1.4845656791050943`}}], 
          
          LineBox[{{-2.021351319690928, -1.4845656791050943`}, \
{-2.021351319690928, -1.4570007644726028`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.976025406568619, -1.6230203481862029`}, \
{-1.976025406568619, -1.59555578739753}}], 
          
          LineBox[{{-1.976025406568619, -1.59555578739753}, \
{-1.976025406568619, -1.568825409608864}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.9326653384575119`, -1.7301330517984268`}, \
{-1.9326653384575119`, -1.7027605865952382`}}], 
          
          LineBox[{{-1.9326653384575119`, -1.7027605865952382`}, \
{-1.9326653384575119`, -1.6761174539365076`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.8810672419769725`, -1.8644348804754065`}, \
{-1.8810672419769725`, -1.8345096417797626`}}], 
          
          LineBox[{{-1.8810672419769725`, -1.8345096417797626`}, \
{-1.8810672419769725`, -1.8054539641759457`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.8223707416388202`, -2.014856624895649}, \
{-1.8223707416388202`, -1.9856212744145907`}}], 
          
          LineBox[{{-1.8223707416388202`, -1.9856212744145907`}, \
{-1.8223707416388202`, -1.9572164076380145`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.7758907745205157`, -2.131570832632727}, \
{-1.7758907745205157`, -2.107634967759701}}], 
          
          LineBox[{{-1.7758907745205157`, -2.107634967759701}, \
{-1.7758907745205157`, -2.084258661094414}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.7316070609965282`, -2.251488555523233}, \
{-1.7316070609965282`, -2.224726744754}}], 
          
          LineBox[{{-1.7316070609965282`, -2.224726744754}, \
{-1.7316070609965282`, -2.198662500893012}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.680857774871063, -2.3859138846692374`}, \
{-1.680857774871063, -2.3599817523558033`}}], 
          
          LineBox[{{-1.680857774871063, -2.3599817523558033`}, \
{-1.680857774871063, -2.3347051324978803`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.632560487956873, -2.5152040809715737`}, \
{-1.632560487956873, -2.489668544409202}}], 
          
          LineBox[{{-1.632560487956873, -2.489668544409202}, \
{-1.632560487956873, -2.4647688681311553`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.5790774413137347`, -2.664557577222938}, \
{-1.5790774413137347`, -2.6379187192572617`}}], 
          
          LineBox[{{-1.5790774413137347`, -2.6379187192572617`}, \
{-1.5790774413137347`, -2.611971115634746}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.5281875999704038`, -2.8036071565860734`}, \
{-1.5281875999704038`, -2.779695817205757}}], 
          
          LineBox[{{-1.5281875999704038`, -2.779695817205757}, \
{-1.5281875999704038`, -2.7563429032609403`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.4798745637368198`, -2.9436141799444933`}, \
{-1.4798745637368198`, -2.9181366238851334`}}], 
          
          LineBox[{{-1.4798745637368198`, -2.9181366238851334`}, \
{-1.4798745637368198`, -2.893292079487593}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.4273150021222818`, -3.0956894017560677`}, \
{-1.4273150021222818`, -3.0711758446568207`}}], 
          
          LineBox[{{-1.4273150021222818`, -3.0711758446568207`}, \
{-1.4273150021222818`, -3.047248851929252}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.377381030775886, -3.2397850221295537`}, \
{-1.377381030775886, -3.216497774414115}}], 
          
          LineBox[{{-1.377381030775886, -3.216497774414115}, \
{-1.377381030775886, -3.1937405042900817`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.329822772449285, -3.3799183490601936`}, \
{-1.329822772449285, -3.3571920089000207`}}], 
          
          LineBox[{{-1.329822772449285, -3.3571920089000207`}, \
{-1.329822772449285, -3.3349706990397396`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.2789374525299622`, -3.5350444436458326`}, \
{-1.2789374525299622`, -3.510520905884819}}], 
          
          LineBox[{{-1.2789374525299622`, -3.510520905884819}, \
{-1.2789374525299622`, -3.4865844045339474`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.2252283792125176`, -3.7014167236487956`}, \
{-1.2252283792125176`, -3.6779346386820486`}}], 
          
          LineBox[{{-1.2252283792125176`, -3.6779346386820486`}, \
{-1.2252283792125176`, -3.6549913345216725`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.1742581157840541`, -3.8580864980719722`}, \
{-1.1742581157840541`, -3.835521132237588}}], 
          
          LineBox[{{-1.1742581157840541`, -3.835521132237588}, \
{-1.1742581157840541`, -3.8134537457169615`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.125760810882863, -4.009909874105528}, \
{-1.125760810882863, -3.988813635057169}}], 
          
          LineBox[{{-1.125760810882863, -3.988813635057169}, \
{-1.125760810882863, -3.9681532678846136`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.0750347908756233`, -4.1754571248735175`}, \
{-1.0750347908756233`, -4.153127642831106}}], 
          
          LineBox[{{-1.0750347908756233`, -4.153127642831106}, \
{-1.0750347908756233`, -4.131285895515625}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-1.026687762897248, -4.334206058147893}, \
{-1.026687762897248, -4.313662688830575}}], 
          
          LineBox[{{-1.026687762897248, -4.313662688830575}, \
{-1.026687762897248, -4.293532868105781}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-0.9765855081311018, -4.498630773585158}, \
{-0.9765855081311018, -4.476818558484064}}], 
          
          LineBox[{{-0.9765855081311018, -4.476818558484064}, \
{-0.9765855081311018, -4.455471977662345}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-0.924895304705649, -4.6752948777080885`}, \
{-0.924895304705649, -4.654713149863878}}], 
          
          LineBox[{{-0.924895304705649, -4.654713149863878}, \
{-0.924895304705649, -4.634546500857783}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-0.8758086169295246, -4.841267658362432}, \
{-0.8758086169295246, -4.820014246280281}}], 
          
          LineBox[{{-0.8758086169295246, -4.820014246280281}, \
{-0.8758086169295246, -4.799203157154373}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-0.8254778772492771, -5.010220963419249}, \
{-0.8254778772492771, -4.9908968589107445`}}], 
          
          LineBox[{{-0.8254778772492771, -4.9908968589107445`}, \
{-0.8254778772492771, -4.971939107162257}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-0.7775597923865766, -5.176053739067741}, \
{-0.7775597923865766, -5.156261357038326}}], 
          
          LineBox[{{-0.7775597923865766, -5.156261357038326}, \
{-0.7775597923865766, -5.136853122498256}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-0.7286714703974044, -5.349282783451713}, \
{-0.7286714703974044, -5.329983052392014}}], 
          
          LineBox[{{-0.7286714703974044, -5.329983052392014}, \
{-0.7286714703974044, -5.311048759226412}}]}}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-5.256921585253977, 
           4.174065704710909}, {-5.256921585253977, 4.189835529220337}}], 
          
          LineBox[{{-5.256921585253977, 
           4.189835529220337}, {-5.256921585253977, 4.205360522318066}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-5.2005387488032095`, 
           4.073259742757601}, {-5.2005387488032095`, 4.118587632818974}}], 
          
          LineBox[{{-5.2005387488032095`, 
           4.118587632818974}, {-5.2005387488032095`, 4.16194969034683}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-5.147166472619123, 
           4.060316135610796}, {-5.147166472619123, 4.089782626107377}}], 
          
          LineBox[{{-5.147166472619123, 
           4.089782626107377}, {-5.147166472619123, 4.118405637625673}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-5.09649951504208, 4.003106248180086}, {-5.09649951504208,
            4.01611303271202}}], 
          
          LineBox[{{-5.09649951504208, 4.01611303271202}, {-5.09649951504208, 
           4.028952810694088}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-5.048276729473299, 
           3.9389358153149536`}, {-5.048276729473299, 3.955597647650569}}], 
          
          LineBox[{{-5.048276729473299, 
           3.955597647650569}, {-5.048276729473299, 
           3.9719864070116766`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-5.002273086667765, 
           3.8914024800279385`}, {-5.002273086667765, 3.903310392808608}}], 
          
          LineBox[{{-5.002273086667765, 
           3.903310392808608}, {-5.002273086667765, 3.915078174238025}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.94768844245325, 
           3.8139079894512866`}, {-4.94768844245325, 3.834967815887749}}], 
          
          LineBox[{{-4.94768844245325, 3.834967815887749}, {-4.94768844245325,
            3.855593258362314}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.895750762859643, 
           3.7724277923240597`}, {-4.895750762859643, 3.788495548063706}}], 
          
          LineBox[{{-4.895750762859643, 
           3.788495548063706}, {-4.895750762859643, 
           3.8043092083916625`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.846540574896795, 
           3.6680318725929815`}, {-4.846540574896795, 3.6971948892513216`}}], 
          
          LineBox[{{-4.846540574896795, 
           3.6971948892513216`}, {-4.846540574896795, 
           3.7255314688563543`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.7904256789098545`, 
           3.5807972114376416`}, {-4.7904256789098545`, 3.595170940641284}}], 
          
          LineBox[{{-4.7904256789098545`, 
           3.595170940641284}, {-4.7904256789098545`, 
           3.6093409899365225`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.745892143749627, 
           3.5305408348680896`}, {-4.745892143749627, 3.53272761870269}}], 
          
          LineBox[{{-4.745892143749627, 
           3.53272761870269}, {-4.745892143749627, 3.5349096309462915`}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.703378855771098, 
           3.4590766095255976`}, {-4.703378855771098, 3.472169423772622}}], 
          LineBox[{{-4.703378855771098, 
           3.472169423772622}, {-4.703378855771098, 
           3.4850930292675857`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.646735106032223, 
           3.364716685573411}, {-4.646735106032223, 3.3848178194951477`}}], 
          
          LineBox[{{-4.646735106032223, 
           3.3848178194951477`}, {-4.646735106032223, 
           3.4045228469468096`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.592991950938105, 
           3.2732683619492975`}, {-4.592991950938105, 3.295588536605113}}], 
          
          LineBox[{{-4.592991950938105, 
           3.295588536605113}, {-4.592991950938105, 
           3.3174213786240285`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.5491755160613705`, 
           3.229358754150528}, {-4.5491755160613705`, 3.2394049327590824`}}], 
          
          LineBox[{{-4.5491755160613705`, 
           3.2394049327590824`}, {-4.5491755160613705`, 
           3.2493511886722124`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.500425063167319, 
           3.1317298537854725`}, {-4.500425063167319, 3.1460297171712357`}}], 
          
          LineBox[{{-4.500425063167319, 
           3.1460297171712357`}, {-4.500425063167319, 
           3.1601279740230326`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.4474126107277066`, 
           3.0428963582873423`}, {-4.4474126107277066`, 3.059686411253172}}], 
          
          LineBox[{{-4.4474126107277066`, 
           3.059686411253172}, {-4.4474126107277066`, 
           3.076199207096457}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.397070109545044, 
           2.9463135772451974`}, {-4.397070109545044, 2.959403018876568}}], 
          
          LineBox[{{-4.397070109545044, 
           2.959403018876568}, {-4.397070109545044, 2.972323338356772}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.349141399333698, 
           2.872285782580809}, {-4.349141399333698, 2.877656946886363}}], 
          
          LineBox[{{-4.349141399333698, 
           2.877656946886363}, {-4.349141399333698, 
           2.8829994158447265`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.297879181821557, 
           2.7824187941093794`}, {-4.297879181821557, 2.798573181441161}}], 
          
          LineBox[{{-4.297879181821557, 
           2.798573181441161}, {-4.297879181821557, 2.81447074783161}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.243792424715041, 
           2.6838653228817315`}, {-4.243792424715041, 2.7006713343721764`}}], 
          
          LineBox[{{-4.243792424715041, 
           2.7006713343721764`}, {-4.243792424715041, 2.71719956578566}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.192482121267007, 
           2.5766830597560872`}, {-4.192482121267007, 2.587555056827199}}], 
          
          LineBox[{{-4.192482121267007, 
           2.587555056827199}, {-4.192482121267007, 
           2.5983101237033623`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.143677057603073, 
           2.5204816973906157`}, {-4.143677057603073, 2.530559516618549}}], 
          
          LineBox[{{-4.143677057603073, 
           2.530559516618549}, {-4.143677057603073, 
           2.5405367858878845`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.097143880912867, 
           2.413056266879144}, {-4.097143880912867, 2.422233606842421}}], 
          
          LineBox[{{-4.097143880912867, 
           2.422233606842421}, {-4.097143880912867, 2.431327488580964}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-4.048375288040937, 
           2.327698031247493}, {-4.048375288040937, 2.3462696836216175`}}], 
          
          LineBox[{{-4.048375288040937, 
           2.3462696836216175`}, {-4.048375288040937, 
           2.3645027090308597`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.997716015667319, 
           2.226054796373329}, {-3.997716015667319, 2.242709897757567}}], 
          
          LineBox[{{-3.997716015667319, 
           2.242709897757567}, {-3.997716015667319, 2.259092144950021}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.9456183557485507`, 
           2.131347120083652}, {-3.9456183557485507`, 2.1394536117756386`}}], 
          
          LineBox[{{-3.9456183557485507`, 
           2.1394536117756386`}, {-3.9456183557485507`, 
           2.1474949163448325`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.896038528511996, 
           2.0374706798311664`}, {-3.896038528511996, 2.0500144214158937`}}], 
          
          LineBox[{{-3.896038528511996, 
           2.0500144214158937`}, {-3.896038528511996, 
           2.0624027648100802`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.8488587655549606`, 
           1.908393140892248}, {-3.8488587655549606`, 1.923147820803117}}], 
          
          LineBox[{{-3.8488587655549606`, 
           1.923147820803117}, {-3.8488587655549606`, 
           1.9376879617529417`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.7970479452732633`, 
           1.8283891044109912`}, {-3.7970479452732633`, 
           1.8402317996712925`}}], 
          
          LineBox[{{-3.7970479452732633`, 
           1.8402317996712925`}, {-3.7970479452732633`, 
           1.851935885409871}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.7445609736580776`, 
           1.7185374484728435`}, {-3.7445609736580776`, 
           1.7366433023373513`}}], 
          
          LineBox[{{-3.7445609736580776`, 
           1.7366433023373513`}, {-3.7445609736580776`, 
           1.7544271557115294`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.6946925590696376`, 
           1.619534100146613}, {-3.6946925590696376`, 1.6304916630115016`}}], 
          
          LineBox[{{-3.6946925590696376`, 
           1.6304916630115016`}, {-3.6946925590696376`, 
           1.6413304579242867`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.647193798405784, 
           1.500603557784828}, {-3.647193798405784, 1.5113017216832858`}}], 
          
          LineBox[{{-3.647193798405784, 
           1.5113017216832858`}, {-3.647193798405784, 
           1.521886645265807}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.5963690136318585`, 
           1.4280279764612096`}, {-3.5963690136318585`, 
           1.4397071262034546`}}], 
          
          LineBox[{{-3.5963690136318585`, 
           1.4397071262034546`}, {-3.5963690136318585`, 
           1.4512514465844122`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.5453141380980635`, 
           1.3047043217162122`}, {-3.5453141380980635`, 1.317818390210541}}], 
          
          LineBox[{{-3.5453141380980635`, 
           1.317818390210541}, {-3.5453141380980635`, 
           1.3307627036899459`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.4967816516117667`, 
           1.2117606124700808`}, {-3.4967816516117667`, 1.220750407258174}}], 
          
          LineBox[{{-3.4967816516117667`, 
           1.220750407258174}, {-3.4967816516117667`, 
           1.2296601051559222`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.445744518368156, 
           1.0916083461865123`}, {-3.445744518368156, 1.0975218249554692`}}], 
          
          LineBox[{{-3.445744518368156, 
           1.0975218249554692`}, {-3.445744518368156, 
           1.1034005399673055`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.3949116789514067`, 
           0.9936925948039551}, {-3.3949116789514067`, 1.0090572814052252`}}], 
          
          LineBox[{{-3.3949116789514067`, 
           1.0090572814052252`}, {-3.3949116789514067`, 
           1.0241894622849155`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.3465387336268324`, 
           0.8872014700684998}, {-3.3465387336268324`, 0.8943531688669267}}], 
          
          LineBox[{{-3.3465387336268324`, 
           0.8943531688669267}, {-3.3465387336268324`, 
           0.90145408384532}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.2963410320765485`, 
           0.7854089424673312}, {-3.2963410320765485`, 0.7948191622238685}}], 
          
          LineBox[{{-3.2963410320765485`, 
           0.7948191622238685}, {-3.2963410320765485`, 
           0.8041416546367885}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.244625779142534, 
           0.6688282198263341}, {-3.244625779142534, 0.6801846350739412}}], 
          
          LineBox[{{-3.244625779142534, 
           0.6801846350739412}, {-3.244625779142534, 
           0.6914135289844118}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.195454498404754, 
           0.5534869555896357}, {-3.195454498404754, 0.5655211208853126}}], 
          
          LineBox[{{-3.195454498404754, 
           0.5655211208853126}, {-3.195454498404754, 
           0.5774121854381664}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.1468430769836333`, 
           0.46460384520127856`}, {-3.1468430769836333`, 
           0.4747680401731179}}], 
          
          LineBox[{{-3.1468430769836333`, 
           0.4747680401731179}, {-3.1468430769836333`, 
           0.4848299629286564}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.097134772347408, 
           0.3388907561525857}, {-3.097134772347408, 0.34767696062634224`}}], 
          
          LineBox[{{-3.097134772347408, 
           0.34767696062634224`}, {-3.097134772347408, 
           0.35638663959179967`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-3.0465953406784982`, 
           0.23709258418056486`}, {-3.0465953406784982`, 
           0.24732717300357399`}}], 
          
          LineBox[{{-3.0465953406784982`, 
           0.24732717300357399`}, {-3.0465953406784982`, 
           0.25745807531116344`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.994268823040654, 
           0.1192697630268357}, {-2.994268823040654, 0.12918124899030498`}}], 
          
          LineBox[{{-2.994268823040654, 
           0.12918124899030498`}, {-2.994268823040654, 
           0.13899546074323016`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.9453650008726933`, 
           0.007813371229710387}, {-2.9453650008726933`, 
           0.01852004708493453}}], 
          
          LineBox[{{-2.9453650008726933`, 
           0.01852004708493453}, {-2.9453650008726933`, 
           0.029113303307546946`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.917432257064329, -0.037395945995369245`}, \
{-2.917432257064329, -0.02841053904297403}}], 
          
          LineBox[{{-2.917432257064329, -0.02841053904297403}, \
{-2.917432257064329, -0.01950515115837279}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.6444443836852294`, -0.6658267298866025}, \
{-2.6444443836852294`, -0.6163922388315504}}], 
          
          LineBox[{{-2.6444443836852294`, -0.6163922388315504}, \
{-2.6444443836852294`, -0.5692868315248666}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.4487245335749988`, -1.0957259121114014`}, \
{-2.4487245335749988`, -1.0556986892846205`}}], 
          
          LineBox[{{-2.4487245335749988`, -1.0556986892846205`}, \
{-2.4487245335749988`, -1.0172121726105652`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.347387847945706, -1.3282513264020794`}, \
{-2.347387847945706, -1.2874633197730563`}}], 
          
          LineBox[{{-2.347387847945706, -1.2874633197730563`}, \
{-2.347387847945706, -1.2482739810831731`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.2553841482219026`, -1.5330680624972417`}, \
{-2.2553841482219026`, -1.4997443267671489`}}], 
          
          LineBox[{{-2.2553841482219026`, -1.4997443267671489`}, \
{-2.2553841482219026`, -1.4674953438648664`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.1984389311930306`, -1.6652082346301083`}, \
{-2.1984389311930306`, -1.6323694181875545`}}], 
          
          LineBox[{{-2.1984389311930306`, -1.6323694181875545`}, \
{-2.1984389311930306`, -1.6005747905345595`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.144562997373256, -1.7909769342208373`}, \
{-2.144562997373256, -1.7598879851040943`}}], 
          
          LineBox[{{-2.144562997373256, -1.7598879851040943`}, \
{-2.144562997373256, -1.7297364875849874`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.0934424039470523`, -1.9142673397810188`}, \
{-2.0934424039470523`, -1.883709346111293}}], 
          
          LineBox[{{-2.0934424039470523`, -1.883709346111293}, \
{-2.0934424039470523`, -1.8540575211414987`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-2.0448088291688524`, -2.030679039079973}, \
{-2.0448088291688524`, -2.0005884375940104`}}], 
          
          LineBox[{{-2.0448088291688524`, -2.0005884375940104`}, \
{-2.0448088291688524`, -1.9713768934298805`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.998431547349378, -2.139805142210923}, \
{-1.998431547349378, -2.1129221078909204`}}], 
          
          LineBox[{{-1.998431547349378, -2.1129221078909204`}, \
{-1.998431547349378, -2.086742891616604}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.9434261704597346`, -2.274706267308357}, \
{-1.9434261704597346`, -2.2441378664494818`}}], 
          
          LineBox[{{-1.9434261704597346`, -2.2441378664494818`}, \
{-1.9434261704597346`, -2.2144762425132947`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.8911076856443865`, -2.3985175095671787`}, \
{-1.8911076856443865`, -2.3731770660439384`}}], 
          
          LineBox[{{-1.8911076856443865`, -2.3731770660439384`}, \
{-1.8911076856443865`, -2.3484629225627245`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.8415558697159746`, -2.523866174228259}, \
{-1.8415558697159746`, -2.4949214965481983`}}], 
          
          LineBox[{{-1.8415558697159746`, -2.4949214965481983`}, \
{-1.8415558697159746`, -2.4667910993951443`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.794195067044452, -2.636012756413769}, \
{-1.794195067044452, -2.6123231874248036`}}], 
          
          LineBox[{{-1.794195067044452, -2.6123231874248036`}, \
{-1.794195067044452, -2.5891818517486516`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.749112569203864, -2.7523866326907167`}, \
{-1.749112569203864, -2.7254664461566005`}}], 
          
          LineBox[{{-1.749112569203864, -2.7254664461566005`}, \
{-1.749112569203864, -2.699251998933381}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.6974896181121244`, -2.883125737019028}, \
{-1.6974896181121244`, -2.857718858038654}}], 
          
          LineBox[{{-1.6974896181121244`, -2.857718858038654}, \
{-1.6974896181121244`, -2.832941526740773}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.6484017660376873`, -3.0072464747489995`}, \
{-1.6484017660376873`, -2.9836327753803844`}}], 
          
          LineBox[{{-1.6484017660376873`, -2.9836327753803844`}, \
{-1.6484017660376873`, -2.960563843561669}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.594088397426578, -3.151363193183176}, \
{-1.594088397426578, -3.1241326242959593`}}], 
          
          LineBox[{{-1.594088397426578, -3.1241326242959593`}, \
{-1.594088397426578, -3.0976239452427095`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.5424473593467354`, -3.2820670126181506`}, \
{-1.5424473593467354`, -3.2602355963400265`}}], 
          
          LineBox[{{-1.5424473593467354`, -3.2602355963400265`}, \
{-1.5424473593467354`, -3.23887062575828}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.493457846130768, -3.4158738161812936`}, \
{-1.493457846130768, -3.3916133331596203`}}], 
          
          LineBox[{{-1.493457846130768, -3.3916133331596203`}, \
{-1.493457846130768, -3.3679275072328214`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.4466528065688393`, -3.5377825084564627`}, \
{-1.4466528065688393`, -3.517454834967928}}], 
          
          LineBox[{{-1.4466528065688393`, -3.517454834967928}, \
{-1.4466528065688393`, -3.4975321568430324`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.4020363206488669`, -3.661847690753108}, \
{-1.4020363206488669`, -3.6390422597518133`}}], 
          
          LineBox[{{-1.4020363206488669`, -3.6390422597518133`}, \
{-1.4020363206488669`, -3.6167453411368107`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.3474454533915494`, -3.814270610398914}, \
{-1.3474454533915494`, -3.7909451201277533`}}], 
          
          LineBox[{{-1.3474454533915494`, -3.7909451201277533`}, \
{-1.3474454533915494`, -3.7681513297493674`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.2955821719692076`, -3.9543276763346142`}, \
{-1.2955821719692076`, -3.934701187335693}}], 
          
          LineBox[{{-1.2955821719692076`, -3.934701187335693}, \
{-1.2955821719692076`, -3.9154524944887386`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.24636706214148, -4.095259485683212}, \
{-1.24636706214148, -4.073301338365976}}], 
          
          LineBox[{{-1.24636706214148, -4.073301338365976}, \
{-1.24636706214148, -4.051815009571605}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.1943354736944491`, -4.245358295931416}, \
{-1.1943354736944491`, -4.224667104198138}}], 
          
          LineBox[{{-1.1943354736944491`, -4.224667104198138}, \
{-1.1943354736944491`, -4.2043953733951405`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.1448783782845262`, -4.388222942362424}, \
{-1.1448783782845262`, -4.367913539896439}}], 
          
          LineBox[{{-1.1448783782845262`, -4.367913539896439}, \
{-1.1448783782845262`, -4.348008412297119}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.0977528619957602`, -4.527404535721952}, \
{-1.0977528619957602`, -4.5068286369321715`}}], 
          
          LineBox[{{-1.0977528619957602`, -4.5068286369321715`}, \
{-1.0977528619957602`, -4.486667584262271}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-1.0483930806633872`, -4.675286330704212}, \
{-1.0483930806633872`, -4.655576675865791}}], 
          
          LineBox[{{-1.0483930806633872`, -4.655576675865791}, \
{-1.0483930806633872`, -4.636247994755012}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-0.9971493792545362, -4.83118648403724}, \
{-0.9971493792545362, -4.81195792240584}}], 
          
          LineBox[{{-0.9971493792545362, -4.81195792240584}, \
{-0.9971493792545362, -4.793092133721371}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{Small, Small}]], {}, {
          
          LineBox[{{-0.9484045818214244, -4.978215617221485}, \
{-0.9484045818214244, -4.959352094623877}}], 
          
          LineBox[{{-0.9484045818214244, -4.959352094623877}, \
{-0.9484045818214244, -4.940837826505711}}]}}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-5.256921585253977, 
           2.7978145509545933`}, {-5.256921585253977, 2.8621947502553313`}}], 
          
          LineBox[{{-5.256921585253977, 
           2.8621947502553313`}, {-5.256921585253977, 
           2.9226796555144534`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-5.2005387488032095`, 
           2.8629413193426974`}, {-5.2005387488032095`, 
           2.8982035699615114`}}], 
          
          LineBox[{{-5.2005387488032095`, 
           2.8982035699615114`}, {-5.2005387488032095`, 
           2.932264630701338}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-5.147166472619123, 
           2.8398441984077256`}, {-5.147166472619123, 2.8474536487341817`}}], 
          
          LineBox[{{-5.147166472619123, 
           2.8474536487341817`}, {-5.147166472619123, 
           2.8550056323413133`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-5.09649951504208, 2.770129493587463}, {-5.09649951504208,
            2.7792563930298733`}}], 
          
          LineBox[{{-5.09649951504208, 
           2.7792563930298733`}, {-5.09649951504208, 2.788300745013374}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-5.048276729473299, 
           2.815368364351652}, {-5.048276729473299, 2.8172159482885815`}}], 
          
          LineBox[{{-5.048276729473299, 
           2.8172159482885815`}, {-5.048276729473299, 
           2.8190601249533613`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-5.002273086667765, 
           2.6690908151988983`}, {-5.002273086667765, 2.673152709939648}}], 
          
          LineBox[{{-5.002273086667765, 
           2.673152709939648}, {-5.002273086667765, 2.677198172415143}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.94768844245325, 
           2.6560655974876735`}, {-4.94768844245325, 2.6976247009705356`}}], 
          
          LineBox[{{-4.94768844245325, 
           2.6976247009705356`}, {-4.94768844245325, 
           2.7375253404887494`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.895750762859643, 
           2.631694354666416}, {-4.895750762859643, 2.6374048751649477`}}], 
          
          LineBox[{{-4.895750762859643, 
           2.6374048751649477`}, {-4.895750762859643, 
           2.643082970694948}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.846540574896795, 
           2.564029633046699}, {-4.846540574896795, 2.605266958806029}}], 
          
          LineBox[{{-4.846540574896795, 
           2.605266958806029}, {-4.846540574896795, 
           2.6448709015952936`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.7904256789098545`, 
           2.482852992891339}, {-4.7904256789098545`, 2.5018452859535363`}}], 
          
          LineBox[{{-4.7904256789098545`, 
           2.5018452859535363`}, {-4.7904256789098545`, 
           2.5204835845445315`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.745892143749627, 
           2.454427324574902}, {-4.745892143749627, 2.464264517159642}}], 
          
          LineBox[{{-4.745892143749627, 
           2.464264517159642}, {-4.745892143749627, 
           2.4740058813040076`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.703378855771098, 
           2.3621685093852642`}, {-4.703378855771098, 2.4066805244935554`}}], 
          
          LineBox[{{-4.703378855771098, 
           2.4066805244935554`}, {-4.703378855771098, 
           2.449295367216024}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.646735106032223, 
           2.3292796332500867`}, {-4.646735106032223, 2.3412868695809625`}}], 
          
          LineBox[{{-4.646735106032223, 
           2.3412868695809625`}, {-4.646735106032223, 2.35315164110482}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.591895738572719, 
           2.2784096661105036`}, {-4.591895738572719, 2.295871349676884}}], 
          
          LineBox[{{-4.591895738572719, 
           2.295871349676884}, {-4.591895738572719, 
           2.3130333483687866`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.552199066800568, 
           2.2217192424015453`}, {-4.552199066800568, 2.2233830686030127`}}], 
          
          LineBox[{{-4.552199066800568, 
           2.2233830686030127`}, {-4.552199066800568, 
           2.225044131084565}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.402042555761872, 
           1.9805033359319928`}, {-4.402042555761872, 2.0121996432023246`}}], 
          
          LineBox[{{-4.402042555761872, 
           2.0121996432023246`}, {-4.402042555761872, 
           2.0429220835391737`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.2944436118375116`, 
           1.8353489400539047`}, {-4.2944436118375116`, 
           1.8609788800130855`}}], 
          
          LineBox[{{-4.2944436118375116`, 
           1.8609788800130855`}, {-4.2944436118375116`, 
           1.885968308242122}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.19730843655865, 1.676037514378018}, {-4.19730843655865,
            1.6998452500710504`}}], 
          
          LineBox[{{-4.19730843655865, 
           1.6998452500710504`}, {-4.19730843655865, 
           1.7230993331577882`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.137427702804738, 
           1.5740219878160084`}, {-4.137427702804738, 1.6017340360793693`}}], 
          
          LineBox[{{-4.137427702804738, 
           1.6017340360793693`}, {-4.137427702804738, 
           1.628698789268097}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.053837356848126, 
           1.4239050771170159`}, {-4.053837356848126, 1.4490140534378622`}}], 
          
          LineBox[{{-4.053837356848126, 
           1.4490140534378622`}, {-4.053837356848126, 
           1.4735079807954974`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-4.001756736202332, 
           1.3429657288390264`}, {-4.001756736202332, 1.3676331118086469`}}], 
          
          LineBox[{{-4.001756736202332, 
           1.3676331118086469`}, {-4.001756736202332, 
           1.3917066345856652`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.9522551105228425`, 
           1.2631977442077975`}, {-3.9522551105228425`, 
           1.2825093696670358`}}], 
          
          LineBox[{{-3.9522551105228425`, 
           1.2825093696670358`}, {-3.9522551105228425`, 
           1.3014551109119115`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.9050891681813837`, 
           1.1708299686398962`}, {-3.9050891681813837`, 
           1.1871397716151189`}}], 
          
          LineBox[{{-3.9050891681813837`, 
           1.1871397716151189`}, {-3.9050891681813837`, 
           1.2031878282395976`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.8491968474870055`, 
           1.053578365009375}, {-3.8491968474870055`, 1.0812469561676872`}}], 
          
          LineBox[{{-3.8491968474870055`, 
           1.0812469561676872`}, {-3.8491968474870055`, 
           1.1081705628155853`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.7960766508869286`, 
           0.972120401071927}, {-3.7960766508869286`, 0.9862463800436038}}], 
          
          LineBox[{{-3.7960766508869286`, 
           0.9862463800436038}, {-3.7960766508869286`, 
           1.00017559203327}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.745806254138991, 
           0.8609485135684525}, {-3.745806254138991, 0.8856238509395108}}], 
          
          LineBox[{{-3.745806254138991, 
           0.8856238509395108}, {-3.745806254138991, 
           0.9097049496512896}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.697789438310754, 
           0.7763984029897117}, {-3.697789438310754, 0.7906932920496603}}], 
          
          LineBox[{{-3.697789438310754, 
           0.7906932920496603}, {-3.697789438310754, 
           0.8047867138265026}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.652113025280155, 
           0.6755980707534107}, {-3.652113025280155, 0.6967001846791796}}], 
          
          LineBox[{{-3.652113025280155, 
           0.6967001846791796}, {-3.652113025280155, 
           0.7173661864329857}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.5998413776538905`, 
           0.5743952576200828}, {-3.5998413776538905`, 0.5926739745813264}}], 
          
          LineBox[{{-3.5998413776538905`, 
           0.5926739745813264}, {-3.5998413776538905`, 
           0.6106245687409843}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.550167336133954, 
           0.46063117381806223`}, {-3.550167336133954, 
           0.48543807098122094`}}], 
          
          LineBox[{{-3.550167336133954, 
           0.48543807098122094`}, {-3.550167336133954, 
           0.5096444528690526}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.495239238732143, 
           0.35257209149902025`}, {-3.495239238732143, 
           0.37579504469830594`}}], 
          
          LineBox[{{-3.495239238732143, 
           0.37579504469830594`}, {-3.495239238732143, 
           0.3984909097358079}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.4430427535118717`, 
           0.24675424771567256`}, {-3.4430427535118717`, 
           0.2653352297043462}}], 
          
          LineBox[{{-3.4430427535118717`, 
           0.2653352297043462}, {-3.4430427535118717`, 
           0.28357724751436136`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.393553721612056, 
           0.13954020442180715`}, {-3.393553721612056, 0.1597360897932318}}], 
          
          LineBox[{{-3.393553721612056, 
           0.1597360897932318}, {-3.393553721612056, 
           0.17953216262677715`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.3462929219035455`, 
           0.03764292140958449}, {-3.3462929219035455`, 
           0.05417587100098447}}], 
          
          LineBox[{{-3.3462929219035455`, 
           0.05417587100098447}, {-3.3462929219035455`, 
           0.07043992183447328}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.3012624883237294`, -0.06419529957265487}, \
{-3.3012624883237294`, -0.04677993493290712}}], 
          
          LineBox[{{-3.3012624883237294`, -0.04677993493290712}, \
{-3.3012624883237294`, -0.02966268091897755}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.246189753861999, -0.18462092144717332`}, \
{-3.246189753861999, -0.1655166171170455}}], 
          
          LineBox[{{-3.246189753861999, -0.1655166171170455}, \
{-3.246189753861999, -0.1467704558452364}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.193891750599751, -0.2986472303930195}, \
{-3.193891750599751, -0.2813117963411156}}], 
          
          LineBox[{{-3.193891750599751, -0.2813117963411156}, \
{-3.193891750599751, -0.26427176588507867`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.144285378030157, -0.4073826267927299}, \
{-3.144285378030157, -0.38830878065860036`}}], 
          
          LineBox[{{-3.144285378030157, -0.38830878065860036`}, \
{-3.144285378030157, -0.36959194714796634`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.0918603937501348`, -0.5247793220725498}, \
{-3.0918603937501348`, -0.5087566167721987}}], 
          
          LineBox[{{-3.0918603937501348`, -0.5087566167721987}, \
{-3.0918603937501348`, -0.49298659520064503`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-3.0420479410377324`, -0.6335808659513096}, \
{-3.0420479410377324`, -0.617569506406823}}], 
          
          LineBox[{{-3.0420479410377324`, -0.617569506406823}, \
{-3.0420479410377324`, -0.6018104756750953}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.9911660280620147`, -0.7374719891774395}, \
{-2.9911660280620147`, -0.7215011591461775}}], 
          
          LineBox[{{-2.9911660280620147`, -0.7215011591461775}, \
{-2.9911660280620147`, -0.7057813920951608}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.944918614078745, -0.8362110549760714}, \
{-2.944918614078745, -0.8196991131376578}}], 
          
          LineBox[{{-2.944918614078745, -0.8196991131376578}, \
{-2.944918614078745, -0.8034553926619885}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.8965392040719284`, -0.9328211852091962}, \
{-2.8965392040719284`, -0.9188116567034952}}], 
          
          LineBox[{{-2.8965392040719284`, -0.9188116567034952}, \
{-2.8965392040719284`, -0.9049956865475173}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.8466335915245713`, -1.0375365361013396`}, \
{-2.8466335915245713`, -1.0259312047180407`}}], 
          
          LineBox[{{-2.8466335915245713`, -1.0259312047180407`}, \
{-2.8466335915245713`, -1.0144590133939144`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.799104911673882, -1.1365696696820229`}, \
{-2.799104911673882, -1.1245755849936172`}}], 
          
          LineBox[{{-2.799104911673882, -1.1245755849936172`}, \
{-2.799104911673882, -1.1127236550407524`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.750482761099594, -1.2485993334688679`}, \
{-2.750482761099594, -1.2358979931600667`}}], 
          
          LineBox[{{-2.750482761099594, -1.2358979931600667`}, \
{-2.750482761099594, -1.2233559556525513`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.698044485612837, -1.3641249079278925`}, \
{-2.698044485612837, -1.3524564283438612`}}], 
          
          LineBox[{{-2.698044485612837, -1.3524564283438612`}, \
{-2.698044485612837, -1.3409225332882004`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.6457065546811838`, -1.4821866944413546`}, \
{-2.6457065546811838`, -1.4703381219634943`}}], 
          
          LineBox[{{-2.6457065546811838`, -1.4703381219634943`}, \
{-2.6457065546811838`, -1.4586282958136556`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.598812388273519, -1.584641582548729}, \
{-2.598812388273519, -1.5717209847297622`}}], 
          
          LineBox[{{-2.598812388273519, -1.5717209847297622`}, \
{-2.598812388273519, -1.5589652015191306`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.4487245335749988`, -1.928781633108404}, \
{-2.4487245335749988`, -1.8890340321099925`}}], 
          
          LineBox[{{-2.4487245335749988`, -1.8890340321099925`}, \
{-2.4487245335749988`, -1.8508060924141505`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.347387847945706, -2.1523552906391537`}, \
{-2.347387847945706, -2.113182968889576}}], 
          
          LineBox[{{-2.347387847945706, -2.113182968889576}, \
{-2.347387847945706, -2.075487449850066}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.2553841482219026`, -2.352452518889396}, \
{-2.2553841482219026`, -2.3211497621762356`}}], 
          
          LineBox[{{-2.2553841482219026`, -2.3211497621762356`}, \
{-2.2553841482219026`, -2.2907971995753313`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.1984389311930306`, -2.4829862593427214`}, \
{-2.1984389311930306`, -2.45079481532641}}], 
          
          LineBox[{{-2.1984389311930306`, -2.45079481532641}, \
{-2.1984389311930306`, -2.41960742251835}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.144562997373256, -2.6029486807815174`}, \
{-2.144562997373256, -2.5722039675643007`}}], 
          
          LineBox[{{-2.144562997373256, -2.5722039675643007`}, \
{-2.144562997373256, -2.5423763655009797`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.0934424039470523`, -2.720087050081372}, \
{-2.0934424039470523`, -2.6907988030754204`}}], 
          
          LineBox[{{-2.0934424039470523`, -2.6907988030754204`}, \
{-2.0934424039470523`, -2.6623440051010547`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-2.0448088291688524`, -2.8336935388753965`}, \
{-2.0448088291688524`, -2.806132950143697}}], 
          
          LineBox[{{-2.0448088291688524`, -2.806132950143697}, \
{-2.0448088291688524`, -2.7793116186361937`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.998431547349378, -2.9387939236257243`}, \
{-1.998431547349378, -2.9124598188943853`}}], 
          
          LineBox[{{-1.998431547349378, -2.9124598188943853`}, \
{-1.998431547349378, -2.886801442579472}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.9434261704597346`, -3.0673639090841838`}, \
{-1.9434261704597346`, -3.039159868781684}}], 
          
          LineBox[{{-1.9434261704597346`, -3.039159868781684}, \
{-1.9434261704597346`, -3.01172952488272}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.8911076856443865`, -3.185249690190937}, \
{-1.8911076856443865`, -3.1607400603456925`}}], 
          
          LineBox[{{-1.8911076856443865`, -3.1607400603456925`}, \
{-1.8911076856443865`, -3.136816809182249}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.8415558697159746`, -3.3064446017270437`}, \
{-1.8415558697159746`, -3.279314642629432}}], 
          
          LineBox[{{-1.8415558697159746`, -3.279314642629432}, \
{-1.8415558697159746`, -3.2529013187221345`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.794195067044452, -3.4135516794781897`}, \
{-1.794195067044452, -3.3906136001548424`}}], 
          
          LineBox[{{-1.794195067044452, -3.3906136001548424`}, \
{-1.794195067044452, -3.3681898995030415`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.749112569203864, -3.523456359850129}, \
{-1.749112569203864, -3.499548511813561}}], 
          
          LineBox[{{-1.749112569203864, -3.499548511813561}, \
{-1.749112569203864, -3.47619892804705}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.6974896181121244`, -3.6455075219265303`}, \
{-1.6974896181121244`, -3.6216984396600984`}}], 
          
          LineBox[{{-1.6974896181121244`, -3.6216984396600984`}, \
{-1.6974896181121244`, -3.5984430719057596`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.6484017660376873`, -3.7654344435265275`}, \
{-1.6484017660376873`, -3.7424286196570886`}}], 
          
          LineBox[{{-1.6484017660376873`, -3.7424286196570886`}, \
{-1.6484017660376873`, -3.7199401831040193`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.594088397426578, -3.8980013376253955`}, \
{-1.594088397426578, -3.87392344288946}}], 
          
          LineBox[{{-1.594088397426578, -3.87392344288946}, \
{-1.594088397426578, -3.850411688410476}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.5424473593467354`, -4.019104562708266}, \
{-1.5424473593467354`, -3.998502034232763}}], 
          
          LineBox[{{-1.5424473593467354`, -3.998502034232763}, \
{-1.5424473593467354`, -3.9783154155576197`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.493457846130768, -4.144605631951875}, \
{-1.493457846130768, -4.121771968119527}}], 
          
          LineBox[{{-1.493457846130768, -4.121771968119527}, \
{-1.493457846130768, -4.099448062496578}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.4466528065688393`, -4.257764579638224}, \
{-1.4466528065688393`, -4.2383543285108845`}}], 
          
          LineBox[{{-1.4466528065688393`, -4.2383543285108845`}, \
{-1.4466528065688393`, -4.219313672677725}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.4020363206488669`, -4.369755556908221}, \
{-1.4020363206488669`, -4.349905075637888}}], 
          
          LineBox[{{-1.4020363206488669`, -4.349905075637888}, \
{-1.4020363206488669`, -4.33044097850358}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.3474454533915494`, -4.511179822871451}, \
{-1.3474454533915494`, -4.489060819669355}}], 
          
          LineBox[{{-1.3474454533915494`, -4.489060819669355}, \
{-1.3474454533915494`, -4.467420497907055}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.2955821719692076`, -4.640444765307245}, \
{-1.2955821719692076`, -4.622390825830852}}], 
          
          LineBox[{{-1.2955821719692076`, -4.622390825830852}, \
{-1.2955821719692076`, -4.604657059245276}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.24636706214148, -4.770413084293939}, \
{-1.24636706214148, -4.750071112143876}}], 
          
          LineBox[{{-1.24636706214148, -4.750071112143876}, \
{-1.24636706214148, -4.730134699647399}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.1943354736944491`, -4.906828601533499}, \
{-1.1943354736944491`, -4.88859075409121}}], 
          
          LineBox[{{-1.1943354736944491`, -4.88859075409121}, \
{-1.1943354736944491`, -4.870679576859187}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.1448783782845262`, -5.033963654781131}, \
{-1.1448783782845262`, -5.015628813738735}}], 
          
          LineBox[{{-1.1448783782845262`, -5.015628813738735}, \
{-1.1448783782845262`, -4.997624095425968}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.0977528619957602`, -5.159208430692456}, \
{-1.0977528619957602`, -5.1419132702212025`}}], 
          
          LineBox[{{-1.0977528619957602`, -5.1419132702212025`}, \
{-1.0977528619957602`, -5.124912153988273}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-1.0483930806633872`, -5.291884720049113}, \
{-1.0483930806633872`, -5.2736689088208015`}}], 
          
          LineBox[{{-1.0483930806633872`, -5.2736689088208015`}, \
{-1.0483930806633872`, -5.2557789859011645`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-0.9971493792545362, -5.432180438363585}, \
{-0.9971493792545362, -5.41345145162586}}], 
          
          LineBox[{{-0.9971493792545362, -5.41345145162586}, \
{-0.9971493792545362, -5.395066800652531}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.01], 
          Dashing[{0, Small}]], {}, {
          
          LineBox[{{-0.9484045818214244, -5.557761723713959}, \
{-0.9484045818214244, -5.541004997843584}}], 
          
          LineBox[{{-0.9484045818214244, -5.541004997843584}, \
{-0.9484045818214244, -5.524524438543028}}]}}}}}, {{{
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.02], 
         Thickness[0.01]], 
        PointBox[CompressedData["
1:eJwVyXs403scwHFmY2Nm15ImRzUpFaV78vs6LqlzKpNLOXEkKgtdSKsQSS4l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         "]]}, {
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
         PointSize[0.02], 
         Thickness[0.01], 
         Dashing[{Small, Small}]], 
        PointBox[CompressedData["
1:eJwVk/k/1HkcgMeYw8ww850xrHKUMx2rUKxK3y8iTYciyi01o7ZFciRLozbW
kZrYpkbHKl0bnaxdUZ83OcoVhVqDNiSU3Ne4tv3heT2v5w949ANDXYVkEom0
+xv/W7KmMFyTrgGaPxds2F+KEXrPr9K9avmQnuPKCD2GEZT26rrHUj5sT2Ap
BrwxQvVZY1l9IB+CTFwHxBhGnJmOjgg150Oap8le7CaHyLzo8K8bmQ9l87Ia
hQ2HWJhc0xxSpQ6xmZaXlO+zCZlw0UP8vDrY1s5D83Y28SbXJUkeqA7XzMh9
LRlqhHjPPk/hUnUoz/lpuqdUlfg6G2JSPc0Da5WsxzQHVSJocDLVvp4H7haC
56RKFnHc3emJnZQH5yyCfbX5LELTeZWzjT8PenfVJfj6MonwWQrX24IHuy8b
G2zrYxD0yyeCQ0k86BuVZ3GXM4gv6awkkyou3H1xsn19jAqxsVWRKpNyIZob
EifPpRMpjg9cE4RcOPXeXymMSifqd8Xb0s25wKSyPWL20Yj027l/35jCwHEm
PX0qk0rYZ4lVFpZjAAG12I48CtHho8dfnIFB9N3OmfMbKMSg9vEHx/Zh4OEs
VC4OUCa0nLMEyeYYOJOtmEvLycSxrldJrtMcWOLE7OQOKRHXxA7eWRIOiDQG
WmS6SkTXTjGuuZwDujHk8WARidBs+RQVVcWG7HPrblmVz+EBu11zvQLY0OIt
6JaGzeJWfbaBraNqkJNXHit4OY3bNw5MPjmjBhlnseDjmgr8wBWLofDvv7Wg
vkBgNonbr+Do+Zarwv2qfg8mYwJHh/64U+ujCtl74otfaIzha4Mu3DkwxQIR
c/1v5kkjeOaCxPgOCQukm9JY4WeH8L71LhGVpizwaojCFxgP4pXVcQsKypkw
EnooOeXqF/xIC0O1x48JO1LEF01De/G3QZt95kYZMLbF5xyv7CNuw8g/IpAw
wKzqC0JaHbjAZRlWvIIBzEchcbLAdrxGEHHxa4UKNF9ta/MgmvHUD6UBwf4q
8NCiKO/HO69wuUG4lcMoHSqKmuTkZMDH8NOJ2hI61ARYun4eT8c1tAwLuz3o
YJ68mnT7uyvIWJbo59hBg4M73SatP5egG5PmuuuP0mDd8KxrolU9co9dxTvF
pYHdG1FLztq3SEy/HnL5IRUcUy3CsP429MKEFPl6CRWiHQ9axxZ2ohUXBFfy
blHgtoi62Hh7D9JxuJX8gzsF4ho+XG1f8hlV3Et7JKdRwPd40OX+f/qRdHB/
54xUGZYlsF2MugaR3L03besKZVAsajBrKhlG/OwHm8IrycCWuRmGy0ZRgdCv
uVFEBkreBFPoM46sbI3e0Vhk0Lax7RmZm0AhDXEmQVIlkDzWF67UUyD/w5yb
mKkS3HCr2hZvOoPIC0yL/BAJ+D9vOZhrOIciGjYUlXmT4H5FycnVSiQQSR57
Z0zNoz1az/MdPpEgg+nIdNKaR4x+SJsbUQJK76C+wm4OGa0Ztts4Q4ans9c3
Kx+dRZ5adSLZmDIcvjTVQf1zBsVkUPIY3RRoUtWJ8p2ZRjr5Rl4ltVRYGvno
fZ/pNKKe3Jd/qZUGXXXFv7b4K1Cc/dbWmHY67NBobwo8MYXYz2o32MypwIi+
g3PbvUl00zlWNM5ngtPeIbXVHyfQ6IvG5TQDFmSo1x2MM55AK0sEPshQFbzk
nOynIeNobJnlqlIdNbjk99e4wdkxZMmYV5G7saHNSs8//8kooukWXtkY8+0j
zxyp3tAIKjY8fYKzBYOoRPEv89ojKIpnZMDpxuAuL2X20M5hFBlW4PYsmgvJ
1RrbhZIhZGDJ1Zyj8eBpY+5r64pBlBcxHefyOw8i57Prb/YMIPt3Lz+G4eqg
I30p2eX5FclVcGFAszr8B8I4nmU=
         "]]}, {
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
         PointSize[0.02], 
         Thickness[0.01], 
         Dashing[{0, Small}]], 
        PointBox[CompressedData["
1:eJwVxXk4lHkcAPC5D+OYSyhh2nVM22ZTUYzet6JbUUmjMVo1rnaR7lp5RAod
JLMk1Y7u9LRsqVC/74pxzNSqHJWV0pbyFKPBHGbM7v7xeT6CmOS1MhKBQIj4
z//nz72/YxLdHlYw90mU72m4y6Nz9MjHfGjgb4887E3HKa9VT6rkfEjNDGsq
aqLh1g/bG9pi+MByOqMcCKDhJ8b37kyexYflkT2ZV3No+JnixW/WkfiQJ1r3
riyGik/OUXcmtfKgN1ayqO40FS+Ruf6OFfGg3lNYE+dExZ9XrDnaHcODRilr
jryLgqdv3CKWCXnwtnDS7iYyBR80J3moxrlQ6XErtK2ajMdp9HmL2rhwZZRy
7y1Oxg+GL6lZKOdCmCjg7EgNCedi5wecpFyY/Eu4ejiKhLsKeRU75nIh2mrY
Lq2FiD/ada15DZELWSHGjDmBRFyV6oBLuzhgOmu40txCwDu3+LAqSzkgK9vq
ZnIk4B9WeuwfieEATeNwKRgmsPakkAuHvueAK7a4tUBpxgoLMjKSjWyY0a8X
xiWaMC8jYz6rlQ31th2D+T7jWOJ2ysv7x9hQXBb1+o8LBiwouNljaDMbGDvT
R/EgPTb2d/c3Aj82zJN4S4TeOqzE/VSWmsiG1WGkRc/fjmJ9nglf/M7ZwQ85
e/O8Do9goT+1bjkfaAeVfV+Csye+YgeKDt71VNnCHlFNacuqYcxfLEuOktpC
44NDBetPDmGc5NGgBJ0NMPW57fSIz9j1NYzfuEU2UK9oo0hCPmH3zJcZR/xs
wN8211u68gNGTXut2Ke2BvExPMFb14eVz3wjeBhrDSJc2ZXI6cXi41LM2BgL
PhQ/vEqzeYEVZzRbxHkseKXILMPH2zB1hOSgxZ0Fv+Y/TwlIbcDUK2fPn9to
BX5ayWlN3Q1s8/vq1aZ4K+BWrHDP1V5BitPbwn30TNj3XS3lsncjmr52gYvD
cSbw+0NnkYnP0J3t5x3SPZlQmbCNa/PqBepSRIQI6hggdusYqV36BvnqnQOm
bmCAsdHNTfDoHfq4a9POj1/ocLsvrCRnUj/KUGenzTpJB21+ssLgP4CIBQzk
PIMOX2c73O6P/YJmbpzc0d9Ig7ObHnX6JmqQsurm1IKtNKjoGtMtmhhGR3lO
U8wEGgQxogwipRa9fPthY3ERFYro7Mhr5aNIIL7vEz+dCpR1C4IysnUovhj3
kLZSoOpcYH+DuwE5L76cMy+cAuFtA8E3B41IefN4ZTeNAtuEfhtkK01Irtn6
ziQnwyrHv9CB+ROoO/zT8VUzyHCaWBL1mEwAfvmtpTuaSBBTP7hX3U+Aapm0
sz2WBFyp/vZkJRF8A799QWORwH3tz7rqAhIkPU3ziJMTYWbQxzX+pWSITrG7
xPYiAv/i/oreQgqQnLxqpYgAG0teHf4zmwo7ny6obdhEgM/1jI7RVBrE5ldt
KjRYED+7ufbuKjoUWgVbLXG0IM+eMuvZoQygfNIIjAsnkFVdlb3PciY8MCuW
k/eYUbBTbShTZAUppYY+6h0TOhGioRpdWdBh7bw7yjSOrjKXreBZWCDcVdk7
4DWOVJlcRqDBGv55UnfkVbQRicKPJh7U2ECo/euOmAwD0kdoT6nMtqAVLF7W
c1OPQjxTFIMmO1jy47DNnPc6FHkqtbXyFzYU8p4kpLnrUMdCPy/eCBsiu+3K
HySNIdWSaVkhsRwold4dm3ZyFO3VMCTqEQ70+LpE364ZQVmOy6nr07gwVXxD
7jKsRcHrF17kEniwOzs90zJFi1xiOXUDx3lwnZtr3hb2FW04OmQhsPmQo7Jf
LcsfRvd6xdVhBXx40F7xzE+pQbqgomsiR3vYZSlvu/RxCFl6RE+jr9iDs7wl
f714ED3ueuZrFk6CfwHyJK6b
         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-6.907755278982122, -6.907755278982122}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
         TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameTicks -> {{{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           
           TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           
           TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.907755278982137, 0.}, {-6.907755278982137, 
      6.907755278982137}}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{0, 0}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], 
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0]}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"C20\"", "\"C21\"", "\"C22\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.18]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.18]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608], 
                    PointSize[0.5], 
                    Thickness[0.18], 
                    Dashing[{Small, Small}]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608], 
                    PointSize[0.5], 
                    Thickness[0.18], 
                    Dashing[{Small, Small}]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6470588235294118, 0.5686274509803921, 
                    0.611764705882353], 
                    PointSize[0.5], 
                    Thickness[0.18], 
                    Dashing[{0, Small}]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6470588235294118, 0.5686274509803921, 
                    0.611764705882353], 
                    PointSize[0.5], 
                    Thickness[0.18], 
                    Dashing[{0, Small}]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.01`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6470588235294118, 0.5686274509803921, 
                    0.611764705882353]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "Small"}], "}"}], "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "False", ",", "False"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.902217220996213*^9, {3.902217492107437*^9, 3.9022175133591595`*^9}, 
   3.9022177145073056`*^9, 3.9022178456890564`*^9, {3.902218004462067*^9, 
   3.902218039095897*^9}, 3.9022180801172466`*^9, 3.902218183630154*^9, 
   3.9022182179687195`*^9, 3.902218267061261*^9, 3.902218299722651*^9, 
   3.90222033900448*^9, 3.9022220423314676`*^9, 3.902378538939608*^9, 
   3.9023824867786922`*^9, {3.9035807464138355`*^9, 3.9035807631379757`*^9}, 
   3.904795167218701*^9, 3.9047952017819695`*^9, 3.904795546459771*^9, 
   3.904795599048907*^9, 3.905926114100419*^9, 3.9156985270599546`*^9, 
   3.91794429993673*^9, 3.917945240423125*^9, 3.918720616496622*^9, 
   3.9187206741702046`*^9, 3.918720718493164*^9, 3.91872169588393*^9, 
   3.9187270231686935`*^9},
 CellLabel->
  "Out[1276]=",ExpressionUUID->"660d526c-8c40-4749-8216-96c7045898c4"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\LH-ESRF-C14-16 & C20-22 \
plot\\\\DataMergedBinnedC20-22.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.902217220996213*^9, {3.902217492107437*^9, 3.9022175133591595`*^9}, 
   3.9022177145073056`*^9, 3.9022178456890564`*^9, {3.902218004462067*^9, 
   3.902218039095897*^9}, 3.9022180801172466`*^9, 3.902218183630154*^9, 
   3.9022182179687195`*^9, 3.902218267061261*^9, 3.902218299722651*^9, 
   3.90222033900448*^9, 3.9022220423314676`*^9, 3.902378538939608*^9, 
   3.9023824867786922`*^9, {3.9035807464138355`*^9, 3.9035807631379757`*^9}, 
   3.904795167218701*^9, 3.9047952017819695`*^9, 3.904795546459771*^9, 
   3.904795599048907*^9, 3.905926114100419*^9, 3.9156985270599546`*^9, 
   3.91794429993673*^9, 3.917945240423125*^9, 3.918720616496622*^9, 
   3.9187206741702046`*^9, 3.918720718493164*^9, 3.91872169588393*^9, 
   3.9187270279841022`*^9},
 CellLabel->
  "Out[1277]=",ExpressionUUID->"77885f82-0a55-4026-87d4-d25473104df2"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.352012198649872, -2.0093287828709796`}, \
{-5.352012198649872, -1.6814367993293893`}}], 
          
          LineBox[{{-5.352012198649872, -1.6814367993293893`}, \
{-5.352012198649872, -1.3535448157877992`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.197327949963066, -2.162449290062261}, \
{-5.197327949963066, -1.853973646897377}}], 
          
          LineBox[{{-5.197327949963066, -1.853973646897377}, \
{-5.197327949963066, -1.5454980037324935`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.046182498246482, -2.0517235372113287`}, \
{-5.046182498246482, -1.7610744015672055`}}], 
          
          LineBox[{{-5.046182498246482, -1.7610744015672055`}, \
{-5.046182498246482, -1.4704252659230823`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.894444132978499, -2.0825971397420115`}, \
{-4.894444132978499, -1.7869663217644973`}}], 
          
          LineBox[{{-4.894444132978499, -1.7869663217644973`}, \
{-4.894444132978499, -1.491335503786983}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.745125399370905, -2.1808530865199893`}, \
{-4.745125399370905, -1.90031225283698}}], 
          
          LineBox[{{-4.745125399370905, -1.90031225283698}, \
{-4.745125399370905, -1.6197714191539707`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.596628633102665, -2.2183411497318897`}, \
{-4.596628633102665, -1.9599645382822033`}}], 
          
          LineBox[{{-4.596628633102665, -1.9599645382822033`}, \
{-4.596628633102665, -1.7015879268325167`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.447741719114617, -2.2274008505891785`}, \
{-4.447741719114617, -1.9807057577397864`}}], 
          
          LineBox[{{-4.447741719114617, -1.9807057577397864`}, \
{-4.447741719114617, -1.7340106648903946`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.298711959937622, -2.185318714234099}, \
{-4.298711959937622, -1.9531048696628939`}}], 
          
          LineBox[{{-4.298711959937622, -1.9531048696628939`}, \
{-4.298711959937622, -1.7208910250916887`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.149632905511913, -2.219952502474402}, \
{-4.149632905511913, -2.001896117050877}}], 
          
          LineBox[{{-4.149632905511913, -2.001896117050877}, \
{-4.149632905511913, -1.7838397316273522`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.001278268975371, -2.2274534134911748`}, \
{-4.001278268975371, -2.0285179870113916`}}], 
          
          LineBox[{{-4.001278268975371, -2.0285179870113916`}, \
{-4.001278268975371, -1.8295825605316085`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.8508575458258987`, -2.4175562263623713`}, \
{-3.8508575458258987`, -2.225690849696841}}], 
          
          LineBox[{{-3.8508575458258987`, -2.225690849696841}, \
{-3.8508575458258987`, -2.033825473031311}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.6998351226863213`, -2.2727215623528925`}, \
{-3.6998351226863213`, -2.0919678625081652`}}], 
          
          LineBox[{{-3.6998351226863213`, -2.0919678625081652`}, \
{-3.6998351226863213`, -1.9112141626634382`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.550260154845919, -2.2629091764730767`}, \
{-3.550260154845919, -2.091929028752837}}], 
          
          LineBox[{{-3.550260154845919, -2.091929028752837}, \
{-3.550260154845919, -1.9209488810325972`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.3997502222704012`, -2.322751107274743}, \
{-3.3997502222704012`, -2.165765529900271}}], 
          
          LineBox[{{-3.3997502222704012`, -2.165765529900271}, \
{-3.3997502222704012`, -2.008779952525799}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.2492191603155653`, -2.3145014418751098`}, \
{-3.2492191603155653`, -2.1714505004601428`}}], 
          
          LineBox[{{-3.2492191603155653`, -2.1714505004601428`}, \
{-3.2492191603155653`, -2.0283995590451758`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.099363949694378, -2.294533488635746}, \
{-3.099363949694378, -2.1623580363201795`}}], 
          
          LineBox[{{-3.099363949694378, -2.1623580363201795`}, \
{-3.099363949694378, -2.030182584004613}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.9723318619592627`, -2.385446257630764}, \
{-2.9723318619592627`, -2.172990520670644}}], 
          
          LineBox[{{-2.9723318619592627`, -2.172990520670644}, \
{-2.9723318619592627`, -1.960534783710524}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.8161289018458944`, -2.3395589006173303`}, \
{-2.8161289018458944`, -2.038414432336277}}], 
          
          LineBox[{{-2.8161289018458944`, -2.038414432336277}, \
{-2.8161289018458944`, -1.7372699640552238`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.637122953927779, -2.8276708709846607`}, \
{-2.637122953927779, -2.2655493021042967`}}], 
          
          LineBox[{{-2.637122953927779, -2.2655493021042967`}, \
{-2.637122953927779, -1.703427733223933}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.4883394437723703`, -2.8001641582910803`}, \
{-2.4883394437723703`, -2.2762301306695414`}}], 
          
          LineBox[{{-2.4883394437723703`, -2.2762301306695414`}, \
{-2.4883394437723703`, -1.7522961030480024`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.3426491274116255`, -2.859476806527219}, \
{-2.3426491274116255`, -2.3671413990266306`}}], 
          
          LineBox[{{-2.3426491274116255`, -2.3671413990266306`}, \
{-2.3426491274116255`, -1.8748059915260418`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.1952323671440643`, -2.86101296801341}, \
{-2.1952323671440643`, -2.40394992995351}}], 
          
          LineBox[{{-2.1952323671440643`, -2.40394992995351}, \
{-2.1952323671440643`, -1.9468868918936102`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.048114358050804, -2.927583790365584}, \
{-2.048114358050804, -2.480016801922211}}], 
          
          LineBox[{{-2.048114358050804, -2.480016801922211}, \
{-2.048114358050804, -2.032449813478838}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.9047213128625353`, -2.9539600369254435`}, \
{-1.9047213128625353`, -2.537291464128335}}], 
          
          LineBox[{{-1.9047213128625353`, -2.537291464128335}, \
{-1.9047213128625353`, -2.1206228913312266`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.7572185227137695`, -3.0295367064494565`}, \
{-1.7572185227137695`, -2.6386670909388585`}}], 
          
          LineBox[{{-1.7572185227137695`, -2.6386670909388585`}, \
{-1.7572185227137695`, -2.2477974754282606`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.6053998639759, -3.1281301596343156`}, \
{-1.6053998639759, -2.7555266821823174`}}], 
          
          LineBox[{{-1.6053998639759, -2.7555266821823174`}, \
{-1.6053998639759, -2.3829232047303193`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.4536487775630647`, -3.2536861916921644`}, \
{-1.4536487775630647`, -2.8914721239984646`}}], 
          
          LineBox[{{-1.4536487775630647`, -2.8914721239984646`}, \
{-1.4536487775630647`, -2.529258056304765}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.3021571254789979`, -3.371752061543436}, \
{-1.3021571254789979`, -3.0237373326734476`}}], 
          
          LineBox[{{-1.3021571254789979`, -3.0237373326734476`}, \
{-1.3021571254789979`, -2.675722603803459}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.1509597708634107`, -3.5161706840968763`}, \
{-1.1509597708634107`, -3.1742352803685083`}}], 
          
          LineBox[{{-1.1509597708634107`, -3.1742352803685083`}, \
{-1.1509597708634107`, -2.8322998766401404`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.0007923805337786`, -3.653023148518657}, \
{-1.0007923805337786`, -3.323018544488238}}], 
          
          LineBox[{{-1.0007923805337786`, -3.323018544488238}, \
{-1.0007923805337786`, -2.9930139404578187`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-0.8504177096512346, -3.741118323825691}, \
{-0.8504177096512346, -3.4256501256993244`}}], 
          
          LineBox[{{-0.8504177096512346, -3.4256501256993244`}, \
{-0.8504177096512346, -3.110181927572958}}]}}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.1252793563099095`, -1.3528451653663944`}, \
{-5.1252793563099095`, -1.1433795214933027`}}], 
          
          LineBox[{{-5.1252793563099095`, -1.1433795214933027`}, \
{-5.1252793563099095`, -0.9339138776202109}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.972895007974446, -1.4467978539834505`}, \
{-4.972895007974446, -1.2260374126787217`}}], 
          
          LineBox[{{-4.972895007974446, -1.2260374126787217`}, \
{-4.972895007974446, -1.0052769713739929`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.8217116543319705`, -1.8090928756008526`}, \
{-4.8217116543319705`, -1.5870255304684209`}}], 
          
          LineBox[{{-4.8217116543319705`, -1.5870255304684209`}, \
{-4.8217116543319705`, -1.3649581853359891`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.673997009477748, -1.7201331254683612`}, \
{-4.673997009477748, -1.5072343590697368`}}], 
          
          LineBox[{{-4.673997009477748, -1.5072343590697368`}, \
{-4.673997009477748, -1.2943355926711124`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.5248234384963775`, -1.911503421821114}, \
{-4.5248234384963775`, -1.694867955095279}}], 
          
          LineBox[{{-4.5248234384963775`, -1.694867955095279}, \
{-4.5248234384963775`, -1.478232488369444}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.37075571259779, -1.9410342050813103`}, \
{-4.37075571259779, -1.7333780006790314`}}], 
          
          LineBox[{{-4.37075571259779, -1.7333780006790314`}, \
{-4.37075571259779, -1.5257217962767524`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.218821591988268, -2.025125721518314}, \
{-4.218821591988268, -1.8333400247972242`}}], 
          
          LineBox[{{-4.218821591988268, -1.8333400247972242`}, \
{-4.218821591988268, -1.6415543280761344`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.0694770795907385`, -2.0338505814348116`}, \
{-4.0694770795907385`, -1.8415704137385887`}}], 
          
          LineBox[{{-4.0694770795907385`, -1.8415704137385887`}, \
{-4.0694770795907385`, -1.6492902460423657`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.918560524201742, -2.232652532918944}, \
{-3.918560524201742, -2.037689312909757}}], 
          
          LineBox[{{-3.918560524201742, -2.037689312909757}, \
{-3.918560524201742, -1.8427260929005702`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.7690418430970776`, -2.2469329242210914`}, \
{-3.7690418430970776`, -2.050470813269418}}], 
          
          LineBox[{{-3.7690418430970776`, -2.050470813269418}, \
{-3.7690418430970776`, -1.8540087023177443`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.620833185567976, -2.1924751125763615`}, \
{-3.620833185567976, -2.0078450826643963`}}], 
          
          LineBox[{{-3.620833185567976, -2.0078450826643963`}, \
{-3.620833185567976, -1.823215052752431}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.4709577855367924`, -2.327943111848826}, \
{-3.4709577855367924`, -2.1672420250239024`}}], 
          
          LineBox[{{-3.4709577855367924`, -2.1672420250239024`}, \
{-3.4709577855367924`, -2.0065409381989787`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.320602706761705, -2.2819923140511977`}, \
{-3.320602706761705, -2.130575773770181}}], 
          
          LineBox[{{-3.320602706761705, -2.130575773770181}, \
{-3.320602706761705, -1.9791592334891646`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.170051886202171, -2.325960853381056}, \
{-3.170051886202171, -2.178668004677789}}], 
          
          LineBox[{{-3.170051886202171, -2.178668004677789}, \
{-3.170051886202171, -2.031375155974522}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.030477377590662, -2.364963478329096}, \
{-3.030477377590662, -2.215833089497624}}], 
          
          LineBox[{{-3.030477377590662, -2.215833089497624}, \
{-3.030477377590662, -2.066702700666152}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.8877051576271007`, -2.4470810453712706`}, \
{-2.8877051576271007`, -2.0308235141317508`}}], 
          
          LineBox[{{-2.8877051576271007`, -2.0308235141317508`}, \
{-2.8877051576271007`, -1.614565982892231}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.7272330204080557`, -2.765905625269932}, \
{-2.7272330204080557`, -2.2167173422497792`}}], 
          
          LineBox[{{-2.7272330204080557`, -2.2167173422497792`}, \
{-2.7272330204080557`, -1.6675290592296266`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.5654914303840752`, -2.7566653381080948`}, \
{-2.5654914303840752`, -2.242092245770433}}], 
          
          LineBox[{{-2.5654914303840752`, -2.242092245770433}, \
{-2.5654914303840752`, -1.727519153432771}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.4167532824388296`, -2.7966935161724824`}, \
{-2.4167532824388296`, -2.2729773346218276`}}], 
          
          LineBox[{{-2.4167532824388296`, -2.2729773346218276`}, \
{-2.4167532824388296`, -1.7492611530711728`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.273683103959538, -2.7892211361624484`}, \
{-2.273683103959538, -2.320537873341196}}], 
          
          LineBox[{{-2.273683103959538, -2.320537873341196}, \
{-2.273683103959538, -1.8518546105199438`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.1225114762089117`, -2.8236710408799715`}, \
{-2.1225114762089117`, -2.3937844289603167`}}], 
          
          LineBox[{{-2.1225114762089117`, -2.3937844289603167`}, \
{-2.1225114762089117`, -1.9638978170406618`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.9688530566493743`, -2.8229541872537505`}, \
{-1.9688530566493743`, -2.420665764815222}}], 
          
          LineBox[{{-1.9688530566493743`, -2.420665764815222}, \
{-1.9688530566493743`, -2.0183773423766933`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.8165848867407983`, -2.8752021559189758`}, \
{-1.8165848867407983`, -2.490287621993528}}], 
          
          LineBox[{{-1.8165848867407983`, -2.490287621993528}, \
{-1.8165848867407983`, -2.1053730880680805`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.6679573417952833`, -2.943694442125146}, \
{-1.6679573417952833`, -2.573234246260398}}], 
          
          LineBox[{{-1.6679573417952833`, -2.573234246260398}, \
{-1.6679573417952833`, -2.20277405039565}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.5211693704213907`, -3.0180240138702534`}, \
{-1.5211693704213907`, -2.666104615926631}}], 
          
          LineBox[{{-1.5211693704213907`, -2.666104615926631}, \
{-1.5211693704213907`, -2.3141852179830082`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.371988295897768, -3.092946448022707}, \
{-1.371988295897768, -2.7627217465836353`}}], 
          
          LineBox[{{-1.371988295897768, -2.7627217465836353`}, \
{-1.371988295897768, -2.4324970451445638`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.2210917594318125`, -3.1916284426259494`}, \
{-1.2210917594318125`, -2.8740183095344505`}}], 
          
          LineBox[{{-1.2210917594318125`, -2.8740183095344505`}, \
{-1.2210917594318125`, -2.5564081764429516`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.0718189592856806`, -3.3051122988253487`}, \
{-1.0718189592856806`, -2.996429944455006}}], 
          
          LineBox[{{-1.0718189592856806`, -2.996429944455006}, \
{-1.0718189592856806`, -2.6877475900846637`}}]}}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.1252793563099095`, -0.96477943753508}, \
{-5.1252793563099095`, -0.7391686344009561}}], 
          
          LineBox[{{-5.1252793563099095`, -0.7391686344009561}, \
{-5.1252793563099095`, -0.5135578312668323}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.972895007974446, -0.9535993632839864}, \
{-4.972895007974446, -0.7133739101905257}}], 
          
          LineBox[{{-4.972895007974446, -0.7133739101905257}, \
{-4.972895007974446, -0.4731484570970649}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.8217116543319705`, -1.4920352848705054`}, \
{-4.8217116543319705`, -1.2734305782197923`}}], 
          
          LineBox[{{-4.8217116543319705`, -1.2734305782197923`}, \
{-4.8217116543319705`, -1.0548258715690793`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.673830349076903, -1.3157870376537555`}, \
{-4.673830349076903, -1.1270814075746538`}}], 
          
          LineBox[{{-4.673830349076903, -1.1270814075746538`}, \
{-4.673830349076903, -0.9383757774955521}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.521216293266271, -1.6531108264067091`}, \
{-4.521216293266271, -1.3983615441650237`}}], 
          
          LineBox[{{-4.521216293266271, -1.3983615441650237`}, \
{-4.521216293266271, -1.1436122619233382`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.3682219300566025`, -1.7992520141962367`}, \
{-4.3682219300566025`, -1.465059688428702}}], 
          
          LineBox[{{-4.3682219300566025`, -1.465059688428702}, \
{-4.3682219300566025`, -1.1308673626611672`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.223924574573319, -1.9645624717370351`}, \
{-4.223924574573319, -1.6245590795392313`}}], 
          
          LineBox[{{-4.223924574573319, -1.6245590795392313`}, \
{-4.223924574573319, -1.2845556873414274`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.077721657523017, -2.038209780364534}, \
{-4.077721657523017, -1.7147861404360367`}}], 
          
          LineBox[{{-4.077721657523017, -1.7147861404360367`}, \
{-4.077721657523017, -1.3913625005075394`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.92630264206681, -2.1494508829121255`}, \
{-3.92630264206681, -1.8478089031935414`}}], 
          
          LineBox[{{-3.92630264206681, -1.8478089031935414`}, \
{-3.92630264206681, -1.546166923474957}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.774327986151194, -2.245759723513893}, \
{-3.774327986151194, -1.9383472878026295`}}], 
          
          LineBox[{{-3.774327986151194, -1.9383472878026295`}, \
{-3.774327986151194, -1.6309348520913662`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.6208826994945396`, -2.334711992235891}, \
{-3.6208826994945396`, -2.0395686420545247`}}], 
          
          LineBox[{{-3.6208826994945396`, -2.0395686420545247`}, \
{-3.6208826994945396`, -1.7444252918731584`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.4686602504493296`, -2.399748237667733}, \
{-3.4686602504493296`, -2.1091620931464528`}}], 
          
          LineBox[{{-3.4686602504493296`, -2.1091620931464528`}, \
{-3.4686602504493296`, -1.8185759486251727`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.320632854288721, -2.4784768658854617`}, \
{-3.320632854288721, -2.2038471789535055`}}], 
          
          LineBox[{{-3.320632854288721, -2.2038471789535055`}, \
{-3.320632854288721, -1.9292174920215492`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.169887377457001, -2.4564658324092714`}, \
{-3.169887377457001, -2.2050530434335336`}}], 
          
          LineBox[{{-3.169887377457001, -2.2050530434335336`}, \
{-3.169887377457001, -1.953640254457796}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.01721515252269, -2.345074896394708}, \
{-3.01721515252269, -2.120912908334111}}], 
          
          LineBox[{{-3.01721515252269, -2.120912908334111}, \
{-3.01721515252269, -1.8967509202735144`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.869122979428457, -2.3248215745985488`}, \
{-2.869122979428457, -2.125116138908417}}], 
          
          LineBox[{{-2.869122979428457, -2.125116138908417}, \
{-2.869122979428457, -1.9254107032182852`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.7229707239555854`, -2.4101854065991413`}, \
{-2.7229707239555854`, -2.222581347955065}}], 
          
          LineBox[{{-2.7229707239555854`, -2.222581347955065}, \
{-2.7229707239555854`, -2.034977289310989}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.5674984695241374`, -2.4585576605778705`}, \
{-2.5674984695241374`, -2.1167607486550155`}}], 
          
          LineBox[{{-2.5674984695241374`, -2.1167607486550155`}, \
{-2.5674984695241374`, -1.7749638367321607`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.4167532824388296`, -2.730676061111512}, \
{-2.4167532824388296`, -2.215365091833709}}], 
          
          LineBox[{{-2.4167532824388296`, -2.215365091833709}, \
{-2.4167532824388296`, -1.7000541225559056`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.273683103959538, -2.7151373798005185`}, \
{-2.273683103959538, -2.260552152824246}}], 
          
          LineBox[{{-2.273683103959538, -2.260552152824246}, \
{-2.273683103959538, -1.8059669258479734`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.1225114762089117`, -2.7223200485296535`}, \
{-2.1225114762089117`, -2.3072025595882764`}}], 
          
          LineBox[{{-2.1225114762089117`, -2.3072025595882764`}, \
{-2.1225114762089117`, -1.8920850706468992`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.9688530566493743`, -2.710030614808251}, \
{-1.9688530566493743`, -2.3236366231172294`}}], 
          
          LineBox[{{-1.9688530566493743`, -2.3236366231172294`}, \
{-1.9688530566493743`, -1.9372426314262075`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.8165848867407983`, -2.736987228862975}, \
{-1.8165848867407983`, -2.372330782351529}}], 
          
          LineBox[{{-1.8165848867407983`, -2.372330782351529}, \
{-1.8165848867407983`, -2.0076743358400835`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.6679573417952833`, -2.7655887838744464`}, \
{-1.6679573417952833`, -2.420561808974977}}], 
          
          LineBox[{{-1.6679573417952833`, -2.420561808974977}, \
{-1.6679573417952833`, -2.0755348340755075`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.5211693704213907`, -2.7982903951784612`}, \
{-1.5211693704213907`, -2.4733619472453525`}}], 
          
          LineBox[{{-1.5211693704213907`, -2.4733619472453525`}, \
{-1.5211693704213907`, -2.148433499312244}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.371988295897768, -2.848351894935505}, \
{-1.371988295897768, -2.543378251816936}}], 
          
          LineBox[{{-1.371988295897768, -2.543378251816936}, \
{-1.371988295897768, -2.238404608698367}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.2210917594318125`, -2.9077092438776244`}, \
{-1.2210917594318125`, -2.6181369569061665`}}], 
          
          LineBox[{{-1.2210917594318125`, -2.6181369569061665`}, \
{-1.2210917594318125`, -2.3285646699347087`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.0718189592856806`, -2.942973344943205}, \
{-1.0718189592856806`, -2.6680361941378496`}}], 
          
          LineBox[{{-1.0718189592856806`, -2.6680361941378496`}, \
{-1.0718189592856806`, -2.3930990433324943`}}]}}}}, {{{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-5.352012198649872, -1.3535448157877992`}, 
             
             Offset[{3, 
              0}, {-5.352012198649872, -1.3535448157877992`}]}, \
{{-5.352012198649872, -1.3535448157877992`}, 
             
             Offset[{-3, 
              0}, {-5.352012198649872, -1.3535448157877992`}]}, \
{{-5.352012198649872, -2.0093287828709796`}, 
             
             Offset[{3, 
              0}, {-5.352012198649872, -2.0093287828709796`}]}, \
{{-5.352012198649872, -2.0093287828709796`}, 
             
             Offset[{-3, 
              0}, {-5.352012198649872, -2.0093287828709796`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-5.197327949963066, -1.5454980037324935`}, 
             
             Offset[{3, 
              0}, {-5.197327949963066, -1.5454980037324935`}]}, \
{{-5.197327949963066, -1.5454980037324935`}, 
             
             Offset[{-3, 
              0}, {-5.197327949963066, -1.5454980037324935`}]}, \
{{-5.197327949963066, -2.162449290062261}, 
             
             Offset[{3, 
              0}, {-5.197327949963066, -2.162449290062261}]}, \
{{-5.197327949963066, -2.162449290062261}, 
             Offset[{-3, 0}, {-5.197327949963066, -2.162449290062261}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-5.046182498246482, -1.4704252659230823`}, 
             Offset[{3, 
              0}, {-5.046182498246482, -1.4704252659230823`}]}, \
{{-5.046182498246482, -1.4704252659230823`}, 
             
             Offset[{-3, 
              0}, {-5.046182498246482, -1.4704252659230823`}]}, \
{{-5.046182498246482, -2.0517235372113287`}, 
             
             Offset[{3, 
              0}, {-5.046182498246482, -2.0517235372113287`}]}, \
{{-5.046182498246482, -2.0517235372113287`}, 
             
             Offset[{-3, 
              0}, {-5.046182498246482, -2.0517235372113287`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.894444132978499, -1.491335503786983}, 
             
             Offset[{3, 
              0}, {-4.894444132978499, -1.491335503786983}]}, \
{{-4.894444132978499, -1.491335503786983}, 
             
             Offset[{-3, 
              0}, {-4.894444132978499, -1.491335503786983}]}, \
{{-4.894444132978499, -2.0825971397420115`}, 
             
             Offset[{3, 
              0}, {-4.894444132978499, -2.0825971397420115`}]}, \
{{-4.894444132978499, -2.0825971397420115`}, 
             
             Offset[{-3, 
              0}, {-4.894444132978499, -2.0825971397420115`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.745125399370905, -1.6197714191539707`}, 
             
             Offset[{3, 
              0}, {-4.745125399370905, -1.6197714191539707`}]}, \
{{-4.745125399370905, -1.6197714191539707`}, 
             
             Offset[{-3, 
              0}, {-4.745125399370905, -1.6197714191539707`}]}, \
{{-4.745125399370905, -2.1808530865199893`}, 
             
             Offset[{3, 
              0}, {-4.745125399370905, -2.1808530865199893`}]}, \
{{-4.745125399370905, -2.1808530865199893`}, 
             
             Offset[{-3, 
              0}, {-4.745125399370905, -2.1808530865199893`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.596628633102665, -1.7015879268325167`}, 
             
             Offset[{3, 
              0}, {-4.596628633102665, -1.7015879268325167`}]}, \
{{-4.596628633102665, -1.7015879268325167`}, 
             
             Offset[{-3, 
              0}, {-4.596628633102665, -1.7015879268325167`}]}, \
{{-4.596628633102665, -2.2183411497318897`}, 
             
             Offset[{3, 
              0}, {-4.596628633102665, -2.2183411497318897`}]}, \
{{-4.596628633102665, -2.2183411497318897`}, 
             
             Offset[{-3, 
              0}, {-4.596628633102665, -2.2183411497318897`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.447741719114617, -1.7340106648903946`}, 
             
             Offset[{3, 
              0}, {-4.447741719114617, -1.7340106648903946`}]}, \
{{-4.447741719114617, -1.7340106648903946`}, 
             
             Offset[{-3, 
              0}, {-4.447741719114617, -1.7340106648903946`}]}, \
{{-4.447741719114617, -2.2274008505891785`}, 
             
             Offset[{3, 
              0}, {-4.447741719114617, -2.2274008505891785`}]}, \
{{-4.447741719114617, -2.2274008505891785`}, 
             Offset[{-3, 
              0}, {-4.447741719114617, -2.2274008505891785`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.298711959937622, -1.7208910250916887`}, 
             
             Offset[{3, 
              0}, {-4.298711959937622, -1.7208910250916887`}]}, \
{{-4.298711959937622, -1.7208910250916887`}, 
             
             Offset[{-3, 
              0}, {-4.298711959937622, -1.7208910250916887`}]}, \
{{-4.298711959937622, -2.185318714234099}, 
             
             Offset[{3, 
              0}, {-4.298711959937622, -2.185318714234099}]}, \
{{-4.298711959937622, -2.185318714234099}, 
             Offset[{-3, 0}, {-4.298711959937622, -2.185318714234099}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.149632905511913, -1.7838397316273522`}, 
             
             Offset[{3, 
              0}, {-4.149632905511913, -1.7838397316273522`}]}, \
{{-4.149632905511913, -1.7838397316273522`}, 
             
             Offset[{-3, 
              0}, {-4.149632905511913, -1.7838397316273522`}]}, \
{{-4.149632905511913, -2.219952502474402}, 
             
             Offset[{3, 
              0}, {-4.149632905511913, -2.219952502474402}]}, \
{{-4.149632905511913, -2.219952502474402}, 
             Offset[{-3, 0}, {-4.149632905511913, -2.219952502474402}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.001278268975371, -1.8295825605316085`}, 
             
             Offset[{3, 
              0}, {-4.001278268975371, -1.8295825605316085`}]}, \
{{-4.001278268975371, -1.8295825605316085`}, 
             
             Offset[{-3, 
              0}, {-4.001278268975371, -1.8295825605316085`}]}, \
{{-4.001278268975371, -2.2274534134911748`}, 
             
             Offset[{3, 
              0}, {-4.001278268975371, -2.2274534134911748`}]}, \
{{-4.001278268975371, -2.2274534134911748`}, 
             
             Offset[{-3, 
              0}, {-4.001278268975371, -2.2274534134911748`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.8508575458258987`, -2.033825473031311}, 
             
             Offset[{3, 
              0}, {-3.8508575458258987`, -2.033825473031311}]}, \
{{-3.8508575458258987`, -2.033825473031311}, 
             
             Offset[{-3, 
              0}, {-3.8508575458258987`, -2.033825473031311}]}, \
{{-3.8508575458258987`, -2.4175562263623713`}, 
             
             Offset[{3, 
              0}, {-3.8508575458258987`, -2.4175562263623713`}]}, \
{{-3.8508575458258987`, -2.4175562263623713`}, 
             
             Offset[{-3, 
              0}, {-3.8508575458258987`, -2.4175562263623713`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.6998351226863213`, -1.9112141626634382`}, 
             
             Offset[{3, 
              0}, {-3.6998351226863213`, -1.9112141626634382`}]}, \
{{-3.6998351226863213`, -1.9112141626634382`}, 
             
             Offset[{-3, 
              0}, {-3.6998351226863213`, -1.9112141626634382`}]}, \
{{-3.6998351226863213`, -2.2727215623528925`}, 
             
             Offset[{3, 
              0}, {-3.6998351226863213`, -2.2727215623528925`}]}, \
{{-3.6998351226863213`, -2.2727215623528925`}, 
             
             Offset[{-3, 
              0}, {-3.6998351226863213`, -2.2727215623528925`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.550260154845919, -1.9209488810325972`}, 
             
             Offset[{3, 
              0}, {-3.550260154845919, -1.9209488810325972`}]}, \
{{-3.550260154845919, -1.9209488810325972`}, 
             
             Offset[{-3, 
              0}, {-3.550260154845919, -1.9209488810325972`}]}, \
{{-3.550260154845919, -2.2629091764730767`}, 
             
             Offset[{3, 
              0}, {-3.550260154845919, -2.2629091764730767`}]}, \
{{-3.550260154845919, -2.2629091764730767`}, 
             
             Offset[{-3, 
              0}, {-3.550260154845919, -2.2629091764730767`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.3997502222704012`, -2.008779952525799}, 
             
             Offset[{3, 
              0}, {-3.3997502222704012`, -2.008779952525799}]}, \
{{-3.3997502222704012`, -2.008779952525799}, 
             
             Offset[{-3, 
              0}, {-3.3997502222704012`, -2.008779952525799}]}, \
{{-3.3997502222704012`, -2.322751107274743}, 
             
             Offset[{3, 
              0}, {-3.3997502222704012`, -2.322751107274743}]}, \
{{-3.3997502222704012`, -2.322751107274743}, 
             
             Offset[{-3, 
              0}, {-3.3997502222704012`, -2.322751107274743}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.2492191603155653`, -2.0283995590451758`}, 
             
             Offset[{3, 
              0}, {-3.2492191603155653`, -2.0283995590451758`}]}, \
{{-3.2492191603155653`, -2.0283995590451758`}, 
             
             Offset[{-3, 
              0}, {-3.2492191603155653`, -2.0283995590451758`}]}, \
{{-3.2492191603155653`, -2.3145014418751098`}, 
             
             Offset[{3, 
              0}, {-3.2492191603155653`, -2.3145014418751098`}]}, \
{{-3.2492191603155653`, -2.3145014418751098`}, 
             
             Offset[{-3, 
              0}, {-3.2492191603155653`, -2.3145014418751098`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.099363949694378, -2.030182584004613}, 
             
             Offset[{3, 
              0}, {-3.099363949694378, -2.030182584004613}]}, \
{{-3.099363949694378, -2.030182584004613}, 
             
             Offset[{-3, 
              0}, {-3.099363949694378, -2.030182584004613}]}, \
{{-3.099363949694378, -2.294533488635746}, 
             Offset[{3, 
              0}, {-3.099363949694378, -2.294533488635746}]}, \
{{-3.099363949694378, -2.294533488635746}, 
             Offset[{-3, 0}, {-3.099363949694378, -2.294533488635746}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.9723318619592627`, -1.960534783710524}, 
             
             Offset[{3, 
              0}, {-2.9723318619592627`, -1.960534783710524}]}, \
{{-2.9723318619592627`, -1.960534783710524}, 
             
             Offset[{-3, 
              0}, {-2.9723318619592627`, -1.960534783710524}]}, \
{{-2.9723318619592627`, -2.385446257630764}, 
             
             Offset[{3, 
              0}, {-2.9723318619592627`, -2.385446257630764}]}, \
{{-2.9723318619592627`, -2.385446257630764}, 
             
             Offset[{-3, 
              0}, {-2.9723318619592627`, -2.385446257630764}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.8161289018458944`, -1.7372699640552238`}, 
             
             Offset[{3, 
              0}, {-2.8161289018458944`, -1.7372699640552238`}]}, \
{{-2.8161289018458944`, -1.7372699640552238`}, 
             
             Offset[{-3, 
              0}, {-2.8161289018458944`, -1.7372699640552238`}]}, \
{{-2.8161289018458944`, -2.3395589006173303`}, 
             
             Offset[{3, 
              0}, {-2.8161289018458944`, -2.3395589006173303`}]}, \
{{-2.8161289018458944`, -2.3395589006173303`}, 
             
             Offset[{-3, 
              0}, {-2.8161289018458944`, -2.3395589006173303`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.637122953927779, -1.703427733223933}, 
             
             Offset[{3, 
              0}, {-2.637122953927779, -1.703427733223933}]}, \
{{-2.637122953927779, -1.703427733223933}, 
             
             Offset[{-3, 
              0}, {-2.637122953927779, -1.703427733223933}]}, \
{{-2.637122953927779, -2.8276708709846607`}, 
             
             Offset[{3, 
              0}, {-2.637122953927779, -2.8276708709846607`}]}, \
{{-2.637122953927779, -2.8276708709846607`}, 
             
             Offset[{-3, 
              0}, {-2.637122953927779, -2.8276708709846607`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.4883394437723703`, -1.7522961030480024`}, 
             
             Offset[{3, 
              0}, {-2.4883394437723703`, -1.7522961030480024`}]}, \
{{-2.4883394437723703`, -1.7522961030480024`}, 
             
             Offset[{-3, 
              0}, {-2.4883394437723703`, -1.7522961030480024`}]}, \
{{-2.4883394437723703`, -2.8001641582910803`}, 
             
             Offset[{3, 
              0}, {-2.4883394437723703`, -2.8001641582910803`}]}, \
{{-2.4883394437723703`, -2.8001641582910803`}, 
             
             Offset[{-3, 
              0}, {-2.4883394437723703`, -2.8001641582910803`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.3426491274116255`, -1.8748059915260418`}, 
             
             Offset[{3, 
              0}, {-2.3426491274116255`, -1.8748059915260418`}]}, \
{{-2.3426491274116255`, -1.8748059915260418`}, 
             
             Offset[{-3, 
              0}, {-2.3426491274116255`, -1.8748059915260418`}]}, \
{{-2.3426491274116255`, -2.859476806527219}, 
             
             Offset[{3, 
              0}, {-2.3426491274116255`, -2.859476806527219}]}, \
{{-2.3426491274116255`, -2.859476806527219}, 
             
             Offset[{-3, 
              0}, {-2.3426491274116255`, -2.859476806527219}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.1952323671440643`, -1.9468868918936102`}, 
             
             Offset[{3, 
              0}, {-2.1952323671440643`, -1.9468868918936102`}]}, \
{{-2.1952323671440643`, -1.9468868918936102`}, 
             
             Offset[{-3, 
              0}, {-2.1952323671440643`, -1.9468868918936102`}]}, \
{{-2.1952323671440643`, -2.86101296801341}, 
             
             Offset[{3, 
              0}, {-2.1952323671440643`, -2.86101296801341}]}, \
{{-2.1952323671440643`, -2.86101296801341}, 
             
             Offset[{-3, 
              0}, {-2.1952323671440643`, -2.86101296801341}]}}], {{{1., 0.}, {
           0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.048114358050804, -2.032449813478838}, 
             
             Offset[{3, 
              0}, {-2.048114358050804, -2.032449813478838}]}, \
{{-2.048114358050804, -2.032449813478838}, 
             
             Offset[{-3, 
              0}, {-2.048114358050804, -2.032449813478838}]}, \
{{-2.048114358050804, -2.927583790365584}, 
             
             Offset[{3, 
              0}, {-2.048114358050804, -2.927583790365584}]}, \
{{-2.048114358050804, -2.927583790365584}, 
             Offset[{-3, 0}, {-2.048114358050804, -2.927583790365584}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.9047213128625353`, -2.1206228913312266`}, 
             
             Offset[{3, 
              0}, {-1.9047213128625353`, -2.1206228913312266`}]}, \
{{-1.9047213128625353`, -2.1206228913312266`}, 
             
             Offset[{-3, 
              0}, {-1.9047213128625353`, -2.1206228913312266`}]}, \
{{-1.9047213128625353`, -2.9539600369254435`}, 
             
             Offset[{3, 
              0}, {-1.9047213128625353`, -2.9539600369254435`}]}, \
{{-1.9047213128625353`, -2.9539600369254435`}, 
             
             Offset[{-3, 
              0}, {-1.9047213128625353`, -2.9539600369254435`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.7572185227137695`, -2.2477974754282606`}, 
             
             Offset[{3, 
              0}, {-1.7572185227137695`, -2.2477974754282606`}]}, \
{{-1.7572185227137695`, -2.2477974754282606`}, 
             
             Offset[{-3, 
              0}, {-1.7572185227137695`, -2.2477974754282606`}]}, \
{{-1.7572185227137695`, -3.0295367064494565`}, 
             
             Offset[{3, 
              0}, {-1.7572185227137695`, -3.0295367064494565`}]}, \
{{-1.7572185227137695`, -3.0295367064494565`}, 
             
             Offset[{-3, 
              0}, {-1.7572185227137695`, -3.0295367064494565`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.6053998639759, -2.3829232047303193`}, 
             
             Offset[{3, 
              0}, {-1.6053998639759, -2.3829232047303193`}]}, \
{{-1.6053998639759, -2.3829232047303193`}, 
             
             Offset[{-3, 
              0}, {-1.6053998639759, -2.3829232047303193`}]}, \
{{-1.6053998639759, -3.1281301596343156`}, 
             
             Offset[{3, 
              0}, {-1.6053998639759, -3.1281301596343156`}]}, \
{{-1.6053998639759, -3.1281301596343156`}, 
             Offset[{-3, 0}, {-1.6053998639759, -3.1281301596343156`}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.4536487775630647`, -2.529258056304765}, 
             
             Offset[{3, 
              0}, {-1.4536487775630647`, -2.529258056304765}]}, \
{{-1.4536487775630647`, -2.529258056304765}, 
             
             Offset[{-3, 
              0}, {-1.4536487775630647`, -2.529258056304765}]}, \
{{-1.4536487775630647`, -3.2536861916921644`}, 
             
             Offset[{3, 
              0}, {-1.4536487775630647`, -3.2536861916921644`}]}, \
{{-1.4536487775630647`, -3.2536861916921644`}, 
             
             Offset[{-3, 
              0}, {-1.4536487775630647`, -3.2536861916921644`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.3021571254789979`, -2.675722603803459}, 
             
             Offset[{3, 
              0}, {-1.3021571254789979`, -2.675722603803459}]}, \
{{-1.3021571254789979`, -2.675722603803459}, 
             
             Offset[{-3, 
              0}, {-1.3021571254789979`, -2.675722603803459}]}, \
{{-1.3021571254789979`, -3.371752061543436}, 
             
             Offset[{3, 
              0}, {-1.3021571254789979`, -3.371752061543436}]}, \
{{-1.3021571254789979`, -3.371752061543436}, 
             
             Offset[{-3, 
              0}, {-1.3021571254789979`, -3.371752061543436}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.1509597708634107`, -2.8322998766401404`}, 
             
             Offset[{3, 
              0}, {-1.1509597708634107`, -2.8322998766401404`}]}, \
{{-1.1509597708634107`, -2.8322998766401404`}, 
             
             Offset[{-3, 
              0}, {-1.1509597708634107`, -2.8322998766401404`}]}, \
{{-1.1509597708634107`, -3.5161706840968763`}, 
             
             Offset[{3, 
              0}, {-1.1509597708634107`, -3.5161706840968763`}]}, \
{{-1.1509597708634107`, -3.5161706840968763`}, 
             
             Offset[{-3, 
              0}, {-1.1509597708634107`, -3.5161706840968763`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.0007923805337786`, -2.9930139404578187`}, 
             
             Offset[{3, 
              0}, {-1.0007923805337786`, -2.9930139404578187`}]}, \
{{-1.0007923805337786`, -2.9930139404578187`}, 
             
             Offset[{-3, 
              0}, {-1.0007923805337786`, -2.9930139404578187`}]}, \
{{-1.0007923805337786`, -3.653023148518657}, 
             
             Offset[{3, 
              0}, {-1.0007923805337786`, -3.653023148518657}]}, \
{{-1.0007923805337786`, -3.653023148518657}, 
             
             Offset[{-3, 
              0}, {-1.0007923805337786`, -3.653023148518657}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-0.8504177096512346, -3.110181927572958}, 
             
             Offset[{3, 
              0}, {-0.8504177096512346, -3.110181927572958}]}, \
{{-0.8504177096512346, -3.110181927572958}, 
             
             Offset[{-3, 
              0}, {-0.8504177096512346, -3.110181927572958}]}, \
{{-0.8504177096512346, -3.741118323825691}, 
             
             Offset[{3, 
              0}, {-0.8504177096512346, -3.741118323825691}]}, \
{{-0.8504177096512346, -3.741118323825691}, 
             
             Offset[{-3, 
              0}, {-0.8504177096512346, -3.741118323825691}]}}], {{{1., 0.}, {
           0., 1.}}, {0., 0.}}]}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-5.1252793563099095`, -0.9339138776202109}, 
             
             Offset[{3, 
              0}, {-5.1252793563099095`, -0.9339138776202109}]}, \
{{-5.1252793563099095`, -0.9339138776202109}, 
             
             Offset[{-3, 
              0}, {-5.1252793563099095`, -0.9339138776202109}]}, \
{{-5.1252793563099095`, -1.3528451653663944`}, 
             
             Offset[{3, 
              0}, {-5.1252793563099095`, -1.3528451653663944`}]}, \
{{-5.1252793563099095`, -1.3528451653663944`}, 
             
             Offset[{-3, 
              0}, {-5.1252793563099095`, -1.3528451653663944`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.972895007974446, -1.0052769713739929`}, 
             
             Offset[{3, 
              0}, {-4.972895007974446, -1.0052769713739929`}]}, \
{{-4.972895007974446, -1.0052769713739929`}, 
             
             Offset[{-3, 
              0}, {-4.972895007974446, -1.0052769713739929`}]}, \
{{-4.972895007974446, -1.4467978539834505`}, 
             
             Offset[{3, 
              0}, {-4.972895007974446, -1.4467978539834505`}]}, \
{{-4.972895007974446, -1.4467978539834505`}, 
             
             Offset[{-3, 
              0}, {-4.972895007974446, -1.4467978539834505`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.8217116543319705`, -1.3649581853359891`}, 
             
             Offset[{3, 
              0}, {-4.8217116543319705`, -1.3649581853359891`}]}, \
{{-4.8217116543319705`, -1.3649581853359891`}, 
             
             Offset[{-3, 
              0}, {-4.8217116543319705`, -1.3649581853359891`}]}, \
{{-4.8217116543319705`, -1.8090928756008526`}, 
             
             Offset[{3, 
              0}, {-4.8217116543319705`, -1.8090928756008526`}]}, \
{{-4.8217116543319705`, -1.8090928756008526`}, 
             
             Offset[{-3, 
              0}, {-4.8217116543319705`, -1.8090928756008526`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.673997009477748, -1.2943355926711124`}, 
             
             Offset[{3, 
              0}, {-4.673997009477748, -1.2943355926711124`}]}, \
{{-4.673997009477748, -1.2943355926711124`}, 
             
             Offset[{-3, 
              0}, {-4.673997009477748, -1.2943355926711124`}]}, \
{{-4.673997009477748, -1.7201331254683612`}, 
             
             Offset[{3, 
              0}, {-4.673997009477748, -1.7201331254683612`}]}, \
{{-4.673997009477748, -1.7201331254683612`}, 
             
             Offset[{-3, 
              0}, {-4.673997009477748, -1.7201331254683612`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.5248234384963775`, -1.478232488369444}, 
             
             Offset[{3, 
              0}, {-4.5248234384963775`, -1.478232488369444}]}, \
{{-4.5248234384963775`, -1.478232488369444}, 
             
             Offset[{-3, 
              0}, {-4.5248234384963775`, -1.478232488369444}]}, \
{{-4.5248234384963775`, -1.911503421821114}, 
             
             Offset[{3, 
              0}, {-4.5248234384963775`, -1.911503421821114}]}, \
{{-4.5248234384963775`, -1.911503421821114}, 
             
             Offset[{-3, 
              0}, {-4.5248234384963775`, -1.911503421821114}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.37075571259779, -1.5257217962767524`}, 
             
             Offset[{3, 
              0}, {-4.37075571259779, -1.5257217962767524`}]}, \
{{-4.37075571259779, -1.5257217962767524`}, 
             
             Offset[{-3, 
              0}, {-4.37075571259779, -1.5257217962767524`}]}, \
{{-4.37075571259779, -1.9410342050813103`}, 
             
             Offset[{3, 
              0}, {-4.37075571259779, -1.9410342050813103`}]}, \
{{-4.37075571259779, -1.9410342050813103`}, 
             
             Offset[{-3, 
              0}, {-4.37075571259779, -1.9410342050813103`}]}}], {{{1., 0.}, {
           0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.218821591988268, -1.6415543280761344`}, 
             
             Offset[{3, 
              0}, {-4.218821591988268, -1.6415543280761344`}]}, \
{{-4.218821591988268, -1.6415543280761344`}, 
             
             Offset[{-3, 
              0}, {-4.218821591988268, -1.6415543280761344`}]}, \
{{-4.218821591988268, -2.025125721518314}, 
             
             Offset[{3, 
              0}, {-4.218821591988268, -2.025125721518314}]}, \
{{-4.218821591988268, -2.025125721518314}, 
             Offset[{-3, 0}, {-4.218821591988268, -2.025125721518314}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.0694770795907385`, -1.6492902460423657`}, 
             
             Offset[{3, 
              0}, {-4.0694770795907385`, -1.6492902460423657`}]}, \
{{-4.0694770795907385`, -1.6492902460423657`}, 
             
             Offset[{-3, 
              0}, {-4.0694770795907385`, -1.6492902460423657`}]}, \
{{-4.0694770795907385`, -2.0338505814348116`}, 
             
             Offset[{3, 
              0}, {-4.0694770795907385`, -2.0338505814348116`}]}, \
{{-4.0694770795907385`, -2.0338505814348116`}, 
             
             Offset[{-3, 
              0}, {-4.0694770795907385`, -2.0338505814348116`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.918560524201742, -1.8427260929005702`}, 
             
             Offset[{3, 
              0}, {-3.918560524201742, -1.8427260929005702`}]}, \
{{-3.918560524201742, -1.8427260929005702`}, 
             
             Offset[{-3, 
              0}, {-3.918560524201742, -1.8427260929005702`}]}, \
{{-3.918560524201742, -2.232652532918944}, 
             
             Offset[{3, 
              0}, {-3.918560524201742, -2.232652532918944}]}, \
{{-3.918560524201742, -2.232652532918944}, 
             Offset[{-3, 0}, {-3.918560524201742, -2.232652532918944}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.7690418430970776`, -1.8540087023177443`}, 
             
             Offset[{3, 
              0}, {-3.7690418430970776`, -1.8540087023177443`}]}, \
{{-3.7690418430970776`, -1.8540087023177443`}, 
             
             Offset[{-3, 
              0}, {-3.7690418430970776`, -1.8540087023177443`}]}, \
{{-3.7690418430970776`, -2.2469329242210914`}, 
             
             Offset[{3, 
              0}, {-3.7690418430970776`, -2.2469329242210914`}]}, \
{{-3.7690418430970776`, -2.2469329242210914`}, 
             
             Offset[{-3, 
              0}, {-3.7690418430970776`, -2.2469329242210914`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.620833185567976, -1.823215052752431}, 
             
             Offset[{3, 
              0}, {-3.620833185567976, -1.823215052752431}]}, \
{{-3.620833185567976, -1.823215052752431}, 
             
             Offset[{-3, 
              0}, {-3.620833185567976, -1.823215052752431}]}, \
{{-3.620833185567976, -2.1924751125763615`}, 
             
             Offset[{3, 
              0}, {-3.620833185567976, -2.1924751125763615`}]}, \
{{-3.620833185567976, -2.1924751125763615`}, 
             
             Offset[{-3, 
              0}, {-3.620833185567976, -2.1924751125763615`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.4709577855367924`, -2.0065409381989787`}, 
             
             Offset[{3, 
              0}, {-3.4709577855367924`, -2.0065409381989787`}]}, \
{{-3.4709577855367924`, -2.0065409381989787`}, 
             
             Offset[{-3, 
              0}, {-3.4709577855367924`, -2.0065409381989787`}]}, \
{{-3.4709577855367924`, -2.327943111848826}, 
             
             Offset[{3, 
              0}, {-3.4709577855367924`, -2.327943111848826}]}, \
{{-3.4709577855367924`, -2.327943111848826}, 
             
             Offset[{-3, 
              0}, {-3.4709577855367924`, -2.327943111848826}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.320602706761705, -1.9791592334891646`}, 
             
             Offset[{3, 
              0}, {-3.320602706761705, -1.9791592334891646`}]}, \
{{-3.320602706761705, -1.9791592334891646`}, 
             
             Offset[{-3, 
              0}, {-3.320602706761705, -1.9791592334891646`}]}, \
{{-3.320602706761705, -2.2819923140511977`}, 
             
             Offset[{3, 
              0}, {-3.320602706761705, -2.2819923140511977`}]}, \
{{-3.320602706761705, -2.2819923140511977`}, 
             
             Offset[{-3, 
              0}, {-3.320602706761705, -2.2819923140511977`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.170051886202171, -2.031375155974522}, 
             
             Offset[{3, 
              0}, {-3.170051886202171, -2.031375155974522}]}, \
{{-3.170051886202171, -2.031375155974522}, 
             
             Offset[{-3, 
              0}, {-3.170051886202171, -2.031375155974522}]}, \
{{-3.170051886202171, -2.325960853381056}, 
             
             Offset[{3, 
              0}, {-3.170051886202171, -2.325960853381056}]}, \
{{-3.170051886202171, -2.325960853381056}, 
             Offset[{-3, 0}, {-3.170051886202171, -2.325960853381056}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.030477377590662, -2.066702700666152}, 
             
             Offset[{3, 
              0}, {-3.030477377590662, -2.066702700666152}]}, \
{{-3.030477377590662, -2.066702700666152}, 
             
             Offset[{-3, 
              0}, {-3.030477377590662, -2.066702700666152}]}, \
{{-3.030477377590662, -2.364963478329096}, 
             
             Offset[{3, 
              0}, {-3.030477377590662, -2.364963478329096}]}, \
{{-3.030477377590662, -2.364963478329096}, 
             Offset[{-3, 0}, {-3.030477377590662, -2.364963478329096}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.8877051576271007`, -1.614565982892231}, 
             
             Offset[{3, 
              0}, {-2.8877051576271007`, -1.614565982892231}]}, \
{{-2.8877051576271007`, -1.614565982892231}, 
             
             Offset[{-3, 
              0}, {-2.8877051576271007`, -1.614565982892231}]}, \
{{-2.8877051576271007`, -2.4470810453712706`}, 
             
             Offset[{3, 
              0}, {-2.8877051576271007`, -2.4470810453712706`}]}, \
{{-2.8877051576271007`, -2.4470810453712706`}, 
             
             Offset[{-3, 
              0}, {-2.8877051576271007`, -2.4470810453712706`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.7272330204080557`, -1.6675290592296266`}, 
             
             Offset[{3, 
              0}, {-2.7272330204080557`, -1.6675290592296266`}]}, \
{{-2.7272330204080557`, -1.6675290592296266`}, 
             
             Offset[{-3, 
              0}, {-2.7272330204080557`, -1.6675290592296266`}]}, \
{{-2.7272330204080557`, -2.765905625269932}, 
             
             Offset[{3, 
              0}, {-2.7272330204080557`, -2.765905625269932}]}, \
{{-2.7272330204080557`, -2.765905625269932}, 
             
             Offset[{-3, 
              0}, {-2.7272330204080557`, -2.765905625269932}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.5654914303840752`, -1.727519153432771}, 
             
             Offset[{3, 
              0}, {-2.5654914303840752`, -1.727519153432771}]}, \
{{-2.5654914303840752`, -1.727519153432771}, 
             
             Offset[{-3, 
              0}, {-2.5654914303840752`, -1.727519153432771}]}, \
{{-2.5654914303840752`, -2.7566653381080948`}, 
             
             Offset[{3, 
              0}, {-2.5654914303840752`, -2.7566653381080948`}]}, \
{{-2.5654914303840752`, -2.7566653381080948`}, 
             
             Offset[{-3, 
              0}, {-2.5654914303840752`, -2.7566653381080948`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.4167532824388296`, -1.7492611530711728`}, 
             
             Offset[{3, 
              0}, {-2.4167532824388296`, -1.7492611530711728`}]}, \
{{-2.4167532824388296`, -1.7492611530711728`}, 
             
             Offset[{-3, 
              0}, {-2.4167532824388296`, -1.7492611530711728`}]}, \
{{-2.4167532824388296`, -2.7966935161724824`}, 
             
             Offset[{3, 
              0}, {-2.4167532824388296`, -2.7966935161724824`}]}, \
{{-2.4167532824388296`, -2.7966935161724824`}, 
             
             Offset[{-3, 
              0}, {-2.4167532824388296`, -2.7966935161724824`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.273683103959538, -1.8518546105199438`}, 
             
             Offset[{3, 
              0}, {-2.273683103959538, -1.8518546105199438`}]}, \
{{-2.273683103959538, -1.8518546105199438`}, 
             
             Offset[{-3, 
              0}, {-2.273683103959538, -1.8518546105199438`}]}, \
{{-2.273683103959538, -2.7892211361624484`}, 
             
             Offset[{3, 
              0}, {-2.273683103959538, -2.7892211361624484`}]}, \
{{-2.273683103959538, -2.7892211361624484`}, 
             
             Offset[{-3, 
              0}, {-2.273683103959538, -2.7892211361624484`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.1225114762089117`, -1.9638978170406618`}, 
             
             Offset[{3, 
              0}, {-2.1225114762089117`, -1.9638978170406618`}]}, \
{{-2.1225114762089117`, -1.9638978170406618`}, 
             
             Offset[{-3, 
              0}, {-2.1225114762089117`, -1.9638978170406618`}]}, \
{{-2.1225114762089117`, -2.8236710408799715`}, 
             
             Offset[{3, 
              0}, {-2.1225114762089117`, -2.8236710408799715`}]}, \
{{-2.1225114762089117`, -2.8236710408799715`}, 
             
             Offset[{-3, 
              0}, {-2.1225114762089117`, -2.8236710408799715`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.9688530566493743`, -2.0183773423766933`}, 
             
             Offset[{3, 
              0}, {-1.9688530566493743`, -2.0183773423766933`}]}, \
{{-1.9688530566493743`, -2.0183773423766933`}, 
             
             Offset[{-3, 
              0}, {-1.9688530566493743`, -2.0183773423766933`}]}, \
{{-1.9688530566493743`, -2.8229541872537505`}, 
             
             Offset[{3, 
              0}, {-1.9688530566493743`, -2.8229541872537505`}]}, \
{{-1.9688530566493743`, -2.8229541872537505`}, 
             
             Offset[{-3, 
              0}, {-1.9688530566493743`, -2.8229541872537505`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.8165848867407983`, -2.1053730880680805`}, 
             
             Offset[{3, 
              0}, {-1.8165848867407983`, -2.1053730880680805`}]}, \
{{-1.8165848867407983`, -2.1053730880680805`}, 
             
             Offset[{-3, 
              0}, {-1.8165848867407983`, -2.1053730880680805`}]}, \
{{-1.8165848867407983`, -2.8752021559189758`}, 
             
             Offset[{3, 
              0}, {-1.8165848867407983`, -2.8752021559189758`}]}, \
{{-1.8165848867407983`, -2.8752021559189758`}, 
             
             Offset[{-3, 
              0}, {-1.8165848867407983`, -2.8752021559189758`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.6679573417952833`, -2.20277405039565}, 
             
             Offset[{3, 
              0}, {-1.6679573417952833`, -2.20277405039565}]}, \
{{-1.6679573417952833`, -2.20277405039565}, 
             
             Offset[{-3, 
              0}, {-1.6679573417952833`, -2.20277405039565}]}, \
{{-1.6679573417952833`, -2.943694442125146}, 
             
             Offset[{3, 
              0}, {-1.6679573417952833`, -2.943694442125146}]}, \
{{-1.6679573417952833`, -2.943694442125146}, 
             
             Offset[{-3, 
              0}, {-1.6679573417952833`, -2.943694442125146}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.5211693704213907`, -2.3141852179830082`}, 
             Offset[{3, 
              0}, {-1.5211693704213907`, -2.3141852179830082`}]}, \
{{-1.5211693704213907`, -2.3141852179830082`}, 
             
             Offset[{-3, 
              0}, {-1.5211693704213907`, -2.3141852179830082`}]}, \
{{-1.5211693704213907`, -3.0180240138702534`}, 
             
             Offset[{3, 
              0}, {-1.5211693704213907`, -3.0180240138702534`}]}, \
{{-1.5211693704213907`, -3.0180240138702534`}, 
             
             Offset[{-3, 
              0}, {-1.5211693704213907`, -3.0180240138702534`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.371988295897768, -2.4324970451445638`}, 
             
             Offset[{3, 
              0}, {-1.371988295897768, -2.4324970451445638`}]}, \
{{-1.371988295897768, -2.4324970451445638`}, 
             
             Offset[{-3, 
              0}, {-1.371988295897768, -2.4324970451445638`}]}, \
{{-1.371988295897768, -3.092946448022707}, 
             
             Offset[{3, 
              0}, {-1.371988295897768, -3.092946448022707}]}, \
{{-1.371988295897768, -3.092946448022707}, 
             Offset[{-3, 0}, {-1.371988295897768, -3.092946448022707}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.2210917594318125`, -2.5564081764429516`}, 
             
             Offset[{3, 
              0}, {-1.2210917594318125`, -2.5564081764429516`}]}, \
{{-1.2210917594318125`, -2.5564081764429516`}, 
             
             Offset[{-3, 
              0}, {-1.2210917594318125`, -2.5564081764429516`}]}, \
{{-1.2210917594318125`, -3.1916284426259494`}, 
             
             Offset[{3, 
              0}, {-1.2210917594318125`, -3.1916284426259494`}]}, \
{{-1.2210917594318125`, -3.1916284426259494`}, 
             
             Offset[{-3, 
              0}, {-1.2210917594318125`, -3.1916284426259494`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.0718189592856806`, -2.6877475900846637`}, 
             
             Offset[{3, 
              0}, {-1.0718189592856806`, -2.6877475900846637`}]}, \
{{-1.0718189592856806`, -2.6877475900846637`}, 
             
             Offset[{-3, 
              0}, {-1.0718189592856806`, -2.6877475900846637`}]}, \
{{-1.0718189592856806`, -3.3051122988253487`}, 
             
             Offset[{3, 
              0}, {-1.0718189592856806`, -3.3051122988253487`}]}, \
{{-1.0718189592856806`, -3.3051122988253487`}, 
             
             Offset[{-3, 
              0}, {-1.0718189592856806`, -3.3051122988253487`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-5.1252793563099095`, -0.5135578312668323}, 
             
             Offset[{3, 
              0}, {-5.1252793563099095`, -0.5135578312668323}]}, \
{{-5.1252793563099095`, -0.5135578312668323}, 
             
             Offset[{-3, 
              0}, {-5.1252793563099095`, -0.5135578312668323}]}, \
{{-5.1252793563099095`, -0.96477943753508}, 
             
             Offset[{3, 
              0}, {-5.1252793563099095`, -0.96477943753508}]}, \
{{-5.1252793563099095`, -0.96477943753508}, 
             Offset[{-3, 
              0}, {-5.1252793563099095`, -0.96477943753508}]}}], {{{1., 0.}, {
           0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.972895007974446, -0.4731484570970649}, 
             
             Offset[{3, 
              0}, {-4.972895007974446, -0.4731484570970649}]}, \
{{-4.972895007974446, -0.4731484570970649}, 
             
             Offset[{-3, 
              0}, {-4.972895007974446, -0.4731484570970649}]}, \
{{-4.972895007974446, -0.9535993632839864}, 
             
             Offset[{3, 
              0}, {-4.972895007974446, -0.9535993632839864}]}, \
{{-4.972895007974446, -0.9535993632839864}, 
             
             Offset[{-3, 
              0}, {-4.972895007974446, -0.9535993632839864}]}}], {{{1., 0.}, {
           0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.8217116543319705`, -1.0548258715690793`}, 
             
             Offset[{3, 
              0}, {-4.8217116543319705`, -1.0548258715690793`}]}, \
{{-4.8217116543319705`, -1.0548258715690793`}, 
             
             Offset[{-3, 
              0}, {-4.8217116543319705`, -1.0548258715690793`}]}, \
{{-4.8217116543319705`, -1.4920352848705054`}, 
             
             Offset[{3, 
              0}, {-4.8217116543319705`, -1.4920352848705054`}]}, \
{{-4.8217116543319705`, -1.4920352848705054`}, 
             
             Offset[{-3, 
              0}, {-4.8217116543319705`, -1.4920352848705054`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.673830349076903, -0.9383757774955521}, 
             
             Offset[{3, 
              0}, {-4.673830349076903, -0.9383757774955521}]}, \
{{-4.673830349076903, -0.9383757774955521}, 
             
             Offset[{-3, 
              0}, {-4.673830349076903, -0.9383757774955521}]}, \
{{-4.673830349076903, -1.3157870376537555`}, 
             
             Offset[{3, 
              0}, {-4.673830349076903, -1.3157870376537555`}]}, \
{{-4.673830349076903, -1.3157870376537555`}, 
             
             Offset[{-3, 
              0}, {-4.673830349076903, -1.3157870376537555`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.521216293266271, -1.1436122619233382`}, 
             
             Offset[{3, 
              0}, {-4.521216293266271, -1.1436122619233382`}]}, \
{{-4.521216293266271, -1.1436122619233382`}, 
             
             Offset[{-3, 
              0}, {-4.521216293266271, -1.1436122619233382`}]}, \
{{-4.521216293266271, -1.6531108264067091`}, 
             
             Offset[{3, 
              0}, {-4.521216293266271, -1.6531108264067091`}]}, \
{{-4.521216293266271, -1.6531108264067091`}, 
             
             Offset[{-3, 
              0}, {-4.521216293266271, -1.6531108264067091`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.3682219300566025`, -1.1308673626611672`}, 
             
             Offset[{3, 
              0}, {-4.3682219300566025`, -1.1308673626611672`}]}, \
{{-4.3682219300566025`, -1.1308673626611672`}, 
             
             Offset[{-3, 
              0}, {-4.3682219300566025`, -1.1308673626611672`}]}, \
{{-4.3682219300566025`, -1.7992520141962367`}, 
             
             Offset[{3, 
              0}, {-4.3682219300566025`, -1.7992520141962367`}]}, \
{{-4.3682219300566025`, -1.7992520141962367`}, 
             
             Offset[{-3, 
              0}, {-4.3682219300566025`, -1.7992520141962367`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.223924574573319, -1.2845556873414274`}, 
             
             Offset[{3, 
              0}, {-4.223924574573319, -1.2845556873414274`}]}, \
{{-4.223924574573319, -1.2845556873414274`}, 
             
             Offset[{-3, 
              0}, {-4.223924574573319, -1.2845556873414274`}]}, \
{{-4.223924574573319, -1.9645624717370351`}, 
             
             Offset[{3, 
              0}, {-4.223924574573319, -1.9645624717370351`}]}, \
{{-4.223924574573319, -1.9645624717370351`}, 
             
             Offset[{-3, 
              0}, {-4.223924574573319, -1.9645624717370351`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-4.077721657523017, -1.3913625005075394`}, 
             
             Offset[{3, 
              0}, {-4.077721657523017, -1.3913625005075394`}]}, \
{{-4.077721657523017, -1.3913625005075394`}, 
             
             Offset[{-3, 
              0}, {-4.077721657523017, -1.3913625005075394`}]}, \
{{-4.077721657523017, -2.038209780364534}, 
             
             Offset[{3, 
              0}, {-4.077721657523017, -2.038209780364534}]}, \
{{-4.077721657523017, -2.038209780364534}, 
             Offset[{-3, 0}, {-4.077721657523017, -2.038209780364534}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.92630264206681, -1.546166923474957}, 
             
             Offset[{3, 
              0}, {-3.92630264206681, -1.546166923474957}]}, \
{{-3.92630264206681, -1.546166923474957}, 
             
             Offset[{-3, 
              0}, {-3.92630264206681, -1.546166923474957}]}, \
{{-3.92630264206681, -2.1494508829121255`}, 
             
             Offset[{3, 
              0}, {-3.92630264206681, -2.1494508829121255`}]}, \
{{-3.92630264206681, -2.1494508829121255`}, 
             
             Offset[{-3, 
              0}, {-3.92630264206681, -2.1494508829121255`}]}}], {{{1., 0.}, {
           0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.774327986151194, -1.6309348520913662`}, 
             
             Offset[{3, 
              0}, {-3.774327986151194, -1.6309348520913662`}]}, \
{{-3.774327986151194, -1.6309348520913662`}, 
             
             Offset[{-3, 
              0}, {-3.774327986151194, -1.6309348520913662`}]}, \
{{-3.774327986151194, -2.245759723513893}, 
             
             Offset[{3, 
              0}, {-3.774327986151194, -2.245759723513893}]}, \
{{-3.774327986151194, -2.245759723513893}, 
             Offset[{-3, 0}, {-3.774327986151194, -2.245759723513893}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.6208826994945396`, -1.7444252918731584`}, 
             
             Offset[{3, 
              0}, {-3.6208826994945396`, -1.7444252918731584`}]}, \
{{-3.6208826994945396`, -1.7444252918731584`}, 
             
             Offset[{-3, 
              0}, {-3.6208826994945396`, -1.7444252918731584`}]}, \
{{-3.6208826994945396`, -2.334711992235891}, 
             
             Offset[{3, 
              0}, {-3.6208826994945396`, -2.334711992235891}]}, \
{{-3.6208826994945396`, -2.334711992235891}, 
             
             Offset[{-3, 
              0}, {-3.6208826994945396`, -2.334711992235891}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.4686602504493296`, -1.8185759486251727`}, 
             
             Offset[{3, 
              0}, {-3.4686602504493296`, -1.8185759486251727`}]}, \
{{-3.4686602504493296`, -1.8185759486251727`}, 
             
             Offset[{-3, 
              0}, {-3.4686602504493296`, -1.8185759486251727`}]}, \
{{-3.4686602504493296`, -2.399748237667733}, 
             
             Offset[{3, 
              0}, {-3.4686602504493296`, -2.399748237667733}]}, \
{{-3.4686602504493296`, -2.399748237667733}, 
             
             Offset[{-3, 
              0}, {-3.4686602504493296`, -2.399748237667733}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.320632854288721, -1.9292174920215492`}, 
             
             Offset[{3, 
              0}, {-3.320632854288721, -1.9292174920215492`}]}, \
{{-3.320632854288721, -1.9292174920215492`}, 
             
             Offset[{-3, 
              0}, {-3.320632854288721, -1.9292174920215492`}]}, \
{{-3.320632854288721, -2.4784768658854617`}, 
             
             Offset[{3, 
              0}, {-3.320632854288721, -2.4784768658854617`}]}, \
{{-3.320632854288721, -2.4784768658854617`}, 
             
             Offset[{-3, 
              0}, {-3.320632854288721, -2.4784768658854617`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.169887377457001, -1.953640254457796}, 
             
             Offset[{3, 
              0}, {-3.169887377457001, -1.953640254457796}]}, \
{{-3.169887377457001, -1.953640254457796}, 
             
             Offset[{-3, 
              0}, {-3.169887377457001, -1.953640254457796}]}, \
{{-3.169887377457001, -2.4564658324092714`}, 
             
             Offset[{3, 
              0}, {-3.169887377457001, -2.4564658324092714`}]}, \
{{-3.169887377457001, -2.4564658324092714`}, 
             
             Offset[{-3, 
              0}, {-3.169887377457001, -2.4564658324092714`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-3.01721515252269, -1.8967509202735144`}, 
             
             Offset[{3, 
              0}, {-3.01721515252269, -1.8967509202735144`}]}, \
{{-3.01721515252269, -1.8967509202735144`}, 
             
             Offset[{-3, 
              0}, {-3.01721515252269, -1.8967509202735144`}]}, \
{{-3.01721515252269, -2.345074896394708}, 
             
             Offset[{3, 
              0}, {-3.01721515252269, -2.345074896394708}]}, \
{{-3.01721515252269, -2.345074896394708}, 
             Offset[{-3, 0}, {-3.01721515252269, -2.345074896394708}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.869122979428457, -1.9254107032182852`}, 
             
             Offset[{3, 
              0}, {-2.869122979428457, -1.9254107032182852`}]}, \
{{-2.869122979428457, -1.9254107032182852`}, 
             
             Offset[{-3, 
              0}, {-2.869122979428457, -1.9254107032182852`}]}, \
{{-2.869122979428457, -2.3248215745985488`}, 
             
             Offset[{3, 
              0}, {-2.869122979428457, -2.3248215745985488`}]}, \
{{-2.869122979428457, -2.3248215745985488`}, 
             
             Offset[{-3, 
              0}, {-2.869122979428457, -2.3248215745985488`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.7229707239555854`, -2.034977289310989}, 
             
             Offset[{3, 
              0}, {-2.7229707239555854`, -2.034977289310989}]}, \
{{-2.7229707239555854`, -2.034977289310989}, 
             
             Offset[{-3, 
              0}, {-2.7229707239555854`, -2.034977289310989}]}, \
{{-2.7229707239555854`, -2.4101854065991413`}, 
             
             Offset[{3, 
              0}, {-2.7229707239555854`, -2.4101854065991413`}]}, \
{{-2.7229707239555854`, -2.4101854065991413`}, 
             
             Offset[{-3, 
              0}, {-2.7229707239555854`, -2.4101854065991413`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.5674984695241374`, -1.7749638367321607`}, 
             
             Offset[{3, 
              0}, {-2.5674984695241374`, -1.7749638367321607`}]}, \
{{-2.5674984695241374`, -1.7749638367321607`}, 
             
             Offset[{-3, 
              0}, {-2.5674984695241374`, -1.7749638367321607`}]}, \
{{-2.5674984695241374`, -2.4585576605778705`}, 
             
             Offset[{3, 
              0}, {-2.5674984695241374`, -2.4585576605778705`}]}, \
{{-2.5674984695241374`, -2.4585576605778705`}, 
             
             Offset[{-3, 
              0}, {-2.5674984695241374`, -2.4585576605778705`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.4167532824388296`, -1.7000541225559056`}, 
             
             Offset[{3, 
              0}, {-2.4167532824388296`, -1.7000541225559056`}]}, \
{{-2.4167532824388296`, -1.7000541225559056`}, 
             
             Offset[{-3, 
              0}, {-2.4167532824388296`, -1.7000541225559056`}]}, \
{{-2.4167532824388296`, -2.730676061111512}, 
             
             Offset[{3, 
              0}, {-2.4167532824388296`, -2.730676061111512}]}, \
{{-2.4167532824388296`, -2.730676061111512}, 
             
             Offset[{-3, 
              0}, {-2.4167532824388296`, -2.730676061111512}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.273683103959538, -1.8059669258479734`}, 
             
             Offset[{3, 
              0}, {-2.273683103959538, -1.8059669258479734`}]}, \
{{-2.273683103959538, -1.8059669258479734`}, 
             
             Offset[{-3, 
              0}, {-2.273683103959538, -1.8059669258479734`}]}, \
{{-2.273683103959538, -2.7151373798005185`}, 
             
             Offset[{3, 
              0}, {-2.273683103959538, -2.7151373798005185`}]}, \
{{-2.273683103959538, -2.7151373798005185`}, 
             
             Offset[{-3, 
              0}, {-2.273683103959538, -2.7151373798005185`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-2.1225114762089117`, -1.8920850706468992`}, 
             
             Offset[{3, 
              0}, {-2.1225114762089117`, -1.8920850706468992`}]}, \
{{-2.1225114762089117`, -1.8920850706468992`}, 
             
             Offset[{-3, 
              0}, {-2.1225114762089117`, -1.8920850706468992`}]}, \
{{-2.1225114762089117`, -2.7223200485296535`}, 
             
             Offset[{3, 
              0}, {-2.1225114762089117`, -2.7223200485296535`}]}, \
{{-2.1225114762089117`, -2.7223200485296535`}, 
             
             Offset[{-3, 
              0}, {-2.1225114762089117`, -2.7223200485296535`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.9688530566493743`, -1.9372426314262075`}, 
             
             Offset[{3, 
              0}, {-1.9688530566493743`, -1.9372426314262075`}]}, \
{{-1.9688530566493743`, -1.9372426314262075`}, 
             
             Offset[{-3, 
              0}, {-1.9688530566493743`, -1.9372426314262075`}]}, \
{{-1.9688530566493743`, -2.710030614808251}, 
             
             Offset[{3, 
              0}, {-1.9688530566493743`, -2.710030614808251}]}, \
{{-1.9688530566493743`, -2.710030614808251}, 
             
             Offset[{-3, 
              0}, {-1.9688530566493743`, -2.710030614808251}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.8165848867407983`, -2.0076743358400835`}, 
             
             Offset[{3, 
              0}, {-1.8165848867407983`, -2.0076743358400835`}]}, \
{{-1.8165848867407983`, -2.0076743358400835`}, 
             
             Offset[{-3, 
              0}, {-1.8165848867407983`, -2.0076743358400835`}]}, \
{{-1.8165848867407983`, -2.736987228862975}, 
             
             Offset[{3, 
              0}, {-1.8165848867407983`, -2.736987228862975}]}, \
{{-1.8165848867407983`, -2.736987228862975}, 
             
             Offset[{-3, 
              0}, {-1.8165848867407983`, -2.736987228862975}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.6679573417952833`, -2.0755348340755075`}, 
             
             Offset[{3, 
              0}, {-1.6679573417952833`, -2.0755348340755075`}]}, \
{{-1.6679573417952833`, -2.0755348340755075`}, 
             
             Offset[{-3, 
              0}, {-1.6679573417952833`, -2.0755348340755075`}]}, \
{{-1.6679573417952833`, -2.7655887838744464`}, 
             
             Offset[{3, 
              0}, {-1.6679573417952833`, -2.7655887838744464`}]}, \
{{-1.6679573417952833`, -2.7655887838744464`}, 
             
             Offset[{-3, 
              0}, {-1.6679573417952833`, -2.7655887838744464`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.5211693704213907`, -2.148433499312244}, 
             
             Offset[{3, 
              0}, {-1.5211693704213907`, -2.148433499312244}]}, \
{{-1.5211693704213907`, -2.148433499312244}, 
             
             Offset[{-3, 
              0}, {-1.5211693704213907`, -2.148433499312244}]}, \
{{-1.5211693704213907`, -2.7982903951784612`}, 
             
             Offset[{3, 
              0}, {-1.5211693704213907`, -2.7982903951784612`}]}, \
{{-1.5211693704213907`, -2.7982903951784612`}, 
             
             Offset[{-3, 
              0}, {-1.5211693704213907`, -2.7982903951784612`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.371988295897768, -2.238404608698367}, 
             
             Offset[{3, 
              0}, {-1.371988295897768, -2.238404608698367}]}, \
{{-1.371988295897768, -2.238404608698367}, 
             
             Offset[{-3, 
              0}, {-1.371988295897768, -2.238404608698367}]}, \
{{-1.371988295897768, -2.848351894935505}, 
             
             Offset[{3, 
              0}, {-1.371988295897768, -2.848351894935505}]}, \
{{-1.371988295897768, -2.848351894935505}, 
             Offset[{-3, 0}, {-1.371988295897768, -2.848351894935505}]}}], {{{
           1., 0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.2210917594318125`, -2.3285646699347087`}, 
             
             Offset[{3, 
              0}, {-1.2210917594318125`, -2.3285646699347087`}]}, \
{{-1.2210917594318125`, -2.3285646699347087`}, 
             
             Offset[{-3, 
              0}, {-1.2210917594318125`, -2.3285646699347087`}]}, \
{{-1.2210917594318125`, -2.9077092438776244`}, 
             
             Offset[{3, 
              0}, {-1.2210917594318125`, -2.9077092438776244`}]}, \
{{-1.2210917594318125`, -2.9077092438776244`}, 
             
             Offset[{-3, 
              0}, {-1.2210917594318125`, -2.9077092438776244`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}, {Antialiasing -> False, 
         Directive[
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.01], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{-1.0718189592856806`, -2.3930990433324943`}, 
             
             Offset[{3, 
              0}, {-1.0718189592856806`, -2.3930990433324943`}]}, \
{{-1.0718189592856806`, -2.3930990433324943`}, 
             
             Offset[{-3, 
              0}, {-1.0718189592856806`, -2.3930990433324943`}]}, \
{{-1.0718189592856806`, -2.942973344943205}, 
             
             Offset[{3, 
              0}, {-1.0718189592856806`, -2.942973344943205}]}, \
{{-1.0718189592856806`, -2.942973344943205}, 
             
             Offset[{-3, 
              0}, {-1.0718189592856806`, -2.942973344943205}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]}}}}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.02], 
         Thickness[0.005]], 
        LineBox[CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAAHvrD4nVoFcD9kfZFKuf6v162jlYQ
yhTAEx9RReCp/b8Cd/52Si8UwNrcCFpcLfy/iPesKemTE8DIgnD/aZf8vy/e
FicC+xLAc/ch0q1n/r/tIcyd8mISwG3ek8YDXP+/wJsiznzKEcBK3EeF+LD/
v7JsS4zhMRHAfsRN5Oo//78GUU5eOZkQwILIhRziAwDAYsctF08BEMBSfmyj
ZzoAwDYEp2aOzg7AlKITATfOAcA7PSQoQ5kNwHULjqVZvADASNfKy+5mDMAw
X2BJRbwAwMbCmT6wMgvAY87N4HxTAcBIvHidZv4JwIjfonAhXwHAv7WSU3/L
CMBT58FegkwBwGLKX+1VxwfALmOm2khiAcDz/PWWbocGwDWh1DmsTgDAsDRV
69MYBcDPGwBQ2B8CwBXLooIe6APA9SmLJLg1AsAP42HTvr0CwNSdbtTn7wLA
DgnA/NWPAcB7+dIZSjsDwLJe0seJYgDAj0qODBPXA8AE0isOvXn+vyvPlndf
TATAerJvK5Ed/L8t6eR9/RsFwCx4jMS3r/m/2NO5klELBsBTD3g4JUL3v9fz
DiO8IQfAe/jCtaLV9L++NtwynTAIwIjr7cpUavK/5O93d9VkCcA1qAffPgPw
v8agJL+KlQrAVoVcM58267/JVctAu2cLwKmG/io=
         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
         PointSize[0.01], 
         Thickness[0.005]], 
        LineBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAAJ9xIO0mAFMCGrTtTSEvyv4PExpY+
5BPAggryZ9md8784ZKjHbkkTwHR29OF0ZPm/JDylRSyyEsDrynnGoR34v5kQ
wlBrGRLADcNi3C0e+7+WprFip3sRwF1bCJLqu/u/Ov50xBLgEMADO49ZXFX9
v76n4v8kRxDAZp3EiRJ3/b+qvpZCNlkPwFTZ8g0wTQDAL9zqaP8mDsBKKOM9
XWcAwKNJomN39wzA8dIrFREQAMC2avWDhcQLwK/0n/yCVgHAomfkJpiQCsBN
8a9PawsBwDrkzilEXAnAIHanfeltAcBsKGDsaj4IwKVL5rIGugHAy/1jKQUa
B8A5JglmID8AwIzKuYtf0QXAv4JLTda7AcDJV/1eIIYEwPiXMQ/O7wHAeJq0
voJVA8D//6W9Di8CwLjKZ8SAMALA4wkZKXaQAsCcnf1L5/oAwAF4YHN4JgPA
6AQPEGyA/7/3bDMDhl0DwH5ab1C7EP2/OsSw6hvsA8AxJKIJ9K/6v8AVJdb7
lQTAQzCasbVW+L/H9CioLlQFwM4C1v+p8/W/nTLs2w0aBsC2y0KDl4nzvwNy
vE/9/QbACNYVoysm8b/Jg0FDsPgHwJpU4k8=
         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
         PointSize[0.01], 
         Thickness[0.005]], 
        LineBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAAJ9xIO0mAFMARZd/6RKfnv4PExpY+
5BPAetDChfXT5r84ZKjHbkkTwNTi8r34X/S/qllBlQCyEsCRZ5eDhgjyv0ji
Vrm5FRLA8MPCWrBf9r9sDW0rD3kRwN3Th23icPe/okDSe0zlEMBep1CpMf75
v1MCJUSWTxDA0uiMl8Nv+7+0AA9cEWkPwA6VhxGgkP2/5CwH39IxDsAGcRZy
eAP/v5bZR1mR9wzADZI8XQlRAMCa6wTy0L8LwCI3IGCQ3wDAp4s59aeQCsC3
5TeheqEBwL5y0entWwnAOPCb2fKjAcAUpaiyQSMIwI2s1y+h9wDAR8emv/bz
BsDvgebjPAABwGTW+t+kyAXAM1XRutjHAcD8FjmjPIoEwCpwZ0Ig7wDAeJq0
voJVA8CsAVFVEbkBwLjKZ8SAMALAn0L6XZwVAsCcnf1L5/oAwOBulZ0mdQLA
6AQPEGyA/79snEDMzpYCwH5ab1C7EP2/iPOrj4j6AsAxJKIJ9K/6v/jze4JP
XQPAQzCasbVW+L+jtxT9cckDwM4C1v+p8/W/iEpnstZYBMC2y0KDl4nzvzjj
8snx8QTACNYVoysm8b9U7jJcI1gFwKGU7og=
         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {-6.907755278982122, 0}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"n\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
          HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameTicks -> {{Automatic, Automatic}, {{{
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.907755278982137, 0.}, {-6., 0.}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{0, 0}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"C20\"", "\"C21\"", "\"C22\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608], 
                    PointSize[0.5], 
                    Thickness[0.09]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6470588235294118, 0.5686274509803921, 
                    0.611764705882353], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6470588235294118, 0.5686274509803921, 
                    0.611764705882353], 
                    PointSize[0.5], 
                    Thickness[0.09]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6470588235294118, 0.5686274509803921, 
                    0.611764705882353]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.902217220996213*^9, {3.902217492107437*^9, 3.9022175133591595`*^9}, 
   3.9022177145073056`*^9, 3.9022178456890564`*^9, {3.902218004462067*^9, 
   3.902218039095897*^9}, 3.9022180801172466`*^9, 3.902218183630154*^9, 
   3.9022182179687195`*^9, 3.902218267061261*^9, 3.902218299722651*^9, 
   3.90222033900448*^9, 3.9022220423314676`*^9, 3.902378538939608*^9, 
   3.9023824867786922`*^9, {3.9035807464138355`*^9, 3.9035807631379757`*^9}, 
   3.904795167218701*^9, 3.9047952017819695`*^9, 3.904795546459771*^9, 
   3.904795599048907*^9, 3.905926114100419*^9, 3.9156985270599546`*^9, 
   3.91794429993673*^9, 3.917945240423125*^9, 3.918720616496622*^9, 
   3.9187206741702046`*^9, 3.918720718493164*^9, 3.91872169588393*^9, 
   3.9187270286174927`*^9},
 CellLabel->
  "Out[1278]=",ExpressionUUID->"05dffc6b-051b-4e20-8bbe-fdff9e0417f4"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\LH-ESRF-C14-16 & C20-22 \
plot\\\\SlopesC20-22.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.902217220996213*^9, {3.902217492107437*^9, 3.9022175133591595`*^9}, 
   3.9022177145073056`*^9, 3.9022178456890564`*^9, {3.902218004462067*^9, 
   3.902218039095897*^9}, 3.9022180801172466`*^9, 3.902218183630154*^9, 
   3.9022182179687195`*^9, 3.902218267061261*^9, 3.902218299722651*^9, 
   3.90222033900448*^9, 3.9022220423314676`*^9, 3.902378538939608*^9, 
   3.9023824867786922`*^9, {3.9035807464138355`*^9, 3.9035807631379757`*^9}, 
   3.904795167218701*^9, 3.9047952017819695`*^9, 3.904795546459771*^9, 
   3.904795599048907*^9, 3.905926114100419*^9, 3.9156985270599546`*^9, 
   3.91794429993673*^9, 3.917945240423125*^9, 3.918720616496622*^9, 
   3.9187206741702046`*^9, 3.918720718493164*^9, 3.91872169588393*^9, 
   3.918727029881866*^9},
 CellLabel->
  "Out[1279]=",ExpressionUUID->"eb8b4e76-4266-4f8c-9c08-75e672b142c1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{"datamergedbinned", "\[IndentingNewLine]", "slopes"}], "Input",
 CellChangeTimes->{{3.9022175431613054`*^9, 3.9022175645953445`*^9}},
 CellLabel->
  "In[219]:=",ExpressionUUID->"4a97ea6b-d69e-429c-bd7d-48eda4881d0a"],

Cell[BoxData["datamergedbinned"], "Output",
 CellChangeTimes->{{3.9022175471048417`*^9, 3.902217565141075*^9}, 
   3.903580773342307*^9, 3.917945252130316*^9},
 CellLabel->
  "Out[219]=",ExpressionUUID->"1ddc6be6-c01e-4ef6-8cd8-9c90bd50d9b5"],

Cell[BoxData["slopes"], "Output",
 CellChangeTimes->{{3.9022175471048417`*^9, 3.902217565141075*^9}, 
   3.903580773342307*^9, 3.9179452521440015`*^9},
 CellLabel->
  "Out[220]=",ExpressionUUID->"8ed6f8fa-9c95-4988-b857-ee0beec06be8"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellLabel->
  "In[221]:=",ExpressionUUID->"fc1ebc98-ef4f-4738-a070-36d8553dc98a"],

Cell[TextData[StyleBox["Plot slope fit", "Subsection"]], "Text",
 CellChangeTimes->{{3.90221326727293*^9, 3.902213268872779*^9}, {
  3.9022132993769493`*^9, 3.9022133123279767`*^9}, {3.90221837905232*^9, 
  3.9022183810135107`*^9}},ExpressionUUID->"1a55261a-6883-4734-9f89-\
3ea1d5ad02d6"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"FileNameJoin", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
     "\"\<PlateletsSlopeFitC14.pdf\>\""}], "}"}], "]"}], "*)"}]], "Input",
 CellChangeTimes->{{3.9023825711530323`*^9, 3.9023825774062014`*^9}},
 CellLabel->
  "In[222]:=",ExpressionUUID->"b1335785-6eb1-4fa2-b4a3-e677d4e7313c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"ColorData", "[", 
    RowBox[{"\"\<SunsetColors\>\"", ",", "\"\<Image\>\""}], "]"}], "*)"}], 
  " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Visualize", " ", "a", " ", "color", " ", "scheme"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Save", " ", "slopefits"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"slopeFitC14", " ", "=", " ", 
     RowBox[{"slope", "[", 
      RowBox[{"calculateIntensitiesLR", "[", 
       RowBox[{
       "1.947", ",", " ", "0.771", ",", " ", "5.513", ",", " ", "0.619"}], 
       "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"slopeFitC15", " ", "=", " ", 
     RowBox[{"slope", "[", 
      RowBox[{"calculateIntensitiesLR", "[", 
       RowBox[{
       "1.559", ",", " ", "0.852", ",", " ", "5.363", ",", " ", "0.550"}], 
       "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"slopeFitC16", " ", "=", " ", 
     RowBox[{"slope", "[", 
      RowBox[{"calculateIntensitiesLR", "[", 
       RowBox[{
       "1.193", ",", " ", "0.975", ",", " ", "4.931", ",", " ", "0.701"}], 
       "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"slopeFitC20", " ", "=", " ", 
     RowBox[{"slope", "[", 
      RowBox[{"calculateIntensitiesLR", "[", 
       RowBox[{
       "1.893", ",", " ", "0.769", ",", " ", "5.654", ",", " ", "0.782"}], 
       "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"slopeFitC21", " ", "=", " ", 
     RowBox[{"slope", "[", 
      RowBox[{"calculateIntensitiesLR", "[", 
       RowBox[{
       "1.542", ",", " ", "0.908", ",", " ", "5.00", ",", " ", "0.603"}], 
       "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"slopeFitC22", " ", "=", " ", 
     RowBox[{"slope", "[", 
      RowBox[{"calculateIntensitiesLR", "[", 
       RowBox[{
       "0.686", ",", " ", "1.209", ",", " ", "4.715", ",", " ", "0.536"}], 
       "]"}], "]"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"slopeFitC14", " ", "=", " ", 
     RowBox[{"slope", "[", 
      RowBox[{"calculateIntensitiesLR", "[", 
       RowBox[{
       "1.352", ",", " ", "0.771", ",", " ", "5.131", ",", " ", "0.619"}], 
       "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopeFitC15", " ", "=", " ", 
     RowBox[{"slope", "[", 
      RowBox[{"calculateIntensitiesLR", "[", 
       RowBox[{
       "0.833", ",", " ", "0.852", ",", " ", "5.061", ",", " ", "0.550"}], 
       "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopeFitC16", " ", "=", " ", 
     RowBox[{"slope", "[", 
      RowBox[{"calculateIntensitiesLR", "[", 
       RowBox[{
       "0.242", ",", " ", "0.975", ",", " ", "4.439", ",", " ", "0.701"}], 
       "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopeFitC20", " ", "=", " ", 
     RowBox[{"slope", "[", 
      RowBox[{"calculateIntensitiesLR", "[", 
       RowBox[{
       "1.322", ",", " ", "0.762", ",", " ", "5.045", ",", " ", "0.781"}], 
       "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopeFitC21", " ", "=", " ", 
     RowBox[{"slope", "[", 
      RowBox[{"calculateIntensitiesLR", "[", 
       RowBox[{
       "0.717", ",", " ", "0.908", ",", " ", "4.640", ",", " ", "0.603"}], 
       "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopeFitC22", " ", "=", " ", 
     RowBox[{"slope", "[", 
      RowBox[{"calculateIntensitiesLR", "[", 
       RowBox[{
        RowBox[{"1.014", " ", 
         SuperscriptBox["10", 
          RowBox[{"-", "9"}]]}], ",", " ", "1.018", ",", " ", "4.469", ",", 
        " ", "0.524"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"C14", " ", "only"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"plotPlateletsFit", " ", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"slopesC14", ",", "\[IndentingNewLine]", "slopeFitC14"}], " ", 
       "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", "1"}], "}"}], ",", 
         "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\\\"n\\\",FontSlant->\\\"Italic\\\"]\)\>\"", 
           ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{"\"\<Data C14\>\"", ",", " ", "\"\<Fit C14\>\""}], "}"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], 
        "\[IndentingNewLine]", "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "->", 
       RowBox[{"{", 
        RowBox[{"False", ",", "True"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotMarkers", "->", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "None"}], "}"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsSlopeFitC14.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotPlateletsFit", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"C14", " ", "+", " ", "C15"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"plotPlateletsFit", " ", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
       "slopesC14", ",", "\[IndentingNewLine]", "slopesC15", ",", 
        "\[IndentingNewLine]", "slopeFitC14", " ", ",", "\[IndentingNewLine]",
         "slopeFitC15"}], "\[IndentingNewLine]", "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", "1"}], "}"}], ",", 
         "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\\\"n\\\",FontSlant->\\\"Italic\\\"]\)\>\"", 
           ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Data C14\>\"", ",", " ", "\"\<Data C15\>\"", ",", " ", 
         "\"\<Fit C14\>\"", ",", " ", "\"\<Fit C15\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], 
        "\[IndentingNewLine]", "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "->", 
       RowBox[{"{", 
        RowBox[{"False", ",", "False", ",", " ", "True", ",", " ", "True"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotMarkers", "->", 
       RowBox[{"{", 
        RowBox[{
        "Automatic", ",", " ", "Automatic", ",", " ", "None", ",", " ", 
         "None"}], "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsSlopeFitC14-C15.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotPlateletsFit", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"C14", "-", 
     RowBox[{"C16", " ", "without", " ", "errors"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotPlateletsFitNEa", " ", "=", " ", 
     RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
        "slopesC14NE", ",", "\[IndentingNewLine]", "slopesC15NE", ",", 
         "\[IndentingNewLine]", "slopesC16NE"}], "\[IndentingNewLine]", "}"}],
        ",", "\[IndentingNewLine]", 
       RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"1", " ", 
             RowBox[{"10", "^", 
              RowBox[{"-", "3"}]}]}], ",", " ", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "4.4"}], ",", " ", "0"}], "}"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
       RowBox[{"FrameTicks", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
            RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"FrameLabel", " ", "->", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "\"\<\!\(\*StyleBox[\"n\",FontSlant->\"Italic\"]\)\>\"", ",", " ", 
            "None"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
           "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"LabelStyle", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotLegends", "->", 
        RowBox[{"{", 
         RowBox[{
         "\"\<Data C14\>\"", ",", " ", "\"\<Data C15\>\"", ",", " ", 
          "\"\<Data C16\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", "->", " ", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
            RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
            RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
            RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
            RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"ColorData", "[", "9", "]"}], "[", "9", "]"}], ",", 
            RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
            RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], 
         "\[IndentingNewLine]", "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"Joined", "->", 
        RowBox[{"{", 
         RowBox[{"False", ",", "False", ",", "False"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PlotMarkers", "->", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "Automatic", ",", " ", "Automatic"}], 
         "}"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotPlateletsFitNEb", " ", "=", " ", 
     RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
        "slopeFitC14", ",", "\[IndentingNewLine]", "slopeFitC15", ",", 
         "\[IndentingNewLine]", "slopeFitC16"}], "\[IndentingNewLine]", "}"}],
        ",", "\[IndentingNewLine]", 
       RowBox[{"PlotLegends", "->", 
        RowBox[{"{", 
         RowBox[{
         "\"\<Fit C14\>\"", ",", " ", "\"\<Fit C15\>\"", ",", " ", 
          "\"\<Fit C16\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"LabelStyle", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", "->", " ", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Black", ",", 
            RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"Black", ",", 
            RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"Black", ",", 
            RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], 
         "\[IndentingNewLine]", "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"Joined", "->", 
        RowBox[{"{", 
         RowBox[{"True", ",", " ", "True", ",", "True"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PlotMarkers", "->", 
        RowBox[{"{", 
         RowBox[{"None", ",", " ", "None", ",", " ", "None"}], "}"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"plotPlateletsFitNE", " ", "=", " ", 
    RowBox[{"Show", "[", 
     RowBox[{"plotPlateletsFitNEa", ",", " ", "plotPlateletsFitNEb"}], 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsSlopeFitC14-C16_no_error.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotPlateletsFitNE", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"C20", " ", "only"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"plotPlateletsFit", " ", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"slopesC20", ",", "\[IndentingNewLine]", "slopeFitC20"}], 
       "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", "1"}], "}"}], ",", 
         "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\\\"n\\\",FontSlant->\\\"Italic\\\"]\)\>\"", 
           ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{"\"\<Data C20\>\"", ",", " ", "\"\<Fit C20\>\""}], "}"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], 
        "\[IndentingNewLine]", "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "->", 
       RowBox[{"{", 
        RowBox[{"False", ",", "True"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotMarkers", "->", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "None"}], "}"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsSlopeFitC20.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotPlateletsFit", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"C20", " ", "+", " ", "C21"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"plotPlateletsFit", " ", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
       "slopesC20", ",", "\[IndentingNewLine]", "slopesC21", ",", 
        "\[IndentingNewLine]", "slopeFitC20", ",", "\[IndentingNewLine]", 
        "slopeFitC21"}], "\[IndentingNewLine]", "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", "1"}], "}"}], ",", 
         "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\\\"n\\\",FontSlant->\\\"Italic\\\"]\)\>\"", 
           ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Data C20\>\"", ",", " ", "\"\<Data C21\>\"", ",", " ", 
         "\"\<Fit C20\>\"", ",", " ", "\"\<Fit C21\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], 
        "\[IndentingNewLine]", "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "->", 
       RowBox[{"{", 
        RowBox[{"False", ",", "False", ",", " ", "True", ",", " ", "True"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotMarkers", "->", 
       RowBox[{"{", 
        RowBox[{
        "Automatic", ",", " ", "Automatic", ",", " ", "None", ",", " ", 
         "None"}], "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsSlopeFitC20-C21.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotPlateletsFit", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"C20", "-", "C22"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"plotPlateletsFit", " ", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
       "slopesC20", ",", "\[IndentingNewLine]", "slopesC21", ",", 
        "\[IndentingNewLine]", "slopesC22", ",", "\[IndentingNewLine]", 
        "slopeFitC20", ",", "\[IndentingNewLine]", "slopeFitC21", ",", 
        "\[IndentingNewLine]", "slopeFitC22"}], "\[IndentingNewLine]", "}"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", "1"}], "}"}], ",", 
         "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\\\"n\\\",FontSlant->\\\"Italic\\\"]\)\>\"", 
           ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Data C20\>\"", ",", " ", "\"\<Data C21\>\"", ",", " ", 
         "\"\<Data C22\>\"", ",", " ", "\"\<Fit C20\>\"", ",", " ", 
         "\"\<Fit C21\>\"", ",", " ", "\"\<Fit C22\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "9", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], 
        "\[IndentingNewLine]", "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "->", 
       RowBox[{"{", 
        RowBox[{
        "False", ",", "False", ",", "False", ",", " ", "True", ",", " ", 
         "True", ",", "True"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotMarkers", "->", 
       RowBox[{"{", 
        RowBox[{
        "Automatic", ",", "Automatic", ",", " ", "Automatic", ",", " ", 
         "None", ",", " ", "None", ",", " ", "None"}], "}"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsSlopeFitC20-C22.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotPlateletsFit", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"(*", " ", 
     RowBox[{"C20", "-", 
      RowBox[{"C22", " ", "without", " ", "errors"}]}], " ", "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"plotPlateletsFitNE", " ", "=", " ", 
     RowBox[{
      RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
         "slopesC20NE", ",", "\[IndentingNewLine]", "slopesC21NE", ",", 
          "\[IndentingNewLine]", "slopesC22NE", ",", "\[IndentingNewLine]", 
          "slopeFitC20", ",", "\[IndentingNewLine]", "slopeFitC21", ",", 
          "\[IndentingNewLine]", "slopeFitC22"}], "\[IndentingNewLine]", 
         "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"1", " ", 
              RowBox[{"10", "^", 
               RowBox[{"-", "3"}]}]}], ",", " ", "1"}], "}"}], ",", 
           "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"FrameTicks", "->", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
             RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"FrameLabel", " ", "->", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "\"\<\!\(\*StyleBox[\"n\",FontSlant->\"Italic\"]\)\>\"", ",", " ",
              "None"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
            "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
          "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"LabelStyle", "\[Rule]", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
          "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"PlotLegends", "->", 
         RowBox[{"{", 
          RowBox[{
          "\"\<Data C20\>\"", ",", " ", "\"\<Data C21\>\"", ",", " ", 
           "\"\<Data C22\>\"", ",", " ", "\"\<Fit C20\>\"", ",", " ", 
           "\"\<Fit C21\>\"", ",", " ", "\"\<Fit C22\>\""}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"PlotStyle", "->", " ", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
             RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
             RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "9", "]"}], "[", "9", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
             RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"Black", ",", 
             RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"Black", ",", 
             RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"Black", ",", 
             RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], 
          "\[IndentingNewLine]", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"Joined", "->", 
         RowBox[{"{", 
          RowBox[{
          "False", ",", "False", ",", "False", ",", " ", "True", ",", " ", 
           "True", ",", "True"}], "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"PlotMarkers", "->", 
         RowBox[{"{", 
          RowBox[{
          "Automatic", ",", "Automatic", ",", " ", "Automatic", ",", " ", 
           "None", ",", " ", "None", ",", " ", "None"}], "}"}]}]}], 
       "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
      RowBox[{"Export", "[", 
       RowBox[{
        RowBox[{"FileNameJoin", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
           "\"\<PlateletsSlopeFitC20-C22_no_errors.pdf\>\""}], "}"}], "]"}], 
        ",", 
        RowBox[{"Show", "[", 
         RowBox[{"plotPlateletsFitNE", ",", " ", 
          RowBox[{"ImageSize", " ", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"8", " ", "cm"}], ",", " ", 
             RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}]}]}], 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"C20", "-", 
     RowBox[{"C22", " ", "without", " ", "errors"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotPlateletsFitNEa", " ", "=", " ", 
     RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
        "slopesC20NE", ",", "\[IndentingNewLine]", "slopesC21NE", ",", 
         "\[IndentingNewLine]", "slopesC22NE"}], "\[IndentingNewLine]", "}"}],
        ",", "\[IndentingNewLine]", 
       RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"1", " ", 
             RowBox[{"10", "^", 
              RowBox[{"-", "3"}]}]}], ",", " ", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "4.4"}], ",", " ", "0"}], "}"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
       RowBox[{"FrameTicks", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
            RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"FrameLabel", " ", "->", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "\"\<\!\(\*StyleBox[\"n\",FontSlant->\"Italic\"]\)\>\"", ",", " ", 
            "None"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
           "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"LabelStyle", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotLegends", "->", 
        RowBox[{"{", 
         RowBox[{
         "\"\<Data C20\>\"", ",", " ", "\"\<Data C21\>\"", ",", " ", 
          "\"\<Data C22\>\"", ",", " ", "\"\<Fit C20\>\""}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", "->", " ", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
            RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
            RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
            RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
            RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"ColorData", "[", "9", "]"}], "[", "9", "]"}], ",", 
            RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
            RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], 
         "\[IndentingNewLine]", "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"Joined", "->", 
        RowBox[{"{", 
         RowBox[{"False", ",", "False", ",", "False"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PlotMarkers", "->", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "Automatic", ",", " ", "Automatic"}], 
         "}"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotPlateletsFitNEb", " ", "=", " ", 
     RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
        "slopeFitC20", ",", "\[IndentingNewLine]", "slopeFitC21", ",", 
         "\[IndentingNewLine]", "slopeFitC22"}], "\[IndentingNewLine]", "}"}],
        ",", "\[IndentingNewLine]", 
       RowBox[{"PlotLegends", "->", 
        RowBox[{"{", 
         RowBox[{
         "\"\<Fit C20\>\"", ",", " ", "\"\<Fit C21\>\"", ",", " ", 
          "\"\<Fit C22\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"LabelStyle", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", "->", " ", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Black", ",", 
            RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"Black", ",", 
            RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"Black", ",", 
            RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], 
         "\[IndentingNewLine]", "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"Joined", "->", 
        RowBox[{"{", 
         RowBox[{"True", ",", " ", "True", ",", "True"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PlotMarkers", "->", 
        RowBox[{"{", 
         RowBox[{"None", ",", " ", "None", ",", " ", "None"}], "}"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"plotPlateletsFitNE", " ", "=", " ", 
    RowBox[{"Show", "[", 
     RowBox[{"plotPlateletsFitNEa", ",", " ", "plotPlateletsFitNEb"}], 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsSlopeFitC20-C22_no_errors.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotPlateletsFitNE", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.889083294305049*^9, 3.889083315851309*^9}, {
   3.8890833883662243`*^9, 3.8890834456873417`*^9}, {3.889083486103497*^9, 
   3.8890835217014627`*^9}, {3.889083563050894*^9, 3.8890835639046907`*^9}, {
   3.88908424900935*^9, 3.889084266338831*^9}, {3.8895047640723577`*^9, 
   3.8895048132399473`*^9}, {3.889504846884196*^9, 3.8895048547452297`*^9}, {
   3.8895049269182625`*^9, 3.8895050026520877`*^9}, {3.8895050961729617`*^9, 
   3.889505131901743*^9}, {3.8895051665115204`*^9, 3.88950517791572*^9}, {
   3.889514960971097*^9, 3.889515036411804*^9}, {3.8895151686784644`*^9, 
   3.8895152527812395`*^9}, {3.889515322726761*^9, 3.889515322942603*^9}, {
   3.889515414799749*^9, 3.889515415134011*^9}, {3.889515802135846*^9, 
   3.8895158072956295`*^9}, {3.88951762311401*^9, 3.8895176529460897`*^9}, {
   3.8895177805499964`*^9, 3.8895178521346097`*^9}, {3.8895178958654327`*^9, 
   3.889517895992517*^9}, {3.8895179853740325`*^9, 3.8895179941825094`*^9}, {
   3.889518050385213*^9, 3.8895180651462665`*^9}, {3.889518110111107*^9, 
   3.8895181537599416`*^9}, {3.8895181952428894`*^9, 3.889518231543586*^9}, {
   3.8895182640986247`*^9, 3.889518360154647*^9}, {3.889518402957049*^9, 
   3.8895184404208817`*^9}, {3.889518524888457*^9, 3.8895185272255807`*^9}, {
   3.8895889126133003`*^9, 3.889588935610735*^9}, {3.889589038336623*^9, 
   3.889589077704085*^9}, {3.889592078032647*^9, 3.8895920808209195`*^9}, {
   3.889592118364094*^9, 3.8895924083479843`*^9}, {3.8895925522801237`*^9, 
   3.8895925725829153`*^9}, {3.8895927385856147`*^9, 3.889592740371332*^9}, {
   3.8895928489211516`*^9, 3.8895928588784356`*^9}, {3.8895928981345015`*^9, 
   3.889592939760598*^9}, {3.889592994486616*^9, 3.889593006731392*^9}, {
   3.8896690677438173`*^9, 3.8896690861177497`*^9}, {3.8896691662237344`*^9, 
   3.8896691680709915`*^9}, {3.8896692820528316`*^9, 
   3.8896693106620665`*^9}, {3.889669383022016*^9, 3.8896694349828773`*^9}, {
   3.8896699958407335`*^9, 3.8896699966198225`*^9}, {3.8896701115288887`*^9, 
   3.8896701256913085`*^9}, {3.8896701570270524`*^9, 3.889670157394929*^9}, {
   3.8896712449546976`*^9, 3.889671273339734*^9}, {3.8896722465178547`*^9, 
   3.8896723216246796`*^9}, {3.889677150823584*^9, 3.889677160683831*^9}, {
   3.8896771908757315`*^9, 3.889677195202493*^9}, 3.8896773421424313`*^9, {
   3.889677378283571*^9, 3.8896773887669315`*^9}, {3.88967742719445*^9, 
   3.889677430963851*^9}, {3.889677480339917*^9, 3.889677480743126*^9}, {
   3.889677596624218*^9, 3.8896775968970366`*^9}, {3.889680706734044*^9, 
   3.8896807216712313`*^9}, {3.889680801340059*^9, 3.8896808079046683`*^9}, 
   3.8896849744898243`*^9, {3.889685151140499*^9, 3.8896851850751715`*^9}, {
   3.9022143351373234`*^9, 3.9022143457075415`*^9}, {3.902217269696082*^9, 
   3.902217270200951*^9}, {3.9022173155310507`*^9, 3.9022173399244585`*^9}, {
   3.9022173951254196`*^9, 3.902217398451253*^9}, {3.9022183993095517`*^9, 
   3.9022184967246695`*^9}, {3.902218567194338*^9, 3.902218589926301*^9}, {
   3.9022186355594287`*^9, 3.9022186384144664`*^9}, 3.9022186788903103`*^9, {
   3.90221872157267*^9, 3.902218790754416*^9}, 3.9022189075570207`*^9, {
   3.9022189860362177`*^9, 3.902219064270348*^9}, {3.902219301983201*^9, 
   3.902219506364025*^9}, {3.9022195367201366`*^9, 3.9022195644502935`*^9}, 
   3.9022195981147165`*^9, {3.9022196644479475`*^9, 3.902219826419914*^9}, {
   3.902219870182803*^9, 3.902219949602034*^9}, {3.9022199887895393`*^9, 
   3.902220146909876*^9}, {3.9022205683106046`*^9, 3.902220577493764*^9}, {
   3.9022215866550646`*^9, 3.902221783962392*^9}, {3.9023786995737205`*^9, 
   3.902378984723471*^9}, {3.9024597161117487`*^9, 3.902459739274332*^9}, {
   3.9024597791701097`*^9, 3.9024598198842497`*^9}, {3.904795250463937*^9, 
   3.9047953383134565`*^9}, {3.9047956629414744`*^9, 
   3.9047957535926833`*^9}, {3.904798306979192*^9, 3.9047983512027273`*^9}, {
   3.904798382546859*^9, 3.904798410143236*^9}, {3.904798496961456*^9, 
   3.9047985009846196`*^9}, {3.905926172370016*^9, 3.9059261935734367`*^9}, {
   3.915698559339667*^9, 3.9156986833726535`*^9}, {3.9156987230637307`*^9, 
   3.9156987367657747`*^9}, {3.917943923143335*^9, 3.917943923269372*^9}, {
   3.917944138702747*^9, 3.917944232400084*^9}, {3.9179443469953337`*^9, 
   3.917944367334844*^9}, {3.918560232363167*^9, 3.9185603821176825`*^9}, 
   3.9185604140937805`*^9, {3.918560452755327*^9, 3.91856045522666*^9}, {
   3.9185605080234594`*^9, 3.9185605199913216`*^9}, {3.9185605767638054`*^9, 
   3.9185606187871637`*^9}, {3.9185608861120586`*^9, 
   3.9185609805333843`*^9}, {3.918561077881313*^9, 3.9185610907715054`*^9}, {
   3.9185612727568984`*^9, 3.918561392802757*^9}, {3.9185617189046445`*^9, 
   3.918561720220172*^9}, {3.918561834736827*^9, 3.918561834839472*^9}},
 CellLabel->
  "In[319]:=",ExpressionUUID->"53db37f2-ab19-4a4d-8175-4749ca30cef4"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.6554248936175195`, -1.3754752798292404`}, \
{-5.6554248936175195`, -1.0598095276965294`}}], 
          
          LineBox[{{-5.6554248936175195`, -1.0598095276965294`}, \
{-5.6554248936175195`, -0.7441437755638183}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.505650557368423, -1.6058265850271665`}, \
{-5.505650557368423, -1.299153679788789}}], 
          
          LineBox[{{-5.505650557368423, -1.299153679788789}, \
{-5.505650557368423, -0.9924807745504116}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.352012198649872, -1.8664192256781258`}, \
{-5.352012198649872, -1.5487656000261758`}}], 
          
          LineBox[{{-5.352012198649872, -1.5487656000261758`}, \
{-5.352012198649872, -1.2311119743742258`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.197327949963066, -1.9160413309640592`}, \
{-5.197327949963066, -1.6221727152612109`}}], 
          
          LineBox[{{-5.197327949963066, -1.6221727152612109`}, \
{-5.197327949963066, -1.3283040995583626`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.046182498246482, -1.9443899812655037`}, \
{-5.046182498246482, -1.646337564940634}}], 
          
          LineBox[{{-5.046182498246482, -1.646337564940634}, \
{-5.046182498246482, -1.3482851486157643`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.894444132978499, -2.054729383000484}, \
{-4.894444132978499, -1.7673180501957881`}}], 
          
          LineBox[{{-4.894444132978499, -1.7673180501957881`}, \
{-4.894444132978499, -1.4799067173910923`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.745125399370905, -2.0436838539320887`}, \
{-4.745125399370905, -1.7790030360493436`}}], 
          
          LineBox[{{-4.745125399370905, -1.7790030360493436`}, \
{-4.745125399370905, -1.5143222181665987`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.596628633102665, -2.155055401276338}, \
{-4.596628633102665, -1.9018395732059943`}}], 
          
          LineBox[{{-4.596628633102665, -1.9018395732059943`}, \
{-4.596628633102665, -1.6486237451356507`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.447741719114617, -2.141283295074858}, \
{-4.447741719114617, -1.9072672831704347`}}], 
          
          LineBox[{{-4.447741719114617, -1.9072672831704347`}, \
{-4.447741719114617, -1.6732512712660113`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.298711959937622, -2.1741403061228324`}, \
{-4.298711959937622, -1.956182801462741}}], 
          
          LineBox[{{-4.298711959937622, -1.956182801462741}, \
{-4.298711959937622, -1.7382252968026495`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.149632905511913, -2.2157632698654677`}, \
{-4.149632905511913, -2.0014304169941814`}}], 
          
          LineBox[{{-4.149632905511913, -2.0014304169941814`}, \
{-4.149632905511913, -1.787097564122895}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.001278268975371, -2.180179830632701}, \
{-4.001278268975371, -1.9797092707882549`}}], 
          
          LineBox[{{-4.001278268975371, -1.9797092707882549`}, \
{-4.001278268975371, -1.7792387109438086`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.8508575458258987`, -2.3621772224343935`}, \
{-3.8508575458258987`, -2.1744414390160456`}}], 
          
          LineBox[{{-3.8508575458258987`, -2.1744414390160456`}, \
{-3.8508575458258987`, -1.9867056555976979`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.6998351226863213`, -2.21519821644171}, \
{-3.6998351226863213`, -2.03529139387336}}], 
          
          LineBox[{{-3.6998351226863213`, -2.03529139387336}, \
{-3.6998351226863213`, -1.8553845713050103`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.550260154845919, -2.2882721832855677`}, \
{-3.550260154845919, -2.1232882907193176`}}], 
          
          LineBox[{{-3.550260154845919, -2.1232882907193176`}, \
{-3.550260154845919, -1.9583043981530677`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.3997502222704012`, -2.2596424372692936`}, \
{-3.3997502222704012`, -2.1108374517938837`}}], 
          
          LineBox[{{-3.3997502222704012`, -2.1108374517938837`}, \
{-3.3997502222704012`, -1.9620324663184738`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.2492191603155653`, -2.262247354252459}, \
{-3.2492191603155653`, -2.120548060098231}}], 
          
          LineBox[{{-3.2492191603155653`, -2.120548060098231}, \
{-3.2492191603155653`, -1.9788487659440033`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.099363949694378, -2.325682989323952}, \
{-3.099363949694378, -2.1912112272257005`}}], 
          
          LineBox[{{-3.099363949694378, -2.1912112272257005`}, \
{-3.099363949694378, -2.056739465127449}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.9723318619592627`, -2.3447234080641337`}, \
{-2.9723318619592627`, -2.1198491065643985`}}], 
          
          LineBox[{{-2.9723318619592627`, -2.1198491065643985`}, \
{-2.9723318619592627`, -1.8949748050646635`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.8161289018458944`, -2.4254477492472883`}, \
{-2.8161289018458944`, -2.1235798621853275`}}], 
          
          LineBox[{{-2.8161289018458944`, -2.1235798621853275`}, \
{-2.8161289018458944`, -1.8217119751233666`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.637122953927779, -2.8413253632452493`}, \
{-2.637122953927779, -2.278547275957496}}], 
          
          LineBox[{{-2.637122953927779, -2.278547275957496}, \
{-2.637122953927779, -1.7157691886697428`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.4883394437723703`, -2.8224766777422747`}, \
{-2.4883394437723703`, -2.2945785421813194`}}], 
          
          LineBox[{{-2.4883394437723703`, -2.2945785421813194`}, \
{-2.4883394437723703`, -1.766680406620364}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.3426491274116255`, -2.8819377562355633`}, \
{-2.3426491274116255`, -2.3841664101003133`}}], 
          
          LineBox[{{-2.3426491274116255`, -2.3841664101003133`}, \
{-2.3426491274116255`, -1.8863950639650633`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.1952323671440643`, -2.8970664017320726`}, \
{-2.1952323671440643`, -2.4353568974949273`}}], 
          
          LineBox[{{-2.1952323671440643`, -2.4353568974949273`}, \
{-2.1952323671440643`, -1.973647393257782}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.048114358050804, -2.968529373545217}, \
{-2.048114358050804, -2.514206950968894}}], 
          
          LineBox[{{-2.048114358050804, -2.514206950968894}, \
{-2.048114358050804, -2.059884528392571}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.9047213128625353`, -3.0022765477363382`}, \
{-1.9047213128625353`, -2.576373376847949}}], 
          
          LineBox[{{-1.9047213128625353`, -2.576373376847949}, \
{-1.9047213128625353`, -2.15047020595956}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.7572185227137695`, -3.094837271329944}, \
{-1.7572185227137695`, -2.694912787804791}}], 
          
          LineBox[{{-1.7572185227137695`, -2.694912787804791}, \
{-1.7572185227137695`, -2.2949883042796384`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.6053998639759, -3.1963113633507874`}, \
{-1.6053998639759, -2.815233406102849}}], 
          
          LineBox[{{-1.6053998639759, -2.815233406102849}, {-1.6053998639759, \
-2.43415544885491}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.4536487775630647`, -3.319806547313522}, \
{-1.4536487775630647`, -2.9498566221552425`}}], 
          
          LineBox[{{-1.4536487775630647`, -2.9498566221552425`}, \
{-1.4536487775630647`, -2.579906696996963}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.3021571254789979`, -3.4374715265753477`}, \
{-1.3021571254789979`, -3.0820720918970834`}}], 
          
          LineBox[{{-1.3021571254789979`, -3.0820720918970834`}, \
{-1.3021571254789979`, -2.726672657218819}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.1509597708634107`, -3.575354502019425}, \
{-1.1509597708634107`, -3.229140593642689}}], 
          
          LineBox[{{-1.1509597708634107`, -3.229140593642689}, \
{-1.1509597708634107`, -2.8829266852659527`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.0007923805337786`, -3.6838381654034302`}, \
{-1.0007923805337786`, -3.352874895418735}}], 
          
          LineBox[{{-1.0007923805337786`, -3.352874895418735}, \
{-1.0007923805337786`, -3.02191162543404}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-0.8504177096512346, -3.7163191294527014`}, \
{-0.8504177096512346, -3.4036106316122847`}}], 
          
          LineBox[{{-0.8504177096512346, -3.4036106316122847`}, \
{-0.8504177096512346, -3.090902133771868}}]}}}}}, {{{}, {}, {}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.009166666666666668], 
         AbsoluteThickness[1.6], 
         GrayLevel[0], 
         Thickness[0.005]], 
        LineBox[CompressedData["
1:eJw1VXk4Vd0Xvtflco3HdC/3mjNVIooSOle+Rg1CEaJESXN+GoQoIURlllBJ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         "]]}}, {{
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.02], 
         Thickness[0.005]], 
        GeometricTransformationBox[
         InsetBox[
          BoxData[
           FormBox[
            StyleBox[
             GraphicsBox[{
               EdgeForm[], 
               DiskBox[{0, 0}]}], 
             GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                 AbsoluteThickness[1.6], 
                 RGBColor[
                 0.6745098039215687, 0.07450980392156863, 
                  0.043137254901960784`], 
                 PointSize[0.02], 
                 Thickness[0.005]]}, StripOnInput -> False], 
            TraditionalForm]], {0., 0.}, Automatic, 
          Offset[6.272]], CompressedData["
1:eJwBJQLa/SFib1JlAwAAACEAAAABAAAAAgAAAD5JDLQnnxbA/yHX1fr08L/8
Z3xCyQUWwAe8cl5VyfS/HvrD4nVoFcAQhBRwvsf4v162jlYQyhTAryqIYGv0
+b8Cd/52Si8UwHGK+Q5mV/q/iPesKemTE8DXirNK70b8vy/eFicC+xLA9RA1
48t2/L/tIcyd8mISwJOIElXvbf6/wJsiznzKEcAkKt+yKoT+v7JsS4zhMRHA
bXtUVoZM/78GUU5eOZkQwF6tUfPtAgDAYsctF08BEMAd+tmg46z/vzYEp2aO
zg7A9iCdjUFlAcA7PSQoQ5kNwHUhtNpGSADASNfKy+5mDMAk9ESSfvwAwMbC
mT6wMgvAfwP1vv7iAMBIvHidZv4JwMO+vebh9gDAv7WSU3/LCMDQf3zAmYcB
wGLKX+1VxwfA+DDJcnP1AMDz/PWWbocGwMk9VHAX/QDAsDRV69MYBcDHBIX+
djoCwBXLooIe6APATy2m/ktbAsAP42HTvr0CwBDSvNbFEgPADgnA/NWPAcBB
oaZlnHsDwLJe0seJYgDAV0yuiBgdBMAE0isOvXn+v7XGHqVpnATAerJvK5Ed
/L/VjIlvLo8FwCx4jMS3r/m/IYyOF5mFBsBTD3g4JUL3v8pdwG1OmQfAe/jC
taLV9L/z5bRpFagIwIjr7cpUavK/Dg3fqUfVCcA1qAffPgPwvx05uxKw0grA
VoVcM58267/Ivfg1mDoLwKhIE48=
         "]]}, {}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {-6.907755278982122, 0}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"n\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
          HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameStyle -> GrayLevel[0], 
     FrameTicks -> {{Automatic, Automatic}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.907755278982137, 0.}, {-4.1575894443909105`, 0}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {
        Scaled[0.05], 
        Scaled[0.02]}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"Data C14\"", "\"Fit C14\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    DiskBox[{0, 0}]}, {DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 6.272}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.28196428571428567`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Thickness[0.09]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Thickness[0.09]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    EdgeForm[], 
                    DiskBox[{0, 0}]}], ",", 
                    RowBox[{"Offset", "[", "6.272`", "]"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"None", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.8895182869567413`*^9, {3.8895183343905697`*^9, 3.8895183620551634`*^9}, {
   3.8895184150560637`*^9, 3.8895184418507495`*^9}, 3.8895185281220536`*^9, 
   3.8895889404320927`*^9, {3.8895890406246934`*^9, 3.8895890784682913`*^9}, 
   3.889592148098647*^9, 3.889592411520773*^9, 3.8895925734732924`*^9, 
   3.889592742450922*^9, 3.889592859727005*^9, 3.889592922507035*^9, 
   3.8895930087831736`*^9, 3.889668998234763*^9, 3.8896690890570593`*^9, 
   3.889669169286552*^9, 3.8896693168938737`*^9, 3.8896711091569824`*^9, 
   3.889671276253702*^9, 3.8896723301246977`*^9, 3.889677442821598*^9, 
   3.889677598100257*^9, 3.889684978194605*^9, 3.889685185804984*^9, 
   3.890204642630407*^9, 3.8902063323023443`*^9, 3.8902104829738626`*^9, 
   3.8902169904530506`*^9, 3.890217304571312*^9, 3.8902182374475017`*^9, 
   3.8909820692101192`*^9, 3.8909824066539817`*^9, 3.8909829558379273`*^9, 
   3.8914172809480352`*^9, 3.89141922718013*^9, 3.8926158229674926`*^9, 
   3.89262922150885*^9, 3.89272089485242*^9, 3.9022174287052937`*^9, 
   3.90221850464843*^9, {3.902218568798971*^9, 3.9022185909588995`*^9}, {
   3.9022186690119762`*^9, 3.9022186820000067`*^9}, 3.902218723860509*^9, {
   3.9022187641114473`*^9, 3.9022187740635996`*^9}, 3.90221880694001*^9, 
   3.902218910464753*^9, {3.902218987314639*^9, 3.9022190443797426`*^9}, 
   3.902219184342458*^9, 3.9022193051179514`*^9, 3.9022193605600953`*^9, 
   3.9022194568420315`*^9, 3.9022195116035814`*^9, 3.902219566279887*^9, {
   3.9022196665031495`*^9, 3.902219690729586*^9}, {3.9022197438343844`*^9, 
   3.902219793043107*^9}, {3.9022198766762857`*^9, 3.902219951643075*^9}, 
   3.9022200460836196`*^9, 3.902220149808984*^9, 3.9022205813727236`*^9, 
   3.9022217999990807`*^9, 3.90222207660452*^9, 3.9023789909216423`*^9, 
   3.902382596673857*^9, 3.902459757551134*^9, 3.902459826203156*^9, 
   3.903580778294915*^9, 3.9047957640505533`*^9, 3.904798416951468*^9, 
   3.9047985089142313`*^9, 3.9059261967219095`*^9, 3.915698742640217*^9, 
   3.917944319587473*^9, 3.9179443763595448`*^9, 3.9179452587291994`*^9, 
   3.917951280827122*^9, 3.9185608591100545`*^9, 3.9185610998150153`*^9, 
   3.9185613092718544`*^9, 3.9185613453556614`*^9, 3.9185613973954306`*^9, 
   3.918561724708984*^9, 3.918561795367496*^9, 3.918561839258089*^9},
 CellLabel->
  "Out[325]=",ExpressionUUID->"fdc07ddb-b116-45d6-8a9a-1123757f6bad"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\LH-ESRF-C14-16 & C20-22 \
plot\\\\PlateletsSlopeFitC14.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.8895182869567413`*^9, {3.8895183343905697`*^9, 3.8895183620551634`*^9}, {
   3.8895184150560637`*^9, 3.8895184418507495`*^9}, 3.8895185281220536`*^9, 
   3.8895889404320927`*^9, {3.8895890406246934`*^9, 3.8895890784682913`*^9}, 
   3.889592148098647*^9, 3.889592411520773*^9, 3.8895925734732924`*^9, 
   3.889592742450922*^9, 3.889592859727005*^9, 3.889592922507035*^9, 
   3.8895930087831736`*^9, 3.889668998234763*^9, 3.8896690890570593`*^9, 
   3.889669169286552*^9, 3.8896693168938737`*^9, 3.8896711091569824`*^9, 
   3.889671276253702*^9, 3.8896723301246977`*^9, 3.889677442821598*^9, 
   3.889677598100257*^9, 3.889684978194605*^9, 3.889685185804984*^9, 
   3.890204642630407*^9, 3.8902063323023443`*^9, 3.8902104829738626`*^9, 
   3.8902169904530506`*^9, 3.890217304571312*^9, 3.8902182374475017`*^9, 
   3.8909820692101192`*^9, 3.8909824066539817`*^9, 3.8909829558379273`*^9, 
   3.8914172809480352`*^9, 3.89141922718013*^9, 3.8926158229674926`*^9, 
   3.89262922150885*^9, 3.89272089485242*^9, 3.9022174287052937`*^9, 
   3.90221850464843*^9, {3.902218568798971*^9, 3.9022185909588995`*^9}, {
   3.9022186690119762`*^9, 3.9022186820000067`*^9}, 3.902218723860509*^9, {
   3.9022187641114473`*^9, 3.9022187740635996`*^9}, 3.90221880694001*^9, 
   3.902218910464753*^9, {3.902218987314639*^9, 3.9022190443797426`*^9}, 
   3.902219184342458*^9, 3.9022193051179514`*^9, 3.9022193605600953`*^9, 
   3.9022194568420315`*^9, 3.9022195116035814`*^9, 3.902219566279887*^9, {
   3.9022196665031495`*^9, 3.902219690729586*^9}, {3.9022197438343844`*^9, 
   3.902219793043107*^9}, {3.9022198766762857`*^9, 3.902219951643075*^9}, 
   3.9022200460836196`*^9, 3.902220149808984*^9, 3.9022205813727236`*^9, 
   3.9022217999990807`*^9, 3.90222207660452*^9, 3.9023789909216423`*^9, 
   3.902382596673857*^9, 3.902459757551134*^9, 3.902459826203156*^9, 
   3.903580778294915*^9, 3.9047957640505533`*^9, 3.904798416951468*^9, 
   3.9047985089142313`*^9, 3.9059261967219095`*^9, 3.915698742640217*^9, 
   3.917944319587473*^9, 3.9179443763595448`*^9, 3.9179452587291994`*^9, 
   3.917951280827122*^9, 3.9185608591100545`*^9, 3.9185610998150153`*^9, 
   3.9185613092718544`*^9, 3.9185613453556614`*^9, 3.9185613973954306`*^9, 
   3.918561724708984*^9, 3.918561795367496*^9, 3.9185618398827915`*^9},
 CellLabel->
  "Out[326]=",ExpressionUUID->"3dd5fd87-e152-4386-aaec-911a912fef22"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.6554248936175195`, -1.3754752798292404`}, \
{-5.6554248936175195`, -1.0598095276965294`}}], 
          
          LineBox[{{-5.6554248936175195`, -1.0598095276965294`}, \
{-5.6554248936175195`, -0.7441437755638183}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.505650557368423, -1.6058265850271665`}, \
{-5.505650557368423, -1.299153679788789}}], 
          
          LineBox[{{-5.505650557368423, -1.299153679788789}, \
{-5.505650557368423, -0.9924807745504116}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.352012198649872, -1.8664192256781258`}, \
{-5.352012198649872, -1.5487656000261758`}}], 
          
          LineBox[{{-5.352012198649872, -1.5487656000261758`}, \
{-5.352012198649872, -1.2311119743742258`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.197327949963066, -1.9160413309640592`}, \
{-5.197327949963066, -1.6221727152612109`}}], 
          
          LineBox[{{-5.197327949963066, -1.6221727152612109`}, \
{-5.197327949963066, -1.3283040995583626`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.046182498246482, -1.9443899812655037`}, \
{-5.046182498246482, -1.646337564940634}}], 
          
          LineBox[{{-5.046182498246482, -1.646337564940634}, \
{-5.046182498246482, -1.3482851486157643`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.894444132978499, -2.054729383000484}, \
{-4.894444132978499, -1.7673180501957881`}}], 
          
          LineBox[{{-4.894444132978499, -1.7673180501957881`}, \
{-4.894444132978499, -1.4799067173910923`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.745125399370905, -2.0436838539320887`}, \
{-4.745125399370905, -1.7790030360493436`}}], 
          
          LineBox[{{-4.745125399370905, -1.7790030360493436`}, \
{-4.745125399370905, -1.5143222181665987`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.596628633102665, -2.155055401276338}, \
{-4.596628633102665, -1.9018395732059943`}}], 
          
          LineBox[{{-4.596628633102665, -1.9018395732059943`}, \
{-4.596628633102665, -1.6486237451356507`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.447741719114617, -2.141283295074858}, \
{-4.447741719114617, -1.9072672831704347`}}], 
          
          LineBox[{{-4.447741719114617, -1.9072672831704347`}, \
{-4.447741719114617, -1.6732512712660113`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.298711959937622, -2.1741403061228324`}, \
{-4.298711959937622, -1.956182801462741}}], 
          
          LineBox[{{-4.298711959937622, -1.956182801462741}, \
{-4.298711959937622, -1.7382252968026495`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.149632905511913, -2.2157632698654677`}, \
{-4.149632905511913, -2.0014304169941814`}}], 
          
          LineBox[{{-4.149632905511913, -2.0014304169941814`}, \
{-4.149632905511913, -1.787097564122895}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.001278268975371, -2.180179830632701}, \
{-4.001278268975371, -1.9797092707882549`}}], 
          
          LineBox[{{-4.001278268975371, -1.9797092707882549`}, \
{-4.001278268975371, -1.7792387109438086`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.8508575458258987`, -2.3621772224343935`}, \
{-3.8508575458258987`, -2.1744414390160456`}}], 
          
          LineBox[{{-3.8508575458258987`, -2.1744414390160456`}, \
{-3.8508575458258987`, -1.9867056555976979`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.6998351226863213`, -2.21519821644171}, \
{-3.6998351226863213`, -2.03529139387336}}], 
          
          LineBox[{{-3.6998351226863213`, -2.03529139387336}, \
{-3.6998351226863213`, -1.8553845713050103`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.550260154845919, -2.2882721832855677`}, \
{-3.550260154845919, -2.1232882907193176`}}], 
          
          LineBox[{{-3.550260154845919, -2.1232882907193176`}, \
{-3.550260154845919, -1.9583043981530677`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.3997502222704012`, -2.2596424372692936`}, \
{-3.3997502222704012`, -2.1108374517938837`}}], 
          
          LineBox[{{-3.3997502222704012`, -2.1108374517938837`}, \
{-3.3997502222704012`, -1.9620324663184738`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.2492191603155653`, -2.262247354252459}, \
{-3.2492191603155653`, -2.120548060098231}}], 
          
          LineBox[{{-3.2492191603155653`, -2.120548060098231}, \
{-3.2492191603155653`, -1.9788487659440033`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.099363949694378, -2.325682989323952}, \
{-3.099363949694378, -2.1912112272257005`}}], 
          
          LineBox[{{-3.099363949694378, -2.1912112272257005`}, \
{-3.099363949694378, -2.056739465127449}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.9723318619592627`, -2.3447234080641337`}, \
{-2.9723318619592627`, -2.1198491065643985`}}], 
          
          LineBox[{{-2.9723318619592627`, -2.1198491065643985`}, \
{-2.9723318619592627`, -1.8949748050646635`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.8161289018458944`, -2.4254477492472883`}, \
{-2.8161289018458944`, -2.1235798621853275`}}], 
          
          LineBox[{{-2.8161289018458944`, -2.1235798621853275`}, \
{-2.8161289018458944`, -1.8217119751233666`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.637122953927779, -2.8413253632452493`}, \
{-2.637122953927779, -2.278547275957496}}], 
          
          LineBox[{{-2.637122953927779, -2.278547275957496}, \
{-2.637122953927779, -1.7157691886697428`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.4883394437723703`, -2.8224766777422747`}, \
{-2.4883394437723703`, -2.2945785421813194`}}], 
          
          LineBox[{{-2.4883394437723703`, -2.2945785421813194`}, \
{-2.4883394437723703`, -1.766680406620364}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.3426491274116255`, -2.8819377562355633`}, \
{-2.3426491274116255`, -2.3841664101003133`}}], 
          
          LineBox[{{-2.3426491274116255`, -2.3841664101003133`}, \
{-2.3426491274116255`, -1.8863950639650633`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.1952323671440643`, -2.8970664017320726`}, \
{-2.1952323671440643`, -2.4353568974949273`}}], 
          
          LineBox[{{-2.1952323671440643`, -2.4353568974949273`}, \
{-2.1952323671440643`, -1.973647393257782}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.048114358050804, -2.968529373545217}, \
{-2.048114358050804, -2.514206950968894}}], 
          
          LineBox[{{-2.048114358050804, -2.514206950968894}, \
{-2.048114358050804, -2.059884528392571}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.9047213128625353`, -3.0022765477363382`}, \
{-1.9047213128625353`, -2.576373376847949}}], 
          
          LineBox[{{-1.9047213128625353`, -2.576373376847949}, \
{-1.9047213128625353`, -2.15047020595956}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.7572185227137695`, -3.094837271329944}, \
{-1.7572185227137695`, -2.694912787804791}}], 
          
          LineBox[{{-1.7572185227137695`, -2.694912787804791}, \
{-1.7572185227137695`, -2.2949883042796384`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.6053998639759, -3.1963113633507874`}, \
{-1.6053998639759, -2.815233406102849}}], 
          
          LineBox[{{-1.6053998639759, -2.815233406102849}, {-1.6053998639759, \
-2.43415544885491}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.4536487775630647`, -3.319806547313522}, \
{-1.4536487775630647`, -2.9498566221552425`}}], 
          
          LineBox[{{-1.4536487775630647`, -2.9498566221552425`}, \
{-1.4536487775630647`, -2.579906696996963}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.3021571254789979`, -3.4374715265753477`}, \
{-1.3021571254789979`, -3.0820720918970834`}}], 
          
          LineBox[{{-1.3021571254789979`, -3.0820720918970834`}, \
{-1.3021571254789979`, -2.726672657218819}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.1509597708634107`, -3.575354502019425}, \
{-1.1509597708634107`, -3.229140593642689}}], 
          
          LineBox[{{-1.1509597708634107`, -3.229140593642689}, \
{-1.1509597708634107`, -2.8829266852659527`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.0007923805337786`, -3.6838381654034302`}, \
{-1.0007923805337786`, -3.352874895418735}}], 
          
          LineBox[{{-1.0007923805337786`, -3.352874895418735}, \
{-1.0007923805337786`, -3.02191162543404}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-0.8504177096512346, -3.7163191294527014`}, \
{-0.8504177096512346, -3.4036106316122847`}}], 
          
          LineBox[{{-0.8504177096512346, -3.4036106316122847`}, \
{-0.8504177096512346, -3.090902133771868}}]}}}, {{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.352012198649872, -1.3931597078962221`}, \
{-5.352012198649872, -1.151834366725471}}], 
          
          LineBox[{{-5.352012198649872, -1.151834366725471}, \
{-5.352012198649872, -0.9105090255547197}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.197327949963066, -1.3134154073527315`}, \
{-5.197327949963066, -1.069959893773818}}], 
          
          LineBox[{{-5.197327949963066, -1.069959893773818}, \
{-5.197327949963066, -0.8265043801949042}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.046182498246482, -1.9504581230708071`}, \
{-5.046182498246482, -1.6762357931850604`}}], 
          
          LineBox[{{-5.046182498246482, -1.6762357931850604`}, \
{-5.046182498246482, -1.4020134632993138`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.894444132978499, -2.0135895487593514`}, \
{-4.894444132978499, -1.7375884675911477`}}], 
          
          LineBox[{{-4.894444132978499, -1.7375884675911477`}, \
{-4.894444132978499, -1.461587386422944}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.745125399370905, -2.1041540613861183`}, \
{-4.745125399370905, -1.8251655604291082`}}], 
          
          LineBox[{{-4.745125399370905, -1.8251655604291082`}, \
{-4.745125399370905, -1.546177059472098}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.596628633102665, -2.0307430586360637`}, \
{-4.596628633102665, -1.7724110332954253`}}], 
          
          LineBox[{{-4.596628633102665, -1.7724110332954253`}, \
{-4.596628633102665, -1.5140790079547868`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.447741719114617, -2.0169830121124313`}, \
{-4.447741719114617, -1.7725072919707168`}}], 
          
          LineBox[{{-4.447741719114617, -1.7725072919707168`}, \
{-4.447741719114617, -1.5280315718290023`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.298711959937622, -2.0626503772314857`}, \
{-4.298711959937622, -1.8496491893256315`}}], 
          
          LineBox[{{-4.298711959937622, -1.8496491893256315`}, \
{-4.298711959937622, -1.6366480014197775`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.149632905511913, -2.236616860168895}, \
{-4.149632905511913, -2.0325593608914523`}}], 
          
          LineBox[{{-4.149632905511913, -2.0325593608914523`}, \
{-4.149632905511913, -1.8285018616140096`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.001278268975371, -2.126596922805546}, \
{-4.001278268975371, -1.9202406735472024`}}], 
          
          LineBox[{{-4.001278268975371, -1.9202406735472024`}, \
{-4.001278268975371, -1.7138844242888587`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.8508575458258987`, -2.405553425795285}, \
{-3.8508575458258987`, -2.2031646692537383`}}], 
          
          LineBox[{{-3.8508575458258987`, -2.2031646692537383`}, \
{-3.8508575458258987`, -2.0007759127121916`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.6998351226863213`, -2.3164167395806587`}, \
{-3.6998351226863213`, -2.134158695867596}}], 
          
          LineBox[{{-3.6998351226863213`, -2.134158695867596}, \
{-3.6998351226863213`, -1.9519006521545337`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.550260154845919, -2.203216947445259}, \
{-3.550260154845919, -2.0473258241851515`}}], 
          
          LineBox[{{-3.550260154845919, -2.0473258241851515`}, \
{-3.550260154845919, -1.891434700925044}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.3997502222704012`, -2.2307861716923925`}, \
{-3.3997502222704012`, -2.0800504841837304`}}], 
          
          LineBox[{{-3.3997502222704012`, -2.0800504841837304`}, \
{-3.3997502222704012`, -1.9293147966750681`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.2492191603155653`, -2.2478328027805525`}, \
{-3.2492191603155653`, -2.1107168701832237`}}], 
          
          LineBox[{{-3.2492191603155653`, -2.1107168701832237`}, \
{-3.2492191603155653`, -1.973600937585895}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.099363949694378, -2.2353296307097104`}, \
{-3.099363949694378, -2.1004607688868693`}}], 
          
          LineBox[{{-3.099363949694378, -2.1004607688868693`}, \
{-3.099363949694378, -1.9655919070640282`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.9723318619592627`, -2.3858567159594695`}, \
{-2.9723318619592627`, -2.169150133472718}}], 
          
          LineBox[{{-2.9723318619592627`, -2.169150133472718}, \
{-2.9723318619592627`, -1.9524435509859663`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.8161289018458944`, -2.306313665840845}, \
{-2.8161289018458944`, -2.014061893425849}}], 
          
          LineBox[{{-2.8161289018458944`, -2.014061893425849}, \
{-2.8161289018458944`, -1.7218101210108534`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.637122953927779, -2.7518917128356595`}, \
{-2.637122953927779, -2.2061952959799984`}}], 
          
          LineBox[{{-2.637122953927779, -2.2061952959799984`}, \
{-2.637122953927779, -1.6604988791243374`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.4883394437723703`, -2.7366945816937207`}, \
{-2.4883394437723703`, -2.225953227624485}}], 
          
          LineBox[{{-2.4883394437723703`, -2.225953227624485}, \
{-2.4883394437723703`, -1.7152118735552495`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.3426491274116255`, -2.772455987224709}, \
{-2.3426491274116255`, -2.2921739832968755`}}], 
          
          LineBox[{{-2.3426491274116255`, -2.2921739832968755`}, \
{-2.3426491274116255`, -1.811891979369042}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.1952323671440643`, -2.7715253067085035`}, \
{-2.1952323671440643`, -2.329483345181388}}], 
          
          LineBox[{{-2.1952323671440643`, -2.329483345181388}, \
{-2.1952323671440643`, -1.8874413836542725`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.048114358050804, -2.8147049786780887`}, \
{-2.048114358050804, -2.3830075094473293`}}], 
          
          LineBox[{{-2.048114358050804, -2.3830075094473293`}, \
{-2.048114358050804, -1.95131004021657}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.9047213128625353`, -2.832278194104769}, \
{-1.9047213128625353`, -2.4311676688983095`}}], 
          
          LineBox[{{-1.9047213128625353`, -2.4311676688983095`}, \
{-1.9047213128625353`, -2.0300571436918498`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.7572185227137695`, -2.8846177931737373`}, \
{-1.7572185227137695`, -2.511398827530227}}], 
          
          LineBox[{{-1.7572185227137695`, -2.511398827530227}, \
{-1.7572185227137695`, -2.1381798618867163`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.6053998639759, -2.9663156495983545`}, \
{-1.6053998639759, -2.61370163284424}}], 
          
          LineBox[{{-1.6053998639759, -2.61370163284424}, {-1.6053998639759, \
-2.2610876160901254`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.4536487775630647`, -3.0377885868632313`}, \
{-1.4536487775630647`, -2.6973826950774096`}}], 
          
          LineBox[{{-1.4536487775630647`, -2.6973826950774096`}, \
{-1.4536487775630647`, -2.356976803291588}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.3021571254789979`, -3.144948413067255}, \
{-1.3021571254789979`, -2.8205679377033843`}}], 
          
          LineBox[{{-1.3021571254789979`, -2.8205679377033843`}, \
{-1.3021571254789979`, -2.4961874623395137`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.1509597708634107`, -3.234763455290838}, \
{-1.1509597708634107`, -2.9191367616169543`}}], 
          
          LineBox[{{-1.1509597708634107`, -2.9191367616169543`}, \
{-1.1509597708634107`, -2.6035100679430707`}}]}}}}}, {{{}, {}, {}, {}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[0.007333333333333334], 
         AbsoluteThickness[1.6], 
         GrayLevel[0], 
         Thickness[0.005]], 
        LineBox[CompressedData["
1:eJw1VXk4Vd0Xvtflco3HdC/3mjNVIooSOle+Rg1CEaJESXN+GoQoIURlllBJ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         "]]}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         PointSize[0.007333333333333334], 
         AbsoluteThickness[1.6], 
         GrayLevel[0], 
         Thickness[0.005]], 
        LineBox[CompressedData["
1:eJw1lXk4Vdsbx4/jmDJtHNNRoohSpEtRtJUGKUKkVObQRYaTK4QGKdFknkJR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         "]]}}, {{
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.02], 
         Thickness[0.005]], 
        GeometricTransformationBox[
         InsetBox[
          BoxData[
           FormBox[
            StyleBox[
             GraphicsBox[{
               EdgeForm[], 
               DiskBox[{0, 0}]}], 
             GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                 AbsoluteThickness[1.6], 
                 RGBColor[
                 0.6745098039215687, 0.07450980392156863, 
                  0.043137254901960784`], 
                 PointSize[0.02], 
                 Thickness[0.005]]}, StripOnInput -> False], 
            TraditionalForm]], {0., 0.}, Automatic, 
          Offset[6.272]], CompressedData["
1:eJwBJQLa/SFib1JlAwAAACEAAAABAAAAAgAAAD5JDLQnnxbA/yHX1fr08L/8
Z3xCyQUWwAe8cl5VyfS/HvrD4nVoFcAQhBRwvsf4v162jlYQyhTAryqIYGv0
+b8Cd/52Si8UwHGK+Q5mV/q/iPesKemTE8DXirNK70b8vy/eFicC+xLA9RA1
48t2/L/tIcyd8mISwJOIElXvbf6/wJsiznzKEcAkKt+yKoT+v7JsS4zhMRHA
bXtUVoZM/78GUU5eOZkQwF6tUfPtAgDAYsctF08BEMAd+tmg46z/vzYEp2aO
zg7A9iCdjUFlAcA7PSQoQ5kNwHUhtNpGSADASNfKy+5mDMAk9ESSfvwAwMbC
mT6wMgvAfwP1vv7iAMBIvHidZv4JwMO+vebh9gDAv7WSU3/LCMDQf3zAmYcB
wGLKX+1VxwfA+DDJcnP1AMDz/PWWbocGwMk9VHAX/QDAsDRV69MYBcDHBIX+
djoCwBXLooIe6APATy2m/ktbAsAP42HTvr0CwBDSvNbFEgPADgnA/NWPAcBB
oaZlnHsDwLJe0seJYgDAV0yuiBgdBMAE0isOvXn+v7XGHqVpnATAerJvK5Ed
/L/VjIlvLo8FwCx4jMS3r/m/IYyOF5mFBsBTD3g4JUL3v8pdwG1OmQfAe/jC
taLV9L/z5bRpFagIwIjr7cpUavK/Dg3fqUfVCcA1qAffPgPwvx05uxKw0grA
VoVcM58267/Ivfg1mDoLwKhIE48=
         "]]}, {
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
         PointSize[0.02], 
         Thickness[0.005]], 
        GeometricTransformationBox[
         InsetBox[
          BoxData[
           FormBox[
            StyleBox[
             GraphicsBox[{
               EdgeForm[], 
               PolygonBox[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}], 
             GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                 AbsoluteThickness[1.6], 
                 RGBColor[
                 0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
                 PointSize[0.02], 
                 Thickness[0.005]]}, StripOnInput -> False], 
            TraditionalForm]], {0., 0.}, Automatic, 
          Offset[6.72]], CompressedData["
1:eJwB5QEa/iFib1JlAwAAAB0AAAABAAAAAgAAAB76w+J1aBXAkup33+lt8r9e
to5WEMoUwJak/EOOHvG/Anf+dkovFMDO1IGf3NH6v4j3rCnpkxPALF+jkCnN
+78v3hYnAvsSwKpBfc3gM/2/7SHMnfJiEsC5LPGry1v8v8CbIs58yhHA1/gu
mzBc/L+ybEuM4TERwL6fk78pmP2/BlFOXjmZEMDbqHF7rkIAwGLHLRdPARDA
E1nVSE65/r82BKdmjs4OwAEuUcwUoAHAOz0kKEOZDcB9zVnLwRIBwEjXysvu
ZgzAQQ2ZXOxgAMDGwpk+sDILwOLIHILxowDASLx4nWb+CcBda8SGv+IAwL+1
klN/ywjAcTMnYL7NAMBiyl/tVccHwO0Im2JrWgHA8/z1lm6HBsAlEmN7zBwA
wLA0VevTGAXAx5UmuEmmAcAVy6KCHugDwByV2JDAzgHAD+Nh0769AsBdBDhQ
X1YCwA4JwPzVjwHAwgsBKsiiAsCyXtLHiWIAwOuWuT1mEAPABNIrDr15/r8c
FugICHMDwHqybyuRHfy/+6O7RFgXBMAseIzEt6/5v+CK1Gbc6ATAUw94OCVC
978DO+FgPZQFwHv4wrWi1fS/WahE7IWQBsCI6+3KVGryv8CR3V9kWgfAW2rv
UQ==
         "]]}, {}, {}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {-6.907755278982122, 0}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"n\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
          HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameStyle -> GrayLevel[0], 
     FrameTicks -> {{Automatic, Automatic}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.907755278982137, 0.}, {-4.1575894443909105`, 0}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {
        Scaled[0.05], 
        Scaled[0.02]}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"Data C14\"", "\"Data C15\"", "\"Fit C14\"", "\"Fit C15\""}, 
      "PointLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    DiskBox[{0, 0}]}, {DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 6.272}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.28196428571428567`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}, {
                    DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608], 
                    PointSize[0.5], 
                    Thickness[0.09]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 6.72}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.2358333333333333] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Thickness[0.09]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Thickness[0.09]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Thickness[0.09]], {
                    LineBox[{{0, 6.272}, {20, 6.272}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Thickness[0.09]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    DiskBox[{0, 0}]}, {DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Thickness[0.09]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 6.272}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.28196428571428567`] -> 
                    Baseline)], #4}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.007333333333333334`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.007333333333333334`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    EdgeForm[], 
                    DiskBox[{0, 0}]}], ",", 
                    RowBox[{"Offset", "[", "6.272`", "]"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}], ",", 
                    RowBox[{"Offset", "[", "6.72`", "]"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"None", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "False", ",", "True", ",", "True"}], 
               "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.8895182869567413`*^9, {3.8895183343905697`*^9, 3.8895183620551634`*^9}, {
   3.8895184150560637`*^9, 3.8895184418507495`*^9}, 3.8895185281220536`*^9, 
   3.8895889404320927`*^9, {3.8895890406246934`*^9, 3.8895890784682913`*^9}, 
   3.889592148098647*^9, 3.889592411520773*^9, 3.8895925734732924`*^9, 
   3.889592742450922*^9, 3.889592859727005*^9, 3.889592922507035*^9, 
   3.8895930087831736`*^9, 3.889668998234763*^9, 3.8896690890570593`*^9, 
   3.889669169286552*^9, 3.8896693168938737`*^9, 3.8896711091569824`*^9, 
   3.889671276253702*^9, 3.8896723301246977`*^9, 3.889677442821598*^9, 
   3.889677598100257*^9, 3.889684978194605*^9, 3.889685185804984*^9, 
   3.890204642630407*^9, 3.8902063323023443`*^9, 3.8902104829738626`*^9, 
   3.8902169904530506`*^9, 3.890217304571312*^9, 3.8902182374475017`*^9, 
   3.8909820692101192`*^9, 3.8909824066539817`*^9, 3.8909829558379273`*^9, 
   3.8914172809480352`*^9, 3.89141922718013*^9, 3.8926158229674926`*^9, 
   3.89262922150885*^9, 3.89272089485242*^9, 3.9022174287052937`*^9, 
   3.90221850464843*^9, {3.902218568798971*^9, 3.9022185909588995`*^9}, {
   3.9022186690119762`*^9, 3.9022186820000067`*^9}, 3.902218723860509*^9, {
   3.9022187641114473`*^9, 3.9022187740635996`*^9}, 3.90221880694001*^9, 
   3.902218910464753*^9, {3.902218987314639*^9, 3.9022190443797426`*^9}, 
   3.902219184342458*^9, 3.9022193051179514`*^9, 3.9022193605600953`*^9, 
   3.9022194568420315`*^9, 3.9022195116035814`*^9, 3.902219566279887*^9, {
   3.9022196665031495`*^9, 3.902219690729586*^9}, {3.9022197438343844`*^9, 
   3.902219793043107*^9}, {3.9022198766762857`*^9, 3.902219951643075*^9}, 
   3.9022200460836196`*^9, 3.902220149808984*^9, 3.9022205813727236`*^9, 
   3.9022217999990807`*^9, 3.90222207660452*^9, 3.9023789909216423`*^9, 
   3.902382596673857*^9, 3.902459757551134*^9, 3.902459826203156*^9, 
   3.903580778294915*^9, 3.9047957640505533`*^9, 3.904798416951468*^9, 
   3.9047985089142313`*^9, 3.9059261967219095`*^9, 3.915698742640217*^9, 
   3.917944319587473*^9, 3.9179443763595448`*^9, 3.9179452587291994`*^9, 
   3.917951280827122*^9, 3.9185608591100545`*^9, 3.9185610998150153`*^9, 
   3.9185613092718544`*^9, 3.9185613453556614`*^9, 3.9185613973954306`*^9, 
   3.918561724708984*^9, 3.918561795367496*^9, 3.9185618401395082`*^9},
 CellLabel->
  "Out[327]=",ExpressionUUID->"5d054ff6-9682-4b95-8982-66d6abeefa2a"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\LH-ESRF-C14-16 & C20-22 \
plot\\\\PlateletsSlopeFitC14-C15.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.8895182869567413`*^9, {3.8895183343905697`*^9, 3.8895183620551634`*^9}, {
   3.8895184150560637`*^9, 3.8895184418507495`*^9}, 3.8895185281220536`*^9, 
   3.8895889404320927`*^9, {3.8895890406246934`*^9, 3.8895890784682913`*^9}, 
   3.889592148098647*^9, 3.889592411520773*^9, 3.8895925734732924`*^9, 
   3.889592742450922*^9, 3.889592859727005*^9, 3.889592922507035*^9, 
   3.8895930087831736`*^9, 3.889668998234763*^9, 3.8896690890570593`*^9, 
   3.889669169286552*^9, 3.8896693168938737`*^9, 3.8896711091569824`*^9, 
   3.889671276253702*^9, 3.8896723301246977`*^9, 3.889677442821598*^9, 
   3.889677598100257*^9, 3.889684978194605*^9, 3.889685185804984*^9, 
   3.890204642630407*^9, 3.8902063323023443`*^9, 3.8902104829738626`*^9, 
   3.8902169904530506`*^9, 3.890217304571312*^9, 3.8902182374475017`*^9, 
   3.8909820692101192`*^9, 3.8909824066539817`*^9, 3.8909829558379273`*^9, 
   3.8914172809480352`*^9, 3.89141922718013*^9, 3.8926158229674926`*^9, 
   3.89262922150885*^9, 3.89272089485242*^9, 3.9022174287052937`*^9, 
   3.90221850464843*^9, {3.902218568798971*^9, 3.9022185909588995`*^9}, {
   3.9022186690119762`*^9, 3.9022186820000067`*^9}, 3.902218723860509*^9, {
   3.9022187641114473`*^9, 3.9022187740635996`*^9}, 3.90221880694001*^9, 
   3.902218910464753*^9, {3.902218987314639*^9, 3.9022190443797426`*^9}, 
   3.902219184342458*^9, 3.9022193051179514`*^9, 3.9022193605600953`*^9, 
   3.9022194568420315`*^9, 3.9022195116035814`*^9, 3.902219566279887*^9, {
   3.9022196665031495`*^9, 3.902219690729586*^9}, {3.9022197438343844`*^9, 
   3.902219793043107*^9}, {3.9022198766762857`*^9, 3.902219951643075*^9}, 
   3.9022200460836196`*^9, 3.902220149808984*^9, 3.9022205813727236`*^9, 
   3.9022217999990807`*^9, 3.90222207660452*^9, 3.9023789909216423`*^9, 
   3.902382596673857*^9, 3.902459757551134*^9, 3.902459826203156*^9, 
   3.903580778294915*^9, 3.9047957640505533`*^9, 3.904798416951468*^9, 
   3.9047985089142313`*^9, 3.9059261967219095`*^9, 3.915698742640217*^9, 
   3.917944319587473*^9, 3.9179443763595448`*^9, 3.9179452587291994`*^9, 
   3.917951280827122*^9, 3.9185608591100545`*^9, 3.9185610998150153`*^9, 
   3.9185613092718544`*^9, 3.9185613453556614`*^9, 3.9185613973954306`*^9, 
   3.918561724708984*^9, 3.918561795367496*^9, 3.9185618412648544`*^9},
 CellLabel->
  "Out[328]=",ExpressionUUID->"bc3a0aa8-375d-4241-866d-8665d9196ac8"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{}, {{{
         Directive[
          AbsoluteThickness[1.6], 
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          InsetBox[
           BoxData[
            FormBox[
             StyleBox[
              GraphicsBox[{
                EdgeForm[], 
                DiskBox[{0, 0}]}], 
              GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                  AbsoluteThickness[1.6], 
                  RGBColor[
                  0.6745098039215687, 0.07450980392156863, 
                   0.043137254901960784`], 
                  PointSize[0.02], 
                  Thickness[0.005]]}, StripOnInput -> False], 
             TraditionalForm]], {0., 0.}, Automatic, 
           Offset[6.272]], CompressedData["
1:eJwBJQLa/SFib1JlAwAAACEAAAABAAAAAgAAAD5JDLQnnxbA/yHX1fr08L/8
Z3xCyQUWwAe8cl5VyfS/HvrD4nVoFcAQhBRwvsf4v162jlYQyhTAryqIYGv0
+b8Cd/52Si8UwHGK+Q5mV/q/iPesKemTE8DXirNK70b8vy/eFicC+xLA9RA1
48t2/L/tIcyd8mISwJOIElXvbf6/wJsiznzKEcAkKt+yKoT+v7JsS4zhMRHA
bXtUVoZM/78GUU5eOZkQwF6tUfPtAgDAYsctF08BEMAd+tmg46z/vzYEp2aO
zg7A9iCdjUFlAcA7PSQoQ5kNwHUhtNpGSADASNfKy+5mDMAk9ESSfvwAwMbC
mT6wMgvAfwP1vv7iAMBIvHidZv4JwMO+vebh9gDAv7WSU3/LCMDQf3zAmYcB
wGLKX+1VxwfA+DDJcnP1AMDz/PWWbocGwMk9VHAX/QDAsDRV69MYBcDHBIX+
djoCwBXLooIe6APATy2m/ktbAsAP42HTvr0CwBDSvNbFEgPADgnA/NWPAcBB
oaZlnHsDwLJe0seJYgDAV0yuiBgdBMAE0isOvXn+v7XGHqVpnATAerJvK5Ed
/L/VjIlvLo8FwCx4jMS3r/m/IYyOF5mFBsBTD3g4JUL3v8pdwG1OmQfAe/jC
taLV9L/z5bRpFagIwIjr7cpUavK/Dg3fqUfVCcA1qAffPgPwvx05uxKw0grA
VoVcM58267/Ivfg1mDoLwKhIE48=
          "]]}, {
         Directive[
          AbsoluteThickness[1.6], 
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          InsetBox[
           BoxData[
            FormBox[
             StyleBox[
              GraphicsBox[{
                EdgeForm[], 
                PolygonBox[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}], 
              GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                  AbsoluteThickness[1.6], 
                  RGBColor[
                  0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
                  PointSize[0.02], 
                  Thickness[0.005]]}, StripOnInput -> False], 
             TraditionalForm]], {0., 0.}, Automatic, 
           Offset[6.72]], CompressedData["
1:eJwB5QEa/iFib1JlAwAAAB0AAAABAAAAAgAAAB76w+J1aBXAkup33+lt8r9e
to5WEMoUwJak/EOOHvG/Anf+dkovFMDO1IGf3NH6v4j3rCnpkxPALF+jkCnN
+78v3hYnAvsSwKpBfc3gM/2/7SHMnfJiEsC5LPGry1v8v8CbIs58yhHA1/gu
mzBc/L+ybEuM4TERwL6fk78pmP2/BlFOXjmZEMDbqHF7rkIAwGLHLRdPARDA
E1nVSE65/r82BKdmjs4OwAEuUcwUoAHAOz0kKEOZDcB9zVnLwRIBwEjXysvu
ZgzAQQ2ZXOxgAMDGwpk+sDILwOLIHILxowDASLx4nWb+CcBda8SGv+IAwL+1
klN/ywjAcTMnYL7NAMBiyl/tVccHwO0Im2JrWgHA8/z1lm6HBsAlEmN7zBwA
wLA0VevTGAXAx5UmuEmmAcAVy6KCHugDwByV2JDAzgHAD+Nh0769AsBdBDhQ
X1YCwA4JwPzVjwHAwgsBKsiiAsCyXtLHiWIAwOuWuT1mEAPABNIrDr15/r8c
FugICHMDwHqybyuRHfy/+6O7RFgXBMAseIzEt6/5v+CK1Gbc6ATAUw94OCVC
978DO+FgPZQFwHv4wrWi1fS/WahE7IWQBsCI6+3KVGryv8CR3V9kWgfAW2rv
UQ==
          "]]}, {
         Directive[
          AbsoluteThickness[1.6], 
          RGBColor[0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
          PointSize[0.02], 
          Thickness[0.005]], 
         GeometricTransformationBox[
          InsetBox[
           BoxData[
            FormBox[
             StyleBox[
              GraphicsBox[{
                EdgeForm[], 
                PolygonBox[{{0, 1}, {1, 0}, {0, -1}, {-1, 0}}]}], 
              GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                  AbsoluteThickness[1.6], 
                  RGBColor[
                  0.6470588235294118, 0.5686274509803921, 0.611764705882353], 
                  PointSize[0.02], 
                  Thickness[0.005]]}, StripOnInput -> False], 
             TraditionalForm]], {0., 0.}, Automatic, 
           Offset[8.16]], CompressedData["
1:eJwBtQFK/iFib1JlAwAAABoAAAABAAAAAgAAAD4BDegb2RPAStwsfeTY97+c
3pFL0D8TwHUXrmbswfe/EgP70y6mEsBIiajh68H3v7UPTwkvCxLAMOrLpebX
/r8P4fIAcG8RwPFtuFwQp/i/HvoZ0zfTEMDXjukaMUj9v4B5/xSbORDAaRui
iQhH/b+kLkud4EEPwKU9iMh5YgDASBULkegMDsBAFlksYm8BwOu93gUU2AzA
S3mfOZJ3/r9RpY23wqYLwARlHLyBMAHABE57VAx1CsBNzMTBsLsAwHzM2vbm
QAnA2Xkmg26bAMCfmWtzAygIwP5EkqaHkwDAsImn70LeBsDlUxA8kwYAwIjl
N4bzhwXAPlWfLKSDAcC2NczWpW8EwNbobzQrigHALHKE+o9FA8BTxmmQMfEB
wPn/gB8aEgLAONbXmowmAsBghSCHqOAAwMQ14jg1tALAHladfIlT/7/yEHQV
xL8CwPrQsWr/6fy/R1eeESBfA8AhAJxsun/6vzNuZBbOwwPALD5kNnoQ+L93
flU2mmIEwMgcUR2yqfW/e7yo/VAhBcCf9LJA00nzv4Ll8qjnngXA2R/RJw==

          "]]}}}, {{}, {}}}, {{}, {{{}, {}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[0.0055000000000000005`], 
          AbsoluteThickness[1.6], 
          GrayLevel[0], 
          Thickness[0.005]], 
         LineBox[CompressedData["
1:eJw1VXk4Vd0Xvtflco3HdC/3mjNVIooSOle+Rg1CEaJESXN+GoQoIURlllBJ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          "]]}, {
         Hue[0.9060679774997897, 0.6, 0.6], 
         Directive[
          PointSize[0.0055000000000000005`], 
          AbsoluteThickness[1.6], 
          GrayLevel[0], 
          Thickness[0.005]], 
         LineBox[CompressedData["
1:eJw1lXk4Vdsbx4/jmDJtHNNRoohSpEtRtJUGKUKkVObQRYaTK4QGKdFknkJR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          "]]}, {
         Hue[0.1421359549995791, 0.6, 0.6], 
         Directive[
          PointSize[0.0055000000000000005`], 
          AbsoluteThickness[1.6], 
          GrayLevel[0], 
          Thickness[0.005]], 
         LineBox[CompressedData["
1:eJw1lnk8VOsfx2cGwzBjjm2GUZgiLUrZihtHNy1UtoQoW25RiZKLqBCVLUpa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          "]]}}}, {{}, {}}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {-6.907755278982122, 0}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"n\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
          HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameStyle -> GrayLevel[0], 
     FrameTicks -> {{Automatic, Automatic}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.907755278982137, 0.}, {-4.4, 0.}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{0, 0}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], Automatic}}], 
   FormBox[
    TagBox[
     GridBox[{{
        FormBox[
         TemplateBox[{"\"Data C14\"", "\"Data C15\"", "\"Data C16\""}, 
          "PointLegend", DisplayFunction -> (StyleBox[
            StyleBox[
             PaneBox[
              TagBox[
               GridBox[{{
                  TagBox[
                   GridBox[{{
                    GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.72], 
                    Thickness[0.18]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    DiskBox[{0, 0}]}, {DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.72], 
                    Thickness[0.18]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 6.272}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.28196428571428567`] -> 
                    Baseline)], #}, {
                    GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608], 
                    PointSize[0.72], 
                    Thickness[0.18]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}, {
                    DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608], 
                    PointSize[0.72], 
                    Thickness[0.18]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 6.72}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.2358333333333333] -> 
                    Baseline)], #2}, {
                    GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6470588235294118, 0.5686274509803921, 
                    0.611764705882353], 
                    PointSize[0.72], 
                    Thickness[0.18]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[{{0, 1}, {1, 0}, {0, -1}, {-1, 0}}]}, {
                    DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6470588235294118, 0.5686274509803921, 
                    0.611764705882353], 
                    PointSize[0.72], 
                    Thickness[0.18]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 8.16}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.12186274509803918`] -> 
                    Baseline)], #3}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
               "Grid"], Alignment -> Left, AppearanceElements -> None, 
              ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
              "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
            FontSize -> 14, 
             GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
            StripOnInput -> False]& ), 
          InterpretationFunction :> (RowBox[{"PointLegend", "[", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
                    RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    
                    TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608]|>, "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
                    RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    
                    TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6470588235294118, 0.5686274509803921, 
                    0.611764705882353]|>, "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
                    RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
               RowBox[{"LegendMarkers", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    GraphicsBox[{
                    EdgeForm[], 
                    DiskBox[{0, 0}]}], ",", 
                    RowBox[{"Offset", "[", "6.272`", "]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}], ",", 
                    RowBox[{"Offset", "[", "6.72`", "]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[{{0, 1}, {1, 0}, {0, -1}, {-1, 0}}]}], ",", 
                    RowBox[{"Offset", "[", "8.16`", "]"}]}], "}"}]}], "}"}]}],
                ",", 
               RowBox[{"Joined", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "False", ",", "False"}], "}"}]}], 
               ",", 
               RowBox[{"LabelStyle", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                    
                    TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
               RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
          Editable -> True], TraditionalForm]}, {
        FormBox[
         TemplateBox[{"\"Fit C14\"", "\"Fit C15\"", "\"Fit C16\""}, 
          "PointLegend", DisplayFunction -> (StyleBox[
            StyleBox[
             PaneBox[
              TagBox[
               GridBox[{{
                  TagBox[
                   GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Thickness[0.09]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Thickness[0.09]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Thickness[0.09]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Thickness[0.09]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Thickness[0.09]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Thickness[0.09]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
               "Grid"], Alignment -> Left, AppearanceElements -> None, 
              ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
              "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
            FontSize -> 14, 
             GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
            StripOnInput -> False]& ), 
          InterpretationFunction :> (RowBox[{"PointLegend", "[", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", "0.0055000000000000005`", "]"}],
                     ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    
                    TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                    RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", "0.0055000000000000005`", "]"}],
                     ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    
                    TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                    RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", "0.0055000000000000005`", "]"}],
                     ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    
                    TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                    RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
               RowBox[{"LegendMarkers", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], "}"}]}], ",", 
               RowBox[{"Joined", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
               RowBox[{"LabelStyle", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                    
                    TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
               RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
          Editable -> True], TraditionalForm]}}, 
      GridBoxAlignment -> {"Columns" -> {{Left}}}, AutoDelete -> False, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
      GridBoxSpacings -> {"Columns" -> {{0}}}], "Grid"], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.8895182869567413`*^9, {3.8895183343905697`*^9, 3.8895183620551634`*^9}, {
   3.8895184150560637`*^9, 3.8895184418507495`*^9}, 3.8895185281220536`*^9, 
   3.8895889404320927`*^9, {3.8895890406246934`*^9, 3.8895890784682913`*^9}, 
   3.889592148098647*^9, 3.889592411520773*^9, 3.8895925734732924`*^9, 
   3.889592742450922*^9, 3.889592859727005*^9, 3.889592922507035*^9, 
   3.8895930087831736`*^9, 3.889668998234763*^9, 3.8896690890570593`*^9, 
   3.889669169286552*^9, 3.8896693168938737`*^9, 3.8896711091569824`*^9, 
   3.889671276253702*^9, 3.8896723301246977`*^9, 3.889677442821598*^9, 
   3.889677598100257*^9, 3.889684978194605*^9, 3.889685185804984*^9, 
   3.890204642630407*^9, 3.8902063323023443`*^9, 3.8902104829738626`*^9, 
   3.8902169904530506`*^9, 3.890217304571312*^9, 3.8902182374475017`*^9, 
   3.8909820692101192`*^9, 3.8909824066539817`*^9, 3.8909829558379273`*^9, 
   3.8914172809480352`*^9, 3.89141922718013*^9, 3.8926158229674926`*^9, 
   3.89262922150885*^9, 3.89272089485242*^9, 3.9022174287052937`*^9, 
   3.90221850464843*^9, {3.902218568798971*^9, 3.9022185909588995`*^9}, {
   3.9022186690119762`*^9, 3.9022186820000067`*^9}, 3.902218723860509*^9, {
   3.9022187641114473`*^9, 3.9022187740635996`*^9}, 3.90221880694001*^9, 
   3.902218910464753*^9, {3.902218987314639*^9, 3.9022190443797426`*^9}, 
   3.902219184342458*^9, 3.9022193051179514`*^9, 3.9022193605600953`*^9, 
   3.9022194568420315`*^9, 3.9022195116035814`*^9, 3.902219566279887*^9, {
   3.9022196665031495`*^9, 3.902219690729586*^9}, {3.9022197438343844`*^9, 
   3.902219793043107*^9}, {3.9022198766762857`*^9, 3.902219951643075*^9}, 
   3.9022200460836196`*^9, 3.902220149808984*^9, 3.9022205813727236`*^9, 
   3.9022217999990807`*^9, 3.90222207660452*^9, 3.9023789909216423`*^9, 
   3.902382596673857*^9, 3.902459757551134*^9, 3.902459826203156*^9, 
   3.903580778294915*^9, 3.9047957640505533`*^9, 3.904798416951468*^9, 
   3.9047985089142313`*^9, 3.9059261967219095`*^9, 3.915698742640217*^9, 
   3.917944319587473*^9, 3.9179443763595448`*^9, 3.9179452587291994`*^9, 
   3.917951280827122*^9, 3.9185608591100545`*^9, 3.9185610998150153`*^9, 
   3.9185613092718544`*^9, 3.9185613453556614`*^9, 3.9185613973954306`*^9, 
   3.918561724708984*^9, 3.918561795367496*^9, 3.9185618416760035`*^9},
 CellLabel->
  "Out[331]=",ExpressionUUID->"1d34b489-26bb-4982-a071-3397111412d0"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\LH-ESRF-C14-16 & C20-22 \
plot\\\\PlateletsSlopeFitC14-C16_no_error.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.8895182869567413`*^9, {3.8895183343905697`*^9, 3.8895183620551634`*^9}, {
   3.8895184150560637`*^9, 3.8895184418507495`*^9}, 3.8895185281220536`*^9, 
   3.8895889404320927`*^9, {3.8895890406246934`*^9, 3.8895890784682913`*^9}, 
   3.889592148098647*^9, 3.889592411520773*^9, 3.8895925734732924`*^9, 
   3.889592742450922*^9, 3.889592859727005*^9, 3.889592922507035*^9, 
   3.8895930087831736`*^9, 3.889668998234763*^9, 3.8896690890570593`*^9, 
   3.889669169286552*^9, 3.8896693168938737`*^9, 3.8896711091569824`*^9, 
   3.889671276253702*^9, 3.8896723301246977`*^9, 3.889677442821598*^9, 
   3.889677598100257*^9, 3.889684978194605*^9, 3.889685185804984*^9, 
   3.890204642630407*^9, 3.8902063323023443`*^9, 3.8902104829738626`*^9, 
   3.8902169904530506`*^9, 3.890217304571312*^9, 3.8902182374475017`*^9, 
   3.8909820692101192`*^9, 3.8909824066539817`*^9, 3.8909829558379273`*^9, 
   3.8914172809480352`*^9, 3.89141922718013*^9, 3.8926158229674926`*^9, 
   3.89262922150885*^9, 3.89272089485242*^9, 3.9022174287052937`*^9, 
   3.90221850464843*^9, {3.902218568798971*^9, 3.9022185909588995`*^9}, {
   3.9022186690119762`*^9, 3.9022186820000067`*^9}, 3.902218723860509*^9, {
   3.9022187641114473`*^9, 3.9022187740635996`*^9}, 3.90221880694001*^9, 
   3.902218910464753*^9, {3.902218987314639*^9, 3.9022190443797426`*^9}, 
   3.902219184342458*^9, 3.9022193051179514`*^9, 3.9022193605600953`*^9, 
   3.9022194568420315`*^9, 3.9022195116035814`*^9, 3.902219566279887*^9, {
   3.9022196665031495`*^9, 3.902219690729586*^9}, {3.9022197438343844`*^9, 
   3.902219793043107*^9}, {3.9022198766762857`*^9, 3.902219951643075*^9}, 
   3.9022200460836196`*^9, 3.902220149808984*^9, 3.9022205813727236`*^9, 
   3.9022217999990807`*^9, 3.90222207660452*^9, 3.9023789909216423`*^9, 
   3.902382596673857*^9, 3.902459757551134*^9, 3.902459826203156*^9, 
   3.903580778294915*^9, 3.9047957640505533`*^9, 3.904798416951468*^9, 
   3.9047985089142313`*^9, 3.9059261967219095`*^9, 3.915698742640217*^9, 
   3.917944319587473*^9, 3.9179443763595448`*^9, 3.9179452587291994`*^9, 
   3.917951280827122*^9, 3.9185608591100545`*^9, 3.9185610998150153`*^9, 
   3.9185613092718544`*^9, 3.9185613453556614`*^9, 3.9185613973954306`*^9, 
   3.918561724708984*^9, 3.918561795367496*^9, 3.9185618427972894`*^9},
 CellLabel->
  "Out[332]=",ExpressionUUID->"c37afb88-726d-4986-bd5c-d7fe856f8a06"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.352012198649872, -2.0093287828709796`}, \
{-5.352012198649872, -1.6814367993293893`}}], 
          
          LineBox[{{-5.352012198649872, -1.6814367993293893`}, \
{-5.352012198649872, -1.3535448157877992`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.197327949963066, -2.162449290062261}, \
{-5.197327949963066, -1.853973646897377}}], 
          
          LineBox[{{-5.197327949963066, -1.853973646897377}, \
{-5.197327949963066, -1.5454980037324935`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.046182498246482, -2.0517235372113287`}, \
{-5.046182498246482, -1.7610744015672055`}}], 
          
          LineBox[{{-5.046182498246482, -1.7610744015672055`}, \
{-5.046182498246482, -1.4704252659230823`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.894444132978499, -2.0825971397420115`}, \
{-4.894444132978499, -1.7869663217644973`}}], 
          
          LineBox[{{-4.894444132978499, -1.7869663217644973`}, \
{-4.894444132978499, -1.491335503786983}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.745125399370905, -2.1808530865199893`}, \
{-4.745125399370905, -1.90031225283698}}], 
          
          LineBox[{{-4.745125399370905, -1.90031225283698}, \
{-4.745125399370905, -1.6197714191539707`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.596628633102665, -2.2183411497318897`}, \
{-4.596628633102665, -1.9599645382822033`}}], 
          
          LineBox[{{-4.596628633102665, -1.9599645382822033`}, \
{-4.596628633102665, -1.7015879268325167`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.447741719114617, -2.2274008505891785`}, \
{-4.447741719114617, -1.9807057577397864`}}], 
          
          LineBox[{{-4.447741719114617, -1.9807057577397864`}, \
{-4.447741719114617, -1.7340106648903946`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.298711959937622, -2.185318714234099}, \
{-4.298711959937622, -1.9531048696628939`}}], 
          
          LineBox[{{-4.298711959937622, -1.9531048696628939`}, \
{-4.298711959937622, -1.7208910250916887`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.149632905511913, -2.219952502474402}, \
{-4.149632905511913, -2.001896117050877}}], 
          
          LineBox[{{-4.149632905511913, -2.001896117050877}, \
{-4.149632905511913, -1.7838397316273522`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.001278268975371, -2.2274534134911748`}, \
{-4.001278268975371, -2.0285179870113916`}}], 
          
          LineBox[{{-4.001278268975371, -2.0285179870113916`}, \
{-4.001278268975371, -1.8295825605316085`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.8508575458258987`, -2.4175562263623713`}, \
{-3.8508575458258987`, -2.225690849696841}}], 
          
          LineBox[{{-3.8508575458258987`, -2.225690849696841}, \
{-3.8508575458258987`, -2.033825473031311}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.6998351226863213`, -2.2727215623528925`}, \
{-3.6998351226863213`, -2.0919678625081652`}}], 
          
          LineBox[{{-3.6998351226863213`, -2.0919678625081652`}, \
{-3.6998351226863213`, -1.9112141626634382`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.550260154845919, -2.2629091764730767`}, \
{-3.550260154845919, -2.091929028752837}}], 
          
          LineBox[{{-3.550260154845919, -2.091929028752837}, \
{-3.550260154845919, -1.9209488810325972`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.3997502222704012`, -2.322751107274743}, \
{-3.3997502222704012`, -2.165765529900271}}], 
          
          LineBox[{{-3.3997502222704012`, -2.165765529900271}, \
{-3.3997502222704012`, -2.008779952525799}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.2492191603155653`, -2.3145014418751098`}, \
{-3.2492191603155653`, -2.1714505004601428`}}], 
          
          LineBox[{{-3.2492191603155653`, -2.1714505004601428`}, \
{-3.2492191603155653`, -2.0283995590451758`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.099363949694378, -2.294533488635746}, \
{-3.099363949694378, -2.1623580363201795`}}], 
          
          LineBox[{{-3.099363949694378, -2.1623580363201795`}, \
{-3.099363949694378, -2.030182584004613}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.9723318619592627`, -2.385446257630764}, \
{-2.9723318619592627`, -2.172990520670644}}], 
          
          LineBox[{{-2.9723318619592627`, -2.172990520670644}, \
{-2.9723318619592627`, -1.960534783710524}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.8161289018458944`, -2.3395589006173303`}, \
{-2.8161289018458944`, -2.038414432336277}}], 
          
          LineBox[{{-2.8161289018458944`, -2.038414432336277}, \
{-2.8161289018458944`, -1.7372699640552238`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.637122953927779, -2.8276708709846607`}, \
{-2.637122953927779, -2.2655493021042967`}}], 
          
          LineBox[{{-2.637122953927779, -2.2655493021042967`}, \
{-2.637122953927779, -1.703427733223933}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.4883394437723703`, -2.8001641582910803`}, \
{-2.4883394437723703`, -2.2762301306695414`}}], 
          
          LineBox[{{-2.4883394437723703`, -2.2762301306695414`}, \
{-2.4883394437723703`, -1.7522961030480024`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.3426491274116255`, -2.859476806527219}, \
{-2.3426491274116255`, -2.3671413990266306`}}], 
          
          LineBox[{{-2.3426491274116255`, -2.3671413990266306`}, \
{-2.3426491274116255`, -1.8748059915260418`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.1952323671440643`, -2.86101296801341}, \
{-2.1952323671440643`, -2.40394992995351}}], 
          
          LineBox[{{-2.1952323671440643`, -2.40394992995351}, \
{-2.1952323671440643`, -1.9468868918936102`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.048114358050804, -2.927583790365584}, \
{-2.048114358050804, -2.480016801922211}}], 
          
          LineBox[{{-2.048114358050804, -2.480016801922211}, \
{-2.048114358050804, -2.032449813478838}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.9047213128625353`, -2.9539600369254435`}, \
{-1.9047213128625353`, -2.537291464128335}}], 
          
          LineBox[{{-1.9047213128625353`, -2.537291464128335}, \
{-1.9047213128625353`, -2.1206228913312266`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.7572185227137695`, -3.0295367064494565`}, \
{-1.7572185227137695`, -2.6386670909388585`}}], 
          
          LineBox[{{-1.7572185227137695`, -2.6386670909388585`}, \
{-1.7572185227137695`, -2.2477974754282606`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.6053998639759, -3.1281301596343156`}, \
{-1.6053998639759, -2.7555266821823174`}}], 
          
          LineBox[{{-1.6053998639759, -2.7555266821823174`}, \
{-1.6053998639759, -2.3829232047303193`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.4536487775630647`, -3.2536861916921644`}, \
{-1.4536487775630647`, -2.8914721239984646`}}], 
          
          LineBox[{{-1.4536487775630647`, -2.8914721239984646`}, \
{-1.4536487775630647`, -2.529258056304765}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.3021571254789979`, -3.371752061543436}, \
{-1.3021571254789979`, -3.0237373326734476`}}], 
          
          LineBox[{{-1.3021571254789979`, -3.0237373326734476`}, \
{-1.3021571254789979`, -2.675722603803459}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.1509597708634107`, -3.5161706840968763`}, \
{-1.1509597708634107`, -3.1742352803685083`}}], 
          
          LineBox[{{-1.1509597708634107`, -3.1742352803685083`}, \
{-1.1509597708634107`, -2.8322998766401404`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.0007923805337786`, -3.653023148518657}, \
{-1.0007923805337786`, -3.323018544488238}}], 
          
          LineBox[{{-1.0007923805337786`, -3.323018544488238}, \
{-1.0007923805337786`, -2.9930139404578187`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
          PointSize[0.02], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-0.8504177096512346, -3.741118323825691}, \
{-0.8504177096512346, -3.4256501256993244`}}], 
          
          LineBox[{{-0.8504177096512346, -3.4256501256993244`}, \
{-0.8504177096512346, -3.110181927572958}}]}}}}}, {{{}, {}, {}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.009166666666666668], 
         AbsoluteThickness[1.6], 
         GrayLevel[0], 
         Thickness[0.005]], 
        LineBox[CompressedData["
1:eJw1VXk4Vdsb3ubpHLbp4CiZc6PcMmXcmpREEhkjMlW6MoQKKeoqXA2ESIok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         "]]}}, {{
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.02], 
         Thickness[0.005]], 
        GeometricTransformationBox[
         InsetBox[
          BoxData[
           FormBox[
            StyleBox[
             GraphicsBox[{
               EdgeForm[], 
               DiskBox[{0, 0}]}], 
             GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                 AbsoluteThickness[1.6], 
                 RGBColor[
                 0.6745098039215687, 0.07450980392156863, 
                  0.043137254901960784`], 
                 PointSize[0.02], 
                 Thickness[0.005]]}, StripOnInput -> False], 
            TraditionalForm]], {0., 0.}, Automatic, 
          Offset[6.272]], CompressedData["
1:eJwBBQL6/SFib1JlAwAAAB8AAAABAAAAAgAAAB76w+J1aBXA/ZH2RSrn+r9e
to5WEMoUwBMfUUXgqf2/Anf+dkovFMDa3AhaXC38v4j3rCnpkxPAyIJw/2mX
/L8v3hYnAvsSwHP3IdKtZ/6/7SHMnfJiEsBt3pPGA1z/v8CbIs58yhHAStxH
hfiw/7+ybEuM4TERwH7ETeTqP/+/BlFOXjmZEMCCyIUc4gMAwGLHLRdPARDA
Un5so2c6AMA2BKdmjs4OwJSiEwE3zgHAOz0kKEOZDcB1C46lWbwAwEjXysvu
ZgzAMF9gSUW8AMDGwpk+sDILwGPOzeB8UwHASLx4nWb+CcCI36JwIV8BwL+1
klN/ywjAU+fBXoJMAcBiyl/tVccHwC5jptpIYgHA8/z1lm6HBsA1odQ5rE4A
wLA0VevTGAXAzxsAUNgfAsAVy6KCHugDwPUpiyS4NQLAD+Nh0769AsDUnW7U
5+8CwA4JwPzVjwHAe/nSGUo7A8CyXtLHiWIAwI9KjgwT1wPABNIrDr15/r8r
z5Z3X0wEwHqybyuRHfy/Lenkff0bBcAseIzEt6/5v9jTuZJRCwbAUw94OCVC
97/X8w4jvCEHwHv4wrWi1fS/vjbcMp0wCMCI6+3KVGryv+Tvd3fVZAnANagH
3z4D8L/GoCS/ipUKwFaFXDOfNuu/yVXLQLtnC8C0qv4s
         "]]}, {}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {-6.907755278982122, 0}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"n\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
          HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameStyle -> GrayLevel[0], 
     FrameTicks -> {{Automatic, Automatic}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[